/** @license
 *
 * jsPDF - PDF Document creation from JavaScript
 * Version 4.2.0 Built on 2026-02-19T09:43:09.011Z
 *                      CommitID 00000000
 *
 * Copyright (c) 2010-2025 James Hall <james@parall.ax>, https://github.com/MrRio/jsPDF
 *               2015-2025 yWorks GmbH, http://www.yworks.com
 *               2015-2025 Lukas Holländer <lukas.hollaender@yworks.com>, https://github.com/HackbrettXXX
 *               2016-2018 Aras Abbasi <aras.abbasi@gmail.com>
 *               2010 Aaron Spike, https://github.com/acspike
 *               2012 Willow Systems Corporation, https://github.com/willowsystems
 *               2012 Pablo Hess, https://github.com/pablohess
 *               2012 Florian Jenett, https://github.com/fjenett
 *               2013 Warren Weckesser, https://github.com/warrenweckesser
 *               2013 Youssef Beddad, https://github.com/lifof
 *               2013 Lee Driscoll, https://github.com/lsdriscoll
 *               2013 Stefan Slonevskiy, https://github.com/stefslon
 *               2013 Jeremy Morel, https://github.com/jmorel
 *               2013 Christoph Hartmann, https://github.com/chris-rock
 *               2014 Juan Pablo Gaviria, https://github.com/juanpgaviria
 *               2014 James Makes, https://github.com/dollaruw
 *               2014 Diego Casorran, https://github.com/diegocr
 *               2014 Steven Spungin, https://github.com/Flamenco
 *               2014 Kenneth Glassey, https://github.com/Gavvers
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Contributor(s):
 *    siefkenj, ahwolf, rickygu, Midnith, saintclair, eaparango,
 *    kim3er, mfo, alnorth, Flamenco
 */

!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports):"function"==typeof define&&define.amd?define(["exports"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).jspdf={})}(this,function(t){function e(t,e){(null==e||e>t.length)&&(e=t.length);for(var r=0,n=Array(e);r<e;r++)n[r]=t[r];return n}function r(t,r){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var r=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=r){var n,i,a,s,o=[],h=!0,l=!1;try{if(a=(r=r.call(t)).next,0===e){if(Object(r)!==r)return;h=!1}else for(;!(h=(n=a.call(r)).done)&&(o.push(n.value),o.length!==e);h=!0);}catch(t){l=!0,i=t}finally{try{if(!h&&null!=r.return&&(s=r.return(),Object(s)!==s))return}finally{if(l)throw i}}return o}}(t,r)||function(t,r){if(t){if("string"==typeof t)return e(t,r);var n={}.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?e(t,r):void 0}}(t,r)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function n(t){return n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},n(t)}var i=function(){return"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this}();function a(){i.console&&"function"==typeof i.console.log&&i.console.log.apply(i.console,arguments)}var s={log:a,warn:function(t){i.console&&("function"==typeof i.console.warn?i.console.warn.apply(i.console,arguments):a.call(null,arguments))},error:function(t){i.console&&("function"==typeof i.console.error?i.console.error.apply(i.console,arguments):a(t))}};function o(t,e,r){var n=new XMLHttpRequest;n.open("GET",t),n.responseType="blob",n.onload=function(){u(n.response,e,r)},n.onerror=function(){s.error("could not download file")},n.send()}function h(t){var e=new XMLHttpRequest;e.open("HEAD",t,!1);try{e.send()}catch(r){}return e.status>=200&&e.status<=299}function l(t){try{t.dispatchEvent(new MouseEvent("click"))}catch(r){var e=document.createEvent("MouseEvents");e.initMouseEvent("click",!0,!0,window,0,0,0,80,20,!1,!1,!1,!1,0,null),t.dispatchEvent(e)}}var u=i.saveAs||("object"!==("undefined"==typeof window?"undefined":n(window))||window!==i?function(){}:"undefined"!=typeof HTMLAnchorElement&&"download"in HTMLAnchorElement.prototype?function(t,e,r){var n=i.URL||i.webkitURL,a=document.createElement("a");e=e||t.name||"download",a.download=e,a.rel="noopener","string"==typeof t?(a.href=t,a.origin!==location.origin?h(a.href)?o(t,e,r):l(a,a.target="_blank"):l(a)):(a.href=n.createObjectURL(t),setTimeout(function(){n.revokeObjectURL(a.href)},4e4),setTimeout(function(){l(a)},0))}:"msSaveOrOpenBlob"in navigator?function(t,e,r){if(e=e||t.name||"download","string"==typeof t)if(h(t))o(t,e,r);else{var i=document.createElement("a");i.href=t,i.target="_blank",setTimeout(function(){l(i)})}else navigator.msSaveOrOpenBlob(function(t,e){return void 0===e?e={autoBom:!1}:"object"!==n(e)&&(s.warn("Deprecated: Expected third argument to be a object"),e={autoBom:!e}),e.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(t.type)?new Blob([String.fromCharCode(65279),t],{type:t.type}):t}(t,r),e)}:function(t,e,r,a){if((a=a||open("","_blank"))&&(a.document.title=a.document.body.innerText="downloading..."),"string"==typeof t)return o(t,e,r);var s="application/octet-stream"===t.type,h=/constructor/i.test(i.HTMLElement)||i.safari,l=/CriOS\/[\d]+/.test(navigator.userAgent);if((l||s&&h)&&"object"===("undefined"==typeof FileReader?"undefined":n(FileReader))){var u=new FileReader;u.onloadend=function(){var t=u.result;t=l?t:t.replace(/^data:[^;]*;/,"data:attachment/file;"),a?a.location.href=t:location=t,a=null},u.readAsDataURL(t)}else{var c=i.URL||i.webkitURL,f=c.createObjectURL(t);a?a.location=f:location.href=f,a=null,setTimeout(function(){c.revokeObjectURL(f)},4e4)}});
/**
   * A class to parse color values
   * @author Stoyan Stefanov <sstoo@gmail.com>
   * {@link   http://www.phpied.com/rgb-color-parser-in-javascript/}
   * @license Use it if you like it
   */function c(t){var e;t=t||"",this.ok=!1,"#"==t.charAt(0)&&(t=t.substr(1,6)),t={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgrey:"d3d3d3",lightgreen:"90ee90",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"}[t=(t=t.replace(/ /g,"")).toLowerCase()]||t;for(var r=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,example:["rgb(123, 234, 45)","rgb(255,234,245)"],process:function(t){return[parseInt(t[1]),parseInt(t[2]),parseInt(t[3])]}},{re:/^(\w{2})(\w{2})(\w{2})$/,example:["#00ff00","336699"],process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^(\w{1})(\w{1})(\w{1})$/,example:["#fb0","f0f"],process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}}],n=0;n<r.length;n++){var i=r[n].re,a=r[n].process,s=i.exec(t);s&&(e=a(s),this.r=e[0],this.g=e[1],this.b=e[2],this.ok=!0)}this.r=this.r<0||isNaN(this.r)?0:this.r>255?255:this.r,this.g=this.g<0||isNaN(this.g)?0:this.g>255?255:this.g,this.b=this.b<0||isNaN(this.b)?0:this.b>255?255:this.b,this.toRGB=function(){return"rgb("+this.r+", "+this.g+", "+this.b+")"},this.toHex=function(){var t=this.r.toString(16),e=this.g.toString(16),r=this.b.toString(16);return 1==t.length&&(t="0"+t),1==e.length&&(e="0"+e),1==r.length&&(r="0"+r),"#"+t+e+r}}var f=i.atob.bind(i),d=i.btoa.bind(i);
/**
   * @license
   * Joseph Myers does not specify a particular license for his work.
   *
   * Author: Joseph Myers
   * Accessed from: http://www.myersdaily.org/joseph/javascript/md5.js
   *
   * Modified by: Owen Leong
   */
function p(t,e){var r=t[0],n=t[1],i=t[2],a=t[3];r=m(r,n,i,a,e[0],7,-680876936),a=m(a,r,n,i,e[1],12,-389564586),i=m(i,a,r,n,e[2],17,606105819),n=m(n,i,a,r,e[3],22,-1044525330),r=m(r,n,i,a,e[4],7,-176418897),a=m(a,r,n,i,e[5],12,1200080426),i=m(i,a,r,n,e[6],17,-1473231341),n=m(n,i,a,r,e[7],22,-45705983),r=m(r,n,i,a,e[8],7,1770035416),a=m(a,r,n,i,e[9],12,-1958414417),i=m(i,a,r,n,e[10],17,-42063),n=m(n,i,a,r,e[11],22,-1990404162),r=m(r,n,i,a,e[12],7,1804603682),a=m(a,r,n,i,e[13],12,-40341101),i=m(i,a,r,n,e[14],17,-1502002290),r=b(r,n=m(n,i,a,r,e[15],22,1236535329),i,a,e[1],5,-165796510),a=b(a,r,n,i,e[6],9,-1069501632),i=b(i,a,r,n,e[11],14,643717713),n=b(n,i,a,r,e[0],20,-373897302),r=b(r,n,i,a,e[5],5,-701558691),a=b(a,r,n,i,e[10],9,38016083),i=b(i,a,r,n,e[15],14,-660478335),n=b(n,i,a,r,e[4],20,-405537848),r=b(r,n,i,a,e[9],5,568446438),a=b(a,r,n,i,e[14],9,-1019803690),i=b(i,a,r,n,e[3],14,-187363961),n=b(n,i,a,r,e[8],20,1163531501),r=b(r,n,i,a,e[13],5,-1444681467),a=b(a,r,n,i,e[2],9,-51403784),i=b(i,a,r,n,e[7],14,1735328473),r=v(r,n=b(n,i,a,r,e[12],20,-1926607734),i,a,e[5],4,-378558),a=v(a,r,n,i,e[8],11,-2022574463),i=v(i,a,r,n,e[11],16,1839030562),n=v(n,i,a,r,e[14],23,-35309556),r=v(r,n,i,a,e[1],4,-1530992060),a=v(a,r,n,i,e[4],11,1272893353),i=v(i,a,r,n,e[7],16,-155497632),n=v(n,i,a,r,e[10],23,-1094730640),r=v(r,n,i,a,e[13],4,681279174),a=v(a,r,n,i,e[0],11,-358537222),i=v(i,a,r,n,e[3],16,-722521979),n=v(n,i,a,r,e[6],23,76029189),r=v(r,n,i,a,e[9],4,-640364487),a=v(a,r,n,i,e[12],11,-421815835),i=v(i,a,r,n,e[15],16,530742520),r=w(r,n=v(n,i,a,r,e[2],23,-995338651),i,a,e[0],6,-198630844),a=w(a,r,n,i,e[7],10,1126891415),i=w(i,a,r,n,e[14],15,-1416354905),n=w(n,i,a,r,e[5],21,-57434055),r=w(r,n,i,a,e[12],6,1700485571),a=w(a,r,n,i,e[3],10,-1894986606),i=w(i,a,r,n,e[10],15,-1051523),n=w(n,i,a,r,e[1],21,-2054922799),r=w(r,n,i,a,e[8],6,1873313359),a=w(a,r,n,i,e[15],10,-30611744),i=w(i,a,r,n,e[6],15,-1560198380),n=w(n,i,a,r,e[13],21,1309151649),r=w(r,n,i,a,e[4],6,-145523070),a=w(a,r,n,i,e[11],10,-1120210379),i=w(i,a,r,n,e[2],15,718787259),n=w(n,i,a,r,e[9],21,-343485551),t[0]=k(r,t[0]),t[1]=k(n,t[1]),t[2]=k(i,t[2]),t[3]=k(a,t[3])}function g(t,e,r,n,i,a){return e=k(k(e,t),k(n,a)),k(e<<i|e>>>32-i,r)}function m(t,e,r,n,i,a,s){return g(e&r|~e&n,t,e,i,a,s)}function b(t,e,r,n,i,a,s){return g(e&n|r&~n,t,e,i,a,s)}function v(t,e,r,n,i,a,s){return g(e^r^n,t,e,i,a,s)}function w(t,e,r,n,i,a,s){return g(r^(e|~n),t,e,i,a,s)}function y(t){var e,r=t.length,n=[1732584193,-271733879,-1732584194,271733878];for(e=64;e<=t.length;e+=64)p(n,_(t.substring(e-64,e)));t=t.substring(e-64);var i=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(e=0;e<t.length;e++)i[e>>2]|=t.charCodeAt(e)<<(e%4<<3);if(i[e>>2]|=128<<(e%4<<3),e>55)for(p(n,i),e=0;e<16;e++)i[e]=0;return i[14]=8*r,p(n,i),n}function _(t){var e,r=[];for(e=0;e<64;e+=4)r[e>>2]=t.charCodeAt(e)+(t.charCodeAt(e+1)<<8)+(t.charCodeAt(e+2)<<16)+(t.charCodeAt(e+3)<<24);return r}var x="0123456789abcdef".split("");function A(t){for(var e="",r=0;r<4;r++)e+=x[t>>8*r+4&15]+x[t>>8*r&15];return e}function L(t){return String.fromCharCode(255&t,(65280&t)>>8,(16711680&t)>>16,(4278190080&t)>>24)}function N(t){return function(t){return t.map(L).join("")}(y(t))}var S="5d41402abc4b2a76b9719d911017c592"!=function(t){for(var e=0;e<t.length;e++)t[e]=A(t[e]);return t.join("")}(y("hello"));function k(t,e){if(S){var r=(65535&t)+(65535&e);return(t>>16)+(e>>16)+(r>>16)<<16|65535&r}return t+e&4294967295}
/**
   * @license
   * FPDF is released under a permissive license: there is no usage restriction.
   * You may embed it freely in your application (commercial or not), with or
   * without modifications.
   *
   * Reference: http://www.fpdf.org/en/script/script37.php
   */function P(t,e){var r,n,i,a;if(t!==r){for(var s=(i=t,a=1+(256/t.length|0),new Array(a+1).join(i)),o=[],h=0;h<256;h++)o[h]=h;var l=0;for(h=0;h<256;h++){var u=o[h];l=(l+u+s.charCodeAt(h))%256,o[h]=o[l],o[l]=u}r=t,n=o}else o=n;var c=e.length,f=0,d=0,p="";for(h=0;h<c;h++)d=(d+(u=o[f=(f+1)%256]))%256,o[f]=o[d],o[d]=u,s=o[(o[f]+o[d])%256],p+=String.fromCharCode(e.charCodeAt(h)^s);return p}
/**
   * @license
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   * Author: Owen Leong (@owenl131)
   * Date: 15 Oct 2020
   * References:
   * https://www.cs.cmu.edu/~dst/Adobe/Gallery/anon21jul01-pdf-encryption.txt
   * https://github.com/foliojs/pdfkit/blob/master/lib/security.js
   * http://www.fpdf.org/en/script/script37.php
   */var F={print:4,modify:8,copy:16,"annot-forms":32};function I(t,e,r,n){this.v=1,this.r=2;var i=192;t.forEach(function(t){if(void 0!==F.perm)throw new Error("Invalid permission: "+t);i+=F[t]}),this.padding="(¿N^NuAd\0NVÿú\b..\0¶Ðh>/\f©þdSiz";var a=(e+this.padding).substr(0,32),s=(r+this.padding).substr(0,32);this.O=this.processOwnerPassword(a,s),this.P=-(1+(255^i)),this.encryptionKey=N(a+this.O+this.lsbFirstWord(this.P)+this.hexToBytes(n)).substr(0,5),this.U=P(this.encryptionKey,this.padding)}function C(t){if(/[^\u0000-\u00ff]/.test(t))throw new Error("Invalid PDF Name Object: "+t+", Only accept ASCII characters.");for(var e="",r=t.length,n=0;n<r;n++){var i=t.charCodeAt(n);e+=i<33||35===i||37===i||40===i||41===i||47===i||60===i||62===i||91===i||93===i||123===i||125===i||i>126?"#"+("0"+i.toString(16)).slice(-2):t[n]}return e}function j(t){if("object"!==n(t))throw new Error("Invalid Context passed to initialize PubSub (jsPDF-module)");var e={};this.subscribe=function(t,r,n){if(n=n||!1,"string"!=typeof t||"function"!=typeof r||"boolean"!=typeof n)throw new Error("Invalid arguments passed to PubSub.subscribe (jsPDF-module)");e.hasOwnProperty(t)||(e[t]={});var i=Math.random().toString(35);return e[t][i]=[r,!!n],i},this.unsubscribe=function(t){for(var r in e)if(e[r][t])return delete e[r][t],0===Object.keys(e[r]).length&&delete e[r],!0;return!1},this.publish=function(r){if(e.hasOwnProperty(r)){var n=Array.prototype.slice.call(arguments,1),a=[];for(var o in e[r]){var h=e[r][o];try{h[0].apply(t,n)}catch(l){i.console&&s.error("jsPDF PubSub Error",l.message,l)}h[1]&&a.push(o)}a.length&&a.forEach(this.unsubscribe)}},this.getTopics=function(){return e}}function E(t){if(!(this instanceof E))return new E(t);var e="opacity,stroke-opacity".split(",");for(var r in t)t.hasOwnProperty(r)&&e.indexOf(r)>=0&&(this[r]=t[r]);this.id="",this.objectNumber=-1}function O(t,e){this.gState=t,this.matrix=e,this.id="",this.objectNumber=-1}function B(t,e,r,n,i){if(!(this instanceof B))return new B(t,e,r,n,i);this.type="axial"===t?2:3,this.coords=e,this.colors=r,O.call(this,n,i)}function M(t,e,r,n,i){if(!(this instanceof M))return new M(t,e,r,n,i);this.boundingBox=t,this.xStep=e,this.yStep=r,this.stream="",this.cloneIndex=0,O.call(this,n,i)}function R(t){var e,r="string"==typeof arguments[0]?arguments[0]:"p",a=arguments[1],o=arguments[2],h=arguments[3],l=[],f=1,p=16,g="S",m=null;"object"===n(t=t||{})&&(r=t.orientation,a=t.unit||a,o=t.format||o,h=t.compress||t.compressPdf||h,null!==(m=t.encryption||null)&&(m.userPassword=m.userPassword||"",m.ownerPassword=m.ownerPassword||"",m.userPermissions=m.userPermissions||[]),f="number"==typeof t.userUnit?Math.abs(t.userUnit):1,void 0!==t.precision&&(e=t.precision),void 0!==t.floatPrecision&&(p=t.floatPrecision),g=t.defaultPathOperation||"S"),l=t.filters||(!0===h?["FlateEncode"]:l),a=a||"mm",r=(""+(r||"P")).toLowerCase();var b=t.putOnlyUsedFonts||!1,v={},w={internal:{},__private__:{}};w.__private__.PubSub=j;var y="1.3",_=w.__private__.getPdfVersion=function(){return y};w.__private__.setPdfVersion=function(t){y=t};var x={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],"government-letter":[576,756],legal:[612,1008],"junior-legal":[576,360],ledger:[1224,792],tabloid:[792,1224],"credit-card":[153,243]};w.__private__.getPageFormats=function(){return x};var A=w.__private__.getPageFormat=function(t){return x[t]};o=o||"a4";var L="compat",N="advanced",S=L;function k(){this.saveGraphicsState(),ut(new Wt(Nt,0,0,-Nt,0,Nr()*Nt).toString()+" cm"),this.setFontSize(this.getFontSize()/Nt),g="n",S=N}function P(){this.restoreGraphicsState(),g="S",S=L}var F=w.__private__.combineFontStyleAndFontWeight=function(t,e){if("bold"==t&&"normal"==e||"bold"==t&&400==e||"normal"==t&&"italic"==e||"bold"==t&&"italic"==e)throw new Error("Invalid Combination of fontweight and fontstyle");return e&&(t=400==e||"normal"===e?"italic"===t?"italic":"normal":700!=e&&"bold"!==e||"normal"!==t?(700==e?"bold":e)+""+t:"bold"),t};w.advancedAPI=function(t){var e=S===L;return e&&k.call(this),"function"!=typeof t||(t(this),e&&P.call(this)),this},w.compatAPI=function(t){var e=S===N;return e&&P.call(this),"function"!=typeof t||(t(this),e&&k.call(this)),this},w.isAdvancedAPI=function(){return S===N};var O,T=function(t){if(S!==N)throw new Error(t+" is only available in 'advanced' API mode. You need to call advancedAPI() first.")},q=w.roundToPrecision=w.__private__.roundToPrecision=function(t,r){var n=e||r;if(isNaN(t)||isNaN(n))throw new Error("Invalid argument passed to jsPDF.roundToPrecision");return t.toFixed(n).replace(/0+$/,"")};O=w.hpf=w.__private__.hpf="number"==typeof p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return q(t,p)}:"smart"===p?function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return q(t,t>-1&&t<1?16:5)}:function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.hpf");return q(t,16)};var D=w.f2=w.__private__.f2=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f2");return q(t,2)},z=w.__private__.f3=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.f3");return q(t,3)},U=w.scale=w.__private__.scale=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.scale");return S===L?t*Nt:S===N?t:void 0},H=function(t){return U(function(t){return S===L?Nr()-t:S===N?t:void 0}(t))};w.__private__.setPrecision=w.setPrecision=function(t){"number"==typeof parseInt(t,10)&&(e=parseInt(t,10))};var W,V="00000000000000000000000000000000",G=w.__private__.getFileId=function(){return V},Y=w.__private__.setFileId=function(t){return V=void 0!==t&&/^[a-fA-F0-9]{32}$/.test(t)?t.toUpperCase():V.split("").map(function(){return"ABCDEF0123456789".charAt(Math.floor(16*Math.random()))}).join(""),null!==m&&(Ce=new I(m.userPermissions,m.userPassword,m.ownerPassword,V)),V};w.setFileId=function(t){return Y(t),this},w.getFileId=function(){return G()};var Z=w.__private__.convertDateToPDFDate=function(t){var e=t.getTimezoneOffset(),r=e<0?"+":"-",n=Math.floor(Math.abs(e/60)),i=Math.abs(e%60),a=[r,Q(n),"'",Q(i),"'"].join("");return["D:",t.getFullYear(),Q(t.getMonth()+1),Q(t.getDate()),Q(t.getHours()),Q(t.getMinutes()),Q(t.getSeconds()),a].join("")},J=w.__private__.convertPDFDateToDate=function(t){var e=parseInt(t.substr(2,4),10),r=parseInt(t.substr(6,2),10)-1,n=parseInt(t.substr(8,2),10),i=parseInt(t.substr(10,2),10),a=parseInt(t.substr(12,2),10),s=parseInt(t.substr(14,2),10);return new Date(e,r,n,i,a,s,0)},X=w.__private__.setCreationDate=function(t){var e;if(void 0===t&&(t=new Date),t instanceof Date)e=Z(t);else{if(!/^D:(20[0-2][0-9]|203[0-7]|19[7-9][0-9])(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])(0[0-9]|1[0-9]|2[0-3])(0[0-9]|[1-5][0-9])(0[0-9]|[1-5][0-9])(\+0[0-9]|\+1[0-4]|-0[0-9]|-1[0-1])'(0[0-9]|[1-5][0-9])'?$/.test(t))throw new Error("Invalid argument passed to jsPDF.setCreationDate");e=t}return W=e},K=w.__private__.getCreationDate=function(t){var e=W;return"jsDate"===t&&(e=J(W)),e};w.setCreationDate=function(t){return X(t),this},w.getCreationDate=function(t){return K(t)};var $,Q=w.__private__.padd2=function(t){return("0"+parseInt(t)).slice(-2)},tt=w.__private__.padd2Hex=function(t){return("00"+(t=t.toString())).substr(t.length)},et=0,rt=[],nt=[],it=0,at=[],st=[],ot=!1,ht=nt;w.__private__.setCustomOutputDestination=function(t){ot=!0,ht=t};var lt=function(t){ot||(ht=t)};w.__private__.resetCustomOutputDestination=function(){ot=!1,ht=nt};var ut=w.__private__.out=function(t){return t=t.toString(),it+=t.length+1,ht.push(t),ht},ct=w.__private__.write=function(t){return ut(1===arguments.length?t.toString():Array.prototype.join.call(arguments," "))},ft=w.__private__.getArrayBuffer=function(t){for(var e=t.length,r=new ArrayBuffer(e),n=new Uint8Array(r);e--;)n[e]=t.charCodeAt(e);return r},dt=[["Helvetica","helvetica","normal","WinAnsiEncoding"],["Helvetica-Bold","helvetica","bold","WinAnsiEncoding"],["Helvetica-Oblique","helvetica","italic","WinAnsiEncoding"],["Helvetica-BoldOblique","helvetica","bolditalic","WinAnsiEncoding"],["Courier","courier","normal","WinAnsiEncoding"],["Courier-Bold","courier","bold","WinAnsiEncoding"],["Courier-Oblique","courier","italic","WinAnsiEncoding"],["Courier-BoldOblique","courier","bolditalic","WinAnsiEncoding"],["Times-Roman","times","normal","WinAnsiEncoding"],["Times-Bold","times","bold","WinAnsiEncoding"],["Times-Italic","times","italic","WinAnsiEncoding"],["Times-BoldItalic","times","bolditalic","WinAnsiEncoding"],["ZapfDingbats","zapfdingbats","normal",null],["Symbol","symbol","normal",null]];w.__private__.getStandardFonts=function(){return dt};var pt=t.fontSize||16;w.__private__.setFontSize=w.setFontSize=function(t){return pt=S===N?t/Nt:t,this};var gt,mt=w.__private__.getFontSize=w.getFontSize=function(){return S===L?pt:pt*Nt},bt=t.R2L||!1;w.__private__.setR2L=w.setR2L=function(t){return bt=t,this},w.__private__.getR2L=w.getR2L=function(){return bt};var vt,wt=w.__private__.setZoomMode=function(t){if(/^(?:\d+\.\d*|\d*\.\d+|\d+)%$/.test(t))gt=t;else if(isNaN(t)){if(-1===[void 0,null,"fullwidth","fullheight","fullpage","original"].indexOf(t))throw new Error('zoom must be Integer (e.g. 2), a percentage Value (e.g. 300%) or fullwidth, fullheight, fullpage, original. "'+t+'" is not recognized.');gt=t}else gt=parseInt(t,10)};w.__private__.getZoomMode=function(){return gt};var yt,_t=w.__private__.setPageMode=function(t){if(-1==[void 0,null,"UseNone","UseOutlines","UseThumbs","FullScreen"].indexOf(t))throw new Error('Page mode must be one of UseNone, UseOutlines, UseThumbs, or FullScreen. "'+t+'" is not recognized.');vt=t};w.__private__.getPageMode=function(){return vt};var xt=w.__private__.setLayoutMode=function(t){if(-1==[void 0,null,"continuous","single","twoleft","tworight","two"].indexOf(t))throw new Error('Layout mode must be one of continuous, single, twoleft, tworight. "'+t+'" is not recognized.');yt=t};w.__private__.getLayoutMode=function(){return yt},w.__private__.setDisplayMode=w.setDisplayMode=function(t,e,r){return wt(t),xt(e),_t(r),this};var At={title:"",subject:"",author:"",keywords:"",creator:""};w.__private__.getDocumentProperty=function(t){if(-1===Object.keys(At).indexOf(t))throw new Error("Invalid argument passed to jsPDF.getDocumentProperty");return At[t]},w.__private__.getDocumentProperties=function(){return At},w.__private__.setDocumentProperties=w.setProperties=w.setDocumentProperties=function(t){for(var e in At)At.hasOwnProperty(e)&&t[e]&&(At[e]=t[e]);return this},w.__private__.setDocumentProperty=function(t,e){if(-1===Object.keys(At).indexOf(t))throw new Error("Invalid arguments passed to jsPDF.setDocumentProperty");return At[t]=e};var Lt,Nt,St,kt,Pt,Ft={},It={},Ct=[],jt={},Et={},Ot={},Bt={},Mt=null,Rt=0,Tt=[],qt=new j(w),Dt=t.hotfixes||[],zt={},Ut={},Ht=[],Wt=function t(e,r,n,i,a,s){if(!(this instanceof t))return new t(e,r,n,i,a,s);isNaN(e)&&(e=1),isNaN(r)&&(r=0),isNaN(n)&&(n=0),isNaN(i)&&(i=1),isNaN(a)&&(a=0),isNaN(s)&&(s=0),this._matrix=[e,r,n,i,a,s]};Object.defineProperty(Wt.prototype,"sx",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Wt.prototype,"shy",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Wt.prototype,"shx",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Wt.prototype,"sy",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Wt.prototype,"tx",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Wt.prototype,"ty",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Wt.prototype,"a",{get:function(){return this._matrix[0]},set:function(t){this._matrix[0]=t}}),Object.defineProperty(Wt.prototype,"b",{get:function(){return this._matrix[1]},set:function(t){this._matrix[1]=t}}),Object.defineProperty(Wt.prototype,"c",{get:function(){return this._matrix[2]},set:function(t){this._matrix[2]=t}}),Object.defineProperty(Wt.prototype,"d",{get:function(){return this._matrix[3]},set:function(t){this._matrix[3]=t}}),Object.defineProperty(Wt.prototype,"e",{get:function(){return this._matrix[4]},set:function(t){this._matrix[4]=t}}),Object.defineProperty(Wt.prototype,"f",{get:function(){return this._matrix[5]},set:function(t){this._matrix[5]=t}}),Object.defineProperty(Wt.prototype,"rotation",{get:function(){return Math.atan2(this.shx,this.sx)}}),Object.defineProperty(Wt.prototype,"scaleX",{get:function(){return this.decompose().scale.sx}}),Object.defineProperty(Wt.prototype,"scaleY",{get:function(){return this.decompose().scale.sy}}),Object.defineProperty(Wt.prototype,"isIdentity",{get:function(){return 1===this.sx&&0===this.shy&&0===this.shx&&1===this.sy&&0===this.tx&&0===this.ty}}),Wt.prototype.join=function(t){return[this.sx,this.shy,this.shx,this.sy,this.tx,this.ty].map(O).join(t)},Wt.prototype.multiply=function(t){var e=t.sx*this.sx+t.shy*this.shx,r=t.sx*this.shy+t.shy*this.sy,n=t.shx*this.sx+t.sy*this.shx,i=t.shx*this.shy+t.sy*this.sy,a=t.tx*this.sx+t.ty*this.shx+this.tx,s=t.tx*this.shy+t.ty*this.sy+this.ty;return new Wt(e,r,n,i,a,s)},Wt.prototype.decompose=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,s=Math.sqrt(t*t+e*e),o=(t/=s)*r+(e/=s)*n;r-=t*o,n-=e*o;var h=Math.sqrt(r*r+n*n);return o/=h,t*(n/=h)<e*(r/=h)&&(t=-t,e=-e,o=-o,s=-s),{scale:new Wt(s,0,0,h,0,0),translate:new Wt(1,0,0,1,i,a),rotate:new Wt(t,e,-e,t,0,0),skew:new Wt(1,0,o,1,0,0)}},Wt.prototype.toString=function(t){return this.join(" ")},Wt.prototype.inversed=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty,s=1/(t*n-e*r),o=n*s,h=-e*s,l=-r*s,u=t*s;return new Wt(o,h,l,u,-o*i-l*a,-h*i-u*a)},Wt.prototype.applyToPoint=function(t){var e=t.x*this.sx+t.y*this.shx+this.tx,r=t.x*this.shy+t.y*this.sy+this.ty;return new pr(e,r)},Wt.prototype.applyToRectangle=function(t){var e=this.applyToPoint(t),r=this.applyToPoint(new pr(t.x+t.w,t.y+t.h));return new gr(e.x,e.y,r.x-e.x,r.y-e.y)},Wt.prototype.clone=function(){var t=this.sx,e=this.shy,r=this.shx,n=this.sy,i=this.tx,a=this.ty;return new Wt(t,e,r,n,i,a)},w.Matrix=Wt;var Vt=w.matrixMult=function(t,e){return e.multiply(t)},Gt=new Wt(1,0,0,1,0,0);w.unitMatrix=w.identityMatrix=Gt;var Yt=function(t,e){if(!Et[t]){var r=(e instanceof B?"Sh":"P")+(Object.keys(jt).length+1).toString(10);e.id=r,Et[t]=r,jt[r]=e,qt.publish("addPattern",e)}};w.ShadingPattern=B,w.TilingPattern=M,w.addShadingPattern=function(t,e){return T("addShadingPattern()"),Yt(t,e),this},w.beginTilingPattern=function(t){T("beginTilingPattern()"),br(t.boundingBox[0],t.boundingBox[1],t.boundingBox[2]-t.boundingBox[0],t.boundingBox[3]-t.boundingBox[1],t.matrix)},w.endTilingPattern=function(t,e){T("endTilingPattern()"),e.stream=st[$].join("\n"),Yt(t,e),qt.publish("endTilingPattern",e),Ht.pop().restore()};var Zt,Jt=w.__private__.newObject=function(){var t=Xt();return Kt(t,!0),t},Xt=w.__private__.newObjectDeferred=function(){return et++,rt[et]=function(){return it},et},Kt=function(t,e){return e="boolean"==typeof e&&e,rt[t]=it,e&&ut(t+" 0 obj"),t},$t=w.__private__.newAdditionalObject=function(){var t={objId:Xt(),content:""};return at.push(t),t},Qt=Xt(),te=Xt(),ee=w.__private__.decodeColorString=function(t){var e=t.split(" ");if(2!==e.length||"g"!==e[1]&&"G"!==e[1])5!==e.length||"k"!==e[4]&&"K"!==e[4]||(e=[(1-e[0])*(1-e[3]),(1-e[1])*(1-e[3]),(1-e[2])*(1-e[3]),"r"]);else{var r=parseFloat(e[0]);e=[r,r,r,"r"]}for(var n="#",i=0;i<3;i++)n+=("0"+Math.floor(255*parseFloat(e[i])).toString(16)).slice(-2);return n},re=w.__private__.encodeColorString=function(t){var e;"string"==typeof t&&(t={ch1:t});var r=t.ch1,i=t.ch2,a=t.ch3,s=t.ch4,o="draw"===t.pdfColorType?["G","RG","K"]:["g","rg","k"];if("string"==typeof r&&"#"!==r.charAt(0)){var h=new c(r);if(h.ok)r=h.toHex();else if(!/^\d*\.?\d*$/.test(r))throw new Error('Invalid color "'+r+'" passed to jsPDF.encodeColorString.')}if("string"==typeof r&&/^#[0-9A-Fa-f]{3}$/.test(r)&&(r="#"+r[1]+r[1]+r[2]+r[2]+r[3]+r[3]),"string"==typeof r&&/^#[0-9A-Fa-f]{6}$/.test(r)){var l=parseInt(r.substr(1),16);r=l>>16&255,i=l>>8&255,a=255&l}if(void 0===i||void 0===s&&r===i&&i===a)e="string"==typeof r?r+" "+o[0]:2===t.precision?D(r/255)+" "+o[0]:z(r/255)+" "+o[0];else if(void 0===s||"object"===n(s)){if(s&&!isNaN(s.a)&&0===s.a)return["1.","1.","1.",o[1]].join(" ");e="string"==typeof r?[r,i,a,o[1]].join(" "):2===t.precision?[D(r/255),D(i/255),D(a/255),o[1]].join(" "):[z(r/255),z(i/255),z(a/255),o[1]].join(" ")}else e="string"==typeof r?[r,i,a,s,o[2]].join(" "):2===t.precision?[D(r),D(i),D(a),D(s),o[2]].join(" "):[z(r),z(i),z(a),z(s),o[2]].join(" ");return e},ne=w.__private__.getFilters=function(){return l},ie=w.__private__.putStream=function(t){var e=(t=t||{}).data||"",r=t.filters||ne(),n=t.alreadyAppliedFilters||[],i=t.addLength1||!1,a=e.length,s=t.objectId,o=function(t){return t};if(null!==m&&void 0===s)throw new Error("ObjectId must be passed to putStream for file encryption");null!==m&&(o=Ce.encryptor(s,0));var h={};!0===r&&(r=["FlateEncode"]);var l=t.additionalKeyValues||[],u=(h=void 0!==R.API.processDataByFilters?R.API.processDataByFilters(e,r):{data:e,reverseChain:[]}).reverseChain+(Array.isArray(n)?n.join(" "):n.toString());if(0!==h.data.length&&(l.push({key:"Length",value:h.data.length}),!0===i&&l.push({key:"Length1",value:a})),0!=u.length)if(u.split("/").length-1==1)l.push({key:"Filter",value:u});else{l.push({key:"Filter",value:"["+u+"]"});for(var c=0;c<l.length;c+=1)if("DecodeParms"===l[c].key){for(var f=[],d=0;d<h.reverseChain.split("/").length-1;d+=1)f.push("null");f.push(l[c].value),l[c].value="["+f.join(" ")+"]"}}ut("<<");for(var p=0;p<l.length;p++)ut("/"+l[p].key+" "+l[p].value);ut(">>"),0!==h.data.length&&(ut("stream"),ut(o(h.data)),ut("endstream"))},ae=w.__private__.putPage=function(t){var e=t.number,r=t.data,n=t.objId,i=t.contentsObjId;Kt(n,!0),ut("<</Type /Page"),ut("/Parent "+t.rootDictionaryObjId+" 0 R"),ut("/Resources "+t.resourceDictionaryObjId+" 0 R"),ut("/MediaBox ["+parseFloat(O(t.mediaBox.bottomLeftX))+" "+parseFloat(O(t.mediaBox.bottomLeftY))+" "+O(t.mediaBox.topRightX)+" "+O(t.mediaBox.topRightY)+"]"),null!==t.cropBox&&ut("/CropBox ["+O(t.cropBox.bottomLeftX)+" "+O(t.cropBox.bottomLeftY)+" "+O(t.cropBox.topRightX)+" "+O(t.cropBox.topRightY)+"]"),null!==t.bleedBox&&ut("/BleedBox ["+O(t.bleedBox.bottomLeftX)+" "+O(t.bleedBox.bottomLeftY)+" "+O(t.bleedBox.topRightX)+" "+O(t.bleedBox.topRightY)+"]"),null!==t.trimBox&&ut("/TrimBox ["+O(t.trimBox.bottomLeftX)+" "+O(t.trimBox.bottomLeftY)+" "+O(t.trimBox.topRightX)+" "+O(t.trimBox.topRightY)+"]"),null!==t.artBox&&ut("/ArtBox ["+O(t.artBox.bottomLeftX)+" "+O(t.artBox.bottomLeftY)+" "+O(t.artBox.topRightX)+" "+O(t.artBox.topRightY)+"]"),"number"==typeof t.userUnit&&1!==t.userUnit&&ut("/UserUnit "+t.userUnit),qt.publish("putPage",{objId:n,pageContext:Tt[e],pageNumber:e,page:r}),ut("/Contents "+i+" 0 R"),ut(">>"),ut("endobj");var a=r.join("\n");return S===N&&(a+="\nQ"),Kt(i,!0),ie({data:a,filters:ne(),objectId:i}),ut("endobj"),n},se=w.__private__.putPages=function(){var t,e,r=[];for(t=1;t<=Rt;t++)Tt[t].objId=Xt(),Tt[t].contentsObjId=Xt();for(t=1;t<=Rt;t++)r.push(ae({number:t,data:st[t],objId:Tt[t].objId,contentsObjId:Tt[t].contentsObjId,mediaBox:Tt[t].mediaBox,cropBox:Tt[t].cropBox,bleedBox:Tt[t].bleedBox,trimBox:Tt[t].trimBox,artBox:Tt[t].artBox,userUnit:Tt[t].userUnit,rootDictionaryObjId:Qt,resourceDictionaryObjId:te}));Kt(Qt,!0),ut("<</Type /Pages");var n="/Kids [";for(e=0;e<Rt;e++)n+=r[e]+" 0 R ";ut(n+"]"),ut("/Count "+Rt),ut(">>"),ut("endobj"),qt.publish("postPutPages")},oe=function(t){qt.publish("putFont",{font:t,out:ut,newObject:Jt,putStream:ie}),!0!==t.isAlreadyPutted&&(t.objectNumber=Jt(),ut("<<"),ut("/Type /Font"),ut("/BaseFont /"+C(t.postScriptName)),ut("/Subtype /Type1"),"string"==typeof t.encoding&&ut("/Encoding /"+t.encoding),ut("/FirstChar 32"),ut("/LastChar 255"),ut(">>"),ut("endobj"))},he=function(t){t.objectNumber=Jt();var e=[];e.push({key:"Type",value:"/XObject"}),e.push({key:"Subtype",value:"/Form"}),e.push({key:"BBox",value:"["+[O(t.x),O(t.y),O(t.x+t.width),O(t.y+t.height)].join(" ")+"]"}),e.push({key:"Matrix",value:"["+t.matrix.toString()+"]"});var r=t.pages[1].join("\n");ie({data:r,additionalKeyValues:e,objectId:t.objectNumber}),ut("endobj")},le=function(t,e){e||(e=21);var r=Jt(),n=function(t,e){var r,n=[],i=1/(e-1);for(r=0;r<1;r+=i)n.push(r);if(n.push(1),0!=t[0].offset){var a={offset:0,color:t[0].color};t.unshift(a)}if(1!=t[t.length-1].offset){var s={offset:1,color:t[t.length-1].color};t.push(s)}for(var o="",h=0,l=0;l<n.length;l++){for(r=n[l];r>t[h+1].offset;)h++;var u=t[h].offset,c=(r-u)/(t[h+1].offset-u),f=t[h].color,d=t[h+1].color;o+=tt(Math.round((1-c)*f[0]+c*d[0]).toString(16))+tt(Math.round((1-c)*f[1]+c*d[1]).toString(16))+tt(Math.round((1-c)*f[2]+c*d[2]).toString(16))}return o.trim()}(t.colors,e),i=[];i.push({key:"FunctionType",value:"0"}),i.push({key:"Domain",value:"[0.0 1.0]"}),i.push({key:"Size",value:"["+e+"]"}),i.push({key:"BitsPerSample",value:"8"}),i.push({key:"Range",value:"[0.0 1.0 0.0 1.0 0.0 1.0]"}),i.push({key:"Decode",value:"[0.0 1.0 0.0 1.0 0.0 1.0]"}),ie({data:n,additionalKeyValues:i,alreadyAppliedFilters:["/ASCIIHexDecode"],objectId:r}),ut("endobj"),t.objectNumber=Jt(),ut("<< /ShadingType "+t.type),ut("/ColorSpace /DeviceRGB");var a="/Coords ["+O(parseFloat(t.coords[0]))+" "+O(parseFloat(t.coords[1]))+" ";2===t.type?a+=O(parseFloat(t.coords[2]))+" "+O(parseFloat(t.coords[3])):a+=O(parseFloat(t.coords[2]))+" "+O(parseFloat(t.coords[3]))+" "+O(parseFloat(t.coords[4]))+" "+O(parseFloat(t.coords[5])),ut(a+="]"),t.matrix&&ut("/Matrix ["+t.matrix.toString()+"]"),ut("/Function "+r+" 0 R"),ut("/Extend [true true]"),ut(">>"),ut("endobj")},ue=function(t,e){var r=Xt(),n=Jt();e.push({resourcesOid:r,objectOid:n}),t.objectNumber=n;var i=[];i.push({key:"Type",value:"/Pattern"}),i.push({key:"PatternType",value:"1"}),i.push({key:"PaintType",value:"1"}),i.push({key:"TilingType",value:"1"}),i.push({key:"BBox",value:"["+t.boundingBox.map(O).join(" ")+"]"}),i.push({key:"XStep",value:O(t.xStep)}),i.push({key:"YStep",value:O(t.yStep)}),i.push({key:"Resources",value:r+" 0 R"}),t.matrix&&i.push({key:"Matrix",value:"["+t.matrix.toString()+"]"}),ie({data:t.stream,additionalKeyValues:i,objectId:t.objectNumber}),ut("endobj")},ce=function(t){for(var e in t.objectNumber=Jt(),ut("<<"),t)switch(e){case"opacity":ut("/ca "+D(t[e]));break;case"stroke-opacity":ut("/CA "+D(t[e]))}ut(">>"),ut("endobj")},fe=function(t){Kt(t.resourcesOid,!0),ut("<<"),ut("/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]"),function(){for(var t in ut("/Font <<"),Ft)Ft.hasOwnProperty(t)&&(!1===b||!0===b&&v.hasOwnProperty(t))&&ut("/"+t+" "+Ft[t].objectNumber+" 0 R");ut(">>")}(),function(){if(Object.keys(jt).length>0){for(var t in ut("/Shading <<"),jt)jt.hasOwnProperty(t)&&jt[t]instanceof B&&jt[t].objectNumber>=0&&ut("/"+t+" "+jt[t].objectNumber+" 0 R");qt.publish("putShadingPatternDict"),ut(">>")}}(),function(t){if(Object.keys(jt).length>0){for(var e in ut("/Pattern <<"),jt)jt.hasOwnProperty(e)&&jt[e]instanceof w.TilingPattern&&jt[e].objectNumber>=0&&jt[e].objectNumber<t&&ut("/"+e+" "+jt[e].objectNumber+" 0 R");qt.publish("putTilingPatternDict"),ut(">>")}}(t.objectOid),function(){if(Object.keys(Ot).length>0){var t;for(t in ut("/ExtGState <<"),Ot)Ot.hasOwnProperty(t)&&Ot[t].objectNumber>=0&&ut("/"+t+" "+Ot[t].objectNumber+" 0 R");qt.publish("putGStateDict"),ut(">>")}}(),function(){for(var t in ut("/XObject <<"),zt)zt.hasOwnProperty(t)&&zt[t].objectNumber>=0&&ut("/"+t+" "+zt[t].objectNumber+" 0 R");qt.publish("putXobjectDict"),ut(">>")}(),ut(">>"),ut("endobj")},de=function(t){It[t.fontName]=It[t.fontName]||{},It[t.fontName][t.fontStyle]=t.id},pe=function(t,e,r,n,i){var a={id:"F"+(Object.keys(Ft).length+1).toString(10),postScriptName:t,fontName:e,fontStyle:r,encoding:n,isStandardFont:i||!1,metadata:{}};return qt.publish("addFont",{font:a,instance:this}),Ft[a.id]=a,de(a),a.id},ge=w.__private__.pdfEscape=w.pdfEscape=function(t,e){return function(t,e){var r,n,i,a,s,o,h,l,u;if(i=(e=e||{}).sourceEncoding||"Unicode",s=e.outputEncoding,(e.autoencode||s)&&Ft[Lt].metadata&&Ft[Lt].metadata[i]&&Ft[Lt].metadata[i].encoding&&(a=Ft[Lt].metadata[i].encoding,!s&&Ft[Lt].encoding&&(s=Ft[Lt].encoding),!s&&a.codePages&&(s=a.codePages[0]),"string"==typeof s&&(s=a[s]),s)){for(h=!1,o=[],r=0,n=t.length;r<n;r++)(l=s[t.charCodeAt(r)])?o.push(String.fromCharCode(l)):o.push(t[r]),o[r].charCodeAt(0)>>8&&(h=!0);t=o.join("")}for(r=t.length;void 0===h&&0!==r;)t.charCodeAt(r-1)>>8&&(h=!0),r--;if(!h)return t;for(o=e.noBOM?[]:[254,255],r=0,n=t.length;r<n;r++){if((u=(l=t.charCodeAt(r))>>8)>>8)throw new Error("Character at position "+r+" of string '"+t+"' exceeds 16bits. Cannot be encoded into UCS-2 BE");o.push(u),o.push(l-(u<<8))}return String.fromCharCode.apply(void 0,o)}(t,e).replace(/\\/g,"\\\\").replace(/\(/g,"\\(").replace(/\)/g,"\\)")},me=w.__private__.beginPage=function(t){st[++Rt]=[],Tt[Rt]={objId:0,contentsObjId:0,userUnit:Number(f),artBox:null,bleedBox:null,cropBox:null,trimBox:null,mediaBox:{bottomLeftX:0,bottomLeftY:0,topRightX:Number(t[0]),topRightY:Number(t[1])}},we(Rt),lt(st[$])},be=function(t,e){var n,i,a;switch(r=e||r,"string"==typeof t&&(n=A(t.toLowerCase()),Array.isArray(n)&&(i=n[0],a=n[1])),Array.isArray(t)&&(i=t[0]*Nt,a=t[1]*Nt),isNaN(i)&&(i=o[0],a=o[1]),(i>14400||a>14400)&&(s.warn("A page in a PDF can not be wider or taller than 14400 userUnit. jsPDF limits the width/height to 14400"),i=Math.min(14400,i),a=Math.min(14400,a)),o=[i,a],r.substr(0,1)){case"l":a>i&&(o=[a,i]);break;case"p":i>a&&(o=[a,i])}me(o),Ke(Je),ut(ar),0!==cr&&ut(cr+" J"),0!==fr&&ut(fr+" j"),qt.publish("addPage",{pageNumber:Rt})},ve=function(t){t>0&&t<=Rt&&(st.splice(t,1),Tt.splice(t,1),Rt--,$>Rt&&($=Rt),this.setPage($))},we=function(t){t>0&&t<=Rt&&($=t)},ye=w.__private__.getNumberOfPages=w.getNumberOfPages=function(){return st.length-1},_e=function(t,e,r){var n,i=void 0;return r=r||{},t=void 0!==t?t:Ft[Lt].fontName,e=void 0!==e?e:Ft[Lt].fontStyle,n=t.toLowerCase(),void 0!==It[n]&&void 0!==It[n][e]?i=It[n][e]:void 0!==It[t]&&void 0!==It[t][e]?i=It[t][e]:!1===r.disableWarning&&s.warn("Unable to look up font label for font '"+t+"', '"+e+"'. Refer to getFontList() for available fonts."),i||r.noFallback||null==(i=It.times[e])&&(i=It.times.normal),i},xe=w.__private__.putInfo=function(){var t=Jt(),e=function(t){return t};for(var r in null!==m&&(e=Ce.encryptor(t,0)),ut("<<"),ut("/Producer ("+ge(e("jsPDF "+R.version))+")"),At)At.hasOwnProperty(r)&&At[r]&&ut("/"+r.substr(0,1).toUpperCase()+r.substr(1)+" ("+ge(e(At[r]))+")");ut("/CreationDate ("+ge(e(W))+")"),ut(">>"),ut("endobj")},Ae=w.__private__.putCatalog=function(t){var e=(t=t||{}).rootDictionaryObjId||Qt;switch(Jt(),ut("<<"),ut("/Type /Catalog"),ut("/Pages "+e+" 0 R"),gt||(gt="fullwidth"),gt){case"fullwidth":ut("/OpenAction [3 0 R /FitH null]");break;case"fullheight":ut("/OpenAction [3 0 R /FitV null]");break;case"fullpage":ut("/OpenAction [3 0 R /Fit]");break;case"original":ut("/OpenAction [3 0 R /XYZ null null 1]");break;default:var r=""+gt;"%"===r.substr(r.length-1)&&(gt=parseInt(gt)/100),"number"==typeof gt&&ut("/OpenAction [3 0 R /XYZ null null "+D(gt)+"]")}switch(yt||(yt="continuous"),yt){case"continuous":ut("/PageLayout /OneColumn");break;case"single":ut("/PageLayout /SinglePage");break;case"two":case"twoleft":ut("/PageLayout /TwoColumnLeft");break;case"tworight":ut("/PageLayout /TwoColumnRight")}vt&&ut("/PageMode /"+vt),qt.publish("putCatalog"),ut(">>"),ut("endobj")},Le=w.__private__.putTrailer=function(){ut("trailer"),ut("<<"),ut("/Size "+(et+1)),ut("/Root "+et+" 0 R"),ut("/Info "+(et-1)+" 0 R"),null!==m&&ut("/Encrypt "+Ce.oid+" 0 R"),ut("/ID [ <"+V+"> <"+V+"> ]"),ut(">>")},Ne=w.__private__.putHeader=function(){ut("%PDF-"+y),ut("%ºß¬à")},Se=w.__private__.putXRef=function(){var t="0000000000";ut("xref"),ut("0 "+(et+1)),ut("0000000000 65535 f ");for(var e=1;e<=et;e++)"function"==typeof rt[e]?ut((t+rt[e]()).slice(-10)+" 00000 n "):void 0!==rt[e]?ut((t+rt[e]).slice(-10)+" 00000 n "):ut("0000000000 00000 n ")},ke=w.__private__.buildDocument=function(){var t;et=0,it=0,nt=[],rt=[],at=[],Qt=Xt(),te=Xt(),lt(nt),qt.publish("buildDocument"),Ne(),se(),function(){qt.publish("putAdditionalObjects");for(var t=0;t<at.length;t++){var e=at[t];Kt(e.objId,!0),ut(e.content),ut("endobj")}qt.publish("postPutAdditionalObjects")}(),t=[],function(){for(var t in Ft)Ft.hasOwnProperty(t)&&(!1===b||!0===b&&v.hasOwnProperty(t))&&oe(Ft[t])}(),function(){var t;for(t in Ot)Ot.hasOwnProperty(t)&&ce(Ot[t])}(),function(){for(var t in zt)zt.hasOwnProperty(t)&&he(zt[t])}(),function(t){var e;for(e in jt)jt.hasOwnProperty(e)&&(jt[e]instanceof B?le(jt[e]):jt[e]instanceof M&&ue(jt[e],t))}(t),qt.publish("putResources"),t.forEach(fe),fe({resourcesOid:te,objectOid:Number.MAX_SAFE_INTEGER}),qt.publish("postPutResources"),null!==m&&(Ce.oid=Jt(),ut("<<"),ut("/Filter /Standard"),ut("/V "+Ce.v),ut("/R "+Ce.r),ut("/U <"+Ce.toHexString(Ce.U)+">"),ut("/O <"+Ce.toHexString(Ce.O)+">"),ut("/P "+Ce.P),ut(">>"),ut("endobj")),xe(),Ae();var e=it;return Se(),Le(),ut("startxref"),ut(""+e),ut("%%EOF"),lt(st[$]),nt.join("\n")},Pe=w.__private__.getBlob=function(t){return new Blob([ft(t)],{type:"application/pdf"})},Fe=w.output=w.__private__.output=(Zt=function(t,e){switch("string"==typeof(e=e||{})?e={filename:e}:e.filename=e.filename||"generated.pdf",t){case void 0:return ke();case"save":w.save(e.filename);break;case"arraybuffer":return ft(ke());case"blob":return Pe(ke());case"bloburi":case"bloburl":if(void 0!==i.URL&&"function"==typeof i.URL.createObjectURL)return i.URL&&i.URL.createObjectURL(Pe(ke()))||void 0;s.warn("bloburl is not supported by your system, because URL.createObjectURL is not supported by your browser.");break;case"datauristring":case"dataurlstring":var r="",n=ke();try{r=d(n)}catch(m){r=d(unescape(encodeURIComponent(n)))}return"data:application/pdf;filename="+e.filename+";base64,"+r;case"pdfobjectnewwindow":if("[object Window]"===Object.prototype.toString.call(i)){var a="https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js",o=' integrity="sha512-4ze/a9/4jqu+tX9dfOqJYSvyYd5M6qum/3HpCLr+/Jqf0whc37VUbkpNGHR7/8pSnCFw47T1fmIpwBV7UySh3g==" crossorigin="anonymous"';e.pdfObjectUrl&&(a=e.pdfObjectUrl,o="");var h='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><script src="'+a+'"'+o+'><\/script><script >PDFObject.embed("'+this.output("dataurlstring")+'", '+JSON.stringify(e)+");<\/script></body></html>",l=i.open();return null!==l&&l.document.write(h),l}throw new Error("The option pdfobjectnewwindow just works in a browser-environment.");case"pdfjsnewwindow":if("[object Window]"===Object.prototype.toString.call(i)){var u='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe id="pdfViewer" src="'+(e.pdfJsUrl||"examples/PDF.js/web/viewer.html")+"?file=&downloadName="+e.filename+'" width="500px" height="400px" /></body></html>',c=i.open();if(null!==c){c.document.write(u);var f=this;c.document.documentElement.querySelector("#pdfViewer").onload=function(){c.document.title=e.filename,c.document.documentElement.querySelector("#pdfViewer").contentWindow.PDFViewerApplication.open(f.output("bloburl"))}}return c}throw new Error("The option pdfjsnewwindow just works in a browser-environment.");case"dataurlnewwindow":if("[object Window]"!==Object.prototype.toString.call(i))throw new Error("The option dataurlnewwindow just works in a browser-environment.");var p='<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe src="'+this.output("datauristring",e)+'"></iframe></body></html>',g=i.open();if(null!==g&&(g.document.write(p),g.document.title=e.filename),g||"undefined"==typeof safari)return g;break;case"datauri":case"dataurl":return i.document.location.href=this.output("datauristring",e);default:return null}},Zt.foo=function(){try{return Zt.apply(this,arguments)}catch(r){var t=r.stack||"";~t.indexOf(" at ")&&(t=t.split(" at ")[1]);var e="Error in function "+t.split("\n")[0].split("<")[0]+": "+r.message;if(!i.console)throw new Error(e);i.console.error(e,r),i.alert&&alert(e)}},Zt.foo.bar=Zt,Zt.foo),Ie=function(t){return!0===Array.isArray(Dt)&&Dt.indexOf(t)>-1};switch(a){case"pt":Nt=1;break;case"mm":Nt=72/25.4;break;case"cm":Nt=72/2.54;break;case"in":Nt=72;break;case"px":Nt=1==Ie("px_scaling")?.75:96/72;break;case"pc":case"em":Nt=12;break;case"ex":Nt=6;break;default:if("number"!=typeof a)throw new Error("Invalid unit: "+a);Nt=a}var Ce=null;X(),Y();var je=w.__private__.getPageInfo=w.getPageInfo=function(t){if(isNaN(t)||t%1!=0)throw new Error("Invalid argument passed to jsPDF.getPageInfo");return{objId:Tt[t].objId,pageNumber:t,pageContext:Tt[t]}},Ee=w.__private__.getPageInfoByObjId=function(t){if(isNaN(t)||t%1!=0)throw new Error("Invalid argument passed to jsPDF.getPageInfoByObjId");for(var e in Tt)if(Tt[e].objId===t)break;return je(e)},Oe=w.__private__.getCurrentPageInfo=w.getCurrentPageInfo=function(){return{objId:Tt[$].objId,pageNumber:$,pageContext:Tt[$]}};w.addPage=function(){return be.apply(this,arguments),this},w.setPage=function(){return we.apply(this,arguments),lt.call(this,st[$]),this},w.insertPage=function(t){return this.addPage(),this.movePage($,t),this},w.movePage=function(t,e){var r,n;if(t>e){r=st[t],n=Tt[t];for(var i=t;i>e;i--)st[i]=st[i-1],Tt[i]=Tt[i-1];st[e]=r,Tt[e]=n,this.setPage(e)}else if(t<e){r=st[t],n=Tt[t];for(var a=t;a<e;a++)st[a]=st[a+1],Tt[a]=Tt[a+1];st[e]=r,Tt[e]=n,this.setPage(e)}return this},w.deletePage=function(){return ve.apply(this,arguments),this},w.__private__.text=w.text=function(t,e,r,i,a){var s,o,h,l,u,c,f,d,p,g=(i=i||{}).scope||this;if("number"==typeof t&&"number"==typeof e&&("string"==typeof r||Array.isArray(r))){var m=r;r=e,e=t,t=m}if(arguments[3]instanceof Wt==0?(h=arguments[4],l=arguments[5],"object"===n(f=arguments[3])&&null!==f||("string"==typeof h&&(l=h,h=null),"string"==typeof f&&(l=f,f=null),"number"==typeof f&&(h=f,f=null),i={flags:f,angle:h,align:l})):(T("The transform parameter of text() with a Matrix value"),p=a),isNaN(e)||isNaN(r)||null==t)throw new Error("Invalid arguments passed to jsPDF.text");if(0===t.length)return g;var b,w="",y="number"==typeof i.lineHeightFactor?i.lineHeightFactor:Ze,_=g.internal.scaleFactor;function x(t){return t=t.split("\t").join(Array(i.TabLen||9).join(" ")),ge(t,f)}function A(t){for(var e,r=t.concat(),n=[],i=r.length;i--;)"string"==typeof(e=r.shift())?n.push(e):Array.isArray(t)&&(1===e.length||void 0===e[1]&&void 0===e[2])?n.push(e[0]):n.push([e[0],e[1],e[2]]);return n}function L(t,e){var r;if("string"==typeof t)r=e(t)[0];else if(Array.isArray(t)){for(var n,i,a=t.concat(),s=[],o=a.length;o--;)"string"==typeof(n=a.shift())?s.push(e(n)[0]):Array.isArray(n)&&"string"==typeof n[0]&&(i=e(n[0],n[1],n[2]),s.push([i[0],i[1],i[2]]));r=s}return r}var k=!1,P=!0;if("string"==typeof t)k=!0;else if(Array.isArray(t)){var F=t.concat();o=[];for(var I,C=F.length;C--;)("string"!=typeof(I=F.shift())||Array.isArray(I)&&"string"!=typeof I[0])&&(P=!1);k=P}if(!1===k)throw new Error('Type of text must be string or Array. "'+t+'" is not recognized.');"string"==typeof t&&(t=t.match(/[\r?\n]/)?t.split(/\r\n|\r|\n/g):[t]);var j=pt/g.internal.scaleFactor,E=j*(y-1);switch(i.baseline){case"bottom":r-=E;break;case"top":r+=j-E;break;case"hanging":r+=j-2*E;break;case"middle":r+=j/2-E}if((c=i.maxWidth||0)>0&&("string"==typeof t?t=g.splitTextToSize(t,c):"[object Array]"===Object.prototype.toString.call(t)&&(t=t.reduce(function(t,e){return t.concat(g.splitTextToSize(e,c))},[]))),s={text:t,x:e,y:r,options:i,mutex:{pdfEscape:ge,activeFontKey:Lt,fonts:Ft,activeFontSize:pt}},qt.publish("preProcessText",s),t=s.text,h=(i=s.options).angle,p instanceof Wt==0&&h&&"number"==typeof h){h*=Math.PI/180,0===i.rotationDirection&&(h=-h),S===N&&(h=-h);var B=Math.cos(h),M=Math.sin(h);p=new Wt(B,M,-M,B,0,0)}else h&&h instanceof Wt&&(p=h);S!==N||p||(p=Gt),void 0!==(u=i.charSpace||lr)&&(w+=O(U(u))+" Tc\n",this.setCharSpace(this.getCharSpace()||0)),void 0!==(d=i.horizontalScale)&&(w+=O(100*d)+" Tz\n"),i.lang;var R=-1,q=void 0!==i.renderingMode?i.renderingMode:i.stroke,D=g.internal.getCurrentPageInfo().pageContext;switch(q){case 0:case!1:case"fill":R=0;break;case 1:case!0:case"stroke":R=1;break;case 2:case"fillThenStroke":R=2;break;case 3:case"invisible":R=3;break;case 4:case"fillAndAddForClipping":R=4;break;case 5:case"strokeAndAddPathForClipping":R=5;break;case 6:case"fillThenStrokeAndAddToPathForClipping":R=6;break;case 7:case"addToPathForClipping":R=7}var z=void 0!==D.usedRenderingMode?D.usedRenderingMode:-1;-1!==R?w+=R+" Tr\n":-1!==z&&(w+="0 Tr\n"),-1!==R&&(D.usedRenderingMode=R),l=i.align||"left";var H,W=pt*y,V=g.internal.pageSize.getWidth(),G=Ft[Lt];u=i.charSpace||lr,c=i.maxWidth||0,f=Object.assign({autoencode:!0,noBOM:!0},i.flags);var Y=[],Z=function(t){return g.getStringUnitWidth(t,{font:G,charSpace:u,fontSize:pt,doKerning:!1})*pt/_};if("[object Array]"===Object.prototype.toString.call(t)){var J;o=A(t),"left"!==l&&(H=o.map(Z));var X,K=0;if("right"===l){e-=H[0],t=[],C=o.length;for(var $=0;$<C;$++)0===$?(X=er(e),J=rr(r)):(X=U(K-H[$]),J=-W),t.push([o[$],X,J]),K=H[$]}else if("center"===l){e-=H[0]/2,t=[],C=o.length;for(var Q=0;Q<C;Q++)0===Q?(X=er(e),J=rr(r)):(X=U((K-H[Q])/2),J=-W),t.push([o[Q],X,J]),K=H[Q]}else if("left"===l){t=[],C=o.length;for(var tt=0;tt<C;tt++)t.push(o[tt])}else if("justify"===l&&"Identity-H"===G.encoding){t=[],C=o.length,c=0!==c?c:V;for(var et=0,rt=0;rt<C;rt++)if(J=0===rt?rr(r):-W,X=0===rt?er(e):et,rt<C-1){var nt=U((c-H[rt])/(o[rt].split(" ").length-1)),it=o[rt].split(" ");t.push([it[0]+" ",X,J]),et=0;for(var at=1;at<it.length;at++){var st=(Z(it[at-1]+" "+it[at])-Z(it[at]))*_+nt;at==it.length-1?t.push([it[at],st,0]):t.push([it[at]+" ",st,0]),et-=st}}else t.push([o[rt],X,J]);t.push(["",et,0])}else{if("justify"!==l)throw new Error('Unrecognized alignment option, use "left", "center", "right" or "justify".');for(t=[],C=o.length,c=0!==c?c:V,rt=0;rt<C;rt++){J=0===rt?rr(r):-W,X=0===rt?er(e):0;var ot=o[rt].split(" ").length-1,ht=ot>0?(c-H[rt])/ot:0;rt<C-1?Y.push(O(U(ht))):Y.push(0),t.push([o[rt],X,J])}}}!0===("boolean"==typeof i.R2L?i.R2L:bt)&&(t=L(t,function(t,e,r){return[t.split("").reverse().join(""),e,r]})),s={text:t,x:e,y:r,options:i,mutex:{pdfEscape:ge,activeFontKey:Lt,fonts:Ft,activeFontSize:pt}},qt.publish("postProcessText",s),t=s.text,b=s.mutex.isHex||!1;var lt=Ft[Lt].encoding;"WinAnsiEncoding"!==lt&&"StandardEncoding"!==lt||(t=L(t,function(t,e,r){return[x(t),e,r]})),o=A(t),t=[];for(var ct,ft,dt,gt=Array.isArray(o[0])?1:0,mt="",vt=function(t,e,r){var n="";return r instanceof Wt?(r="number"==typeof i.angle?Vt(r,new Wt(1,0,0,1,t,e)):Vt(new Wt(1,0,0,1,t,e),r),S===N&&(r=Vt(new Wt(1,0,0,-1,0,0),r)),n=r.join(" ")+" Tm\n"):n=O(t)+" "+O(e)+" Td\n",n},wt=0;wt<o.length;wt++){switch(mt="",gt){case 1:dt=(b?"<":"(")+o[wt][0]+(b?">":")"),ct=parseFloat(o[wt][1]),ft=parseFloat(o[wt][2]);break;case 0:dt=(b?"<":"(")+o[wt]+(b?">":")"),ct=er(e),ft=rr(r)}void 0!==Y&&void 0!==Y[wt]&&(mt=Y[wt]+" Tw\n"),0===wt?t.push(mt+vt(ct,ft,p)+dt):0===gt?t.push(mt+dt):1===gt&&t.push(mt+vt(ct,ft,p)+dt)}t=0===gt?t.join(" Tj\nT* "):t.join(" Tj\n"),t+=" Tj\n";var yt="BT\n/";return yt+=Lt+" "+pt+" Tf\n",yt+=O(pt*y)+" TL\n",yt+=or+"\n",yt+=w,yt+=t,ut(yt+="ET"),v[Lt]=!0,g};var Be=w.__private__.clip=w.clip=function(t){return ut("evenodd"===t?"W*":"W"),this};w.clipEvenOdd=function(){return Be("evenodd")},w.__private__.discardPath=w.discardPath=function(){return ut("n"),this};var Me=w.__private__.isValidStyle=function(t){var e=!1;return-1!==[void 0,null,"S","D","F","DF","FD","f","f*","B","B*","n"].indexOf(t)&&(e=!0),e};w.__private__.setDefaultPathOperation=w.setDefaultPathOperation=function(t){return Me(t)&&(g=t),this};var Re=w.__private__.getStyle=w.getStyle=function(t){var e=g;switch(t){case"D":case"S":e="S";break;case"F":e="f";break;case"FD":case"DF":e="B";break;case"f":case"f*":case"B":case"B*":e=t}return e},Te=w.close=function(){return ut("h"),this};w.stroke=function(){return ut("S"),this},w.fill=function(t){return qe("f",t),this},w.fillEvenOdd=function(t){return qe("f*",t),this},w.fillStroke=function(t){return qe("B",t),this},w.fillStrokeEvenOdd=function(t){return qe("B*",t),this};var qe=function(t,e){"object"===n(e)?Ue(e,t):ut(t)},De=function(t){null===t||S===N&&void 0===t||(t=Re(t),ut(t))};function ze(t,e,r,n,i){var a=new M(e||this.boundingBox,r||this.xStep,n||this.yStep,this.gState,i||this.matrix);a.stream=this.stream;var s=t+"$$"+this.cloneIndex+++"$$";return Yt(s,a),a}var Ue=function(t,e){var r=Et[t.key],n=jt[r];if(n instanceof B)ut("q"),ut(He(e)),n.gState&&w.setGState(n.gState),ut(t.matrix.toString()+" cm"),ut("/"+r+" sh"),ut("Q");else if(n instanceof M){var i=new Wt(1,0,0,-1,0,Nr());t.matrix&&(i=i.multiply(t.matrix||Gt),r=ze.call(n,t.key,t.boundingBox,t.xStep,t.yStep,i).id),ut("q"),ut("/Pattern cs"),ut("/"+r+" scn"),n.gState&&w.setGState(n.gState),ut(e),ut("Q")}},He=function(t){switch(t){case"f":case"F":case"n":return"W n";case"f*":return"W* n";case"B":case"S":return"W S";case"B*":return"W* S"}},We=w.moveTo=function(t,e){return ut(O(U(t))+" "+O(H(e))+" m"),this},Ve=w.lineTo=function(t,e){return ut(O(U(t))+" "+O(H(e))+" l"),this},Ge=w.curveTo=function(t,e,r,n,i,a){return ut([O(U(t)),O(H(e)),O(U(r)),O(H(n)),O(U(i)),O(H(a)),"c"].join(" ")),this};w.__private__.line=w.line=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Me(i))throw new Error("Invalid arguments passed to jsPDF.line");return S===L?this.lines([[r-t,n-e]],t,e,[1,1],i||"S"):this.lines([[r-t,n-e]],t,e,[1,1]).stroke()},w.__private__.lines=w.lines=function(t,e,r,n,i,a){var s,o,h,l,u,c,f,d,p,g,m,b;if("number"==typeof t&&(b=r,r=e,e=t,t=b),n=n||[1,1],a=a||!1,isNaN(e)||isNaN(r)||!Array.isArray(t)||!Array.isArray(n)||!Me(i)||"boolean"!=typeof a)throw new Error("Invalid arguments passed to jsPDF.lines");for(We(e,r),s=n[0],o=n[1],l=t.length,g=e,m=r,h=0;h<l;h++)2===(u=t[h]).length?(g=u[0]*s+g,m=u[1]*o+m,Ve(g,m)):(c=u[0]*s+g,f=u[1]*o+m,d=u[2]*s+g,p=u[3]*o+m,g=u[4]*s+g,m=u[5]*o+m,Ge(c,f,d,p,g,m));return a&&Te(),De(i),this},w.path=function(t){for(var e=0;e<t.length;e++){var r=t[e],n=r.c;switch(r.op){case"m":We(n[0],n[1]);break;case"l":Ve(n[0],n[1]);break;case"c":Ge.apply(this,n);break;case"h":Te()}}return this},w.__private__.rect=w.rect=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Me(i))throw new Error("Invalid arguments passed to jsPDF.rect");return S===L&&(n=-n),ut([O(U(t)),O(H(e)),O(U(r)),O(U(n)),"re"].join(" ")),De(i),this},w.__private__.triangle=w.triangle=function(t,e,r,n,i,a,s){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i)||isNaN(a)||!Me(s))throw new Error("Invalid arguments passed to jsPDF.triangle");return this.lines([[r-t,n-e],[i-r,a-n],[t-i,e-a]],t,e,[1,1],s,!0),this},w.__private__.roundedRect=w.roundedRect=function(t,e,r,n,i,a,s){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i)||isNaN(a)||!Me(s))throw new Error("Invalid arguments passed to jsPDF.roundedRect");var o=4/3*(Math.SQRT2-1);return i=Math.min(i,.5*r),a=Math.min(a,.5*n),this.lines([[r-2*i,0],[i*o,0,i,a-a*o,i,a],[0,n-2*a],[0,a*o,-i*o,a,-i,a],[2*i-r,0],[-i*o,0,-i,-a*o,-i,-a],[0,2*a-n],[0,-a*o,i*o,-a,i,-a]],t+i,e,[1,1],s,!0),this},w.__private__.ellipse=w.ellipse=function(t,e,r,n,i){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||!Me(i))throw new Error("Invalid arguments passed to jsPDF.ellipse");var a=4/3*(Math.SQRT2-1)*r,s=4/3*(Math.SQRT2-1)*n;return We(t+r,e),Ge(t+r,e-s,t+a,e-n,t,e-n),Ge(t-a,e-n,t-r,e-s,t-r,e),Ge(t-r,e+s,t-a,e+n,t,e+n),Ge(t+a,e+n,t+r,e+s,t+r,e),De(i),this},w.__private__.circle=w.circle=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||!Me(n))throw new Error("Invalid arguments passed to jsPDF.circle");return this.ellipse(t,e,r,r,n)},w.setFont=function(t,e,r){return r&&(e=F(e,r)),Lt=_e(t,e,{disableWarning:!1}),this};var Ye=w.__private__.getFont=w.getFont=function(){return Ft[_e.apply(w,arguments)]};w.__private__.getFontList=w.getFontList=function(){var t,e,r={};for(t in It)if(It.hasOwnProperty(t))for(e in r[t]=[],It[t])It[t].hasOwnProperty(e)&&r[t].push(e);return r},w.addFont=function(t,e,r,n,i){var a=["StandardEncoding","MacRomanEncoding","Identity-H","WinAnsiEncoding"];return arguments[3]&&-1!==a.indexOf(arguments[3])?i=arguments[3]:arguments[3]&&-1==a.indexOf(arguments[3])&&(r=F(r,n)),pe.call(this,t,e,r,i=i||"Identity-H")};var Ze,Je=t.lineWidth||.200025,Xe=w.__private__.getLineWidth=w.getLineWidth=function(){return Je},Ke=w.__private__.setLineWidth=w.setLineWidth=function(t){return Je=t,ut(O(U(t))+" w"),this};w.__private__.setLineDash=R.API.setLineDash=R.API.setLineDashPattern=function(t,e){if(t=t||[],e=e||0,isNaN(e)||!Array.isArray(t))throw new Error("Invalid arguments passed to jsPDF.setLineDash");return t=t.map(function(t){return O(U(t))}).join(" "),e=O(U(e)),ut("["+t+"] "+e+" d"),this};var $e=w.__private__.getLineHeight=w.getLineHeight=function(){return pt*Ze};w.__private__.getLineHeight=w.getLineHeight=function(){return pt*Ze};var Qe=w.__private__.setLineHeightFactor=w.setLineHeightFactor=function(t){return"number"==typeof(t=t||1.15)&&(Ze=t),this},tr=w.__private__.getLineHeightFactor=w.getLineHeightFactor=function(){return Ze};Qe(t.lineHeight);var er=w.__private__.getHorizontalCoordinate=function(t){return U(t)},rr=w.__private__.getVerticalCoordinate=function(t){return S===N?t:Tt[$].mediaBox.topRightY-Tt[$].mediaBox.bottomLeftY-U(t)},nr=w.__private__.getHorizontalCoordinateString=w.getHorizontalCoordinateString=function(t){return O(er(t))},ir=w.__private__.getVerticalCoordinateString=w.getVerticalCoordinateString=function(t){return O(rr(t))},ar=t.strokeColor||"0 G";w.__private__.getStrokeColor=w.getDrawColor=function(){return ee(ar)},w.__private__.setStrokeColor=w.setDrawColor=function(t,e,r,n){return ar=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:"draw",precision:2}),ut(ar),this};var sr=t.fillColor||"0 g";w.__private__.getFillColor=w.getFillColor=function(){return ee(sr)},w.__private__.setFillColor=w.setFillColor=function(t,e,r,n){return sr=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:"fill",precision:2}),ut(sr),this};var or=t.textColor||"0 g",hr=w.__private__.getTextColor=w.getTextColor=function(){return ee(or)};w.__private__.setTextColor=w.setTextColor=function(t,e,r,n){return or=re({ch1:t,ch2:e,ch3:r,ch4:n,pdfColorType:"text",precision:3}),this};var lr=t.charSpace,ur=w.__private__.getCharSpace=w.getCharSpace=function(){return parseFloat(lr||0)};w.__private__.setCharSpace=w.setCharSpace=function(t){if(isNaN(t))throw new Error("Invalid argument passed to jsPDF.setCharSpace");return lr=t,this};var cr=0;w.CapJoinStyles={0:0,butt:0,but:0,miter:0,1:1,round:1,rounded:1,circle:1,2:2,projecting:2,project:2,square:2,bevel:2},w.__private__.setLineCap=w.setLineCap=function(t){var e=w.CapJoinStyles[t];if(void 0===e)throw new Error("Line cap style of '"+t+"' is not recognized. See or extend .CapJoinStyles property for valid styles");return cr=e,ut(e+" J"),this};var fr=0;w.__private__.setLineJoin=w.setLineJoin=function(t){var e=w.CapJoinStyles[t];if(void 0===e)throw new Error("Line join style of '"+t+"' is not recognized. See or extend .CapJoinStyles property for valid styles");return fr=e,ut(e+" j"),this},w.__private__.setLineMiterLimit=w.__private__.setMiterLimit=w.setLineMiterLimit=w.setMiterLimit=function(t){if(t=t||0,isNaN(t))throw new Error("Invalid argument passed to jsPDF.setLineMiterLimit");return ut(O(U(t))+" M"),this},w.GState=E,w.setGState=function(t){(t="string"==typeof t?Ot[Bt[t]]:dr(null,t)).equals(Mt)||(ut("/"+t.id+" gs"),Mt=t)};var dr=function(t,e){if(!t||!Bt[t]){var r=!1;for(var n in Ot)if(Ot.hasOwnProperty(n)&&Ot[n].equals(e)){r=!0;break}if(r)e=Ot[n];else{var i="GS"+(Object.keys(Ot).length+1).toString(10);Ot[i]=e,e.id=i}return t&&(Bt[t]=e.id),qt.publish("addGState",e),e}};w.addGState=function(t,e){return dr(t,e),this},w.saveGraphicsState=function(){return ut("q"),Ct.push({key:Lt,size:pt,color:or}),this},w.restoreGraphicsState=function(){ut("Q");var t=Ct.pop();return Lt=t.key,pt=t.size,or=t.color,Mt=null,this},w.setCurrentTransformationMatrix=function(t){return ut(t.toString()+" cm"),this},w.comment=function(t){return ut("#"+t),this};var pr=function(t,e){var r=t||0;Object.defineProperty(this,"x",{enumerable:!0,get:function(){return r},set:function(t){isNaN(t)||(r=parseFloat(t))}});var n=e||0;Object.defineProperty(this,"y",{enumerable:!0,get:function(){return n},set:function(t){isNaN(t)||(n=parseFloat(t))}});var i="pt";return Object.defineProperty(this,"type",{enumerable:!0,get:function(){return i},set:function(t){i=t.toString()}}),this},gr=function(t,e,r,n){pr.call(this,t,e),this.type="rect";var i=r||0;Object.defineProperty(this,"w",{enumerable:!0,get:function(){return i},set:function(t){isNaN(t)||(i=parseFloat(t))}});var a=n||0;return Object.defineProperty(this,"h",{enumerable:!0,get:function(){return a},set:function(t){isNaN(t)||(a=parseFloat(t))}}),this},mr=function(){this.page=Rt,this.currentPage=$,this.pages=st.slice(0),this.pagesContext=Tt.slice(0),this.x=St,this.y=kt,this.matrix=Pt,this.width=wr($),this.height=_r($),this.outputDestination=ht,this.id="",this.objectNumber=-1};mr.prototype.restore=function(){Rt=this.page,$=this.currentPage,Tt=this.pagesContext,st=this.pages,St=this.x,kt=this.y,Pt=this.matrix,yr($,this.width),xr($,this.height),ht=this.outputDestination};var br=function(t,e,r,n,i){Ht.push(new mr),Rt=$=0,st=[],St=t,kt=e,Pt=i,me([r,n])};for(var vr in w.beginFormObject=function(t,e,r,n,i){return br(t,e,r,n,i),this},w.endFormObject=function(t){return function(t){if(Ut[t])Ht.pop().restore();else{var e=new mr,r="Xo"+(Object.keys(zt).length+1).toString(10);e.id=r,Ut[t]=r,zt[r]=e,qt.publish("addFormObject",e),Ht.pop().restore()}}(t),this},w.doFormObject=function(t,e){var r=zt[Ut[t]];return ut("q"),ut(e.toString()+" cm"),ut("/"+r.id+" Do"),ut("Q"),this},w.getFormObject=function(t){var e=zt[Ut[t]];return{x:e.x,y:e.y,width:e.width,height:e.height,matrix:e.matrix}},w.save=function(t,e){return t=t||"generated.pdf",(e=e||{}).returnPromise=e.returnPromise||!1,!1===e.returnPromise?(u(Pe(ke()),t),"function"==typeof u.unload&&i.setTimeout&&setTimeout(u.unload,911),this):new Promise(function(e,r){try{var n=u(Pe(ke()),t);"function"==typeof u.unload&&i.setTimeout&&setTimeout(u.unload,911),e(n)}catch(a){r(a.message)}})},R.API)R.API.hasOwnProperty(vr)&&("events"===vr&&R.API.events.length?function(t,e){var r,n,i;for(i=e.length-1;-1!==i;i--)r=e[i][0],n=e[i][1],t.subscribe.apply(t,[r].concat("function"==typeof n?[n]:n))}(qt,R.API.events):w[vr]=R.API[vr]);function wr(t){return Tt[t].mediaBox.topRightX-Tt[t].mediaBox.bottomLeftX}function yr(t,e){Tt[t].mediaBox.topRightX=e+Tt[t].mediaBox.bottomLeftX}function _r(t){return Tt[t].mediaBox.topRightY-Tt[t].mediaBox.bottomLeftY}function xr(t,e){Tt[t].mediaBox.topRightY=e+Tt[t].mediaBox.bottomLeftY}var Ar=w.getPageWidth=function(t){return wr(t=t||$)/Nt},Lr=w.setPageWidth=function(t,e){yr(t,e*Nt)},Nr=w.getPageHeight=function(t){return _r(t=t||$)/Nt},Sr=w.setPageHeight=function(t,e){xr(t,e*Nt)};return w.internal={pdfEscape:ge,getStyle:Re,getFont:Ye,getFontSize:mt,getCharSpace:ur,getTextColor:hr,getLineHeight:$e,getLineHeightFactor:tr,getLineWidth:Xe,write:ct,getHorizontalCoordinate:er,getVerticalCoordinate:rr,getCoordinateString:nr,getVerticalCoordinateString:ir,collections:{},newObject:Jt,newAdditionalObject:$t,newObjectDeferred:Xt,newObjectDeferredBegin:Kt,getFilters:ne,putStream:ie,events:qt,scaleFactor:Nt,pageSize:{getWidth:function(){return Ar($)},setWidth:function(t){Lr($,t)},getHeight:function(){return Nr($)},setHeight:function(t){Sr($,t)}},encryptionOptions:m,encryption:Ce,getEncryptor:function(t){return null!==m?Ce.encryptor(t,0):function(t){return t}},output:Fe,getNumberOfPages:ye,get pages(){return st},out:ut,f2:D,f3:z,getPageInfo:je,getPageInfoByObjId:Ee,getCurrentPageInfo:Oe,getPDFVersion:_,Point:pr,Rectangle:gr,Matrix:Wt,hasHotfix:Ie},Object.defineProperty(w.internal.pageSize,"width",{get:function(){return Ar($)},set:function(t){Lr($,t)},enumerable:!0,configurable:!0}),Object.defineProperty(w.internal.pageSize,"height",{get:function(){return Nr($)},set:function(t){Sr($,t)},enumerable:!0,configurable:!0}),function(t){for(var e=0,r=dt.length;e<r;e++){var n=pe.call(this,t[e][0],t[e][1],t[e][2],dt[e][3],!0);!1===b&&(v[n]=!0);var i=t[e][0].split("-");de({id:n,fontName:i[0],fontStyle:i[1]||""})}qt.publish("addFonts",{fonts:Ft,dictionary:It})}.call(w,dt),Lt="F1",be(o,r),qt.publish("initialized"),w}I.prototype.lsbFirstWord=function(t){return String.fromCharCode(255&t,t>>8&255,t>>16&255,t>>24&255)},I.prototype.toHexString=function(t){return t.split("").map(function(t){return("0"+(255&t.charCodeAt(0)).toString(16)).slice(-2)}).join("")},I.prototype.hexToBytes=function(t){for(var e=[],r=0;r<t.length;r+=2)e.push(String.fromCharCode(parseInt(t.substr(r,2),16)));return e.join("")},I.prototype.processOwnerPassword=function(t,e){return P(N(e).substr(0,5),t)},I.prototype.encryptor=function(t,e){var r=N(this.encryptionKey+String.fromCharCode(255&t,t>>8&255,t>>16&255,255&e,e>>8&255)).substr(0,10);return function(t){return P(r,t)}},E.prototype.equals=function(t){var e,r="id,objectNumber,equals";if(!t||n(t)!==n(this))return!1;var i=0;for(e in this)if(!(r.indexOf(e)>=0)){if(this.hasOwnProperty(e)&&!t.hasOwnProperty(e))return!1;if(this[e]!==t[e])return!1;i++}for(e in t)t.hasOwnProperty(e)&&r.indexOf(e)<0&&i--;return 0===i},R.API={events:[]},R.version="4.2.0";var T=R.API,q=1,D=function(t){return t.replace(/\\/g,"\\\\").replace(/\(/g,"\\(").replace(/\)/g,"\\)")},z=function(t){return t.replace(/\\\\/g,"\\").replace(/\\\(/g,"(").replace(/\\\)/g,")")},U=function(t){return t.toString().replace(/#/g,"#23").replace(/[\s\n\r()<>[\]{}\/%]/g,function(t){var e=t.charCodeAt(0).toString(16).toUpperCase();return"#"+(1===e.length?"0"+e:e)})},H=function(t){return t.toFixed(2)},W=function(t){return t.toFixed(5)};T.__acroform__={};var V=function(t,e){t.prototype=Object.create(e.prototype),t.prototype.constructor=t},G=function(t){return t*q},Y=function(t){var e=new ut,r=Lt.internal.getHeight(t)||0,n=Lt.internal.getWidth(t)||0;return e.BBox=[0,0,Number(H(n)),Number(H(r))],e},Z=T.__acroform__.setBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBit");return t|1<<e},J=T.__acroform__.clearBit=function(t,e){if(t=t||0,e=e||0,isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBit");return t&~(1<<e)},X=T.__acroform__.getBit=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBit");return t&1<<e?1:0},K=T.__acroform__.getBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBitForPdf");return X(t,e-1)},$=T.__acroform__.setBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBitForPdf");return Z(t,e-1)},Q=T.__acroform__.clearBitForPdf=function(t,e){if(isNaN(t)||isNaN(e))throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBitForPdf");return J(t,e-1)},tt=T.__acroform__.calculateCoordinates=function(t,e){var r=e.internal.getHorizontalCoordinate,n=e.internal.getVerticalCoordinate,i=t[0],a=t[1],s=t[2],o=t[3],h={};return h.lowerLeft_X=r(i)||0,h.lowerLeft_Y=n(a+o)||0,h.upperRight_X=r(i+s)||0,h.upperRight_Y=n(a)||0,[Number(H(h.lowerLeft_X)),Number(H(h.lowerLeft_Y)),Number(H(h.upperRight_X)),Number(H(h.upperRight_Y))]},et=function(t){if(t.appearanceStreamContent)return t.appearanceStreamContent;if(t.V||t.DV){var e=[],r=t._V||t.DV,n=rt(t,r),i=t.scope.internal.getFont(t.fontName,t.fontStyle).id;e.push("/Tx BMC"),e.push("q"),e.push("BT"),e.push(t.scope.__private__.encodeColorString(t.color)),e.push("/"+i+" "+H(n.fontSize)+" Tf"),e.push("1 0 0 1 0 0 Tm"),e.push(n.text),e.push("ET"),e.push("Q"),e.push("EMC");var a=Y(t);return a.scope=t.scope,a.stream=e.join("\n"),a}},rt=function(t,e){var r=0===t.fontSize?t.maxFontSize:t.fontSize,n={text:"",fontSize:""},i=(e=")"==(e="("==e.substr(0,1)?e.substr(1):e).substr(e.length-1)?e.substr(0,e.length-1):e).split(" ");i=t.multiline?i.map(function(t){return t.split("\n")}):i.map(function(t){return[t]});var a=r,s=Lt.internal.getHeight(t)||0;s=s<0?-s:s;var o=Lt.internal.getWidth(t)||0;o=o<0?-o:o;var h=function(e,r,n){if(e+1<i.length){var a=r+" "+i[e+1][0];return nt(a,t,n).width<=o-4}return!1};a++;t:for(;a>0;){e="",a--;var l,u,c=nt("3",t,a).height,f=t.multiline?s-a:(s-c)/2,d=f+=2,p=0,g=0,m=0;if(a<=0){e="(...) Tj\n",e+="% Width of Text: "+nt(e,t,a=12).width+", FieldWidth:"+o+"\n";break}for(var b="",v=0,w=0;w<i.length;w++)if(i.hasOwnProperty(w)){var y=!1;if(1!==i[w].length&&m!==i[w].length-1){if((c+2)*(v+2)+2>s)continue t;b+=i[w][m],y=!0,g=w,w--}else{b=" "==(b+=i[w][m]+" ").substr(b.length-1)?b.substr(0,b.length-1):b;var _=parseInt(w),x=h(_,b,a),A=w>=i.length-1;if(x&&!A){b+=" ",m=0;continue}if(x||A){if(A)g=_;else if(t.multiline&&(c+2)*(v+2)+2>s)continue t}else{if(!t.multiline)continue t;if((c+2)*(v+2)+2>s)continue t;g=_}}for(var L="",N=p;N<=g;N++){var S=i[N];if(t.multiline){if(N===g){L+=S[m]+" ",m=(m+1)%S.length;continue}if(N===p){L+=S[S.length-1]+" ";continue}}L+=S[0]+" "}switch(L=" "==L.substr(L.length-1)?L.substr(0,L.length-1):L,u=nt(L,t,a).width,t.textAlign){case"right":l=o-u-2;break;case"center":l=(o-u)/2;break;default:l=2}e+=H(l)+" "+H(d)+" Td\n",e+="("+D(L)+") Tj\n",e+=-H(l)+" 0 Td\n",d=-(a+2),u=0,p=y?g:g+1,v++,b=""}break}return n.text=e,n.fontSize=a,n},nt=function(t,e,r){var n=e.scope.internal.getFont(e.fontName,e.fontStyle),i=e.scope.getStringUnitWidth(t,{font:n,fontSize:parseFloat(r),charSpace:0})*parseFloat(r);return{height:e.scope.getStringUnitWidth("3",{font:n,fontSize:parseFloat(r),charSpace:0})*parseFloat(r)*1.5,width:i}},it={fields:[],xForms:[],acroFormDictionaryRoot:null,printedOut:!1,internal:null,isInitialized:!1},at=function(t,e){var r={type:"reference",object:t};void 0===e.internal.getPageInfo(t.page).pageContext.annotations.find(function(t){return t.type===r.type&&t.object===r.object})&&e.internal.getPageInfo(t.page).pageContext.annotations.push(r)},st=function(t,e){if(e.scope=t,void 0!==t.internal&&(void 0===t.internal.acroformPlugin||!1===t.internal.acroformPlugin.isInitialized)){if(ft.FieldNum=0,t.internal.acroformPlugin=JSON.parse(JSON.stringify(it)),t.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error("Exception while creating AcroformDictionary");q=t.internal.scaleFactor,t.internal.acroformPlugin.acroFormDictionaryRoot=new ct,t.internal.acroformPlugin.acroFormDictionaryRoot.scope=t,t.internal.acroformPlugin.acroFormDictionaryRoot._eventID=t.internal.events.subscribe("postPutResources",function(){!function(t){t.internal.events.unsubscribe(t.internal.acroformPlugin.acroFormDictionaryRoot._eventID),delete t.internal.acroformPlugin.acroFormDictionaryRoot._eventID,t.internal.acroformPlugin.printedOut=!0}(t)}),t.internal.events.subscribe("buildDocument",function(){!function(t){t.internal.acroformPlugin.acroFormDictionaryRoot.objId=void 0;var e=t.internal.acroformPlugin.acroFormDictionaryRoot.Fields;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];n.objId=void 0,n.hasAnnotation&&at(n,t)}}(t)}),t.internal.events.subscribe("putCatalog",function(){!function(t){if(void 0===t.internal.acroformPlugin.acroFormDictionaryRoot)throw new Error("putCatalogCallback: Root missing.");t.internal.write("/AcroForm "+t.internal.acroformPlugin.acroFormDictionaryRoot.objId+" 0 R")}(t)}),t.internal.events.subscribe("postPutPages",function(e){!function(t,e){var r=!t;for(var i in t||(e.internal.newObjectDeferredBegin(e.internal.acroformPlugin.acroFormDictionaryRoot.objId,!0),e.internal.acroformPlugin.acroFormDictionaryRoot.putStream()),t=t||e.internal.acroformPlugin.acroFormDictionaryRoot.Kids)if(t.hasOwnProperty(i)){var a=t[i],s=[],o=a.Rect;if(a.Rect&&(a.Rect=tt(a.Rect,e)),e.internal.newObjectDeferredBegin(a.objId,!0),a.DA=Lt.createDefaultAppearanceStream(a),"object"===n(a)&&"function"==typeof a.getKeyValueListForStream&&(s=a.getKeyValueListForStream()),a.Rect=o,a.hasAppearanceStream&&!a.appearanceStreamContent){var h=et(a);s.push({key:"AP",value:"<</N "+h+">>"}),e.internal.acroformPlugin.xForms.push(h)}if(a.appearanceStreamContent){var l="";for(var u in a.appearanceStreamContent)if(a.appearanceStreamContent.hasOwnProperty(u)){var c=a.appearanceStreamContent[u];if(l+="/"+u+" ",l+="<<",Object.keys(c).length>=1||Array.isArray(c)){for(var i in c)if(c.hasOwnProperty(i)){var f=c[i];"function"==typeof f&&(f=f.call(e,a)),l+="/"+i+" "+f+" ",e.internal.acroformPlugin.xForms.indexOf(f)>=0||e.internal.acroformPlugin.xForms.push(f)}}else"function"==typeof(f=c)&&(f=f.call(e,a)),l+="/"+i+" "+f,e.internal.acroformPlugin.xForms.indexOf(f)>=0||e.internal.acroformPlugin.xForms.push(f);l+=">>"}s.push({key:"AP",value:"<<\n"+l+">>"})}e.internal.putStream({additionalKeyValues:s,objectId:a.objId}),e.internal.out("endobj")}r&&function(t,e){for(var r in t)if(t.hasOwnProperty(r)){var i=r,a=t[r];e.internal.newObjectDeferredBegin(a.objId,!0),"object"===n(a)&&"function"==typeof a.putStream&&a.putStream(),delete t[i]}}(e.internal.acroformPlugin.xForms,e)}(e,t)}),t.internal.acroformPlugin.isInitialized=!0}},ot=T.__acroform__.arrayToPdfArray=function(t,e,r){var i=function(t){return t};if(Array.isArray(t)){for(var a="[",s=0;s<t.length;s++)switch(0!==s&&(a+=" "),n(t[s])){case"boolean":case"number":case"object":a+=t[s].toString();break;case"string":"/"===t[s].substr(0,1)?a+="/"+U(t[s].substr(1)):(void 0!==e&&r&&(i=r.internal.getEncryptor(e)),a+="("+D(i(t[s].toString()))+")")}return a+"]"}throw new Error("Invalid argument passed to jsPDF.__acroform__.arrayToPdfArray")},ht=function(t,e,r){var n=function(t){return t};return void 0!==e&&r&&(n=r.internal.getEncryptor(e)),(t=t||"").toString(),"("+D(n(t))+")"},lt=function(){this._objId=void 0,this._scope=void 0,Object.defineProperty(this,"objId",{get:function(){if(void 0===this._objId){if(void 0===this.scope)return;this._objId=this.scope.internal.newObjectDeferred()}return this._objId},set:function(t){this._objId=t}}),Object.defineProperty(this,"scope",{value:this._scope,writable:!0})};lt.prototype.toString=function(){return this.objId+" 0 R"},lt.prototype.putStream=function(){var t=this.getKeyValueListForStream();this.scope.internal.putStream({data:this.stream,additionalKeyValues:t,objectId:this.objId}),this.scope.internal.out("endobj")},lt.prototype.getKeyValueListForStream=function(){var t=[],e=Object.getOwnPropertyNames(this).filter(function(t){return"content"!=t&&"appearanceStreamContent"!=t&&"scope"!=t&&"objId"!=t&&"_"!=t.substring(0,1)});for(var r in e)if(!1===Object.getOwnPropertyDescriptor(this,e[r]).configurable){var n=e[r],i=this[n];i&&(Array.isArray(i)?t.push({key:n,value:ot(i,this.objId,this.scope)}):i instanceof lt?(i.scope=this.scope,t.push({key:n,value:i.objId+" 0 R"})):"function"!=typeof i&&t.push({key:n,value:i}))}return t};var ut=function(){lt.call(this),Object.defineProperty(this,"Type",{value:"/XObject",configurable:!1,writable:!0}),Object.defineProperty(this,"Subtype",{value:"/Form",configurable:!1,writable:!0}),Object.defineProperty(this,"FormType",{value:1,configurable:!1,writable:!0});var t,e=[];Object.defineProperty(this,"BBox",{configurable:!1,get:function(){return e},set:function(t){e=t}}),Object.defineProperty(this,"Resources",{value:"2 0 R",configurable:!1,writable:!0}),Object.defineProperty(this,"stream",{enumerable:!1,configurable:!0,set:function(e){t=e.trim()},get:function(){return t||null}})};V(ut,lt);var ct=function(){lt.call(this);var t,e=[];Object.defineProperty(this,"Kids",{enumerable:!1,configurable:!0,get:function(){return e.length>0?e:void 0}}),Object.defineProperty(this,"Fields",{enumerable:!1,configurable:!1,get:function(){return e}}),Object.defineProperty(this,"DA",{enumerable:!1,configurable:!1,get:function(){if(t){var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),"("+D(e(t))+")"}},set:function(e){t=e}})};V(ct,lt);var ft=function t(){lt.call(this);var e=4;Object.defineProperty(this,"F",{enumerable:!1,configurable:!1,get:function(){return e},set:function(t){if(isNaN(t))throw new Error('Invalid value "'+t+'" for attribute F supplied.');e=t}}),Object.defineProperty(this,"showWhenPrinted",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(e,3))},set:function(t){!0===Boolean(t)?this.F=$(e,3):this.F=Q(e,3)}});var r=0;Object.defineProperty(this,"Ff",{enumerable:!1,configurable:!1,get:function(){return r},set:function(t){if(isNaN(t))throw new Error('Invalid value "'+t+'" for attribute Ff supplied.');r=t}});var n=[];Object.defineProperty(this,"Rect",{enumerable:!1,configurable:!1,get:function(){if(0!==n.length)return n},set:function(t){n=void 0!==t?t:[]}}),Object.defineProperty(this,"x",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[0])?0:n[0]},set:function(t){n[0]=t}}),Object.defineProperty(this,"y",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[1])?0:n[1]},set:function(t){n[1]=t}}),Object.defineProperty(this,"width",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[2])?0:n[2]},set:function(t){n[2]=t}}),Object.defineProperty(this,"height",{enumerable:!0,configurable:!0,get:function(){return!n||isNaN(n[3])?0:n[3]},set:function(t){n[3]=t}});var i="";Object.defineProperty(this,"FT",{enumerable:!0,configurable:!1,get:function(){return i},set:function(t){switch(t){case"/Btn":case"/Tx":case"/Ch":case"/Sig":i=t;break;default:throw new Error('Invalid value "'+t+'" for attribute FT supplied.')}}});var a=null;Object.defineProperty(this,"T",{enumerable:!0,configurable:!1,get:function(){if(!a||a.length<1){if(this instanceof yt)return;a="FieldObject"+t.FieldNum++}var e=function(t){return t};return this.scope&&(e=this.scope.internal.getEncryptor(this.objId)),"("+D(e(a))+")"},set:function(t){a=t.toString()}}),Object.defineProperty(this,"fieldName",{configurable:!0,enumerable:!0,get:function(){return a},set:function(t){a=t}});var s="helvetica";Object.defineProperty(this,"fontName",{enumerable:!0,configurable:!0,get:function(){return s},set:function(t){s=t}});var o="normal";Object.defineProperty(this,"fontStyle",{enumerable:!0,configurable:!0,get:function(){return o},set:function(t){o=t}});var h=0;Object.defineProperty(this,"fontSize",{enumerable:!0,configurable:!0,get:function(){return h},set:function(t){h=t}});var l=void 0;Object.defineProperty(this,"maxFontSize",{enumerable:!0,configurable:!0,get:function(){return void 0===l?50/q:l},set:function(t){l=t}});var u="black";Object.defineProperty(this,"color",{enumerable:!0,configurable:!0,get:function(){return u},set:function(t){u=t}});var c="/F1 0 Tf 0 g";Object.defineProperty(this,"DA",{enumerable:!0,configurable:!1,get:function(){if(!(!c||this instanceof yt||this instanceof xt))return ht(c,this.objId,this.scope)},set:function(t){t=t.toString(),c=t}});var f=null;Object.defineProperty(this,"DV",{enumerable:!1,configurable:!1,get:function(){if(f)return this instanceof bt==0?ht(f,this.objId,this.scope):f},set:function(t){t=t.toString(),f=this instanceof bt==0?"("===t.substr(0,1)?z(t.substr(1,t.length-2)):z(t):t}}),Object.defineProperty(this,"defaultValue",{enumerable:!0,configurable:!0,get:function(){return this instanceof bt==1?z(f.substr(1,f.length-1)):f},set:function(t){t=t.toString(),f=this instanceof bt==1?"/"+U(t):t}});var d=null;Object.defineProperty(this,"_V",{enumerable:!1,configurable:!1,get:function(){if(d)return d},set:function(t){this.V=t}}),Object.defineProperty(this,"V",{enumerable:!1,configurable:!1,get:function(){if(d)return this instanceof bt==0?ht(d,this.objId,this.scope):d},set:function(t){t=t.toString(),d=this instanceof bt==0?"("===t.substr(0,1)?z(t.substr(1,t.length-2)):z(t):t}}),Object.defineProperty(this,"value",{enumerable:!0,configurable:!0,get:function(){return this instanceof bt==1?z(d.substr(1,d.length-1)):d},set:function(t){t=t.toString(),d=this instanceof bt==1?"/"+U(t):t}}),Object.defineProperty(this,"hasAnnotation",{enumerable:!0,configurable:!0,get:function(){return this.Rect}}),Object.defineProperty(this,"Type",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?"/Annot":null}}),Object.defineProperty(this,"Subtype",{enumerable:!0,configurable:!1,get:function(){return this.hasAnnotation?"/Widget":null}});var p,g=!1;Object.defineProperty(this,"hasAppearanceStream",{enumerable:!0,configurable:!0,get:function(){return g},set:function(t){t=Boolean(t),g=t}}),Object.defineProperty(this,"page",{enumerable:!0,configurable:!0,get:function(){if(p)return p},set:function(t){p=t}}),Object.defineProperty(this,"readOnly",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,1))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,1):this.Ff=Q(this.Ff,1)}}),Object.defineProperty(this,"required",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,2))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,2):this.Ff=Q(this.Ff,2)}}),Object.defineProperty(this,"noExport",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,3))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,3):this.Ff=Q(this.Ff,3)}});var m=null;Object.defineProperty(this,"Q",{enumerable:!0,configurable:!1,get:function(){if(null!==m)return m},set:function(t){if(-1===[0,1,2].indexOf(t))throw new Error('Invalid value "'+t+'" for attribute Q supplied.');m=t}}),Object.defineProperty(this,"textAlign",{get:function(){var t;switch(m){case 0:default:t="left";break;case 1:t="center";break;case 2:t="right"}return t},configurable:!0,enumerable:!0,set:function(t){switch(t){case"right":case 2:m=2;break;case"center":case 1:m=1;break;default:m=0}}})};V(ft,lt);var dt=function(){ft.call(this),this.FT="/Ch",this.V="()",this.fontName="zapfdingbats";var t=0;Object.defineProperty(this,"TI",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,"topIndex",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){t=e}});var e=[];Object.defineProperty(this,"Opt",{enumerable:!0,configurable:!1,get:function(){return ot(e,this.objId,this.scope)},set:function(t){var r,n;n=[],"string"==typeof(r=t)&&(n=function(t,e,r){r||(r=1);for(var n,i=[];n=e.exec(t);)i.push(n[r]);return i}(r,/\((.*?)\)/g)),e=n}}),this.getOptions=function(){return e},this.setOptions=function(t){e=t,this.sort&&e.sort()},this.addOption=function(t){t=(t=t||"").toString(),e.push(t),this.sort&&e.sort()},this.removeOption=function(t,r){for(r=r||!1,t=(t=t||"").toString();-1!==e.indexOf(t)&&(e.splice(e.indexOf(t),1),!1!==r););},Object.defineProperty(this,"combo",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,18))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,18):this.Ff=Q(this.Ff,18)}}),Object.defineProperty(this,"edit",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,19))},set:function(t){!0===this.combo&&(!0===Boolean(t)?this.Ff=$(this.Ff,19):this.Ff=Q(this.Ff,19))}}),Object.defineProperty(this,"sort",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,20))},set:function(t){!0===Boolean(t)?(this.Ff=$(this.Ff,20),e.sort()):this.Ff=Q(this.Ff,20)}}),Object.defineProperty(this,"multiSelect",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,22))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,22):this.Ff=Q(this.Ff,22)}}),Object.defineProperty(this,"doNotSpellCheck",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,23):this.Ff=Q(this.Ff,23)}}),Object.defineProperty(this,"commitOnSelChange",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,27))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,27):this.Ff=Q(this.Ff,27)}}),this.hasAppearanceStream=!1};V(dt,ft);var pt=function(){dt.call(this),this.fontName="helvetica",this.combo=!1};V(pt,dt);var gt=function(){pt.call(this),this.combo=!0};V(gt,pt);var mt=function(){gt.call(this),this.edit=!0};V(mt,gt);var bt=function(){ft.call(this),this.FT="/Btn",Object.defineProperty(this,"noToggleToOff",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,15))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,15):this.Ff=Q(this.Ff,15)}}),Object.defineProperty(this,"radio",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,16))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,16):this.Ff=Q(this.Ff,16)}}),Object.defineProperty(this,"pushButton",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,17))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,17):this.Ff=Q(this.Ff,17)}}),Object.defineProperty(this,"radioIsUnison",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,26):this.Ff=Q(this.Ff,26)}});var t,e={};Object.defineProperty(this,"MK",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};if(this.scope&&(t=this.scope.internal.getEncryptor(this.objId)),0!==Object.keys(e).length){var r,n=[];for(r in n.push("<<"),e)n.push("/"+r+" ("+D(t(e[r]))+")");return n.push(">>"),n.join("\n")}},set:function(t){"object"===n(t)&&(e=t)}}),Object.defineProperty(this,"caption",{enumerable:!0,configurable:!0,get:function(){return e.CA||""},set:function(t){"string"==typeof t&&(e.CA=t)}}),Object.defineProperty(this,"AS",{enumerable:!1,configurable:!1,get:function(){return t},set:function(e){var r=null==e?"":e.toString();"/"===r.substr(0,1)&&(r=r.substr(1)),t="/"+U(r)}}),Object.defineProperty(this,"appearanceState",{enumerable:!0,configurable:!0,get:function(){return t.substr(1,t.length-1)},set:function(e){t="/"+U(e)}})};V(bt,ft);var vt=function(){bt.call(this),this.pushButton=!0};V(vt,bt);var wt=function(){bt.call(this),this.radio=!0,this.pushButton=!1;var t=[];Object.defineProperty(this,"Kids",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=void 0!==e?e:[]}})};V(wt,bt);var yt=function(){var t,e;ft.call(this),Object.defineProperty(this,"Parent",{enumerable:!1,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,"optionName",{enumerable:!1,configurable:!0,get:function(){return e},set:function(t){e=t}});var r,i={};Object.defineProperty(this,"MK",{enumerable:!1,configurable:!1,get:function(){var t=function(t){return t};this.scope&&(t=this.scope.internal.getEncryptor(this.objId));var e,r=[];for(e in r.push("<<"),i)r.push("/"+e+" ("+D(t(i[e]))+")");return r.push(">>"),r.join("\n")},set:function(t){"object"===n(t)&&(i=t)}}),Object.defineProperty(this,"caption",{enumerable:!0,configurable:!0,get:function(){return i.CA||""},set:function(t){"string"==typeof t&&(i.CA=t)}}),Object.defineProperty(this,"AS",{enumerable:!1,configurable:!1,get:function(){return r},set:function(t){var e=null==t?"":t.toString();"/"===e.substr(0,1)&&(e=e.substr(1)),r="/"+U(e)}}),Object.defineProperty(this,"appearanceState",{enumerable:!0,configurable:!0,get:function(){return r.substr(1,r.length-1)},set:function(t){var e=null==t?"":t.toString();"/"===e.substr(0,1)&&(e=e.substr(1)),r="/"+U(e)}}),this.caption="l",this.appearanceState="Off",this._AppearanceType=Lt.RadioButton.Circle,this.appearanceStreamContent=this._AppearanceType.createAppearanceStream(this.optionName)};V(yt,ft),wt.prototype.setAppearance=function(t){if(!("createAppearanceStream"in t)||!("getCA"in t))throw new Error("Couldn't assign Appearance to RadioButton. Appearance was Invalid!");for(var e in this.Kids)if(this.Kids.hasOwnProperty(e)){var r=this.Kids[e];r.appearanceStreamContent=t.createAppearanceStream(r.optionName),r.caption=t.getCA()}},wt.prototype.createOption=function(t){var e=new yt;return e.Parent=this,e.optionName=t,this.Kids.push(e),Nt.call(this.scope,e),e};var _t=function(){bt.call(this),this.fontName="zapfdingbats",this.caption="3",this.appearanceState="On",this.value="On",this.textAlign="center",this.appearanceStreamContent=Lt.CheckBox.createAppearanceStream()};V(_t,bt);var xt=function(){ft.call(this),this.FT="/Tx",Object.defineProperty(this,"multiline",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,13))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,13):this.Ff=Q(this.Ff,13)}}),Object.defineProperty(this,"fileSelect",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,21))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,21):this.Ff=Q(this.Ff,21)}}),Object.defineProperty(this,"doNotSpellCheck",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,23))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,23):this.Ff=Q(this.Ff,23)}}),Object.defineProperty(this,"doNotScroll",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,24))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,24):this.Ff=Q(this.Ff,24)}}),Object.defineProperty(this,"comb",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,25))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,25):this.Ff=Q(this.Ff,25)}}),Object.defineProperty(this,"richText",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,26))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,26):this.Ff=Q(this.Ff,26)}});var t=null;Object.defineProperty(this,"MaxLen",{enumerable:!0,configurable:!1,get:function(){return t},set:function(e){t=e}}),Object.defineProperty(this,"maxLength",{enumerable:!0,configurable:!0,get:function(){return t},set:function(e){Number.isInteger(e)&&(t=e)}}),Object.defineProperty(this,"hasAppearanceStream",{enumerable:!0,configurable:!0,get:function(){return this.V||this.DV}})};V(xt,ft);var At=function(){xt.call(this),Object.defineProperty(this,"password",{enumerable:!0,configurable:!0,get:function(){return Boolean(K(this.Ff,14))},set:function(t){!0===Boolean(t)?this.Ff=$(this.Ff,14):this.Ff=Q(this.Ff,14)}}),this.password=!0};V(At,xt);var Lt={CheckBox:{createAppearanceStream:function(){return{N:{On:Lt.CheckBox.YesNormal},D:{On:Lt.CheckBox.YesPushDown,Off:Lt.CheckBox.OffPushDown}}},YesPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=[],n=t.scope.internal.getFont(t.fontName,t.fontStyle).id,i=t.scope.__private__.encodeColorString(t.color),a=rt(t,t.caption);return r.push("0.749023 g"),r.push("0 0 "+H(Lt.internal.getWidth(t))+" "+H(Lt.internal.getHeight(t))+" re"),r.push("f"),r.push("BMC"),r.push("q"),r.push("0 0 1 rg"),r.push("/"+n+" "+H(a.fontSize)+" Tf "+i),r.push("BT"),r.push(a.text),r.push("ET"),r.push("Q"),r.push("EMC"),e.stream=r.join("\n"),e},YesNormal:function(t){var e=Y(t);e.scope=t.scope;var r=t.scope.internal.getFont(t.fontName,t.fontStyle).id,n=t.scope.__private__.encodeColorString(t.color),i=[],a=Lt.internal.getHeight(t),s=Lt.internal.getWidth(t),o=rt(t,t.caption);return i.push("1 g"),i.push("0 0 "+H(s)+" "+H(a)+" re"),i.push("f"),i.push("q"),i.push("0 0 1 rg"),i.push("0 0 "+H(s-1)+" "+H(a-1)+" re"),i.push("W"),i.push("n"),i.push("0 g"),i.push("BT"),i.push("/"+r+" "+H(o.fontSize)+" Tf "+n),i.push(o.text),i.push("ET"),i.push("Q"),e.stream=i.join("\n"),e},OffPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=[];return r.push("0.749023 g"),r.push("0 0 "+H(Lt.internal.getWidth(t))+" "+H(Lt.internal.getHeight(t))+" re"),r.push("f"),e.stream=r.join("\n"),e}},RadioButton:{Circle:{createAppearanceStream:function(t){var e={D:{Off:Lt.RadioButton.Circle.OffPushDown},N:{}};return e.N[t]=Lt.RadioButton.Circle.YesNormal,e.D[t]=Lt.RadioButton.Circle.YesPushDown,e},getCA:function(){return"l"},YesNormal:function(t){var e=Y(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Lt.internal.Bezier_C,a=Number((n*i).toFixed(5));return r.push("q"),r.push("1 0 0 1 "+W(Lt.internal.getWidth(t)/2)+" "+W(Lt.internal.getHeight(t)/2)+" cm"),r.push(n+" 0 m"),r.push(n+" "+a+" "+a+" "+n+" 0 "+n+" c"),r.push("-"+a+" "+n+" -"+n+" "+a+" -"+n+" 0 c"),r.push("-"+n+" -"+a+" -"+a+" -"+n+" 0 -"+n+" c"),r.push(a+" -"+n+" "+n+" -"+a+" "+n+" 0 c"),r.push("f"),r.push("Q"),e.stream=r.join("\n"),e},YesPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Number((2*n).toFixed(5)),a=Number((i*Lt.internal.Bezier_C).toFixed(5)),s=Number((n*Lt.internal.Bezier_C).toFixed(5));return r.push("0.749023 g"),r.push("q"),r.push("1 0 0 1 "+W(Lt.internal.getWidth(t)/2)+" "+W(Lt.internal.getHeight(t)/2)+" cm"),r.push(i+" 0 m"),r.push(i+" "+a+" "+a+" "+i+" 0 "+i+" c"),r.push("-"+a+" "+i+" -"+i+" "+a+" -"+i+" 0 c"),r.push("-"+i+" -"+a+" -"+a+" -"+i+" 0 -"+i+" c"),r.push(a+" -"+i+" "+i+" -"+a+" "+i+" 0 c"),r.push("f"),r.push("Q"),r.push("0 g"),r.push("q"),r.push("1 0 0 1 "+W(Lt.internal.getWidth(t)/2)+" "+W(Lt.internal.getHeight(t)/2)+" cm"),r.push(n+" 0 m"),r.push(n+" "+s+" "+s+" "+n+" 0 "+n+" c"),r.push("-"+s+" "+n+" -"+n+" "+s+" -"+n+" 0 c"),r.push("-"+n+" -"+s+" -"+s+" -"+n+" 0 -"+n+" c"),r.push(s+" -"+n+" "+n+" -"+s+" "+n+" 0 c"),r.push("f"),r.push("Q"),e.stream=r.join("\n"),e},OffPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=[],n=Lt.internal.getWidth(t)<=Lt.internal.getHeight(t)?Lt.internal.getWidth(t)/4:Lt.internal.getHeight(t)/4;n=Number((.9*n).toFixed(5));var i=Number((2*n).toFixed(5)),a=Number((i*Lt.internal.Bezier_C).toFixed(5));return r.push("0.749023 g"),r.push("q"),r.push("1 0 0 1 "+W(Lt.internal.getWidth(t)/2)+" "+W(Lt.internal.getHeight(t)/2)+" cm"),r.push(i+" 0 m"),r.push(i+" "+a+" "+a+" "+i+" 0 "+i+" c"),r.push("-"+a+" "+i+" -"+i+" "+a+" -"+i+" 0 c"),r.push("-"+i+" -"+a+" -"+a+" -"+i+" 0 -"+i+" c"),r.push(a+" -"+i+" "+i+" -"+a+" "+i+" 0 c"),r.push("f"),r.push("Q"),e.stream=r.join("\n"),e}},Cross:{createAppearanceStream:function(t){var e={D:{Off:Lt.RadioButton.Cross.OffPushDown},N:{}};return e.N[t]=Lt.RadioButton.Cross.YesNormal,e.D[t]=Lt.RadioButton.Cross.YesPushDown,e},getCA:function(){return"8"},YesNormal:function(t){var e=Y(t);e.scope=t.scope;var r=[],n=Lt.internal.calculateCross(t);return r.push("q"),r.push("1 1 "+H(Lt.internal.getWidth(t)-2)+" "+H(Lt.internal.getHeight(t)-2)+" re"),r.push("W"),r.push("n"),r.push(H(n.x1.x)+" "+H(n.x1.y)+" m"),r.push(H(n.x2.x)+" "+H(n.x2.y)+" l"),r.push(H(n.x4.x)+" "+H(n.x4.y)+" m"),r.push(H(n.x3.x)+" "+H(n.x3.y)+" l"),r.push("s"),r.push("Q"),e.stream=r.join("\n"),e},YesPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=Lt.internal.calculateCross(t),n=[];return n.push("0.749023 g"),n.push("0 0 "+H(Lt.internal.getWidth(t))+" "+H(Lt.internal.getHeight(t))+" re"),n.push("f"),n.push("q"),n.push("1 1 "+H(Lt.internal.getWidth(t)-2)+" "+H(Lt.internal.getHeight(t)-2)+" re"),n.push("W"),n.push("n"),n.push(H(r.x1.x)+" "+H(r.x1.y)+" m"),n.push(H(r.x2.x)+" "+H(r.x2.y)+" l"),n.push(H(r.x4.x)+" "+H(r.x4.y)+" m"),n.push(H(r.x3.x)+" "+H(r.x3.y)+" l"),n.push("s"),n.push("Q"),e.stream=n.join("\n"),e},OffPushDown:function(t){var e=Y(t);e.scope=t.scope;var r=[];return r.push("0.749023 g"),r.push("0 0 "+H(Lt.internal.getWidth(t))+" "+H(Lt.internal.getHeight(t))+" re"),r.push("f"),e.stream=r.join("\n"),e}}},createDefaultAppearanceStream:function(t){var e=t.scope.internal.getFont(t.fontName,t.fontStyle).id,r=t.scope.__private__.encodeColorString(t.color);return"/"+e+" "+t.fontSize+" Tf "+r}};Lt.internal={Bezier_C:.551915024494,calculateCross:function(t){var e=Lt.internal.getWidth(t),r=Lt.internal.getHeight(t),n=Math.min(e,r);return{x1:{x:(e-n)/2,y:(r-n)/2+n},x2:{x:(e-n)/2+n,y:(r-n)/2},x3:{x:(e-n)/2,y:(r-n)/2},x4:{x:(e-n)/2+n,y:(r-n)/2+n}}}},Lt.internal.getWidth=function(t){var e=0;return"object"===n(t)&&(e=G(t.Rect[2])),e},Lt.internal.getHeight=function(t){var e=0;return"object"===n(t)&&(e=G(t.Rect[3])),e};var Nt=T.addField=function(t){if(st(this,t),!(t instanceof ft))throw new Error("Invalid argument passed to jsPDF.addField.");var e;return(e=t).scope.internal.acroformPlugin.printedOut&&(e.scope.internal.acroformPlugin.printedOut=!1,e.scope.internal.acroformPlugin.acroFormDictionaryRoot=null),e.scope.internal.acroformPlugin.acroFormDictionaryRoot.Fields.push(e),t.page=t.scope.internal.getCurrentPageInfo().pageNumber,this};T.AcroFormChoiceField=dt,T.AcroFormListBox=pt,T.AcroFormComboBox=gt,T.AcroFormEditBox=mt,T.AcroFormButton=bt,T.AcroFormPushButton=vt,T.AcroFormRadioButton=wt,T.AcroFormCheckBox=_t,T.AcroFormTextField=xt,T.AcroFormPasswordField=At,T.AcroFormAppearance=Lt,T.AcroForm={ChoiceField:dt,ListBox:pt,ComboBox:gt,EditBox:mt,Button:bt,PushButton:vt,RadioButton:wt,CheckBox:_t,TextField:xt,PasswordField:At,Appearance:Lt},R.AcroForm={ChoiceField:dt,ListBox:pt,ComboBox:gt,EditBox:mt,Button:bt,PushButton:vt,RadioButton:wt,CheckBox:_t,TextField:xt,PasswordField:At,Appearance:Lt};var St=R.AcroForm;function kt(t){return t.reduce(function(t,e,r){return t[e]=r,t},{})}!function(t){var e="addImage_";t.__addimage__={};var r="UNKNOWN",i={PNG:[[137,80,78,71]],TIFF:[[77,77,0,42],[73,73,42,0]],JPEG:[[255,216,255,224,void 0,void 0,74,70,73,70,0],[255,216,255,225,void 0,void 0,69,120,105,102,0,0],[255,216,255,219],[255,216,255,238]],JPEG2000:[[0,0,0,12,106,80,32,32]],GIF87a:[[71,73,70,56,55,97]],GIF89a:[[71,73,70,56,57,97]],WEBP:[[82,73,70,70,void 0,void 0,void 0,void 0,87,69,66,80]],BMP:[[66,77],[66,65],[67,73],[67,80],[73,67],[80,84]]},a=t.__addimage__.getImageFileTypeByImageData=function(t,e){var n,a,s,o,h,l=r;if("RGBA"===(e=e||r)||void 0!==t.data&&t.data instanceof Uint8ClampedArray&&"height"in t&&"width"in t)return"RGBA";if(L(t))for(h in i)for(s=i[h],n=0;n<s.length;n+=1){for(o=!0,a=0;a<s[n].length;a+=1)if(void 0!==s[n][a]&&s[n][a]!==t[a]){o=!1;break}if(!0===o){l=h;break}}else for(h in i)for(s=i[h],n=0;n<s.length;n+=1){for(o=!0,a=0;a<s[n].length;a+=1)if(void 0!==s[n][a]&&s[n][a]!==t.charCodeAt(a)){o=!1;break}if(!0===o){l=h;break}}return l===r&&e!==r&&(l=e),l},s=function t(e){for(var r=this.internal.write,n=this.internal.putStream,i=(0,this.internal.getFilters)();-1!==i.indexOf("FlateEncode");)i.splice(i.indexOf("FlateEncode"),1);e.objectId=this.internal.newObject();var a=[];if(a.push({key:"Type",value:"/XObject"}),a.push({key:"Subtype",value:"/Image"}),a.push({key:"Width",value:e.width}),a.push({key:"Height",value:e.height}),e.colorSpace===w.INDEXED?a.push({key:"ColorSpace",value:"[/Indexed /DeviceRGB "+(e.palette.length/3-1)+" "+("sMask"in e&&void 0!==e.sMask?e.objectId+2:e.objectId+1)+" 0 R]"}):(a.push({key:"ColorSpace",value:"/"+e.colorSpace}),e.colorSpace===w.DEVICE_CMYK&&a.push({key:"Decode",value:"[1 0 1 0 1 0 1 0]"})),a.push({key:"BitsPerComponent",value:e.bitsPerComponent}),"decodeParameters"in e&&void 0!==e.decodeParameters&&a.push({key:"DecodeParms",value:"<<"+e.decodeParameters+">>"}),"transparency"in e&&Array.isArray(e.transparency)&&e.transparency.length>0){for(var s="",o=0,h=e.transparency.length;o<h;o++)s+=e.transparency[o]+" "+e.transparency[o]+" ";a.push({key:"Mask",value:"["+s+"]"})}void 0!==e.sMask&&a.push({key:"SMask",value:e.objectId+1+" 0 R"});var l=void 0!==e.filter?["/"+e.filter]:void 0;if(n({data:e.data,additionalKeyValues:a,alreadyAppliedFilters:l,objectId:e.objectId}),r("endobj"),"sMask"in e&&void 0!==e.sMask){var u,c=null!==(u=e.sMaskBitsPerComponent)&&void 0!==u?u:e.bitsPerComponent,f={width:e.width,height:e.height,colorSpace:"DeviceGray",bitsPerComponent:c,data:e.sMask};"filter"in e&&(f.decodeParameters="/Predictor ".concat(e.predictor," /Colors 1 /BitsPerComponent ").concat(c," /Columns ").concat(e.width),f.filter=e.filter),t.call(this,f)}if(e.colorSpace===w.INDEXED){var d=this.internal.newObject();n({data:S(new Uint8Array(e.palette)),objectId:d}),r("endobj")}},o=function(){var t=this.internal.collections[e+"images"];for(var r in t)s.call(this,t[r])},h=function(){var t,r=this.internal.collections[e+"images"],n=this.internal.write;for(var i in r)n("/I"+(t=r[i]).index,t.objectId,"0","R")},l=function(){this.internal.collections[e+"images"]||(this.internal.collections[e+"images"]={},this.internal.events.subscribe("putResources",o),this.internal.events.subscribe("putXobjectDict",h))},u=function(){var t=this.internal.collections[e+"images"];return l.call(this),t},c=function(){return Object.keys(this.internal.collections[e+"images"]).length},d=function(e){return"function"==typeof t["process"+e.toUpperCase()]},p=function(t){return"object"===n(t)&&1===t.nodeType},g=function(e,r){if("IMG"===e.nodeName&&e.hasAttribute("src")){var n=""+e.getAttribute("src");if(0===n.indexOf("data:image/"))return f(unescape(n).split("base64,").pop());var i=t.loadFile(n,!0);if(void 0!==i)return i}if("CANVAS"===e.nodeName){if(0===e.width||0===e.height)throw new Error("Given canvas must have data. Canvas width: "+e.width+", height: "+e.height);var a;switch(r){case"PNG":a="image/png";break;case"WEBP":a="image/webp";break;default:a="image/jpeg"}return f(e.toDataURL(a,1).split("base64,").pop())}},m=function(t){var r=this.internal.collections[e+"images"];if(r)for(var n in r)if(t===r[n].alias)return r[n]},b=function(t,e,r){return t||e||(t=-96,e=-96),t<0&&(t=-1*r.width*72/t/this.internal.scaleFactor),e<0&&(e=-1*r.height*72/e/this.internal.scaleFactor),0===t&&(t=e*r.width/r.height),0===e&&(e=t*r.height/r.width),[t,e]},v=function(t,e,r,n,i,a){var s=b.call(this,r,n,i),o=this.internal.getCoordinateString,h=this.internal.getVerticalCoordinateString,l=u.call(this);if(r=s[0],n=s[1],l[i.index]=i,a){a*=Math.PI/180;var c=Math.cos(a),f=Math.sin(a),d=function(t){return t.toFixed(4)},p=[d(c),d(f),d(-1*f),d(c),0,0,"cm"]}this.internal.write("q"),a?(this.internal.write([1,"0","0",1,o(t),h(e+n),"cm"].join(" ")),this.internal.write(p.join(" ")),this.internal.write([o(r),"0","0",o(n),"0","0","cm"].join(" "))):this.internal.write([o(r),"0","0",o(n),o(t),h(e+n),"cm"].join(" ")),this.isAdvancedAPI()&&this.internal.write([1,0,0,-1,0,0,"cm"].join(" ")),this.internal.write("/I"+i.index+" Do"),this.internal.write("Q")},w=t.color_spaces={DEVICE_RGB:"DeviceRGB",DEVICE_GRAY:"DeviceGray",DEVICE_CMYK:"DeviceCMYK",CAL_GREY:"CalGray",CAL_RGB:"CalRGB",LAB:"Lab",ICC_BASED:"ICCBased",INDEXED:"Indexed",PATTERN:"Pattern",SEPARATION:"Separation",DEVICE_N:"DeviceN"};t.decode={DCT_DECODE:"DCTDecode",FLATE_DECODE:"FlateDecode",LZW_DECODE:"LZWDecode",JPX_DECODE:"JPXDecode",JBIG2_DECODE:"JBIG2Decode",ASCII85_DECODE:"ASCII85Decode",ASCII_HEX_DECODE:"ASCIIHexDecode",RUN_LENGTH_DECODE:"RunLengthDecode",CCITT_FAX_DECODE:"CCITTFaxDecode"};var y=t.image_compression={NONE:"NONE",FAST:"FAST",MEDIUM:"MEDIUM",SLOW:"SLOW"},_=t.__addimage__.sHashCode=function(t){var e,r,n=0;if("string"==typeof t)for(r=t.length,e=0;e<r;e++)n=(n<<5)-n+t.charCodeAt(e),n|=0;else if(L(t))for(r=t.byteLength/2,e=0;e<r;e++)n=(n<<5)-n+t[e],n|=0;return n},x=t.__addimage__.validateStringAsBase64=function(t){(t=t||"").toString().trim();var e=!0;return 0===t.length&&(e=!1),t.length%4!=0&&(e=!1),!1===/^[A-Za-z0-9+/]+$/.test(t.substr(0,t.length-2))&&(e=!1),!1===/^[A-Za-z0-9/][A-Za-z0-9+/]|[A-Za-z0-9+/]=|==$/.test(t.substr(-2))&&(e=!1),e},A=t.__addimage__.extractImageFromDataUrl=function(t){if(null==t)return null;if(!(t=t.trim()).startsWith("data:"))return null;var e=t.indexOf(",");return e<0?null:t.substring(0,e).trim().endsWith("base64")?t.substring(e+1):null};t.__addimage__.isArrayBuffer=function(t){return t instanceof ArrayBuffer};var L=t.__addimage__.isArrayBufferView=function(t){return t instanceof Int8Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray||t instanceof Int16Array||t instanceof Uint16Array||t instanceof Int32Array||t instanceof Uint32Array||t instanceof Float32Array||t instanceof Float64Array},N=t.__addimage__.binaryStringToUint8Array=function(t){for(var e=t.length,r=new Uint8Array(e),n=0;n<e;n++)r[n]=t.charCodeAt(n);return r},S=t.__addimage__.arrayBufferToBinaryString=function(t){for(var e="",r=L(t)?t:new Uint8Array(t),n=0;n<r.length;n+=8192)e+=String.fromCharCode.apply(null,r.subarray(n,n+8192));return e};t.addImage=function(){var t,e,i,a,s,o,h,u,c;if("number"==typeof arguments[1]?(e=r,i=arguments[1],a=arguments[2],s=arguments[3],o=arguments[4],h=arguments[5],u=arguments[6],c=arguments[7]):(e=arguments[1],i=arguments[2],a=arguments[3],s=arguments[4],o=arguments[5],h=arguments[6],u=arguments[7],c=arguments[8]),"object"===n(t=arguments[0])&&!p(t)&&"imageData"in t){var f=t;t=f.imageData,e=f.format||e||r,i=f.x||i||0,a=f.y||a||0,s=f.w||f.width||s,o=f.h||f.height||o,h=f.alias||h,u=f.compression||u,c=f.rotation||f.angle||c}var d=this.internal.getFilters();if(void 0===u&&-1!==d.indexOf("FlateEncode")&&(u="SLOW"),isNaN(i)||isNaN(a))throw new Error("Invalid coordinates passed to jsPDF.addImage");l.call(this);var g=k.call(this,t,e,h,u);return v.call(this,i,a,s,o,g,c),this};var k=function(e,n,i,s){var o,h,l;if("string"==typeof e&&a(e)===r){e=unescape(e);var u=P(e,!1);(""!==u||void 0!==(u=t.loadFile(e,!0)))&&(e=u)}if(p(e)&&(e=g(e,n)),n=a(e,n),!d(n))throw new Error("addImage does not support files of type '"+n+"', please ensure that a plugin for '"+n+"' support is added.");if((null==(l=i)||0===l.length)&&(i=function(t){return"string"==typeof t||L(t)?_(t):L(t.data)?_(t.data):null}(e)),(o=m.call(this,i))||(e instanceof Uint8Array||"RGBA"===n||(h=e,e=N(e)),o=this["process"+n.toUpperCase()](e,c.call(this),i,function(e){return e&&"string"==typeof e&&(e=e.toUpperCase()),e in t.image_compression?e:y.NONE}(s),h)),!o)throw new Error("An unknown error occurred whilst processing the image.");return o},P=t.__addimage__.convertBase64ToBinaryString=function(t,e){e="boolean"!=typeof e||e;var r,n="";if("string"==typeof t){var i;r=null!==(i=A(t))&&void 0!==i?i:t;try{n=f(r)}catch(a){if(e)throw x(r)?new Error("atob-Error in jsPDF.convertBase64ToBinaryString "+a.message):new Error("Supplied Data is not a valid base64-String jsPDF.convertBase64ToBinaryString ")}}return n};t.getImageProperties=function(e){var n,i,s="";if(p(e)&&(e=g(e)),"string"==typeof e&&a(e)===r&&(""===(s=P(e,!1))&&(s=t.loadFile(e)||""),e=s),i=a(e),!d(i))throw new Error("addImage does not support files of type '"+i+"', please ensure that a plugin for '"+i+"' support is added.");if(e instanceof Uint8Array||(e=N(e)),!(n=this["process"+i.toUpperCase()](e)))throw new Error("An unknown error occurred whilst processing the image");return n.fileType=i,n}}(R.API),
/**
   * @license
   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e=function(t){if(void 0!==t&&""!=t)return!0};R.API.events.push(["addPage",function(t){this.internal.getPageInfo(t.pageNumber).pageContext.annotations=[]}]),t.events.push(["putPage",function(t){for(var r,n,i,a=this.internal.getCoordinateString,s=this.internal.getVerticalCoordinateString,o=this.internal.getPageInfoByObjId(t.objId),h=t.pageContext.annotations,l=!1,u=0;u<h.length&&!l;u++)switch((r=h[u]).type){case"link":(e(r.options.url)||e(r.options.pageNumber))&&(l=!0);break;case"reference":case"text":case"freetext":l=!0}if(0!=l){this.internal.write("/Annots [");for(var c=0;c<h.length;c++){r=h[c];var f=this.internal.pdfEscape,d=this.internal.getEncryptor(t.objId);switch(r.type){case"reference":this.internal.write(" "+r.object.objId+" 0 R ");break;case"text":var p=this.internal.newAdditionalObject(),g=this.internal.newAdditionalObject(),m=this.internal.getEncryptor(p.objId),b=r.title||"Note";i="<</Type /Annot /Subtype /Text "+(n="/Rect ["+a(r.bounds.x)+" "+s(r.bounds.y+r.bounds.h)+" "+a(r.bounds.x+r.bounds.w)+" "+s(r.bounds.y)+"] ")+"/Contents ("+f(m(r.contents))+")",i+=" /Popup "+g.objId+" 0 R",i+=" /P "+o.objId+" 0 R",i+=" /T ("+f(m(b))+") >>",p.content=i;var v=p.objId+" 0 R";i="<</Type /Annot /Subtype /Popup "+(n="/Rect ["+a(r.bounds.x+30)+" "+s(r.bounds.y+r.bounds.h)+" "+a(r.bounds.x+r.bounds.w+30)+" "+s(r.bounds.y)+"] ")+" /Parent "+v,r.open&&(i+=" /Open true"),i+=" >>",g.content=i,this.internal.write(p.objId,"0 R",g.objId,"0 R");break;case"freetext":n="/Rect ["+a(r.bounds.x)+" "+s(r.bounds.y)+" "+a(r.bounds.x+r.bounds.w)+" "+s(r.bounds.y+r.bounds.h)+"] ";var w=r.color||"#000000";i="<</Type /Annot /Subtype /FreeText "+n+"/Contents ("+f(d(r.contents))+")",i+=" /DS(font: Helvetica,sans-serif 12.0pt; text-align:left; color:#"+w+")",i+=" /Border [0 0 0]",i+=" >>",this.internal.write(i);break;case"link":if(r.options.name){var y=this.annotations._nameMap[r.options.name];r.options.pageNumber=y.page,r.options.top=y.y}else r.options.top||(r.options.top=0);if(n="/Rect ["+r.finalBounds.x+" "+r.finalBounds.y+" "+r.finalBounds.w+" "+r.finalBounds.h+"] ",i="",r.options.url)i="<</Type /Annot /Subtype /Link "+n+"/Border [0 0 0] /A <</S /URI /URI ("+f(d(r.options.url))+") >>";else if(r.options.pageNumber)switch(i="<</Type /Annot /Subtype /Link "+n+"/Border [0 0 0] /Dest ["+this.internal.getPageInfo(r.options.pageNumber).objId+" 0 R",r.options.magFactor=r.options.magFactor||"XYZ",r.options.magFactor){case"Fit":i+=" /Fit]";break;case"FitH":i+=" /FitH "+r.options.top+"]";break;case"FitV":r.options.left=r.options.left||0,i+=" /FitV "+r.options.left+"]";break;default:var _=s(r.options.top);r.options.left=r.options.left||0,void 0===r.options.zoom&&(r.options.zoom=0),i+=" /XYZ "+r.options.left+" "+_+" "+r.options.zoom+"]"}""!=i&&(i+=" >>",this.internal.write(i))}}this.internal.write("]")}}]),t.createAnnotation=function(t){var e=this.internal.getCurrentPageInfo();switch(t.type){case"link":this.link(t.bounds.x,t.bounds.y,t.bounds.w,t.bounds.h,t);break;case"text":case"freetext":e.pageContext.annotations.push(t)}},t.link=function(t,e,r,n,i){var a=this.internal.getCurrentPageInfo(),s=this.internal.getCoordinateString,o=this.internal.getVerticalCoordinateString;a.pageContext.annotations.push({finalBounds:{x:s(t),y:o(e),w:s(t+r),h:o(e+n)},options:i,type:"link"})},t.textWithLink=function(t,e,r,n){var i,a,s=this.getTextWidth(t),o=this.internal.getLineHeight()/this.internal.scaleFactor;if(void 0!==n.maxWidth){a=n.maxWidth;var h=this.splitTextToSize(t,a).length;i=Math.ceil(o*h)}else a=s,i=o;return this.text(t,e,r,n),r+=.2*o,"center"===n.align&&(e-=s/2),"right"===n.align&&(e-=s),this.link(e,r-o,a,i,n),s},t.getTextWidth=function(t){var e=this.internal.getFontSize();return this.getStringUnitWidth(t)*e/this.internal.scaleFactor}}(R.API),
/**
   * @license
   * Copyright (c) 2017 Aras Abbasi
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e={1569:[65152],1570:[65153,65154],1571:[65155,65156],1572:[65157,65158],1573:[65159,65160],1574:[65161,65162,65163,65164],1575:[65165,65166],1576:[65167,65168,65169,65170],1577:[65171,65172],1578:[65173,65174,65175,65176],1579:[65177,65178,65179,65180],1580:[65181,65182,65183,65184],1581:[65185,65186,65187,65188],1582:[65189,65190,65191,65192],1583:[65193,65194],1584:[65195,65196],1585:[65197,65198],1586:[65199,65200],1587:[65201,65202,65203,65204],1588:[65205,65206,65207,65208],1589:[65209,65210,65211,65212],1590:[65213,65214,65215,65216],1591:[65217,65218,65219,65220],1592:[65221,65222,65223,65224],1593:[65225,65226,65227,65228],1594:[65229,65230,65231,65232],1601:[65233,65234,65235,65236],1602:[65237,65238,65239,65240],1603:[65241,65242,65243,65244],1604:[65245,65246,65247,65248],1605:[65249,65250,65251,65252],1606:[65253,65254,65255,65256],1607:[65257,65258,65259,65260],1608:[65261,65262],1609:[65263,65264,64488,64489],1610:[65265,65266,65267,65268],1649:[64336,64337],1655:[64477],1657:[64358,64359,64360,64361],1658:[64350,64351,64352,64353],1659:[64338,64339,64340,64341],1662:[64342,64343,64344,64345],1663:[64354,64355,64356,64357],1664:[64346,64347,64348,64349],1667:[64374,64375,64376,64377],1668:[64370,64371,64372,64373],1670:[64378,64379,64380,64381],1671:[64382,64383,64384,64385],1672:[64392,64393],1676:[64388,64389],1677:[64386,64387],1678:[64390,64391],1681:[64396,64397],1688:[64394,64395],1700:[64362,64363,64364,64365],1702:[64366,64367,64368,64369],1705:[64398,64399,64400,64401],1709:[64467,64468,64469,64470],1711:[64402,64403,64404,64405],1713:[64410,64411,64412,64413],1715:[64406,64407,64408,64409],1722:[64414,64415],1723:[64416,64417,64418,64419],1726:[64426,64427,64428,64429],1728:[64420,64421],1729:[64422,64423,64424,64425],1733:[64480,64481],1734:[64473,64474],1735:[64471,64472],1736:[64475,64476],1737:[64482,64483],1739:[64478,64479],1740:[64508,64509,64510,64511],1744:[64484,64485,64486,64487],1746:[64430,64431],1747:[64432,64433]},r={65247:{65154:65269,65156:65271,65160:65273,65166:65275},65248:{65154:65270,65156:65272,65160:65274,65166:65276},65165:{65247:{65248:{65258:65010}}},1617:{1612:64606,1613:64607,1614:64608,1615:64609,1616:64610}},n={1612:64606,1613:64607,1614:64608,1615:64609,1616:64610},i=[1570,1571,1573,1575];t.__arabicParser__={};var a=t.__arabicParser__.isInArabicSubstitutionA=function(t){return void 0!==e[t.charCodeAt(0)]},s=t.__arabicParser__.isArabicLetter=function(t){return"string"==typeof t&&/^[\u0600-\u06FF\u0750-\u077F\u08A0-\u08FF\uFB50-\uFDFF\uFE70-\uFEFF]+$/.test(t)},o=t.__arabicParser__.isArabicEndLetter=function(t){return s(t)&&a(t)&&e[t.charCodeAt(0)].length<=2},h=t.__arabicParser__.isArabicAlfLetter=function(t){return s(t)&&i.indexOf(t.charCodeAt(0))>=0};t.__arabicParser__.arabicLetterHasIsolatedForm=function(t){return s(t)&&a(t)&&e[t.charCodeAt(0)].length>=1};var l=t.__arabicParser__.arabicLetterHasFinalForm=function(t){return s(t)&&a(t)&&e[t.charCodeAt(0)].length>=2};t.__arabicParser__.arabicLetterHasInitialForm=function(t){return s(t)&&a(t)&&e[t.charCodeAt(0)].length>=3};var u=t.__arabicParser__.arabicLetterHasMedialForm=function(t){return s(t)&&a(t)&&4==e[t.charCodeAt(0)].length},c=t.__arabicParser__.resolveLigatures=function(t){var e=0,n=r,i="",a=0;for(e=0;e<t.length;e+=1)void 0!==n[t.charCodeAt(e)]?(a++,"number"==typeof(n=n[t.charCodeAt(e)])&&(i+=String.fromCharCode(n),n=r,a=0),e===t.length-1&&(n=r,i+=t.charAt(e-(a-1)),e-=a-1,a=0)):(n=r,i+=t.charAt(e-a),e-=a,a=0);return i};t.__arabicParser__.isArabicDiacritic=function(t){return void 0!==t&&void 0!==n[t.charCodeAt(0)]};var f=t.__arabicParser__.getCorrectForm=function(t,e,r){return s(t)?!1===a(t)?-1:!l(t)||!s(e)&&!s(r)||!s(r)&&o(e)||o(t)&&!s(e)||o(t)&&h(e)||o(t)&&o(e)?0:u(t)&&s(e)&&!o(e)&&s(r)&&l(r)?3:o(t)||!s(r)?1:2:-1},d=function(t){var r=0,n=0,i=0,a="",o="",h="",l=(t=t||"").split("\\s+"),u=[];for(r=0;r<l.length;r+=1){for(u.push(""),n=0;n<l[r].length;n+=1)a=l[r][n],o=l[r][n-1],h=l[r][n+1],s(a)?(i=f(a,o,h),u[r]+=-1!==i?String.fromCharCode(e[a.charCodeAt(0)][i]):a):u[r]+=a;u[r]=c(u[r])}return u.join(" ")},p=t.__arabicParser__.processArabic=t.processArabic=function(){var t,e="string"==typeof arguments[0]?arguments[0]:arguments[0].text,r=[];if(Array.isArray(e)){var n=0;for(r=[],n=0;n<e.length;n+=1)Array.isArray(e[n])?r.push([d(e[n][0]),e[n][1],e[n][2]]):r.push([d(e[n])]);t=r}else t=d(e);return"string"==typeof arguments[0]?t:(arguments[0].text=t,arguments[0])};t.events.push(["preProcessText",p])}(R.API),
/** @license
   * jsPDF Autoprint Plugin
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){t.autoPrint=function(t){var e;return(t=t||{}).variant=t.variant||"non-conform","javascript"===t.variant?this.addJS("print({});"):(this.internal.events.subscribe("postPutResources",function(){e=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/S /Named"),this.internal.out("/Type /Action"),this.internal.out("/N /Print"),this.internal.out(">>"),this.internal.out("endobj")}),this.internal.events.subscribe("putCatalog",function(){this.internal.out("/OpenAction "+e+" 0 R")})),this}}(R.API),
/**
   * @license
   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e=function(){var t=void 0;Object.defineProperty(this,"pdf",{get:function(){return t},set:function(e){t=e}});var e=150;Object.defineProperty(this,"width",{get:function(){return e},set:function(t){e=isNaN(t)||!1===Number.isInteger(t)||t<0?150:t,this.getContext("2d").pageWrapXEnabled&&(this.getContext("2d").pageWrapX=e+1)}});var r=300;Object.defineProperty(this,"height",{get:function(){return r},set:function(t){r=isNaN(t)||!1===Number.isInteger(t)||t<0?300:t,this.getContext("2d").pageWrapYEnabled&&(this.getContext("2d").pageWrapY=r+1)}});var n=[];Object.defineProperty(this,"childNodes",{get:function(){return n},set:function(t){n=t}});var i={};Object.defineProperty(this,"style",{get:function(){return i},set:function(t){i=t}}),Object.defineProperty(this,"parentNode",{})};e.prototype.getContext=function(t,e){var r;if("2d"!==(t=t||"2d"))return null;for(r in e)this.pdf.context2d.hasOwnProperty(r)&&(this.pdf.context2d[r]=e[r]);return this.pdf.context2d._canvas=this,this.pdf.context2d},e.prototype.toDataURL=function(){throw new Error("toDataURL is not implemented.")},t.events.push(["initialized",function(){this.canvas=new e,this.canvas.pdf=this}])}(R.API),function(t){var e={left:0,top:0,bottom:0,right:0},r=!1,i=function(){void 0===this.internal.__cell__&&(this.internal.__cell__={},this.internal.__cell__.padding=3,this.internal.__cell__.headerFunction=void 0,this.internal.__cell__.margins=Object.assign({},e),this.internal.__cell__.margins.width=this.getPageWidth(),a.call(this))},a=function(){this.internal.__cell__.lastCell=new s,this.internal.__cell__.pages=1},s=function(){var t=arguments[0];Object.defineProperty(this,"x",{enumerable:!0,get:function(){return t},set:function(e){t=e}});var e=arguments[1];Object.defineProperty(this,"y",{enumerable:!0,get:function(){return e},set:function(t){e=t}});var r=arguments[2];Object.defineProperty(this,"width",{enumerable:!0,get:function(){return r},set:function(t){r=t}});var n=arguments[3];Object.defineProperty(this,"height",{enumerable:!0,get:function(){return n},set:function(t){n=t}});var i=arguments[4];Object.defineProperty(this,"text",{enumerable:!0,get:function(){return i},set:function(t){i=t}});var a=arguments[5];Object.defineProperty(this,"lineNumber",{enumerable:!0,get:function(){return a},set:function(t){a=t}});var s=arguments[6];return Object.defineProperty(this,"align",{enumerable:!0,get:function(){return s},set:function(t){s=t}}),this};s.prototype.clone=function(){return new s(this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align)},s.prototype.toArray=function(){return[this.x,this.y,this.width,this.height,this.text,this.lineNumber,this.align]},t.setHeaderFunction=function(t){return i.call(this),this.internal.__cell__.headerFunction="function"==typeof t?t:void 0,this},t.getTextDimensions=function(t,e){i.call(this);var r=(e=e||{}).fontSize||this.getFontSize(),n=e.font||this.getFont(),a=e.scaleFactor||this.internal.scaleFactor,s=0,o=0,h=0,l=this;if(!Array.isArray(t)&&"string"!=typeof t){if("number"!=typeof t)throw new Error("getTextDimensions expects text-parameter to be of type String or type Number or an Array of Strings.");t=String(t)}var u=e.maxWidth;u>0?"string"==typeof t?t=this.splitTextToSize(t,u):"[object Array]"===Object.prototype.toString.call(t)&&(t=t.reduce(function(t,e){return t.concat(l.splitTextToSize(e,u))},[])):t=Array.isArray(t)?t:[t];for(var c=0;c<t.length;c++)s<(h=this.getStringUnitWidth(t[c],{font:n})*r)&&(s=h);return 0!==s&&(o=t.length),{w:s/=a,h:Math.max((o*r*this.getLineHeightFactor()-r*(this.getLineHeightFactor()-1))/a,0)}},t.cellAddPage=function(){i.call(this),this.addPage();var t=this.internal.__cell__.margins||e;return this.internal.__cell__.lastCell=new s(t.left,t.top,void 0,void 0),this.internal.__cell__.pages+=1,this};var o=t.cell=function(){var t;t=arguments[0]instanceof s?arguments[0]:new s(arguments[0],arguments[1],arguments[2],arguments[3],arguments[4],arguments[5],arguments[6]),i.call(this);var n=this.internal.__cell__.lastCell,a=this.internal.__cell__.padding,o=this.internal.__cell__.margins||e,h=this.internal.__cell__.tableHeaderRow,l=this.internal.__cell__.printHeaders;return void 0!==n.lineNumber&&(n.lineNumber===t.lineNumber?(t.x=(n.x||0)+(n.width||0),t.y=n.y||0):n.y+n.height+t.height+o.bottom>this.getPageHeight()?(this.cellAddPage(),t.y=o.top,l&&h&&(this.printHeaderRow(t.lineNumber,!0),t.y+=h[0].height)):t.y=n.y+n.height||t.y),void 0!==t.text[0]&&(this.rect(t.x,t.y,t.width,t.height,!0===r?"FD":void 0),"right"===t.align?this.text(t.text,t.x+t.width-a,t.y+a,{align:"right",baseline:"top"}):"center"===t.align?this.text(t.text,t.x+t.width/2,t.y+a,{align:"center",baseline:"top",maxWidth:t.width-a-a}):this.text(t.text,t.x+a,t.y+a,{align:"left",baseline:"top",maxWidth:t.width-a-a})),this.internal.__cell__.lastCell=t,this};t.table=function(t,r,l,u,c){if(i.call(this),!l)throw new Error("No data for PDF table.");var f,d,p,g,m=[],b=[],v=[],w={},y={},_=[],x=[],A=(c=c||{}).autoSize||!1,L=!1!==c.printHeaders,N=c.css&&void 0!==c.css["font-size"]?16*c.css["font-size"]:c.fontSize||12,S=c.margins||Object.assign({width:this.getPageWidth()},e),k="number"==typeof c.padding?c.padding:3,P=c.headerBackgroundColor||"#c8c8c8",F=c.headerTextColor||"#000";if(a.call(this),this.internal.__cell__.printHeaders=L,this.internal.__cell__.margins=S,this.internal.__cell__.table_font_size=N,this.internal.__cell__.padding=k,this.internal.__cell__.headerBackgroundColor=P,this.internal.__cell__.headerTextColor=F,this.setFontSize(N),null==u)b=m=Object.keys(l[0]),v=m.map(function(){return"left"});else if(Array.isArray(u)&&"object"===n(u[0]))for(m=u.map(function(t){return t.name}),b=u.map(function(t){return t.prompt||t.name||""}),v=u.map(function(t){return t.align||"left"}),f=0;f<u.length;f+=1)y[u[f].name]=.7499990551181103*u[f].width;else Array.isArray(u)&&"string"==typeof u[0]&&(b=m=u,v=m.map(function(){return"left"}));if(A||Array.isArray(u)&&"string"==typeof u[0])for(f=0;f<m.length;f+=1){for(w[g=m[f]]=l.map(function(t){return t[g]}),this.setFont(void 0,"bold"),_.push(this.getTextDimensions(b[f],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w),d=w[g],this.setFont(void 0,"normal"),p=0;p<d.length;p+=1)_.push(this.getTextDimensions(d[p],{fontSize:this.internal.__cell__.table_font_size,scaleFactor:this.internal.scaleFactor}).w);y[g]=Math.max.apply(null,_)+k+k,_=[]}if(L){var I={};for(f=0;f<m.length;f+=1)I[m[f]]={},I[m[f]].text=b[f],I[m[f]].align=v[f];var C=h.call(this,I,y);x=m.map(function(e){return new s(t,r,y[e],C,I[e].text,void 0,I[e].align)}),this.setTableHeaderRow(x),this.printHeaderRow(1,!1)}var j=u.reduce(function(t,e){return t[e.name]=e.align,t},{});for(f=0;f<l.length;f+=1){"rowStart"in c&&c.rowStart instanceof Function&&c.rowStart({row:f,data:l[f]},this);var E=h.call(this,l[f],y);for(p=0;p<m.length;p+=1){var O=l[f][m[p]];"cellStart"in c&&c.cellStart instanceof Function&&c.cellStart({row:f,col:p,data:O},this),o.call(this,new s(t,r,y[m[p]],E,O,f+2,j[m[p]]))}}return this.internal.__cell__.table_x=t,this.internal.__cell__.table_y=r,this};var h=function(t,e){var r=this.internal.__cell__.padding,n=this.internal.__cell__.table_font_size,i=this.internal.scaleFactor;return Object.keys(t).map(function(n){var i=t[n];return this.splitTextToSize(i.hasOwnProperty("text")?i.text:i,e[n]-r-r)},this).map(function(t){return this.getLineHeightFactor()*t.length*n/i+r+r},this).reduce(function(t,e){return Math.max(t,e)},0)};t.setTableHeaderRow=function(t){i.call(this),this.internal.__cell__.tableHeaderRow=t},t.printHeaderRow=function(t,e){if(i.call(this),!this.internal.__cell__.tableHeaderRow)throw new Error("Property tableHeaderRow does not exist.");var n;if(r=!0,"function"==typeof this.internal.__cell__.headerFunction){var a=this.internal.__cell__.headerFunction(this,this.internal.__cell__.pages);this.internal.__cell__.lastCell=new s(a[0],a[1],a[2],a[3],void 0,-1)}this.setFont(void 0,"bold");for(var h=[],l=0;l<this.internal.__cell__.tableHeaderRow.length;l+=1){n=this.internal.__cell__.tableHeaderRow[l].clone(),e&&(n.y=this.internal.__cell__.margins.top||0,h.push(n)),n.lineNumber=t;var u=this.getTextColor();this.setTextColor(this.internal.__cell__.headerTextColor),this.setFillColor(this.internal.__cell__.headerBackgroundColor),o.call(this,n),this.setTextColor(u)}h.length>0&&this.setTableHeaderRow(h),this.setFont(void 0,"normal"),r=!1}}(R.API);var Pt={italic:["italic","oblique","normal"],oblique:["oblique","italic","normal"],normal:["normal","oblique","italic"]},Ft=["ultra-condensed","extra-condensed","condensed","semi-condensed","normal","semi-expanded","expanded","extra-expanded","ultra-expanded"],It=kt(Ft),Ct=[100,200,300,400,500,600,700,800,900],jt=kt(Ct);function Et(t){var e=t.family.replace(/"|'/g,"").toLowerCase(),r=function(t){return Pt[t=t||"normal"]?t:"normal"}(t.style),n=function(t){return t?"number"==typeof t?t>=100&&t<=900&&t%100==0?t:400:/^\d00$/.test(t)?parseInt(t):"bold"===t?700:400:400}(t.weight),i=function(t){return"number"==typeof It[t=t||"normal"]?t:"normal"}(t.stretch);return{family:e,style:r,weight:n,stretch:i,src:t.src||[],ref:t.ref||{name:e,style:[i,r,n].join(" ")}}}function Ot(t,e,r,n){var i;for(i=r;i>=0&&i<e.length;i+=n)if(t[e[i]])return t[e[i]];for(i=r;i>=0&&i<e.length;i-=n)if(t[e[i]])return t[e[i]]}var Bt={"sans-serif":"helvetica",fixed:"courier",monospace:"courier",terminal:"courier",cursive:"times",fantasy:"times",serif:"times"},Mt={caption:"times",icon:"times",menu:"times","message-box":"times","small-caption":"times","status-bar":"times"};function Rt(t){return[t.stretch,t.style,t.weight,t.family].join(" ")}function Tt(t){return t.trimLeft()}function qt(t,e){for(var r=0;r<t.length;){if(t.charAt(r)===e)return[t.substring(0,r),t.substring(r+1)];r+=1}return null}function Dt(t){var e=t.match(/^(-[a-z_]|[a-z_])[a-z0-9_-]*/i);return null===e?null:[e[0],t.substring(e[0].length)]}var zt=["times"];!function(t){var e,r,i,a,o,h,l,u,f,d=function(t){return t=t||{},this.isStrokeTransparent=t.isStrokeTransparent||!1,this.strokeOpacity=t.strokeOpacity||1,this.strokeStyle=t.strokeStyle||"#000000",this.fillStyle=t.fillStyle||"#000000",this.isFillTransparent=t.isFillTransparent||!1,this.fillOpacity=t.fillOpacity||1,this.font=t.font||"10px sans-serif",this.textBaseline=t.textBaseline||"alphabetic",this.textAlign=t.textAlign||"left",this.lineWidth=t.lineWidth||1,this.lineJoin=t.lineJoin||"miter",this.lineCap=t.lineCap||"butt",this.path=t.path||[],this.transform=void 0!==t.transform?t.transform.clone():new u,this.globalCompositeOperation=t.globalCompositeOperation||"normal",this.globalAlpha=t.globalAlpha||1,this.clip_path=t.clip_path||[],this.currentPoint=t.currentPoint||new h,this.miterLimit=t.miterLimit||10,this.lastPoint=t.lastPoint||new h,this.lineDashOffset=t.lineDashOffset||0,this.lineDash=t.lineDash||[],this.margin=t.margin||[0,0,0,0],this.prevPageLastElemOffset=t.prevPageLastElemOffset||0,this.ignoreClearRect="boolean"!=typeof t.ignoreClearRect||t.ignoreClearRect,this};t.events.push(["initialized",function(){this.context2d=new p(this),e=this.internal.f2,r=this.internal.getCoordinateString,i=this.internal.getVerticalCoordinateString,a=this.internal.getHorizontalCoordinate,o=this.internal.getVerticalCoordinate,h=this.internal.Point,l=this.internal.Rectangle,u=this.internal.Matrix,f=new d}]);var p=function(t){Object.defineProperty(this,"canvas",{get:function(){return{parentNode:!1,style:!1}}});var e=t;Object.defineProperty(this,"pdf",{get:function(){return e}});var r=!1;Object.defineProperty(this,"pageWrapXEnabled",{get:function(){return r},set:function(t){r=Boolean(t)}});var n=!1;Object.defineProperty(this,"pageWrapYEnabled",{get:function(){return n},set:function(t){n=Boolean(t)}});var i=0;Object.defineProperty(this,"posX",{get:function(){return i},set:function(t){isNaN(t)||(i=t)}});var a=0;Object.defineProperty(this,"posY",{get:function(){return a},set:function(t){isNaN(t)||(a=t)}}),Object.defineProperty(this,"margin",{get:function(){return f.margin},set:function(t){var e;"number"==typeof t?e=[t,t,t,t]:((e=new Array(4))[0]=t[0],e[1]=t.length>=2?t[1]:e[0],e[2]=t.length>=3?t[2]:e[0],e[3]=t.length>=4?t[3]:e[1]),f.margin=e}});var s=!1;Object.defineProperty(this,"autoPaging",{get:function(){return s},set:function(t){s=t}});var o=0;Object.defineProperty(this,"lastBreak",{get:function(){return o},set:function(t){o=t}});var h=[];Object.defineProperty(this,"pageBreaks",{get:function(){return h},set:function(t){h=t}}),Object.defineProperty(this,"ctx",{get:function(){return f},set:function(t){t instanceof d&&(f=t)}}),Object.defineProperty(this,"path",{get:function(){return f.path},set:function(t){f.path=t}});var l=[];Object.defineProperty(this,"ctxStack",{get:function(){return l},set:function(t){l=t}}),Object.defineProperty(this,"fillStyle",{get:function(){return this.ctx.fillStyle},set:function(t){var e;e=g(t),this.ctx.fillStyle=e.style,this.ctx.isFillTransparent=0===e.a,this.ctx.fillOpacity=e.a,this.pdf.setFillColor(e.r,e.g,e.b,{a:e.a}),this.pdf.setTextColor(e.r,e.g,e.b,{a:e.a})}}),Object.defineProperty(this,"strokeStyle",{get:function(){return this.ctx.strokeStyle},set:function(t){var e=g(t);this.ctx.strokeStyle=e.style,this.ctx.isStrokeTransparent=0===e.a,this.ctx.strokeOpacity=e.a,0===e.a?this.pdf.setDrawColor(255,255,255):(e.a,this.pdf.setDrawColor(e.r,e.g,e.b))}}),Object.defineProperty(this,"lineCap",{get:function(){return this.ctx.lineCap},set:function(t){-1!==["butt","round","square"].indexOf(t)&&(this.ctx.lineCap=t,this.pdf.setLineCap(t))}}),Object.defineProperty(this,"lineWidth",{get:function(){return this.ctx.lineWidth},set:function(t){isNaN(t)||(this.ctx.lineWidth=t,this.pdf.setLineWidth(t))}}),Object.defineProperty(this,"lineJoin",{get:function(){return this.ctx.lineJoin},set:function(t){-1!==["bevel","round","miter"].indexOf(t)&&(this.ctx.lineJoin=t,this.pdf.setLineJoin(t))}}),Object.defineProperty(this,"miterLimit",{get:function(){return this.ctx.miterLimit},set:function(t){isNaN(t)||(this.ctx.miterLimit=t,this.pdf.setMiterLimit(t))}}),Object.defineProperty(this,"textBaseline",{get:function(){return this.ctx.textBaseline},set:function(t){this.ctx.textBaseline=t}}),Object.defineProperty(this,"textAlign",{get:function(){return this.ctx.textAlign},set:function(t){-1!==["right","end","center","left","start"].indexOf(t)&&(this.ctx.textAlign=t)}});var u=null,c=null;var p=null;Object.defineProperty(this,"fontFaces",{get:function(){return p},set:function(t){u=null,c=null,p=t}}),Object.defineProperty(this,"font",{get:function(){return this.ctx.font},set:function(t){var e;if(this.ctx.font=t,null!==(e=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-_,\"\'\sa-z0-9]+?)\s*$/i.exec(t))){var r=e[1];e[2];var n=e[3],i=e[4];e[5];var a=e[6],s=/^([.\d]+)((?:%|in|[cem]m|ex|p[ctx]))$/i.exec(i)[2];i="px"===s?Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor):"em"===s?Math.floor(parseFloat(i)*this.pdf.getFontSize()):Math.floor(parseFloat(i)*this.pdf.internal.scaleFactor),this.pdf.setFontSize(i);var o=function(t){var e,r,n=[],i=t.trim();if(""===i)return zt;if(i in Mt)return[Mt[i]];for(;""!==i;){switch(r=null,e=(i=Tt(i)).charAt(0)){case'"':case"'":r=qt(i.substring(1),e);break;default:r=Dt(i)}if(null===r)return zt;if(n.push(r[0]),""!==(i=Tt(r[1]))&&","!==i.charAt(0))return zt;i=i.replace(/^,/,"")}return n}(a);if(this.fontFaces){var h=function(t,e){var r=t.getFontList(),n=JSON.stringify(r);if(null===u||c!==n){var i=function(t){var e=[];return Object.keys(t).forEach(function(r){t[r].forEach(function(t){var n=null;switch(t){case"bold":n={family:r,weight:"bold"};break;case"italic":n={family:r,style:"italic"};break;case"bolditalic":n={family:r,weight:"bold",style:"italic"};break;case"":case"normal":n={family:r}}null!==n&&(n.ref={name:r,style:t},e.push(n))})}),e}(r);u=function(t){for(var e={},r=0;r<t.length;++r){var n=Et(t[r]),i=n.family,a=n.stretch,s=n.style,o=n.weight;e[i]=e[i]||{},e[i][a]=e[i][a]||{},e[i][a][s]=e[i][a][s]||{},e[i][a][s][o]=n}return e}(i.concat(e)),c=n}return u}(this.pdf,this.fontFaces),l=o.map(function(t){return{family:t,stretch:"normal",weight:n,style:r}}),f=function(t,e,r){for(var n=(r=r||{}).defaultFontFamily||"times",i=Object.assign({},Bt,r.genericFontFamilies||{}),a=null,s=null,o=0;o<e.length;++o)if(i[(a=Et(e[o])).family]&&(a.family=i[a.family]),t.hasOwnProperty(a.family)){s=t[a.family];break}if(!(s=s||t[n]))throw new Error("Could not find a font-family for the rule '"+Rt(a)+"' and default family '"+n+"'.");if(s=function(t,e){if(e[t])return e[t];var r=It[t],n=r<=It.normal?-1:1,i=Ot(e,Ft,r,n);if(!i)throw new Error("Could not find a matching font-stretch value for "+t);return i}(a.stretch,s),s=function(t,e){if(e[t])return e[t];for(var r=Pt[t],n=0;n<r.length;++n)if(e[r[n]])return e[r[n]];throw new Error("Could not find a matching font-style for "+t)}(a.style,s),!(s=function(t,e){if(e[t])return e[t];if(400===t&&e[500])return e[500];if(500===t&&e[400])return e[400];var r=jt[t],n=Ot(e,Ct,r,t<400?-1:1);if(!n)throw new Error("Could not find a matching font-weight for value "+t);return n}(a.weight,s)))throw new Error("Failed to resolve a font for the rule '"+Rt(a)+"'.");return s}(h,l);this.pdf.setFont(f.ref.name,f.ref.style)}else{var d="";("bold"===n||parseInt(n,10)>=700||"bold"===r)&&(d="bold"),"italic"===r&&(d+="italic"),0===d.length&&(d="normal");for(var p="",g={arial:"Helvetica",Arial:"Helvetica",verdana:"Helvetica",Verdana:"Helvetica",helvetica:"Helvetica",Helvetica:"Helvetica","sans-serif":"Helvetica",fixed:"Courier",monospace:"Courier",terminal:"Courier",cursive:"Times",fantasy:"Times",serif:"Times"},m=0;m<o.length;m++){if(void 0!==this.pdf.internal.getFont(o[m],d,{noFallback:!0,disableWarning:!0})){p=o[m];break}if("bolditalic"===d&&void 0!==this.pdf.internal.getFont(o[m],"bold",{noFallback:!0,disableWarning:!0}))p=o[m],d="bold";else if(void 0!==this.pdf.internal.getFont(o[m],"normal",{noFallback:!0,disableWarning:!0})){p=o[m],d="normal";break}}if(""===p)for(var b=0;b<o.length;b++)if(g[o[b]]){p=g[o[b]];break}p=""===p?"Times":p,this.pdf.setFont(p,d)}}}}),Object.defineProperty(this,"globalCompositeOperation",{get:function(){return this.ctx.globalCompositeOperation},set:function(t){this.ctx.globalCompositeOperation=t}}),Object.defineProperty(this,"globalAlpha",{get:function(){return this.ctx.globalAlpha},set:function(t){this.ctx.globalAlpha=t}}),Object.defineProperty(this,"lineDashOffset",{get:function(){return this.ctx.lineDashOffset},set:function(t){this.ctx.lineDashOffset=t,D.call(this)}}),Object.defineProperty(this,"lineDash",{get:function(){return this.ctx.lineDash},set:function(t){this.ctx.lineDash=t,D.call(this)}}),Object.defineProperty(this,"ignoreClearRect",{get:function(){return this.ctx.ignoreClearRect},set:function(t){this.ctx.ignoreClearRect=Boolean(t)}})};p.prototype.setLineDash=function(t){this.lineDash=t},p.prototype.getLineDash=function(){return this.lineDash.length%2?this.lineDash.concat(this.lineDash):this.lineDash.slice()},p.prototype.fill=function(){A.call(this,"fill",!1)},p.prototype.stroke=function(){A.call(this,"stroke",!1)},p.prototype.beginPath=function(){this.path=[{type:"begin"}]},p.prototype.moveTo=function(t,e){if(isNaN(t)||isNaN(e))throw s.error("jsPDF.context2d.moveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.moveTo");var r=this.ctx.transform.applyToPoint(new h(t,e));this.path.push({type:"mt",x:r.x,y:r.y}),this.ctx.lastPoint=new h(t,e)},p.prototype.closePath=function(){var t=new h(0,0),e=0;for(e=this.path.length-1;-1!==e;e--)if("begin"===this.path[e].type&&"object"===n(this.path[e+1])&&"number"==typeof this.path[e+1].x){t=new h(this.path[e+1].x,this.path[e+1].y);break}this.path.push({type:"close"}),this.ctx.lastPoint=new h(t.x,t.y)},p.prototype.lineTo=function(t,e){if(isNaN(t)||isNaN(e))throw s.error("jsPDF.context2d.lineTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.lineTo");var r=this.ctx.transform.applyToPoint(new h(t,e));this.path.push({type:"lt",x:r.x,y:r.y}),this.ctx.lastPoint=new h(r.x,r.y)},p.prototype.clip=function(){this.ctx.clip_path=JSON.parse(JSON.stringify(this.path)),A.call(this,null,!0)},p.prototype.quadraticCurveTo=function(t,e,r,n){if(isNaN(r)||isNaN(n)||isNaN(t)||isNaN(e))throw s.error("jsPDF.context2d.quadraticCurveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.quadraticCurveTo");var i=this.ctx.transform.applyToPoint(new h(r,n)),a=this.ctx.transform.applyToPoint(new h(t,e));this.path.push({type:"qct",x1:a.x,y1:a.y,x:i.x,y:i.y}),this.ctx.lastPoint=new h(i.x,i.y)},p.prototype.bezierCurveTo=function(t,e,r,n,i,a){if(isNaN(i)||isNaN(a)||isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw s.error("jsPDF.context2d.bezierCurveTo: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.bezierCurveTo");var o=this.ctx.transform.applyToPoint(new h(i,a)),l=this.ctx.transform.applyToPoint(new h(t,e)),u=this.ctx.transform.applyToPoint(new h(r,n));this.path.push({type:"bct",x1:l.x,y1:l.y,x2:u.x,y2:u.y,x:o.x,y:o.y}),this.ctx.lastPoint=new h(o.x,o.y)},p.prototype.arc=function(t,e,r,n,i,a){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i))throw s.error("jsPDF.context2d.arc: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.arc");if(a=Boolean(a),!this.ctx.transform.isIdentity){var o=this.ctx.transform.applyToPoint(new h(t,e));t=o.x,e=o.y;var l=this.ctx.transform.applyToPoint(new h(0,r)),u=this.ctx.transform.applyToPoint(new h(0,0));r=Math.sqrt(Math.pow(l.x-u.x,2)+Math.pow(l.y-u.y,2))}Math.abs(i-n)>=2*Math.PI&&(n=0,i=2*Math.PI),this.path.push({type:"arc",x:t,y:e,radius:r,startAngle:n,endAngle:i,counterclockwise:a})},p.prototype.arcTo=function(t,e,r,n,i){throw new Error("arcTo not implemented.")},p.prototype.rect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw s.error("jsPDF.context2d.rect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.rect");this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+n),this.lineTo(t,e+n),this.lineTo(t,e),this.lineTo(t+r,e),this.lineTo(t,e)},p.prototype.fillRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw s.error("jsPDF.context2d.fillRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.fillRect");if(!m.call(this)){var i={};"butt"!==this.lineCap&&(i.lineCap=this.lineCap,this.lineCap="butt"),"miter"!==this.lineJoin&&(i.lineJoin=this.lineJoin,this.lineJoin="miter"),this.beginPath(),this.rect(t,e,r,n),this.fill(),i.hasOwnProperty("lineCap")&&(this.lineCap=i.lineCap),i.hasOwnProperty("lineJoin")&&(this.lineJoin=i.lineJoin)}},p.prototype.strokeRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw s.error("jsPDF.context2d.strokeRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.strokeRect");b.call(this)||(this.beginPath(),this.rect(t,e,r,n),this.stroke())},p.prototype.clearRect=function(t,e,r,n){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n))throw s.error("jsPDF.context2d.clearRect: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.clearRect");this.ignoreClearRect||(this.fillStyle="#ffffff",this.fillRect(t,e,r,n))},p.prototype.save=function(t){t="boolean"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,r=0;r<this.pdf.internal.getNumberOfPages();r++)this.pdf.setPage(r+1),this.pdf.internal.out("q");if(this.pdf.setPage(e),t){this.ctx.fontSize=this.pdf.internal.getFontSize();var n=new d(this.ctx);this.ctxStack.push(this.ctx),this.ctx=n}},p.prototype.restore=function(t){t="boolean"!=typeof t||t;for(var e=this.pdf.internal.getCurrentPageInfo().pageNumber,r=0;r<this.pdf.internal.getNumberOfPages();r++)this.pdf.setPage(r+1),this.pdf.internal.out("Q");this.pdf.setPage(e),t&&0!==this.ctxStack.length&&(this.ctx=this.ctxStack.pop(),this.fillStyle=this.ctx.fillStyle,this.strokeStyle=this.ctx.strokeStyle,this.font=this.ctx.font,this.lineCap=this.ctx.lineCap,this.lineWidth=this.ctx.lineWidth,this.lineJoin=this.ctx.lineJoin,this.lineDash=this.ctx.lineDash,this.lineDashOffset=this.ctx.lineDashOffset)},p.prototype.toDataURL=function(){throw new Error("toDataUrl not implemented.")};var g=function(t){var e,r,n,i;if(!0===t.isCanvasGradient&&(t=t.getColor()),!t)return{r:0,g:0,b:0,a:0,style:t};if(/transparent|rgba\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*0+\s*\)/.test(t))e=0,r=0,n=0,i=0;else{var a=/rgb\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/.exec(t);if(null!==a)e=parseInt(a[1]),r=parseInt(a[2]),n=parseInt(a[3]),i=1;else if(null!==(a=/rgba\s*\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*([\d.]+)\s*\)/.exec(t)))e=parseInt(a[1]),r=parseInt(a[2]),n=parseInt(a[3]),i=parseFloat(a[4]);else{if(i=1,"string"==typeof t&&"#"!==t.charAt(0)){var s=new c(t);t=s.ok?s.toHex():"#000000"}4===t.length?(e=t.substring(1,2),e+=e,r=t.substring(2,3),r+=r,n=t.substring(3,4),n+=n):(e=t.substring(1,3),r=t.substring(3,5),n=t.substring(5,7)),e=parseInt(e,16),r=parseInt(r,16),n=parseInt(n,16)}}return{r:e,g:r,b:n,a:i,style:t}},m=function(){return this.ctx.isFillTransparent||0==this.globalAlpha},b=function(){return Boolean(this.ctx.isStrokeTransparent||0==this.globalAlpha)};p.prototype.fillText=function(t,e,r,n){if(isNaN(e)||isNaN(r)||"string"!=typeof t)throw s.error("jsPDF.context2d.fillText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.fillText");if(n=isNaN(n)?void 0:n,!m.call(this)){var i=R(this.ctx.transform.rotation),a=this.ctx.transform.scaleX;C.call(this,{text:t,x:e,y:r,scale:a,angle:i,align:this.textAlign,maxWidth:n})}},p.prototype.strokeText=function(t,e,r,n){if(isNaN(e)||isNaN(r)||"string"!=typeof t)throw s.error("jsPDF.context2d.strokeText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.strokeText");if(!b.call(this)){n=isNaN(n)?void 0:n;var i=R(this.ctx.transform.rotation),a=this.ctx.transform.scaleX;C.call(this,{text:t,x:e,y:r,scale:a,renderingMode:"stroke",angle:i,align:this.textAlign,maxWidth:n})}},p.prototype.measureText=function(t){if("string"!=typeof t)throw s.error("jsPDF.context2d.measureText: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.measureText");var e=this.pdf,r=this.pdf.internal.scaleFactor,n=e.internal.getFontSize(),i=e.getStringUnitWidth(t)*n/e.internal.scaleFactor;return new function(t){var e=(t=t||{}).width||0;return Object.defineProperty(this,"width",{get:function(){return e}}),this}({width:i*=Math.round(96*r/72*1e4)/1e4})},p.prototype.scale=function(t,e){if(isNaN(t)||isNaN(e))throw s.error("jsPDF.context2d.scale: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.scale");var r=new u(t,0,0,e,0,0);this.ctx.transform=this.ctx.transform.multiply(r)},p.prototype.rotate=function(t){if(isNaN(t))throw s.error("jsPDF.context2d.rotate: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.rotate");var e=new u(Math.cos(t),Math.sin(t),-Math.sin(t),Math.cos(t),0,0);this.ctx.transform=this.ctx.transform.multiply(e)},p.prototype.translate=function(t,e){if(isNaN(t)||isNaN(e))throw s.error("jsPDF.context2d.translate: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.translate");var r=new u(1,0,0,1,t,e);this.ctx.transform=this.ctx.transform.multiply(r)},p.prototype.transform=function(t,e,r,n,i,a){if(isNaN(t)||isNaN(e)||isNaN(r)||isNaN(n)||isNaN(i)||isNaN(a))throw s.error("jsPDF.context2d.transform: Invalid arguments",arguments),new Error("Invalid arguments passed to jsPDF.context2d.transform");var o=new u(t,e,r,n,i,a);this.ctx.transform=this.ctx.transform.multiply(o)},p.prototype.setTransform=function(t,e,r,n,i,a){t=isNaN(t)?1:t,e=isNaN(e)?0:e,r=isNaN(r)?0:r,n=isNaN(n)?1:n,i=isNaN(i)?0:i,a=isNaN(a)?0:a,this.ctx.transform=new u(t,e,r,n,i,a)};var v=function(){return this.margin[0]>0||this.margin[1]>0||this.margin[2]>0||this.margin[3]>0};p.prototype.drawImage=function(t,e,r,n,i,a,s,o,h){var c=this.pdf.getImageProperties(t),f=1,d=1,p=1,g=1;void 0!==n&&void 0!==o&&(p=o/n,g=h/i,f=c.width/n*o/n,d=c.height/i*h/i),void 0===a&&(a=e,s=r,e=0,r=0),void 0!==n&&void 0===o&&(o=n,h=i),void 0===n&&void 0===o&&(o=c.width,h=c.height);var m=this.ctx.transform.decompose(),b=R(m.rotate.shx),y=new u,A=(y=(y=(y=y.multiply(m.translate)).multiply(m.skew)).multiply(m.scale)).applyToRectangle(new l(a-e*p,s-r*g,n*f,i*d));if(this.autoPaging){for(var N,S=w.call(this,A),k=[],P=0;P<S.length;P+=1)-1===k.indexOf(S[P])&&k.push(S[P]);x(k);for(var F=k[0],I=k[k.length-1],C=F;C<I+1;C++){this.pdf.setPage(C);var j=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],E=1===C?this.posY+this.margin[0]:this.margin[0],O=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],B=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],M=1===C?0:O+(C-2)*B;if(0!==this.ctx.clip_path.length){var T=this.path;N=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=_(N,this.posX+this.margin[3],-M+E+this.ctx.prevPageLastElemOffset),L.call(this,"fill",!0),this.path=T}var q=JSON.parse(JSON.stringify(A));q=_([q],this.posX+this.margin[3],-M+E+this.ctx.prevPageLastElemOffset)[0];var D=(C>F||C<I)&&v.call(this);D&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],j,B,null).clip().discardPath()),this.pdf.addImage(t,"JPEG",q.x,q.y,q.w,q.h,null,null,b),D&&this.pdf.restoreGraphicsState()}}else this.pdf.addImage(t,"JPEG",A.x,A.y,A.w,A.h,null,null,b)};var w=function(t,e,r){var n=[];e=e||this.pdf.internal.pageSize.width,r=r||this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2];var i=this.posY+this.ctx.prevPageLastElemOffset;switch(t.type){default:case"mt":case"lt":n.push(Math.floor((t.y+i)/r)+1);break;case"arc":n.push(Math.floor((t.y+i-t.radius)/r)+1),n.push(Math.floor((t.y+i+t.radius)/r)+1);break;case"qct":var a=T(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x,t.y);n.push(Math.floor((a.y+i)/r)+1),n.push(Math.floor((a.y+a.h+i)/r)+1);break;case"bct":var s=q(this.ctx.lastPoint.x,this.ctx.lastPoint.y,t.x1,t.y1,t.x2,t.y2,t.x,t.y);n.push(Math.floor((s.y+i)/r)+1),n.push(Math.floor((s.y+s.h+i)/r)+1);break;case"rect":n.push(Math.floor((t.y+i)/r)+1),n.push(Math.floor((t.y+t.h+i)/r)+1)}for(var o=0;o<n.length;o+=1)for(;this.pdf.internal.getNumberOfPages()<n[o];)y.call(this);return n},y=function(){var t=this.fillStyle,e=this.strokeStyle,r=this.font,n=this.lineCap,i=this.lineWidth,a=this.lineJoin;this.pdf.addPage(),this.fillStyle=t,this.strokeStyle=e,this.font=r,this.lineCap=n,this.lineWidth=i,this.lineJoin=a},_=function(t,e,r){for(var n=0;n<t.length;n++)switch(t[n].type){case"bct":t[n].x2+=e,t[n].y2+=r;case"qct":t[n].x1+=e,t[n].y1+=r;default:t[n].x+=e,t[n].y+=r}return t},x=function(t){return t.sort(function(t,e){return t-e})},A=function(t,e){var r=this.fillStyle,n=this.strokeStyle,i=this.lineCap,a=this.lineWidth,s=Math.abs(a*this.ctx.transform.scaleX),o=this.lineJoin;if(this.autoPaging){for(var h,l,u=JSON.parse(JSON.stringify(this.path)),c=JSON.parse(JSON.stringify(this.path)),f=[],d=0;d<c.length;d++)if(void 0!==c[d].x)for(var p=w.call(this,c[d]),g=0;g<p.length;g+=1)-1===f.indexOf(p[g])&&f.push(p[g]);for(var m=0;m<f.length;m++)for(;this.pdf.internal.getNumberOfPages()<f[m];)y.call(this);x(f);for(var b=f[0],A=f[f.length-1],N=b;N<A+1;N++){this.pdf.setPage(N),this.fillStyle=r,this.strokeStyle=n,this.lineCap=i,this.lineWidth=s,this.lineJoin=o;var S=this.pdf.internal.pageSize.width-this.margin[3]-this.margin[1],k=1===N?this.posY+this.margin[0]:this.margin[0],P=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],F=this.pdf.internal.pageSize.height-this.margin[0]-this.margin[2],I=1===N?0:P+(N-2)*F;if(0!==this.ctx.clip_path.length){var C=this.path;h=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=_(h,this.posX+this.margin[3],-I+k+this.ctx.prevPageLastElemOffset),L.call(this,t,!0),this.path=C}if(l=JSON.parse(JSON.stringify(u)),this.path=_(l,this.posX+this.margin[3],-I+k+this.ctx.prevPageLastElemOffset),!1===e||0===N){var j=(N>b||N<A)&&v.call(this);j&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],S,F,null).clip().discardPath()),L.call(this,t,e),j&&this.pdf.restoreGraphicsState()}this.lineWidth=a}this.path=u}else this.lineWidth=s,L.call(this,t,e),this.lineWidth=a},L=function(t,e){if(("stroke"!==t||e||!b.call(this))&&("stroke"===t||e||!m.call(this))){for(var r,n,i=[],a=this.path,s=0;s<a.length;s++){var o=a[s];switch(o.type){case"begin":i.push({begin:!0});break;case"close":i.push({close:!0});break;case"mt":i.push({start:o,deltas:[],abs:[]});break;case"lt":var h=i.length;if(a[s-1]&&!isNaN(a[s-1].x)&&(r=[o.x-a[s-1].x,o.y-a[s-1].y],h>0))for(;h>=0;h--)if(!0!==i[h-1].close&&!0!==i[h-1].begin){i[h-1].deltas.push(r),i[h-1].abs.push(o);break}break;case"bct":r=[o.x1-a[s-1].x,o.y1-a[s-1].y,o.x2-a[s-1].x,o.y2-a[s-1].y,o.x-a[s-1].x,o.y-a[s-1].y],i[i.length-1].deltas.push(r);break;case"qct":var l=a[s-1].x+2/3*(o.x1-a[s-1].x),u=a[s-1].y+2/3*(o.y1-a[s-1].y),c=o.x+2/3*(o.x1-o.x),f=o.y+2/3*(o.y1-o.y),d=o.x,p=o.y;r=[l-a[s-1].x,u-a[s-1].y,c-a[s-1].x,f-a[s-1].y,d-a[s-1].x,p-a[s-1].y],i[i.length-1].deltas.push(r);break;case"arc":i.push({deltas:[],abs:[],arc:!0}),Array.isArray(i[i.length-1].abs)&&i[i.length-1].abs.push(o)}}n=e?null:"stroke"===t?"stroke":"fill";for(var g=!1,v=0;v<i.length;v++)if(i[v].arc)for(var w=i[v].abs,y=0;y<w.length;y++){var _=w[y];"arc"===_.type?k.call(this,_.x,_.y,_.radius,_.startAngle,_.endAngle,_.counterclockwise,void 0,e,!g):j.call(this,_.x,_.y),g=!0}else if(!0===i[v].close)this.pdf.internal.out("h"),g=!1;else if(!0!==i[v].begin){var x=i[v].start.x,A=i[v].start.y;E.call(this,i[v].deltas,x,A),g=!0}n&&P.call(this,n),e&&F.call(this)}},N=function(t){var e=this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor,r=e*(this.pdf.internal.getLineHeightFactor()-1);switch(this.ctx.textBaseline){case"bottom":return t-r;case"top":return t+e-r;case"hanging":return t+e-2*r;case"middle":return t+e/2-r;default:return t}},S=function(t){return t+this.pdf.internal.getFontSize()/this.pdf.internal.scaleFactor*(this.pdf.internal.getLineHeightFactor()-1)};p.prototype.createLinearGradient=function(){var t=function(){};return t.colorStops=[],t.addColorStop=function(t,e){this.colorStops.push([t,e])},t.getColor=function(){return 0===this.colorStops.length?"#000000":this.colorStops[0][1]},t.isCanvasGradient=!0,t},p.prototype.createPattern=function(){return this.createLinearGradient()},p.prototype.createRadialGradient=function(){return this.createLinearGradient()};var k=function(t,e,r,n,i,a,s,o,h){for(var l=B.call(this,r,n,i,a),u=0;u<l.length;u++){var c=l[u];0===u&&(h?I.call(this,c.x1+t,c.y1+e):j.call(this,c.x1+t,c.y1+e)),O.call(this,t,e,c.x2,c.y2,c.x3,c.y3,c.x4,c.y4)}o?F.call(this):P.call(this,s)},P=function(t){switch(t){case"stroke":this.pdf.internal.out("S");break;case"fill":this.pdf.internal.out("f")}},F=function(){this.pdf.clip(),this.pdf.discardPath()},I=function(t,e){this.pdf.internal.out(r(t)+" "+i(e)+" m")},C=function(t){var e;switch(t.align){case"right":case"end":e="right";break;case"center":e="center";break;default:e="left"}var r,n,i,a=this.pdf.getTextDimensions(t.text),s=N.call(this,t.y),o=S.call(this,s)-a.h,c=this.ctx.transform.applyToPoint(new h(t.x,s));if(this.autoPaging){var f=this.ctx.transform.decompose(),d=new u;d=(d=(d=d.multiply(f.translate)).multiply(f.skew)).multiply(f.scale);for(var p=this.ctx.transform.applyToRectangle(new l(t.x,s,a.w,a.h)),g=d.applyToRectangle(new l(t.x,o,a.w,a.h)),m=w.call(this,g),b=[],y=0;y<m.length;y+=1)-1===b.indexOf(m[y])&&b.push(m[y]);x(b);for(var A=b[0],k=b[b.length-1],P=A;P<k+1;P++){this.pdf.setPage(P);var F=1===P?this.posY+this.margin[0]:this.margin[0],I=this.pdf.internal.pageSize.height-this.posY-this.margin[0]-this.margin[2],C=this.pdf.internal.pageSize.height-this.margin[2],j=C-this.margin[0],E=this.pdf.internal.pageSize.width-this.margin[1],O=E-this.margin[3],B=1===P?0:I+(P-2)*j;if(0!==this.ctx.clip_path.length){var M=this.path;r=JSON.parse(JSON.stringify(this.ctx.clip_path)),this.path=_(r,this.posX+this.margin[3],-1*B+F),L.call(this,"fill",!0),this.path=M}var R=_([JSON.parse(JSON.stringify(g))],this.posX+this.margin[3],-B+F+this.ctx.prevPageLastElemOffset)[0];t.scale>=.01&&(n=this.pdf.internal.getFontSize(),this.pdf.setFontSize(n*t.scale),i=this.lineWidth,this.lineWidth=i*t.scale);var T="text"!==this.autoPaging;if(T||R.y+R.h<=C){if(T||R.y>=F&&R.x<=E){var q=T?t.text:this.pdf.splitTextToSize(t.text,t.maxWidth||E-R.x)[0],D=_([JSON.parse(JSON.stringify(p))],this.posX+this.margin[3],-B+F+this.ctx.prevPageLastElemOffset)[0],z=T&&(P>A||P<k)&&v.call(this);z&&(this.pdf.saveGraphicsState(),this.pdf.rect(this.margin[3],this.margin[0],O,j,null).clip().discardPath()),this.pdf.text(q,D.x,D.y,{angle:t.angle,align:e,renderingMode:t.renderingMode}),z&&this.pdf.restoreGraphicsState()}}else R.y<C&&(this.ctx.prevPageLastElemOffset+=C-R.y);t.scale>=.01&&(this.pdf.setFontSize(n),this.lineWidth=i)}}else t.scale>=.01&&(n=this.pdf.internal.getFontSize(),this.pdf.setFontSize(n*t.scale),i=this.lineWidth,this.lineWidth=i*t.scale),this.pdf.text(t.text,c.x+this.posX,c.y+this.posY,{angle:t.angle,align:e,renderingMode:t.renderingMode,maxWidth:t.maxWidth}),t.scale>=.01&&(this.pdf.setFontSize(n),this.lineWidth=i)},j=function(t,e,n,a){n=n||0,a=a||0,this.pdf.internal.out(r(t+n)+" "+i(e+a)+" l")},E=function(t,e,r){return this.pdf.lines(t,e,r,null,null)},O=function(t,r,n,i,s,h,l,u){this.pdf.internal.out([e(a(n+t)),e(o(i+r)),e(a(s+t)),e(o(h+r)),e(a(l+t)),e(o(u+r)),"c"].join(" "))},B=function(t,e,r,n){for(var i=2*Math.PI,a=Math.PI/2;e>r;)e-=i;var s=Math.abs(r-e);s<i&&n&&(s=i-s);for(var o=[],h=n?-1:1,l=e;s>1e-5;){var u=l+h*Math.min(s,a);o.push(M.call(this,t,l,u)),s-=Math.abs(u-l),l=u}return o},M=function(t,e,r){var n=(r-e)/2,i=t*Math.cos(n),a=t*Math.sin(n),s=i,o=-a,h=s*s+o*o,l=h+s*i+o*a,u=4/3*(Math.sqrt(2*h*l)-l)/(s*a-o*i),c=s-u*o,f=o+u*s,d=c,p=-f,g=n+e,m=Math.cos(g),b=Math.sin(g);return{x1:t*Math.cos(e),y1:t*Math.sin(e),x2:c*m-f*b,y2:c*b+f*m,x3:d*m-p*b,y3:d*b+p*m,x4:t*Math.cos(r),y4:t*Math.sin(r)}},R=function(t){return 180*t/Math.PI},T=function(t,e,r,n,i,a){var s=t+.5*(r-t),o=e+.5*(n-e),h=i+.5*(r-i),u=a+.5*(n-a),c=Math.min(t,i,s,h),f=Math.max(t,i,s,h),d=Math.min(e,a,o,u),p=Math.max(e,a,o,u);return new l(c,d,f-c,p-d)},q=function(t,e,r,n,i,a,s,o){var h,u,c,f,d,p,g,m,b,v,w,y,_,x,A=r-t,L=n-e,N=i-r,S=a-n,k=s-i,P=o-a;for(u=0;u<41;u++)b=(g=(c=t+(h=u/40)*A)+h*((d=r+h*N)-c))+h*(d+h*(i+h*k-d)-g),v=(m=(f=e+h*L)+h*((p=n+h*S)-f))+h*(p+h*(a+h*P-p)-m),0==u?(w=b,y=v,_=b,x=v):(w=Math.min(w,b),y=Math.min(y,v),_=Math.max(_,b),x=Math.max(x,v));return new l(Math.round(w),Math.round(y),Math.round(_-w),Math.round(x-y))},D=function(){if(this.prevLineDash||this.ctx.lineDash.length||this.ctx.lineDashOffset){var t,e,r=(t=this.ctx.lineDash,e=this.ctx.lineDashOffset,JSON.stringify({lineDash:t,lineDashOffset:e}));this.prevLineDash!==r&&(this.pdf.setLineDash(this.ctx.lineDash,this.ctx.lineDashOffset),this.prevLineDash=r)}}}(R.API);var Ut=Uint8Array,Ht=Uint16Array,Wt=Int32Array,Vt=new Ut([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0,0,0,0]),Gt=new Ut([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,0,0]),Yt=new Ut([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),Zt=function(t,e){for(var r=new Ht(31),n=0;n<31;++n)r[n]=e+=1<<t[n-1];var i=new Wt(r[30]);for(n=1;n<30;++n)for(var a=r[n];a<r[n+1];++a)i[a]=a-r[n]<<5|n;return{b:r,r:i}},Jt=Zt(Vt,2),Xt=Jt.b,Kt=Jt.r;Xt[28]=258,Kt[258]=28;for(var $t=Zt(Gt,0).r,Qt=new Ht(32768),te=0;te<32768;++te){var ee=(43690&te)>>1|(21845&te)<<1;ee=(61680&(ee=(52428&ee)>>2|(13107&ee)<<2))>>4|(3855&ee)<<4,Qt[te]=((65280&ee)>>8|(255&ee)<<8)>>1}var re=function(t,e,r){for(var n=t.length,i=0,a=new Ht(e);i<n;++i)t[i]&&++a[t[i]-1];var s,o=new Ht(e);for(i=1;i<e;++i)o[i]=o[i-1]+a[i-1]<<1;if(r){s=new Ht(1<<e);var h=15-e;for(i=0;i<n;++i)if(t[i])for(var l=i<<4|t[i],u=e-t[i],c=o[t[i]-1]++<<u,f=c|(1<<u)-1;c<=f;++c)s[Qt[c]>>h]=l}else for(s=new Ht(n),i=0;i<n;++i)t[i]&&(s[i]=Qt[o[t[i]-1]++]>>15-t[i]);return s},ne=new Ut(288);for(te=0;te<144;++te)ne[te]=8;for(te=144;te<256;++te)ne[te]=9;for(te=256;te<280;++te)ne[te]=7;for(te=280;te<288;++te)ne[te]=8;var ie=new Ut(32);for(te=0;te<32;++te)ie[te]=5;var ae=re(ne,9,0),se=re(ie,5,0),oe=function(t){return(t+7)/8|0},he=function(t,e,r){r<<=7&e;var n=e/8|0;t[n]|=r,t[n+1]|=r>>8},le=function(t,e,r){r<<=7&e;var n=e/8|0;t[n]|=r,t[n+1]|=r>>8,t[n+2]|=r>>16},ue=function(t,e){for(var r=[],n=0;n<t.length;++n)t[n]&&r.push({s:n,f:t[n]});var i=r.length,a=r.slice();if(!i)return{t:be,l:0};if(1==i){var s=new Ut(r[0].s+1);return s[r[0].s]=1,{t:s,l:1}}r.sort(function(t,e){return t.f-e.f}),r.push({s:-1,f:25001});var o=r[0],h=r[1],l=0,u=1,c=2;for(r[0]={s:-1,f:o.f+h.f,l:o,r:h};u!=i-1;)o=r[r[l].f<r[c].f?l++:c++],h=r[l!=u&&r[l].f<r[c].f?l++:c++],r[u++]={s:-1,f:o.f+h.f,l:o,r:h};var f=a[0].s;for(n=1;n<i;++n)a[n].s>f&&(f=a[n].s);var d=new Ht(f+1),p=ce(r[u-1],d,0);if(p>e){n=0;var g=0,m=p-e,b=1<<m;for(a.sort(function(t,e){return d[e.s]-d[t.s]||t.f-e.f});n<i;++n){var v=a[n].s;if(!(d[v]>e))break;g+=b-(1<<p-d[v]),d[v]=e}for(g>>=m;g>0;){var w=a[n].s;d[w]<e?g-=1<<e-d[w]++-1:++n}for(;n>=0&&g;--n){var y=a[n].s;d[y]==e&&(--d[y],++g)}p=e}return{t:new Ut(d),l:p}},ce=function(t,e,r){return-1==t.s?Math.max(ce(t.l,e,r+1),ce(t.r,e,r+1)):e[t.s]=r},fe=function(t){for(var e=t.length;e&&!t[--e];);for(var r=new Ht(++e),n=0,i=t[0],a=1,s=function(t){r[n++]=t},o=1;o<=e;++o)if(t[o]==i&&o!=e)++a;else{if(!i&&a>2){for(;a>138;a-=138)s(32754);a>2&&(s(a>10?a-11<<5|28690:a-3<<5|12305),a=0)}else if(a>3){for(s(i),--a;a>6;a-=6)s(8304);a>2&&(s(a-3<<5|8208),a=0)}for(;a--;)s(i);a=1,i=t[o]}return{c:r.subarray(0,n),n:e}},de=function(t,e){for(var r=0,n=0;n<e.length;++n)r+=t[n]*e[n];return r},pe=function(t,e,r){var n=r.length,i=oe(e+2);t[i]=255&n,t[i+1]=n>>8,t[i+2]=255^t[i],t[i+3]=255^t[i+1];for(var a=0;a<n;++a)t[i+a+4]=r[a];return 8*(i+4+n)},ge=function(t,e,r,n,i,a,s,o,h,l,u){he(e,u++,r),++i[256];for(var c=ue(i,15),f=c.t,d=c.l,p=ue(a,15),g=p.t,m=p.l,b=fe(f),v=b.c,w=b.n,y=fe(g),_=y.c,x=y.n,A=new Ht(19),L=0;L<v.length;++L)++A[31&v[L]];for(L=0;L<_.length;++L)++A[31&_[L]];for(var N=ue(A,7),S=N.t,k=N.l,P=19;P>4&&!S[Yt[P-1]];--P);var F,I,C,j,E=l+5<<3,O=de(i,ne)+de(a,ie)+s,B=de(i,f)+de(a,g)+s+14+3*P+de(A,S)+2*A[16]+3*A[17]+7*A[18];if(h>=0&&E<=O&&E<=B)return pe(e,u,t.subarray(h,h+l));if(he(e,u,1+(B<O)),u+=2,B<O){F=re(f,d,0),I=f,C=re(g,m,0),j=g;var M=re(S,k,0);for(he(e,u,w-257),he(e,u+5,x-1),he(e,u+10,P-4),u+=14,L=0;L<P;++L)he(e,u+3*L,S[Yt[L]]);u+=3*P;for(var R=[v,_],T=0;T<2;++T){var q=R[T];for(L=0;L<q.length;++L){var D=31&q[L];he(e,u,M[D]),u+=S[D],D>15&&(he(e,u,q[L]>>5&127),u+=q[L]>>12)}}}else F=ae,I=ne,C=se,j=ie;for(L=0;L<o;++L){var z=n[L];if(z>255){le(e,u,F[257+(D=z>>18&31)]),u+=I[D+257],D>7&&(he(e,u,z>>23&31),u+=Vt[D]);var U=31&z;le(e,u,C[U]),u+=j[U],U>3&&(le(e,u,z>>5&8191),u+=Gt[U])}else le(e,u,F[z]),u+=I[z]}return le(e,u,F[256]),u+I[256]},me=new Wt([65540,131080,131088,131104,262176,1048704,1048832,2114560,2117632]),be=new Ut(0),ve=function(){var t=1,e=0;return{p:function(r){for(var n=t,i=e,a=0|r.length,s=0;s!=a;){for(var o=Math.min(s+2655,a);s<o;++s)i+=n+=r[s];n=(65535&n)+15*(n>>16),i=(65535&i)+15*(i>>16)}t=n,e=i},d:function(){return(255&(t%=65521))<<24|(65280&t)<<8|(255&(e%=65521))<<8|e>>8}}},we=function(t,e,r){for(;r;++e)t[e]=r,r>>>=8};function ye(t,e){e||(e={});var r=ve();r.p(t);var n=function(t,e,r,n,i){if(!i&&(i={l:1},e.dictionary)){var a=e.dictionary.subarray(-32768),s=new Ut(a.length+t.length);s.set(a),s.set(t,a.length),t=s,i.w=a.length}return function(t,e,r,n,i,a){var s=a.z||t.length,o=new Ut(n+s+5*(1+Math.ceil(s/7e3))+i),h=o.subarray(n,o.length-i),l=a.l,u=7&(a.r||0);if(e){u&&(h[0]=a.r>>3);for(var c=me[e-1],f=c>>13,d=8191&c,p=(1<<r)-1,g=a.p||new Ht(32768),m=a.h||new Ht(p+1),b=Math.ceil(r/3),v=2*b,w=function(e){return(t[e]^t[e+1]<<b^t[e+2]<<v)&p},y=new Wt(25e3),_=new Ht(288),x=new Ht(32),A=0,L=0,N=a.i||0,S=0,k=a.w||0,P=0;N+2<s;++N){var F=w(N),I=32767&N,C=m[F];if(g[I]=C,m[F]=I,k<=N){var j=s-N;if((A>7e3||S>24576)&&(j>423||!l)){u=ge(t,h,0,y,_,x,L,S,P,N-P,u),S=A=L=0,P=N;for(var E=0;E<286;++E)_[E]=0;for(E=0;E<30;++E)x[E]=0}var O=2,B=0,M=d,R=I-C&32767;if(j>2&&F==w(N-R))for(var T=Math.min(f,j)-1,q=Math.min(32767,N),D=Math.min(258,j);R<=q&&--M&&I!=C;){if(t[N+O]==t[N+O-R]){for(var z=0;z<D&&t[N+z]==t[N+z-R];++z);if(z>O){if(O=z,B=R,z>T)break;var U=Math.min(R,z-2),H=0;for(E=0;E<U;++E){var W=N-R+E&32767,V=W-g[W]&32767;V>H&&(H=V,C=W)}}}R+=(I=C)-(C=g[I])&32767}if(B){y[S++]=268435456|Kt[O]<<18|$t[B];var G=31&Kt[O],Y=31&$t[B];L+=Vt[G]+Gt[Y],++_[257+G],++x[Y],k=N+O,++A}else y[S++]=t[N],++_[t[N]]}}for(N=Math.max(N,k);N<s;++N)y[S++]=t[N],++_[t[N]];u=ge(t,h,l,y,_,x,L,S,P,N-P,u),l||(a.r=7&u|h[u/8|0]<<3,u-=7,a.h=m,a.p=g,a.i=N,a.w=k)}else{for(N=a.w||0;N<s+l;N+=65535){var Z=N+65535;Z>=s&&(h[u/8|0]=l,Z=s),u=pe(h,u+1,t.subarray(N,Z))}a.i=s}return function(t,e,r){return(null==e||e<0)&&(e=0),(null==r||r>t.length)&&(r=t.length),new Ut(t.subarray(e,r))}(o,0,n+oe(u)+i)}(t,null==e.level?6:e.level,null==e.mem?Math.ceil(1.5*Math.max(8,Math.min(13,Math.log(t.length)))):12+e.mem,r,4,i)}(t,e,e.dictionary?6:2);return function(t,e){var r=e.level,n=0==r?0:r<6?1:9==r?3:2;if(t[0]=120,t[1]=n<<6|(e.dictionary&&32),t[1]|=31-(t[0]<<8|t[1])%31,e.dictionary){var i=ve();i.p(e.dictionary),we(t,2,i.d())}}(n,e),we(n,n.length-4,r.d()),n}var _e="undefined"!=typeof TextDecoder&&new TextDecoder;try{_e.decode(be,{stream:!0})}catch(is){}
/**
   * @license
   * jsPDF filters PlugIn
   * Copyright (c) 2014 Aras Abbasi
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */function xe(t,e="utf8"){return new TextDecoder(e).decode(t)}!function(t){var e=function(t){var e,r,n,i,a,s,o,h,l,u;for(/[^\x00-\xFF]/.test(t),r=[],n=0,i=(t+=e="\0\0\0\0".slice(t.length%4||4)).length;i>n;n+=4)0!==(a=(t.charCodeAt(n)<<24)+(t.charCodeAt(n+1)<<16)+(t.charCodeAt(n+2)<<8)+t.charCodeAt(n+3))?(s=(a=((a=((a=((a=(a-(u=a%85))/85)-(l=a%85))/85)-(h=a%85))/85)-(o=a%85))/85)%85,r.push(s+33,o+33,h+33,l+33,u+33)):r.push(122);return function(t,e){for(var r=e;r>0;r--)t.pop()}(r,e.length),String.fromCharCode.apply(String,r)+"~>"},r=function(t){var e,r,n,i,a,s=String,o="length",h=255,l="charCodeAt",u="slice",c="replace";for(t[u](-2),t=t[u](0,-2)[c](/\s/g,"")[c]("z","!!!!!"),n=[],i=0,a=(t+=e="uuuuu"[u](t[o]%5||5))[o];a>i;i+=5)r=52200625*(t[l](i)-33)+614125*(t[l](i+1)-33)+7225*(t[l](i+2)-33)+85*(t[l](i+3)-33)+(t[l](i+4)-33),n.push(h&r>>24,h&r>>16,h&r>>8,h&r);return function(t,e){for(var r=e;r>0;r--)t.pop()}(n,e[o]),s.fromCharCode.apply(s,n)},n=function(t){return t.split("").map(function(t){return("0"+t.charCodeAt().toString(16)).slice(-2)}).join("")+">"},i=function(t){var e=new RegExp(/^([0-9A-Fa-f]{2})+$/);if(-1!==(t=t.replace(/\s/g,"")).indexOf(">")&&(t=t.substr(0,t.indexOf(">"))),t.length%2&&(t+="0"),!1===e.test(t))return"";for(var r="",n=0;n<t.length;n+=2)r+=String.fromCharCode("0x"+(t[n]+t[n+1]));return r},a=function(t){for(var e=new Uint8Array(t.length),r=t.length;r--;)e[r]=t.charCodeAt(r);return(e=ye(e)).reduce(function(t,e){return t+String.fromCharCode(e)},"")};t.processDataByFilters=function(t,s){var o=0,h=t||"",l=[];for("string"==typeof(s=s||[])&&(s=[s]),o=0;o<s.length;o+=1)switch(s[o]){case"ASCII85Decode":case"/ASCII85Decode":h=r(h),l.push("/ASCII85Encode");break;case"ASCII85Encode":case"/ASCII85Encode":h=e(h),l.push("/ASCII85Decode");break;case"ASCIIHexDecode":case"/ASCIIHexDecode":h=i(h),l.push("/ASCIIHexEncode");break;case"ASCIIHexEncode":case"/ASCIIHexEncode":h=n(h),l.push("/ASCIIHexDecode");break;case"FlateEncode":case"/FlateEncode":h=a(h),l.push("/FlateDecode");break;default:throw new Error('The filter: "'+s[o]+'" is not implemented')}return{data:h,reverseChain:l.reverse().join(" ")}}}(R.API),
/**
   * @license
   * jsPDF fileloading PlugIn
   * Copyright (c) 2018 Aras Abbasi (aras.abbasi@gmail.com)
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){t.loadFile=function(t,e,r){return function(t,e,r){e=!1!==e,r="function"==typeof r?r:function(){};var n=void 0;try{n=function(t,e,r){var n=new XMLHttpRequest,i=0,a=function(t){var e=t.length,r=[],n=String.fromCharCode;for(i=0;i<e;i+=1)r.push(n(255&t.charCodeAt(i)));return r.join("")};if(n.open("GET",t,!e),n.overrideMimeType("text/plain; charset=x-user-defined"),!1===e&&(n.onload=function(){200===n.status?r(a(this.responseText)):r(void 0)}),n.send(null),e&&200===n.status)return a(n.responseText)}(t,e,r)}catch(is){}return n}(t,e,r)},t.allowFsRead=void 0,t.loadImageFile=t.loadFile}(R.API),function(e){function r(){return(i.html2canvas?Promise.resolve(i.html2canvas):"object"===(void 0===t?"undefined":n(t))&&"undefined"!=typeof module?new Promise(function(t,e){try{t(require("html2canvas"))}catch(is){e(is)}}):"function"==typeof define&&define.amd?new Promise(function(t,e){try{require(["html2canvas"],t)}catch(is){e(is)}}):Promise.reject(new Error("Could not load html2canvas"))).catch(function(t){return Promise.reject(new Error("Could not load html2canvas: "+t))}).then(function(t){return t.default?t.default:t})}function a(){return(i.DOMPurify?Promise.resolve(i.DOMPurify):"object"===(void 0===t?"undefined":n(t))&&"undefined"!=typeof module?new Promise(function(t,e){try{t(require("dompurify"))}catch(is){e(is)}}):"function"==typeof define&&define.amd?new Promise(function(t,e){try{require(["dompurify"],t)}catch(is){e(is)}}):Promise.reject(new Error("Could not load dompurify"))).catch(function(t){return Promise.reject(new Error("Could not load dompurify: "+t))}).then(function(t){return t.default?t.default:t})}var s=function(t){var e=n(t);return"undefined"===e?"undefined":"string"===e||t instanceof String?"string":"number"===e||t instanceof Number?"number":"function"===e||t instanceof Function?"function":t&&t.constructor===Array?"array":t&&1===t.nodeType?"element":"object"===e?"object":"unknown"},o=function(t,e){var r=document.createElement(t);for(var n in e.className&&(r.className=e.className),e.innerHTML&&e.dompurify&&(r.innerHTML=e.dompurify.sanitize(e.innerHTML)),e.style)r.style[n]=e.style[n];return r},h=function t(e,r){for(var n=3===e.nodeType?document.createTextNode(e.nodeValue):e.cloneNode(!1),i=e.firstChild;i;i=i.nextSibling)!0!==r&&1===i.nodeType&&"SCRIPT"===i.nodeName||n.appendChild(t(i,r));return 1===e.nodeType&&("CANVAS"===e.nodeName?(n.width=e.width,n.height=e.height,n.getContext("2d").drawImage(e,0,0)):"TEXTAREA"!==e.nodeName&&"SELECT"!==e.nodeName||(n.value=e.value),n.addEventListener("load",function(){n.scrollTop=e.scrollTop,n.scrollLeft=e.scrollLeft},!0)),n},l=function t(e){var r=Object.assign(t.convert(Promise.resolve()),JSON.parse(JSON.stringify(t.template))),n=t.convert(Promise.resolve(),r);return(n=n.setProgress(1,t,1,[t])).set(e)};(l.prototype=Object.create(Promise.prototype)).constructor=l,l.convert=function(t,e){return t.__proto__=e||l.prototype,t},l.template={prop:{src:null,container:null,overlay:null,canvas:null,img:null,pdf:null,pageSize:null,callback:function(){}},progress:{val:0,state:null,n:0,stack:[]},opt:{filename:"file.pdf",margin:[0,0,0,0],enableLinks:!0,x:0,y:0,html2canvas:{},jsPDF:{},backgroundColor:"transparent"}},l.prototype.from=function(t,e){return this.then(function(){switch(e=e||function(t){switch(s(t)){case"string":return"string";case"element":return"canvas"===t.nodeName.toLowerCase()?"canvas":"element";default:return"unknown"}}(t),e){case"string":return this.then(a).then(function(e){return this.set({src:o("div",{innerHTML:t,dompurify:e})})});case"element":return this.set({src:t});case"canvas":return this.set({canvas:t});case"img":return this.set({img:t});default:return this.error("Unknown source type.")}})},l.prototype.to=function(t){switch(t){case"container":return this.toContainer();case"canvas":return this.toCanvas();case"img":return this.toImg();case"pdf":return this.toPdf();default:return this.error("Invalid target.")}},l.prototype.toContainer=function(){return this.thenList([function(){return this.prop.src||this.error("Cannot duplicate - no source HTML.")},function(){return this.prop.pageSize||this.setPageSize()}]).then(function(){var t={position:"relative",display:"inline-block",width:("number"!=typeof this.opt.width||isNaN(this.opt.width)||"number"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?Math.max(this.prop.src.clientWidth,this.prop.src.scrollWidth,this.prop.src.offsetWidth):this.opt.windowWidth)+"px",left:0,right:0,top:0,margin:"auto",backgroundColor:this.opt.backgroundColor},e=h(this.prop.src,this.opt.html2canvas.javascriptEnabled);"BODY"===e.tagName&&(t.height=Math.max(document.body.scrollHeight,document.body.offsetHeight,document.documentElement.clientHeight,document.documentElement.scrollHeight,document.documentElement.offsetHeight)+"px"),this.prop.overlay=o("div",{className:"html2pdf__overlay",style:{position:"fixed",overflow:"hidden",zIndex:1e3,left:"-100000px",right:0,bottom:0,top:0}}),this.prop.container=o("div",{className:"html2pdf__container",style:t}),this.prop.container.appendChild(e),this.prop.container.firstChild.appendChild(o("div",{style:{clear:"both",border:"0 none transparent",margin:0,padding:0,height:0}})),this.prop.container.style.float="none",this.prop.overlay.appendChild(this.prop.container),document.body.appendChild(this.prop.overlay),this.prop.container.firstChild.style.position="relative",this.prop.container.height=Math.max(this.prop.container.firstChild.clientHeight,this.prop.container.firstChild.scrollHeight,this.prop.container.firstChild.offsetHeight)+"px"})},l.prototype.toCanvas=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(r).then(function(t){var e=Object.assign({},this.opt.html2canvas);return delete e.onrendered,t(this.prop.container,e)}).then(function(t){(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)})},l.prototype.toContext2d=function(){var t=[function(){return document.body.contains(this.prop.container)||this.toContainer()}];return this.thenList(t).then(r).then(function(t){var e=this.opt.jsPDF,r=this.opt.fontFaces,n="number"!=typeof this.opt.width||isNaN(this.opt.width)||"number"!=typeof this.opt.windowWidth||isNaN(this.opt.windowWidth)?1:this.opt.width/this.opt.windowWidth,i=Object.assign({async:!0,allowTaint:!0,scale:n,scrollX:this.opt.scrollX||0,scrollY:this.opt.scrollY||0,backgroundColor:"#ffffff",imageTimeout:15e3,logging:!0,proxy:null,removeContainer:!0,foreignObjectRendering:!1,useCORS:!1},this.opt.html2canvas);if(delete i.onrendered,e.context2d.autoPaging=void 0===this.opt.autoPaging||this.opt.autoPaging,e.context2d.posX=this.opt.x,e.context2d.posY=this.opt.y,e.context2d.margin=this.opt.margin,e.context2d.fontFaces=r,r)for(var a=0;a<r.length;++a){var s=r[a],o=s.src.find(function(t){return"truetype"===t.format});o&&e.addFont(o.url,s.ref.name,s.ref.style)}return i.windowHeight=i.windowHeight||0,i.windowHeight=0==i.windowHeight?Math.max(this.prop.container.clientHeight,this.prop.container.scrollHeight,this.prop.container.offsetHeight):i.windowHeight,e.context2d.save(!0),t(this.prop.container,i)}).then(function(t){this.opt.jsPDF.context2d.restore(!0),(this.opt.html2canvas.onrendered||function(){})(t),this.prop.canvas=t,document.body.removeChild(this.prop.overlay)})},l.prototype.toImg=function(){return this.thenList([function(){return this.prop.canvas||this.toCanvas()}]).then(function(){var t=this.prop.canvas.toDataURL("image/"+this.opt.image.type,this.opt.image.quality);this.prop.img=document.createElement("img"),this.prop.img.src=t})},l.prototype.toPdf=function(){return this.thenList([function(){return this.toContext2d()}]).then(function(){this.prop.pdf=this.prop.pdf||this.opt.jsPDF})},l.prototype.output=function(t,e,r){return"img"===(r=r||"pdf").toLowerCase()||"image"===r.toLowerCase()?this.outputImg(t,e):this.outputPdf(t,e)},l.prototype.outputPdf=function(t,e){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then(function(){return this.prop.pdf.output(t,e)})},l.prototype.outputImg=function(t){return this.thenList([function(){return this.prop.img||this.toImg()}]).then(function(){switch(t){case void 0:case"img":return this.prop.img;case"datauristring":case"dataurlstring":return this.prop.img.src;case"datauri":case"dataurl":return document.location.href=this.prop.img.src;default:throw'Image output type "'+t+'" is not supported.'}})},l.prototype.save=function(t){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).set(t?{filename:t}:null).then(function(){this.prop.pdf.save(this.opt.filename)})},l.prototype.doCallback=function(){return this.thenList([function(){return this.prop.pdf||this.toPdf()}]).then(function(){this.prop.callback(this.prop.pdf)})},l.prototype.set=function(t){if("object"!==s(t))return this;var e=Object.keys(t||{}).map(function(e){if(e in l.template.prop)return function(){this.prop[e]=t[e]};switch(e){case"margin":return this.setMargin.bind(this,t.margin);case"jsPDF":return function(){return this.opt.jsPDF=t.jsPDF,this.setPageSize()};case"pageSize":return this.setPageSize.bind(this,t.pageSize);default:return function(){this.opt[e]=t[e]}}},this);return this.then(function(){return this.thenList(e)})},l.prototype.get=function(t,e){return this.then(function(){var r=t in l.template.prop?this.prop[t]:this.opt[t];return e?e(r):r})},l.prototype.setMargin=function(t){return this.then(function(){switch(s(t)){case"number":t=[t,t,t,t];case"array":if(2===t.length&&(t=[t[0],t[1],t[0],t[1]]),4===t.length)break;default:return this.error("Invalid margin array.")}this.opt.margin=t}).then(this.setPageSize)},l.prototype.setPageSize=function(t){function e(t,e){return Math.floor(t*e/72*96)}return this.then(function(){(t=t||R.getPageSize(this.opt.jsPDF)).hasOwnProperty("inner")||(t.inner={width:t.width-this.opt.margin[1]-this.opt.margin[3],height:t.height-this.opt.margin[0]-this.opt.margin[2]},t.inner.px={width:e(t.inner.width,t.k),height:e(t.inner.height,t.k)},t.inner.ratio=t.inner.height/t.inner.width),this.prop.pageSize=t})},l.prototype.setProgress=function(t,e,r,n){return null!=t&&(this.progress.val=t),null!=e&&(this.progress.state=e),null!=r&&(this.progress.n=r),null!=n&&(this.progress.stack=n),this.progress.ratio=this.progress.val/this.progress.state,this},l.prototype.updateProgress=function(t,e,r,n){return this.setProgress(t?this.progress.val+t:null,e||null,r?this.progress.n+r:null,n?this.progress.stack.concat(n):null)},l.prototype.then=function(t,e){var r=this;return this.thenCore(t,e,function(t,e){return r.updateProgress(null,null,1,[t]),Promise.prototype.then.call(this,function(e){return r.updateProgress(null,t),e}).then(t,e).then(function(t){return r.updateProgress(1),t})})},l.prototype.thenCore=function(t,e,r){r=r||Promise.prototype.then;var n=this;t&&(t=t.bind(n)),e&&(e=e.bind(n));var i=-1!==Promise.toString().indexOf("[native code]")&&"Promise"===Promise.name?n:l.convert(Object.assign({},n),Promise.prototype),a=r.call(i,t,e);return l.convert(a,n.__proto__)},l.prototype.thenExternal=function(t,e){return Promise.prototype.then.call(this,t,e)},l.prototype.thenList=function(t){var e=this;return t.forEach(function(t){e=e.thenCore(t)}),e},l.prototype.catch=function(t){t&&(t=t.bind(this));var e=Promise.prototype.catch.call(this,t);return l.convert(e,this)},l.prototype.catchExternal=function(t){return Promise.prototype.catch.call(this,t)},l.prototype.error=function(t){return this.then(function(){throw new Error(t)})},l.prototype.using=l.prototype.set,l.prototype.saveAs=l.prototype.save,l.prototype.export=l.prototype.output,l.prototype.run=l.prototype.then,R.getPageSize=function(t,e,r){if("object"===n(t)){var i=t;t=i.orientation,e=i.unit||e,r=i.format||r}e=e||"mm",r=r||"a4",t=(""+(t||"P")).toLowerCase();var a,s=(""+r).toLowerCase(),o={a0:[2383.94,3370.39],a1:[1683.78,2383.94],a2:[1190.55,1683.78],a3:[841.89,1190.55],a4:[595.28,841.89],a5:[419.53,595.28],a6:[297.64,419.53],a7:[209.76,297.64],a8:[147.4,209.76],a9:[104.88,147.4],a10:[73.7,104.88],b0:[2834.65,4008.19],b1:[2004.09,2834.65],b2:[1417.32,2004.09],b3:[1000.63,1417.32],b4:[708.66,1000.63],b5:[498.9,708.66],b6:[354.33,498.9],b7:[249.45,354.33],b8:[175.75,249.45],b9:[124.72,175.75],b10:[87.87,124.72],c0:[2599.37,3676.54],c1:[1836.85,2599.37],c2:[1298.27,1836.85],c3:[918.43,1298.27],c4:[649.13,918.43],c5:[459.21,649.13],c6:[323.15,459.21],c7:[229.61,323.15],c8:[161.57,229.61],c9:[113.39,161.57],c10:[79.37,113.39],dl:[311.81,623.62],letter:[612,792],"government-letter":[576,756],legal:[612,1008],"junior-legal":[576,360],ledger:[1224,792],tabloid:[792,1224],"credit-card":[153,243]};switch(e){case"pt":a=1;break;case"mm":a=72/25.4;break;case"cm":a=72/2.54;break;case"in":a=72;break;case"px":a=.75;break;case"pc":case"em":a=12;break;case"ex":a=6;break;default:throw"Invalid unit: "+e}var h,l=0,u=0;if(o.hasOwnProperty(s))l=o[s][1]/a,u=o[s][0]/a;else try{l=r[1],u=r[0]}catch(qr){throw new Error("Invalid format: "+r)}if("p"===t||"portrait"===t)t="p",u>l&&(h=u,u=l,l=h);else{if("l"!==t&&"landscape"!==t)throw"Invalid orientation: "+t;t="l",l>u&&(h=u,u=l,l=h)}return{width:u,height:l,unit:e,k:a,orientation:t}},e.html=function(t,e){(e=e||{}).callback=e.callback||function(){},e.html2canvas=e.html2canvas||{},e.html2canvas.canvas=e.html2canvas.canvas||this.canvas,e.jsPDF=e.jsPDF||this,e.fontFaces=e.fontFaces?e.fontFaces.map(Et):null;var r=new l(e);return e.worker?r:r.from(t).doCallback()}}(R.API),
/**
   * @license
   * ====================================================================
   * Copyright (c) 2013 Youssef Beddad, youssef.beddad@gmail.com
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   * ====================================================================
   */
function(t){t.addJS=function(t){var e,r,n=function(t){for(var e="",r=0;r<t.length;r++){var n=t[r];if("("===n||")"===n){for(var i=0,a=r-1;a>=0&&"\\"===t[a];a--)i++;e+=i%2==0?"\\"+n:n}else e+=n}return e}(t);return this.internal.events.subscribe("postPutResources",function(){e=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/Names [(EmbeddedJS) "+(e+1)+" 0 R]"),this.internal.out(">>"),this.internal.out("endobj"),r=this.internal.newObject(),this.internal.out("<<"),this.internal.out("/S /JavaScript"),this.internal.out("/JS ("+n+")"),this.internal.out(">>"),this.internal.out("endobj")}),this.internal.events.subscribe("putCatalog",function(){void 0!==e&&void 0!==r&&this.internal.out("/Names <</JavaScript "+e+" 0 R>>")}),this}}(R.API),
/**
   * @license
   * Copyright (c) 2014 Steven Spungin (TwelveTone LLC)  steven@twelvetone.tv
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e;t.events.push(["postPutResources",function(){var t=this,r=/^(\d+) 0 obj$/;if(this.outline.root.children.length>0)for(var n=t.outline.render().split(/\r\n/),i=0;i<n.length;i++){var a=n[i],s=r.exec(a);if(null!=s){var o=s[1];t.internal.newObjectDeferredBegin(o,!1)}t.internal.write(a)}if(this.outline.createNamedDestinations){var h=this.internal.pages.length,l=[];for(i=0;i<h;i++){var u=t.internal.newObject();l.push(u);var c=t.internal.getPageInfo(i+1);t.internal.write("<< /D["+c.objId+" 0 R /XYZ null null null]>> endobj")}var f=t.internal.newObject();for(t.internal.write("<< /Names [ "),i=0;i<l.length;i++)t.internal.write("(page_"+(i+1)+")"+l[i]+" 0 R");t.internal.write(" ] >>","endobj"),e=t.internal.newObject(),t.internal.write("<< /Dests "+f+" 0 R"),t.internal.write(">>","endobj")}}]),t.events.push(["putCatalog",function(){var t=this;t.outline.root.children.length>0&&(t.internal.write("/Outlines",this.outline.makeRef(this.outline.root)),this.outline.createNamedDestinations&&t.internal.write("/Names "+e+" 0 R"))}]),t.events.push(["initialized",function(){var t=this;t.outline={createNamedDestinations:!1,root:{children:[]}},t.outline.add=function(t,e,r){var n={title:e,options:r,children:[]};return null==t&&(t=this.root),t.children.push(n),n},t.outline.render=function(){return this.ctx={},this.ctx.val="",this.ctx.pdf=t,this.genIds_r(this.root),this.renderRoot(this.root),this.renderItems(this.root),this.ctx.val},t.outline.genIds_r=function(e){e.id=t.internal.newObjectDeferred();for(var r=0;r<e.children.length;r++)this.genIds_r(e.children[r])},t.outline.renderRoot=function(t){this.objStart(t),this.line("/Type /Outlines"),t.children.length>0&&(this.line("/First "+this.makeRef(t.children[0])),this.line("/Last "+this.makeRef(t.children[t.children.length-1]))),this.line("/Count "+this.count_r({count:0},t)),this.objEnd()},t.outline.renderItems=function(e){for(var r=this.ctx.pdf.internal.getVerticalCoordinateString,n=0;n<e.children.length;n++){var i=e.children[n];this.objStart(i),this.line("/Title "+this.makeString(i.title)),this.line("/Parent "+this.makeRef(e)),n>0&&this.line("/Prev "+this.makeRef(e.children[n-1])),n<e.children.length-1&&this.line("/Next "+this.makeRef(e.children[n+1])),i.children.length>0&&(this.line("/First "+this.makeRef(i.children[0])),this.line("/Last "+this.makeRef(i.children[i.children.length-1])));var a=this.count=this.count_r({count:0},i);if(a>0&&this.line("/Count "+a),i.options&&i.options.pageNumber){var s=t.internal.getPageInfo(i.options.pageNumber);this.line("/Dest ["+s.objId+" 0 R /XYZ 0 "+r(0)+" 0]")}this.objEnd()}for(var o=0;o<e.children.length;o++)this.renderItems(e.children[o])},t.outline.line=function(t){this.ctx.val+=t+"\r\n"},t.outline.makeRef=function(t){return t.id+" 0 R"},t.outline.makeString=function(e){return"("+t.internal.pdfEscape(e)+")"},t.outline.objStart=function(t){this.ctx.val+="\r\n"+t.id+" 0 obj\r\n<<\r\n"},t.outline.objEnd=function(){this.ctx.val+=">> \r\nendobj\r\n"},t.outline.count_r=function(t,e){for(var r=0;r<e.children.length;r++)t.count++,this.count_r(t,e.children[r]);return t.count}}])}(R.API),
/**
   * @license
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e=[192,193,194,195,196,197,198,199];t.processJPEG=function(t,r,n,i,a,s){var o,h=this.decode.DCT_DECODE,l=null;if("string"==typeof t||this.__addimage__.isArrayBuffer(t)||this.__addimage__.isArrayBufferView(t)){switch(t=a||t,t=this.__addimage__.isArrayBuffer(t)?new Uint8Array(t):t,o=function(t){for(var r,n=256*t.charCodeAt(4)+t.charCodeAt(5),i=t.length,a={width:0,height:0,numcomponents:1},s=4;s<i;s+=2){if(s+=n,-1!==e.indexOf(t.charCodeAt(s+1))){r=256*t.charCodeAt(s+5)+t.charCodeAt(s+6),a={width:256*t.charCodeAt(s+7)+t.charCodeAt(s+8),height:r,numcomponents:t.charCodeAt(s+9)};break}n=256*t.charCodeAt(s+2)+t.charCodeAt(s+3)}return a}(t=this.__addimage__.isArrayBufferView(t)?this.__addimage__.arrayBufferToBinaryString(t):t),o.numcomponents){case 1:s=this.color_spaces.DEVICE_GRAY;break;case 4:s=this.color_spaces.DEVICE_CMYK;break;case 3:s=this.color_spaces.DEVICE_RGB}l={data:t,width:o.width,height:o.height,colorSpace:s,bitsPerComponent:8,filter:h,index:r,alias:n}}return l}}(R.API);const Ae=new TextEncoder,Le=(()=>{const t=new Uint8Array(4);return!((new Uint32Array(t.buffer)[0]=1)&t[0])})(),Ne={int8:globalThis.Int8Array,uint8:globalThis.Uint8Array,int16:globalThis.Int16Array,uint16:globalThis.Uint16Array,int32:globalThis.Int32Array,uint32:globalThis.Uint32Array,uint64:globalThis.BigUint64Array,int64:globalThis.BigInt64Array,float32:globalThis.Float32Array,float64:globalThis.Float64Array};class Se{buffer;byteLength;byteOffset;length;offset;lastWrittenByte;littleEndian;_data;_mark;_marks;constructor(t=8192,e={}){let r=!1;"number"==typeof t?t=new ArrayBuffer(t):(r=!0,this.lastWrittenByte=t.byteLength);const n=e.offset?e.offset>>>0:0,i=t.byteLength-n;let a=n;(ArrayBuffer.isView(t)||t instanceof Se)&&(t.byteLength!==t.buffer.byteLength&&(a=t.byteOffset+n),t=t.buffer),this.lastWrittenByte=r?i:0,this.buffer=t,this.length=i,this.byteLength=i,this.byteOffset=a,this.offset=0,this.littleEndian=!0,this._data=new DataView(this.buffer,a,i),this._mark=0,this._marks=[]}available(t=1){return this.offset+t<=this.length}isLittleEndian(){return this.littleEndian}setLittleEndian(){return this.littleEndian=!0,this}isBigEndian(){return!this.littleEndian}setBigEndian(){return this.littleEndian=!1,this}skip(t=1){return this.offset+=t,this}back(t=1){return this.offset-=t,this}seek(t){return this.offset=t,this}mark(){return this._mark=this.offset,this}reset(){return this.offset=this._mark,this}pushMark(){return this._marks.push(this.offset),this}popMark(){const t=this._marks.pop();if(void 0===t)throw new Error("Mark stack empty");return this.seek(t),this}rewind(){return this.offset=0,this}ensureAvailable(t=1){if(!this.available(t)){const e=2*(this.offset+t),r=new Uint8Array(e);r.set(new Uint8Array(this.buffer)),this.buffer=r.buffer,this.length=e,this.byteLength=e,this._data=new DataView(this.buffer)}return this}readBoolean(){return 0!==this.readUint8()}readInt8(){return this._data.getInt8(this.offset++)}readUint8(){return this._data.getUint8(this.offset++)}readByte(){return this.readUint8()}readBytes(t=1){return this.readArray(t,"uint8")}readArray(t,e){const r=Ne[e].BYTES_PER_ELEMENT*t,n=this.byteOffset+this.offset,i=this.buffer.slice(n,n+r);if(this.littleEndian===Le&&"uint8"!==e&&"int8"!==e){const t=new Uint8Array(this.buffer.slice(n,n+r));t.reverse();const i=new Ne[e](t.buffer);return this.offset+=r,i.reverse(),i}const a=new Ne[e](i);return this.offset+=r,a}readInt16(){const t=this._data.getInt16(this.offset,this.littleEndian);return this.offset+=2,t}readUint16(){const t=this._data.getUint16(this.offset,this.littleEndian);return this.offset+=2,t}readInt32(){const t=this._data.getInt32(this.offset,this.littleEndian);return this.offset+=4,t}readUint32(){const t=this._data.getUint32(this.offset,this.littleEndian);return this.offset+=4,t}readFloat32(){const t=this._data.getFloat32(this.offset,this.littleEndian);return this.offset+=4,t}readFloat64(){const t=this._data.getFloat64(this.offset,this.littleEndian);return this.offset+=8,t}readBigInt64(){const t=this._data.getBigInt64(this.offset,this.littleEndian);return this.offset+=8,t}readBigUint64(){const t=this._data.getBigUint64(this.offset,this.littleEndian);return this.offset+=8,t}readChar(){return String.fromCharCode(this.readInt8())}readChars(t=1){let e="";for(let r=0;r<t;r++)e+=this.readChar();return e}readUtf8(t=1){return xe(this.readBytes(t))}decodeText(t=1,e="utf8"){return xe(this.readBytes(t),e)}writeBoolean(t){return this.writeUint8(t?255:0),this}writeInt8(t){return this.ensureAvailable(1),this._data.setInt8(this.offset++,t),this._updateLastWrittenByte(),this}writeUint8(t){return this.ensureAvailable(1),this._data.setUint8(this.offset++,t),this._updateLastWrittenByte(),this}writeByte(t){return this.writeUint8(t)}writeBytes(t){this.ensureAvailable(t.length);for(let e=0;e<t.length;e++)this._data.setUint8(this.offset++,t[e]);return this._updateLastWrittenByte(),this}writeInt16(t){return this.ensureAvailable(2),this._data.setInt16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this}writeUint16(t){return this.ensureAvailable(2),this._data.setUint16(this.offset,t,this.littleEndian),this.offset+=2,this._updateLastWrittenByte(),this}writeInt32(t){return this.ensureAvailable(4),this._data.setInt32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeUint32(t){return this.ensureAvailable(4),this._data.setUint32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeFloat32(t){return this.ensureAvailable(4),this._data.setFloat32(this.offset,t,this.littleEndian),this.offset+=4,this._updateLastWrittenByte(),this}writeFloat64(t){return this.ensureAvailable(8),this._data.setFloat64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeBigInt64(t){return this.ensureAvailable(8),this._data.setBigInt64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeBigUint64(t){return this.ensureAvailable(8),this._data.setBigUint64(this.offset,t,this.littleEndian),this.offset+=8,this._updateLastWrittenByte(),this}writeChar(t){return this.writeUint8(t.charCodeAt(0))}writeChars(t){for(let e=0;e<t.length;e++)this.writeUint8(t.charCodeAt(e));return this}writeUtf8(t){return this.writeBytes(function(t){return Ae.encode(t)}(t))}toArray(){return new Uint8Array(this.buffer,this.byteOffset,this.lastWrittenByte)}getWrittenByteLength(){return this.lastWrittenByte-this.byteOffset}_updateLastWrittenByte(){this.offset>this.lastWrittenByte&&(this.lastWrittenByte=this.offset)}}
/*! pako 2.1.0 https://github.com/nodeca/pako @license (MIT AND Zlib) */function ke(t){let e=t.length;for(;--e>=0;)t[e]=0}const Pe=new Uint8Array([0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0]),Fe=new Uint8Array([0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13]),Ie=new Uint8Array([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7]),Ce=new Uint8Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),je=new Array(576);ke(je);const Ee=new Array(60);ke(Ee);const Oe=new Array(512);ke(Oe);const Be=new Array(256);ke(Be);const Me=new Array(29);ke(Me);const Re=new Array(30);function Te(t,e,r,n,i){this.static_tree=t,this.extra_bits=e,this.extra_base=r,this.elems=n,this.max_length=i,this.has_stree=t&&t.length}let qe,De,ze;function Ue(t,e){this.dyn_tree=t,this.max_code=0,this.stat_desc=e}ke(Re);const He=t=>t<256?Oe[t]:Oe[256+(t>>>7)],We=(t,e)=>{t.pending_buf[t.pending++]=255&e,t.pending_buf[t.pending++]=e>>>8&255},Ve=(t,e,r)=>{t.bi_valid>16-r?(t.bi_buf|=e<<t.bi_valid&65535,We(t,t.bi_buf),t.bi_buf=e>>16-t.bi_valid,t.bi_valid+=r-16):(t.bi_buf|=e<<t.bi_valid&65535,t.bi_valid+=r)},Ge=(t,e,r)=>{Ve(t,r[2*e],r[2*e+1])},Ye=(t,e)=>{let r=0;do{r|=1&t,t>>>=1,r<<=1}while(--e>0);return r>>>1},Ze=(t,e,r)=>{const n=new Array(16);let i,a,s=0;for(i=1;i<=15;i++)s=s+r[i-1]<<1,n[i]=s;for(a=0;a<=e;a++){let e=t[2*a+1];0!==e&&(t[2*a]=Ye(n[e]++,e))}},Je=t=>{let e;for(e=0;e<286;e++)t.dyn_ltree[2*e]=0;for(e=0;e<30;e++)t.dyn_dtree[2*e]=0;for(e=0;e<19;e++)t.bl_tree[2*e]=0;t.dyn_ltree[512]=1,t.opt_len=t.static_len=0,t.sym_next=t.matches=0},Xe=t=>{t.bi_valid>8?We(t,t.bi_buf):t.bi_valid>0&&(t.pending_buf[t.pending++]=t.bi_buf),t.bi_buf=0,t.bi_valid=0},Ke=(t,e,r,n)=>{const i=2*e,a=2*r;return t[i]<t[a]||t[i]===t[a]&&n[e]<=n[r]},$e=(t,e,r)=>{const n=t.heap[r];let i=r<<1;for(;i<=t.heap_len&&(i<t.heap_len&&Ke(e,t.heap[i+1],t.heap[i],t.depth)&&i++,!Ke(e,n,t.heap[i],t.depth));)t.heap[r]=t.heap[i],r=i,i<<=1;t.heap[r]=n},Qe=(t,e,r)=>{let n,i,a,s,o=0;if(0!==t.sym_next)do{n=255&t.pending_buf[t.sym_buf+o++],n+=(255&t.pending_buf[t.sym_buf+o++])<<8,i=t.pending_buf[t.sym_buf+o++],0===n?Ge(t,i,e):(a=Be[i],Ge(t,a+256+1,e),s=Pe[a],0!==s&&(i-=Me[a],Ve(t,i,s)),n--,a=He(n),Ge(t,a,r),s=Fe[a],0!==s&&(n-=Re[a],Ve(t,n,s)))}while(o<t.sym_next);Ge(t,256,e)},tr=(t,e)=>{const r=e.dyn_tree,n=e.stat_desc.static_tree,i=e.stat_desc.has_stree,a=e.stat_desc.elems;let s,o,h,l=-1;for(t.heap_len=0,t.heap_max=573,s=0;s<a;s++)0!==r[2*s]?(t.heap[++t.heap_len]=l=s,t.depth[s]=0):r[2*s+1]=0;for(;t.heap_len<2;)h=t.heap[++t.heap_len]=l<2?++l:0,r[2*h]=1,t.depth[h]=0,t.opt_len--,i&&(t.static_len-=n[2*h+1]);for(e.max_code=l,s=t.heap_len>>1;s>=1;s--)$e(t,r,s);h=a;do{s=t.heap[1],t.heap[1]=t.heap[t.heap_len--],$e(t,r,1),o=t.heap[1],t.heap[--t.heap_max]=s,t.heap[--t.heap_max]=o,r[2*h]=r[2*s]+r[2*o],t.depth[h]=(t.depth[s]>=t.depth[o]?t.depth[s]:t.depth[o])+1,r[2*s+1]=r[2*o+1]=h,t.heap[1]=h++,$e(t,r,1)}while(t.heap_len>=2);t.heap[--t.heap_max]=t.heap[1],((t,e)=>{const r=e.dyn_tree,n=e.max_code,i=e.stat_desc.static_tree,a=e.stat_desc.has_stree,s=e.stat_desc.extra_bits,o=e.stat_desc.extra_base,h=e.stat_desc.max_length;let l,u,c,f,d,p,g=0;for(f=0;f<=15;f++)t.bl_count[f]=0;for(r[2*t.heap[t.heap_max]+1]=0,l=t.heap_max+1;l<573;l++)u=t.heap[l],f=r[2*r[2*u+1]+1]+1,f>h&&(f=h,g++),r[2*u+1]=f,u>n||(t.bl_count[f]++,d=0,u>=o&&(d=s[u-o]),p=r[2*u],t.opt_len+=p*(f+d),a&&(t.static_len+=p*(i[2*u+1]+d)));if(0!==g){do{for(f=h-1;0===t.bl_count[f];)f--;t.bl_count[f]--,t.bl_count[f+1]+=2,t.bl_count[h]--,g-=2}while(g>0);for(f=h;0!==f;f--)for(u=t.bl_count[f];0!==u;)c=t.heap[--l],c>n||(r[2*c+1]!==f&&(t.opt_len+=(f-r[2*c+1])*r[2*c],r[2*c+1]=f),u--)}})(t,e),Ze(r,l,t.bl_count)},er=(t,e,r)=>{let n,i,a=-1,s=e[1],o=0,h=7,l=4;for(0===s&&(h=138,l=3),e[2*(r+1)+1]=65535,n=0;n<=r;n++)i=s,s=e[2*(n+1)+1],++o<h&&i===s||(o<l?t.bl_tree[2*i]+=o:0!==i?(i!==a&&t.bl_tree[2*i]++,t.bl_tree[32]++):o<=10?t.bl_tree[34]++:t.bl_tree[36]++,o=0,a=i,0===s?(h=138,l=3):i===s?(h=6,l=3):(h=7,l=4))},rr=(t,e,r)=>{let n,i,a=-1,s=e[1],o=0,h=7,l=4;for(0===s&&(h=138,l=3),n=0;n<=r;n++)if(i=s,s=e[2*(n+1)+1],!(++o<h&&i===s)){if(o<l)do{Ge(t,i,t.bl_tree)}while(0!==--o);else 0!==i?(i!==a&&(Ge(t,i,t.bl_tree),o--),Ge(t,16,t.bl_tree),Ve(t,o-3,2)):o<=10?(Ge(t,17,t.bl_tree),Ve(t,o-3,3)):(Ge(t,18,t.bl_tree),Ve(t,o-11,7));o=0,a=i,0===s?(h=138,l=3):i===s?(h=6,l=3):(h=7,l=4)}};let nr=!1;const ir=(t,e,r,n)=>{Ve(t,0+(n?1:0),3),Xe(t),We(t,r),We(t,~r),r&&t.pending_buf.set(t.window.subarray(e,e+r),t.pending),t.pending+=r};var ar={_tr_init:t=>{nr||((()=>{let t,e,r,n,i;const a=new Array(16);for(r=0,n=0;n<28;n++)for(Me[n]=r,t=0;t<1<<Pe[n];t++)Be[r++]=n;for(Be[r-1]=n,i=0,n=0;n<16;n++)for(Re[n]=i,t=0;t<1<<Fe[n];t++)Oe[i++]=n;for(i>>=7;n<30;n++)for(Re[n]=i<<7,t=0;t<1<<Fe[n]-7;t++)Oe[256+i++]=n;for(e=0;e<=15;e++)a[e]=0;for(t=0;t<=143;)je[2*t+1]=8,t++,a[8]++;for(;t<=255;)je[2*t+1]=9,t++,a[9]++;for(;t<=279;)je[2*t+1]=7,t++,a[7]++;for(;t<=287;)je[2*t+1]=8,t++,a[8]++;for(Ze(je,287,a),t=0;t<30;t++)Ee[2*t+1]=5,Ee[2*t]=Ye(t,5);qe=new Te(je,Pe,257,286,15),De=new Te(Ee,Fe,0,30,15),ze=new Te(new Array(0),Ie,0,19,7)})(),nr=!0),t.l_desc=new Ue(t.dyn_ltree,qe),t.d_desc=new Ue(t.dyn_dtree,De),t.bl_desc=new Ue(t.bl_tree,ze),t.bi_buf=0,t.bi_valid=0,Je(t)},_tr_stored_block:ir,_tr_flush_block:(t,e,r,n)=>{let i,a,s=0;t.level>0?(2===t.strm.data_type&&(t.strm.data_type=(t=>{let e,r=4093624447;for(e=0;e<=31;e++,r>>>=1)if(1&r&&0!==t.dyn_ltree[2*e])return 0;if(0!==t.dyn_ltree[18]||0!==t.dyn_ltree[20]||0!==t.dyn_ltree[26])return 1;for(e=32;e<256;e++)if(0!==t.dyn_ltree[2*e])return 1;return 0})(t)),tr(t,t.l_desc),tr(t,t.d_desc),s=(t=>{let e;for(er(t,t.dyn_ltree,t.l_desc.max_code),er(t,t.dyn_dtree,t.d_desc.max_code),tr(t,t.bl_desc),e=18;e>=3&&0===t.bl_tree[2*Ce[e]+1];e--);return t.opt_len+=3*(e+1)+5+5+4,e})(t),i=t.opt_len+3+7>>>3,a=t.static_len+3+7>>>3,a<=i&&(i=a)):i=a=r+5,r+4<=i&&-1!==e?ir(t,e,r,n):4===t.strategy||a===i?(Ve(t,2+(n?1:0),3),Qe(t,je,Ee)):(Ve(t,4+(n?1:0),3),((t,e,r,n)=>{let i;for(Ve(t,e-257,5),Ve(t,r-1,5),Ve(t,n-4,4),i=0;i<n;i++)Ve(t,t.bl_tree[2*Ce[i]+1],3);rr(t,t.dyn_ltree,e-1),rr(t,t.dyn_dtree,r-1)})(t,t.l_desc.max_code+1,t.d_desc.max_code+1,s+1),Qe(t,t.dyn_ltree,t.dyn_dtree)),Je(t),n&&Xe(t)},_tr_tally:(t,e,r)=>(t.pending_buf[t.sym_buf+t.sym_next++]=e,t.pending_buf[t.sym_buf+t.sym_next++]=e>>8,t.pending_buf[t.sym_buf+t.sym_next++]=r,0===e?t.dyn_ltree[2*r]++:(t.matches++,e--,t.dyn_ltree[2*(Be[r]+256+1)]++,t.dyn_dtree[2*He(e)]++),t.sym_next===t.sym_end),_tr_align:t=>{Ve(t,2,3),Ge(t,256,je),(t=>{16===t.bi_valid?(We(t,t.bi_buf),t.bi_buf=0,t.bi_valid=0):t.bi_valid>=8&&(t.pending_buf[t.pending++]=255&t.bi_buf,t.bi_buf>>=8,t.bi_valid-=8)})(t)}},sr=(t,e,r,n)=>{let i=65535&t,a=t>>>16&65535,s=0;for(;0!==r;){s=r>2e3?2e3:r,r-=s;do{i=i+e[n++]|0,a=a+i|0}while(--s);i%=65521,a%=65521}return i|a<<16};const or=new Uint32Array((()=>{let t,e=[];for(var r=0;r<256;r++){t=r;for(var n=0;n<8;n++)t=1&t?3988292384^t>>>1:t>>>1;e[r]=t}return e})());var hr=(t,e,r,n)=>{const i=or,a=n+r;t^=-1;for(let s=n;s<a;s++)t=t>>>8^i[255&(t^e[s])];return-1^t},lr={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"},ur={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_MEM_ERROR:-4,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8};const{_tr_init:cr,_tr_stored_block:fr,_tr_flush_block:dr,_tr_tally:pr,_tr_align:gr}=ar,{Z_NO_FLUSH:mr,Z_PARTIAL_FLUSH:br,Z_FULL_FLUSH:vr,Z_FINISH:wr,Z_BLOCK:yr,Z_OK:_r,Z_STREAM_END:xr,Z_STREAM_ERROR:Ar,Z_DATA_ERROR:Lr,Z_BUF_ERROR:Nr,Z_DEFAULT_COMPRESSION:Sr,Z_FILTERED:kr,Z_HUFFMAN_ONLY:Pr,Z_RLE:Fr,Z_FIXED:Ir,Z_DEFAULT_STRATEGY:Cr,Z_UNKNOWN:jr,Z_DEFLATED:Er}=ur,Or=258,Br=262,Mr=42,Rr=113,Tr=666,qr=(t,e)=>(t.msg=lr[e],e),Dr=t=>2*t-(t>4?9:0),zr=t=>{let e=t.length;for(;--e>=0;)t[e]=0},Ur=t=>{let e,r,n,i=t.w_size;e=t.hash_size,n=e;do{r=t.head[--n],t.head[n]=r>=i?r-i:0}while(--e);e=i,n=e;do{r=t.prev[--n],t.prev[n]=r>=i?r-i:0}while(--e)};let Hr=(t,e,r)=>(e<<t.hash_shift^r)&t.hash_mask;const Wr=t=>{const e=t.state;let r=e.pending;r>t.avail_out&&(r=t.avail_out),0!==r&&(t.output.set(e.pending_buf.subarray(e.pending_out,e.pending_out+r),t.next_out),t.next_out+=r,e.pending_out+=r,t.total_out+=r,t.avail_out-=r,e.pending-=r,0===e.pending&&(e.pending_out=0))},Vr=(t,e)=>{dr(t,t.block_start>=0?t.block_start:-1,t.strstart-t.block_start,e),t.block_start=t.strstart,Wr(t.strm)},Gr=(t,e)=>{t.pending_buf[t.pending++]=e},Yr=(t,e)=>{t.pending_buf[t.pending++]=e>>>8&255,t.pending_buf[t.pending++]=255&e},Zr=(t,e,r,n)=>{let i=t.avail_in;return i>n&&(i=n),0===i?0:(t.avail_in-=i,e.set(t.input.subarray(t.next_in,t.next_in+i),r),1===t.state.wrap?t.adler=sr(t.adler,e,i,r):2===t.state.wrap&&(t.adler=hr(t.adler,e,i,r)),t.next_in+=i,t.total_in+=i,i)},Jr=(t,e)=>{let r,n,i=t.max_chain_length,a=t.strstart,s=t.prev_length,o=t.nice_match;const h=t.strstart>t.w_size-Br?t.strstart-(t.w_size-Br):0,l=t.window,u=t.w_mask,c=t.prev,f=t.strstart+Or;let d=l[a+s-1],p=l[a+s];t.prev_length>=t.good_match&&(i>>=2),o>t.lookahead&&(o=t.lookahead);do{if(r=e,l[r+s]===p&&l[r+s-1]===d&&l[r]===l[a]&&l[++r]===l[a+1]){a+=2,r++;do{}while(l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&l[++a]===l[++r]&&a<f);if(n=Or-(f-a),a=f-Or,n>s){if(t.match_start=e,s=n,n>=o)break;d=l[a+s-1],p=l[a+s]}}}while((e=c[e&u])>h&&0!==--i);return s<=t.lookahead?s:t.lookahead},Xr=t=>{const e=t.w_size;let r,n,i;do{if(n=t.window_size-t.lookahead-t.strstart,t.strstart>=e+(e-Br)&&(t.window.set(t.window.subarray(e,e+e-n),0),t.match_start-=e,t.strstart-=e,t.block_start-=e,t.insert>t.strstart&&(t.insert=t.strstart),Ur(t),n+=e),0===t.strm.avail_in)break;if(r=Zr(t.strm,t.window,t.strstart+t.lookahead,n),t.lookahead+=r,t.lookahead+t.insert>=3)for(i=t.strstart-t.insert,t.ins_h=t.window[i],t.ins_h=Hr(t,t.ins_h,t.window[i+1]);t.insert&&(t.ins_h=Hr(t,t.ins_h,t.window[i+3-1]),t.prev[i&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=i,i++,t.insert--,!(t.lookahead+t.insert<3)););}while(t.lookahead<Br&&0!==t.strm.avail_in)},Kr=(t,e)=>{let r,n,i,a=t.pending_buf_size-5>t.w_size?t.w_size:t.pending_buf_size-5,s=0,o=t.strm.avail_in;do{if(r=65535,i=t.bi_valid+42>>3,t.strm.avail_out<i)break;if(i=t.strm.avail_out-i,n=t.strstart-t.block_start,r>n+t.strm.avail_in&&(r=n+t.strm.avail_in),r>i&&(r=i),r<a&&(0===r&&e!==wr||e===mr||r!==n+t.strm.avail_in))break;s=e===wr&&r===n+t.strm.avail_in?1:0,fr(t,0,0,s),t.pending_buf[t.pending-4]=r,t.pending_buf[t.pending-3]=r>>8,t.pending_buf[t.pending-2]=~r,t.pending_buf[t.pending-1]=~r>>8,Wr(t.strm),n&&(n>r&&(n=r),t.strm.output.set(t.window.subarray(t.block_start,t.block_start+n),t.strm.next_out),t.strm.next_out+=n,t.strm.avail_out-=n,t.strm.total_out+=n,t.block_start+=n,r-=n),r&&(Zr(t.strm,t.strm.output,t.strm.next_out,r),t.strm.next_out+=r,t.strm.avail_out-=r,t.strm.total_out+=r)}while(0===s);return o-=t.strm.avail_in,o&&(o>=t.w_size?(t.matches=2,t.window.set(t.strm.input.subarray(t.strm.next_in-t.w_size,t.strm.next_in),0),t.strstart=t.w_size,t.insert=t.strstart):(t.window_size-t.strstart<=o&&(t.strstart-=t.w_size,t.window.set(t.window.subarray(t.w_size,t.w_size+t.strstart),0),t.matches<2&&t.matches++,t.insert>t.strstart&&(t.insert=t.strstart)),t.window.set(t.strm.input.subarray(t.strm.next_in-o,t.strm.next_in),t.strstart),t.strstart+=o,t.insert+=o>t.w_size-t.insert?t.w_size-t.insert:o),t.block_start=t.strstart),t.high_water<t.strstart&&(t.high_water=t.strstart),s?4:e!==mr&&e!==wr&&0===t.strm.avail_in&&t.strstart===t.block_start?2:(i=t.window_size-t.strstart,t.strm.avail_in>i&&t.block_start>=t.w_size&&(t.block_start-=t.w_size,t.strstart-=t.w_size,t.window.set(t.window.subarray(t.w_size,t.w_size+t.strstart),0),t.matches<2&&t.matches++,i+=t.w_size,t.insert>t.strstart&&(t.insert=t.strstart)),i>t.strm.avail_in&&(i=t.strm.avail_in),i&&(Zr(t.strm,t.window,t.strstart,i),t.strstart+=i,t.insert+=i>t.w_size-t.insert?t.w_size-t.insert:i),t.high_water<t.strstart&&(t.high_water=t.strstart),i=t.bi_valid+42>>3,i=t.pending_buf_size-i>65535?65535:t.pending_buf_size-i,a=i>t.w_size?t.w_size:i,n=t.strstart-t.block_start,(n>=a||(n||e===wr)&&e!==mr&&0===t.strm.avail_in&&n<=i)&&(r=n>i?i:n,s=e===wr&&0===t.strm.avail_in&&r===n?1:0,fr(t,t.block_start,r,s),t.block_start+=r,Wr(t.strm)),s?3:1)},$r=(t,e)=>{let r,n;for(;;){if(t.lookahead<Br){if(Xr(t),t.lookahead<Br&&e===mr)return 1;if(0===t.lookahead)break}if(r=0,t.lookahead>=3&&(t.ins_h=Hr(t,t.ins_h,t.window[t.strstart+3-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),0!==r&&t.strstart-r<=t.w_size-Br&&(t.match_length=Jr(t,r)),t.match_length>=3)if(n=pr(t,t.strstart-t.match_start,t.match_length-3),t.lookahead-=t.match_length,t.match_length<=t.max_lazy_match&&t.lookahead>=3){t.match_length--;do{t.strstart++,t.ins_h=Hr(t,t.ins_h,t.window[t.strstart+3-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart}while(0!==--t.match_length);t.strstart++}else t.strstart+=t.match_length,t.match_length=0,t.ins_h=t.window[t.strstart],t.ins_h=Hr(t,t.ins_h,t.window[t.strstart+1]);else n=pr(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++;if(n&&(Vr(t,!1),0===t.strm.avail_out))return 1}return t.insert=t.strstart<2?t.strstart:2,e===wr?(Vr(t,!0),0===t.strm.avail_out?3:4):t.sym_next&&(Vr(t,!1),0===t.strm.avail_out)?1:2},Qr=(t,e)=>{let r,n,i;for(;;){if(t.lookahead<Br){if(Xr(t),t.lookahead<Br&&e===mr)return 1;if(0===t.lookahead)break}if(r=0,t.lookahead>=3&&(t.ins_h=Hr(t,t.ins_h,t.window[t.strstart+3-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart),t.prev_length=t.match_length,t.prev_match=t.match_start,t.match_length=2,0!==r&&t.prev_length<t.max_lazy_match&&t.strstart-r<=t.w_size-Br&&(t.match_length=Jr(t,r),t.match_length<=5&&(t.strategy===kr||3===t.match_length&&t.strstart-t.match_start>4096)&&(t.match_length=2)),t.prev_length>=3&&t.match_length<=t.prev_length){i=t.strstart+t.lookahead-3,n=pr(t,t.strstart-1-t.prev_match,t.prev_length-3),t.lookahead-=t.prev_length-1,t.prev_length-=2;do{++t.strstart<=i&&(t.ins_h=Hr(t,t.ins_h,t.window[t.strstart+3-1]),r=t.prev[t.strstart&t.w_mask]=t.head[t.ins_h],t.head[t.ins_h]=t.strstart)}while(0!==--t.prev_length);if(t.match_available=0,t.match_length=2,t.strstart++,n&&(Vr(t,!1),0===t.strm.avail_out))return 1}else if(t.match_available){if(n=pr(t,0,t.window[t.strstart-1]),n&&Vr(t,!1),t.strstart++,t.lookahead--,0===t.strm.avail_out)return 1}else t.match_available=1,t.strstart++,t.lookahead--}return t.match_available&&(n=pr(t,0,t.window[t.strstart-1]),t.match_available=0),t.insert=t.strstart<2?t.strstart:2,e===wr?(Vr(t,!0),0===t.strm.avail_out?3:4):t.sym_next&&(Vr(t,!1),0===t.strm.avail_out)?1:2};function tn(t,e,r,n,i){this.good_length=t,this.max_lazy=e,this.nice_length=r,this.max_chain=n,this.func=i}const en=[new tn(0,0,0,0,Kr),new tn(4,4,8,4,$r),new tn(4,5,16,8,$r),new tn(4,6,32,32,$r),new tn(4,4,16,16,Qr),new tn(8,16,32,32,Qr),new tn(8,16,128,128,Qr),new tn(8,32,128,256,Qr),new tn(32,128,258,1024,Qr),new tn(32,258,258,4096,Qr)];function rn(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Er,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new Uint16Array(1146),this.dyn_dtree=new Uint16Array(122),this.bl_tree=new Uint16Array(78),zr(this.dyn_ltree),zr(this.dyn_dtree),zr(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new Uint16Array(16),this.heap=new Uint16Array(573),zr(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new Uint16Array(573),zr(this.depth),this.sym_buf=0,this.lit_bufsize=0,this.sym_next=0,this.sym_end=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}const nn=t=>{if(!t)return 1;const e=t.state;return!e||e.strm!==t||e.status!==Mr&&57!==e.status&&69!==e.status&&73!==e.status&&91!==e.status&&103!==e.status&&e.status!==Rr&&e.status!==Tr?1:0},an=t=>{if(nn(t))return qr(t,Ar);t.total_in=t.total_out=0,t.data_type=jr;const e=t.state;return e.pending=0,e.pending_out=0,e.wrap<0&&(e.wrap=-e.wrap),e.status=2===e.wrap?57:e.wrap?Mr:Rr,t.adler=2===e.wrap?0:1,e.last_flush=-2,cr(e),_r},sn=t=>{const e=an(t);return e===_r&&((r=t.state).window_size=2*r.w_size,zr(r.head),r.max_lazy_match=en[r.level].max_lazy,r.good_match=en[r.level].good_length,r.nice_match=en[r.level].nice_length,r.max_chain_length=en[r.level].max_chain,r.strstart=0,r.block_start=0,r.lookahead=0,r.insert=0,r.match_length=r.prev_length=2,r.match_available=0,r.ins_h=0),e;var r},on=(t,e,r,n,i,a)=>{if(!t)return Ar;let s=1;if(e===Sr&&(e=6),n<0?(s=0,n=-n):n>15&&(s=2,n-=16),i<1||i>9||r!==Er||n<8||n>15||e<0||e>9||a<0||a>Ir||8===n&&1!==s)return qr(t,Ar);8===n&&(n=9);const o=new rn;return t.state=o,o.strm=t,o.status=Mr,o.wrap=s,o.gzhead=null,o.w_bits=n,o.w_size=1<<o.w_bits,o.w_mask=o.w_size-1,o.hash_bits=i+7,o.hash_size=1<<o.hash_bits,o.hash_mask=o.hash_size-1,o.hash_shift=~~((o.hash_bits+3-1)/3),o.window=new Uint8Array(2*o.w_size),o.head=new Uint16Array(o.hash_size),o.prev=new Uint16Array(o.w_size),o.lit_bufsize=1<<i+6,o.pending_buf_size=4*o.lit_bufsize,o.pending_buf=new Uint8Array(o.pending_buf_size),o.sym_buf=o.lit_bufsize,o.sym_end=3*(o.lit_bufsize-1),o.level=e,o.strategy=a,o.method=r,sn(t)};var hn=on,ln=(t,e)=>nn(t)||2!==t.state.wrap?Ar:(t.state.gzhead=e,_r),un=(t,e)=>{if(nn(t)||e>yr||e<0)return t?qr(t,Ar):Ar;const r=t.state;if(!t.output||0!==t.avail_in&&!t.input||r.status===Tr&&e!==wr)return qr(t,0===t.avail_out?Nr:Ar);const n=r.last_flush;if(r.last_flush=e,0!==r.pending){if(Wr(t),0===t.avail_out)return r.last_flush=-1,_r}else if(0===t.avail_in&&Dr(e)<=Dr(n)&&e!==wr)return qr(t,Nr);if(r.status===Tr&&0!==t.avail_in)return qr(t,Nr);if(r.status===Mr&&0===r.wrap&&(r.status=Rr),r.status===Mr){let e=Er+(r.w_bits-8<<4)<<8,n=-1;if(n=r.strategy>=Pr||r.level<2?0:r.level<6?1:6===r.level?2:3,e|=n<<6,0!==r.strstart&&(e|=32),e+=31-e%31,Yr(r,e),0!==r.strstart&&(Yr(r,t.adler>>>16),Yr(r,65535&t.adler)),t.adler=1,r.status=Rr,Wr(t),0!==r.pending)return r.last_flush=-1,_r}if(57===r.status)if(t.adler=0,Gr(r,31),Gr(r,139),Gr(r,8),r.gzhead)Gr(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),Gr(r,255&r.gzhead.time),Gr(r,r.gzhead.time>>8&255),Gr(r,r.gzhead.time>>16&255),Gr(r,r.gzhead.time>>24&255),Gr(r,9===r.level?2:r.strategy>=Pr||r.level<2?4:0),Gr(r,255&r.gzhead.os),r.gzhead.extra&&r.gzhead.extra.length&&(Gr(r,255&r.gzhead.extra.length),Gr(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(t.adler=hr(t.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=69;else if(Gr(r,0),Gr(r,0),Gr(r,0),Gr(r,0),Gr(r,0),Gr(r,9===r.level?2:r.strategy>=Pr||r.level<2?4:0),Gr(r,3),r.status=Rr,Wr(t),0!==r.pending)return r.last_flush=-1,_r;if(69===r.status){if(r.gzhead.extra){let e=r.pending,n=(65535&r.gzhead.extra.length)-r.gzindex;for(;r.pending+n>r.pending_buf_size;){let i=r.pending_buf_size-r.pending;if(r.pending_buf.set(r.gzhead.extra.subarray(r.gzindex,r.gzindex+i),r.pending),r.pending=r.pending_buf_size,r.gzhead.hcrc&&r.pending>e&&(t.adler=hr(t.adler,r.pending_buf,r.pending-e,e)),r.gzindex+=i,Wr(t),0!==r.pending)return r.last_flush=-1,_r;e=0,n-=i}let i=new Uint8Array(r.gzhead.extra);r.pending_buf.set(i.subarray(r.gzindex,r.gzindex+n),r.pending),r.pending+=n,r.gzhead.hcrc&&r.pending>e&&(t.adler=hr(t.adler,r.pending_buf,r.pending-e,e)),r.gzindex=0}r.status=73}if(73===r.status){if(r.gzhead.name){let e,n=r.pending;do{if(r.pending===r.pending_buf_size){if(r.gzhead.hcrc&&r.pending>n&&(t.adler=hr(t.adler,r.pending_buf,r.pending-n,n)),Wr(t),0!==r.pending)return r.last_flush=-1,_r;n=0}e=r.gzindex<r.gzhead.name.length?255&r.gzhead.name.charCodeAt(r.gzindex++):0,Gr(r,e)}while(0!==e);r.gzhead.hcrc&&r.pending>n&&(t.adler=hr(t.adler,r.pending_buf,r.pending-n,n)),r.gzindex=0}r.status=91}if(91===r.status){if(r.gzhead.comment){let e,n=r.pending;do{if(r.pending===r.pending_buf_size){if(r.gzhead.hcrc&&r.pending>n&&(t.adler=hr(t.adler,r.pending_buf,r.pending-n,n)),Wr(t),0!==r.pending)return r.last_flush=-1,_r;n=0}e=r.gzindex<r.gzhead.comment.length?255&r.gzhead.comment.charCodeAt(r.gzindex++):0,Gr(r,e)}while(0!==e);r.gzhead.hcrc&&r.pending>n&&(t.adler=hr(t.adler,r.pending_buf,r.pending-n,n))}r.status=103}if(103===r.status){if(r.gzhead.hcrc){if(r.pending+2>r.pending_buf_size&&(Wr(t),0!==r.pending))return r.last_flush=-1,_r;Gr(r,255&t.adler),Gr(r,t.adler>>8&255),t.adler=0}if(r.status=Rr,Wr(t),0!==r.pending)return r.last_flush=-1,_r}if(0!==t.avail_in||0!==r.lookahead||e!==mr&&r.status!==Tr){let n=0===r.level?Kr(r,e):r.strategy===Pr?((t,e)=>{let r;for(;;){if(0===t.lookahead&&(Xr(t),0===t.lookahead)){if(e===mr)return 1;break}if(t.match_length=0,r=pr(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++,r&&(Vr(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,e===wr?(Vr(t,!0),0===t.strm.avail_out?3:4):t.sym_next&&(Vr(t,!1),0===t.strm.avail_out)?1:2})(r,e):r.strategy===Fr?((t,e)=>{let r,n,i,a;const s=t.window;for(;;){if(t.lookahead<=Or){if(Xr(t),t.lookahead<=Or&&e===mr)return 1;if(0===t.lookahead)break}if(t.match_length=0,t.lookahead>=3&&t.strstart>0&&(i=t.strstart-1,n=s[i],n===s[++i]&&n===s[++i]&&n===s[++i])){a=t.strstart+Or;do{}while(n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&n===s[++i]&&i<a);t.match_length=Or-(a-i),t.match_length>t.lookahead&&(t.match_length=t.lookahead)}if(t.match_length>=3?(r=pr(t,1,t.match_length-3),t.lookahead-=t.match_length,t.strstart+=t.match_length,t.match_length=0):(r=pr(t,0,t.window[t.strstart]),t.lookahead--,t.strstart++),r&&(Vr(t,!1),0===t.strm.avail_out))return 1}return t.insert=0,e===wr?(Vr(t,!0),0===t.strm.avail_out?3:4):t.sym_next&&(Vr(t,!1),0===t.strm.avail_out)?1:2})(r,e):en[r.level].func(r,e);if(3!==n&&4!==n||(r.status=Tr),1===n||3===n)return 0===t.avail_out&&(r.last_flush=-1),_r;if(2===n&&(e===br?gr(r):e!==yr&&(fr(r,0,0,!1),e===vr&&(zr(r.head),0===r.lookahead&&(r.strstart=0,r.block_start=0,r.insert=0))),Wr(t),0===t.avail_out))return r.last_flush=-1,_r}return e!==wr?_r:r.wrap<=0?xr:(2===r.wrap?(Gr(r,255&t.adler),Gr(r,t.adler>>8&255),Gr(r,t.adler>>16&255),Gr(r,t.adler>>24&255),Gr(r,255&t.total_in),Gr(r,t.total_in>>8&255),Gr(r,t.total_in>>16&255),Gr(r,t.total_in>>24&255)):(Yr(r,t.adler>>>16),Yr(r,65535&t.adler)),Wr(t),r.wrap>0&&(r.wrap=-r.wrap),0!==r.pending?_r:xr)},cn=t=>{if(nn(t))return Ar;const e=t.state.status;return t.state=null,e===Rr?qr(t,Lr):_r},fn=(t,e)=>{let r=e.length;if(nn(t))return Ar;const n=t.state,i=n.wrap;if(2===i||1===i&&n.status!==Mr||n.lookahead)return Ar;if(1===i&&(t.adler=sr(t.adler,e,r,0)),n.wrap=0,r>=n.w_size){0===i&&(zr(n.head),n.strstart=0,n.block_start=0,n.insert=0);let t=new Uint8Array(n.w_size);t.set(e.subarray(r-n.w_size,r),0),e=t,r=n.w_size}const a=t.avail_in,s=t.next_in,o=t.input;for(t.avail_in=r,t.next_in=0,t.input=e,Xr(n);n.lookahead>=3;){let t=n.strstart,e=n.lookahead-2;do{n.ins_h=Hr(n,n.ins_h,n.window[t+3-1]),n.prev[t&n.w_mask]=n.head[n.ins_h],n.head[n.ins_h]=t,t++}while(--e);n.strstart=t,n.lookahead=2,Xr(n)}return n.strstart+=n.lookahead,n.block_start=n.strstart,n.insert=n.lookahead,n.lookahead=0,n.match_length=n.prev_length=2,n.match_available=0,t.next_in=s,t.input=o,t.avail_in=a,n.wrap=i,_r};const dn=(t,e)=>Object.prototype.hasOwnProperty.call(t,e);var pn=function(t){const e=Array.prototype.slice.call(arguments,1);for(;e.length;){const r=e.shift();if(r){if("object"!=typeof r)throw new TypeError(r+"must be non-object");for(const e in r)dn(r,e)&&(t[e]=r[e])}}return t},gn=t=>{let e=0;for(let n=0,i=t.length;n<i;n++)e+=t[n].length;const r=new Uint8Array(e);for(let n=0,i=0,a=t.length;n<a;n++){let e=t[n];r.set(e,i),i+=e.length}return r};let mn=!0;try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(as){mn=!1}const bn=new Uint8Array(256);for(let ss=0;ss<256;ss++)bn[ss]=ss>=252?6:ss>=248?5:ss>=240?4:ss>=224?3:ss>=192?2:1;bn[254]=bn[254]=1;var vn=t=>{if("function"==typeof TextEncoder&&TextEncoder.prototype.encode)return(new TextEncoder).encode(t);let e,r,n,i,a,s=t.length,o=0;for(i=0;i<s;i++)r=t.charCodeAt(i),55296==(64512&r)&&i+1<s&&(n=t.charCodeAt(i+1),56320==(64512&n)&&(r=65536+(r-55296<<10)+(n-56320),i++)),o+=r<128?1:r<2048?2:r<65536?3:4;for(e=new Uint8Array(o),a=0,i=0;a<o;i++)r=t.charCodeAt(i),55296==(64512&r)&&i+1<s&&(n=t.charCodeAt(i+1),56320==(64512&n)&&(r=65536+(r-55296<<10)+(n-56320),i++)),r<128?e[a++]=r:r<2048?(e[a++]=192|r>>>6,e[a++]=128|63&r):r<65536?(e[a++]=224|r>>>12,e[a++]=128|r>>>6&63,e[a++]=128|63&r):(e[a++]=240|r>>>18,e[a++]=128|r>>>12&63,e[a++]=128|r>>>6&63,e[a++]=128|63&r);return e},wn=(t,e)=>{const r=e||t.length;if("function"==typeof TextDecoder&&TextDecoder.prototype.decode)return(new TextDecoder).decode(t.subarray(0,e));let n,i;const a=new Array(2*r);for(i=0,n=0;n<r;){let e=t[n++];if(e<128){a[i++]=e;continue}let s=bn[e];if(s>4)a[i++]=65533,n+=s-1;else{for(e&=2===s?31:3===s?15:7;s>1&&n<r;)e=e<<6|63&t[n++],s--;s>1?a[i++]=65533:e<65536?a[i++]=e:(e-=65536,a[i++]=55296|e>>10&1023,a[i++]=56320|1023&e)}}return((t,e)=>{if(e<65534&&t.subarray&&mn)return String.fromCharCode.apply(null,t.length===e?t:t.subarray(0,e));let r="";for(let n=0;n<e;n++)r+=String.fromCharCode(t[n]);return r})(a,i)},yn=(t,e)=>{(e=e||t.length)>t.length&&(e=t.length);let r=e-1;for(;r>=0&&128==(192&t[r]);)r--;return r<0||0===r?e:r+bn[t[r]]>e?r:e},_n=function(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0};const xn=Object.prototype.toString,{Z_NO_FLUSH:An,Z_SYNC_FLUSH:Ln,Z_FULL_FLUSH:Nn,Z_FINISH:Sn,Z_OK:kn,Z_STREAM_END:Pn,Z_DEFAULT_COMPRESSION:Fn,Z_DEFAULT_STRATEGY:In,Z_DEFLATED:Cn}=ur;function jn(t){this.options=pn({level:Fn,method:Cn,chunkSize:16384,windowBits:15,memLevel:8,strategy:In},t||{});let e=this.options;e.raw&&e.windowBits>0?e.windowBits=-e.windowBits:e.gzip&&e.windowBits>0&&e.windowBits<16&&(e.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new _n,this.strm.avail_out=0;let r=hn(this.strm,e.level,e.method,e.windowBits,e.memLevel,e.strategy);if(r!==kn)throw new Error(lr[r]);if(e.header&&ln(this.strm,e.header),e.dictionary){let t;if(t="string"==typeof e.dictionary?vn(e.dictionary):"[object ArrayBuffer]"===xn.call(e.dictionary)?new Uint8Array(e.dictionary):e.dictionary,r=fn(this.strm,t),r!==kn)throw new Error(lr[r]);this._dict_set=!0}}jn.prototype.push=function(t,e){const r=this.strm,n=this.options.chunkSize;let i,a;if(this.ended)return!1;for(a=e===~~e?e:!0===e?Sn:An,"string"==typeof t?r.input=vn(t):"[object ArrayBuffer]"===xn.call(t)?r.input=new Uint8Array(t):r.input=t,r.next_in=0,r.avail_in=r.input.length;;)if(0===r.avail_out&&(r.output=new Uint8Array(n),r.next_out=0,r.avail_out=n),(a===Ln||a===Nn)&&r.avail_out<=6)this.onData(r.output.subarray(0,r.next_out)),r.avail_out=0;else{if(i=un(r,a),i===Pn)return r.next_out>0&&this.onData(r.output.subarray(0,r.next_out)),i=cn(this.strm),this.onEnd(i),this.ended=!0,i===kn;if(0!==r.avail_out){if(a>0&&r.next_out>0)this.onData(r.output.subarray(0,r.next_out)),r.avail_out=0;else if(0===r.avail_in)break}else this.onData(r.output)}return!0},jn.prototype.onData=function(t){this.chunks.push(t)},jn.prototype.onEnd=function(t){t===kn&&(this.result=gn(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};const En=16209;var On=function(t,e){let r,n,i,a,s,o,h,l,u,c,f,d,p,g,m,b,v,w,y,_,x,A,L,N;const S=t.state;r=t.next_in,L=t.input,n=r+(t.avail_in-5),i=t.next_out,N=t.output,a=i-(e-t.avail_out),s=i+(t.avail_out-257),o=S.dmax,h=S.wsize,l=S.whave,u=S.wnext,c=S.window,f=S.hold,d=S.bits,p=S.lencode,g=S.distcode,m=(1<<S.lenbits)-1,b=(1<<S.distbits)-1;t:do{d<15&&(f+=L[r++]<<d,d+=8,f+=L[r++]<<d,d+=8),v=p[f&m];e:for(;;){if(w=v>>>24,f>>>=w,d-=w,w=v>>>16&255,0===w)N[i++]=65535&v;else{if(!(16&w)){if(64&w){if(32&w){S.mode=16191;break t}t.msg="invalid literal/length code",S.mode=En;break t}v=p[(65535&v)+(f&(1<<w)-1)];continue e}for(y=65535&v,w&=15,w&&(d<w&&(f+=L[r++]<<d,d+=8),y+=f&(1<<w)-1,f>>>=w,d-=w),d<15&&(f+=L[r++]<<d,d+=8,f+=L[r++]<<d,d+=8),v=g[f&b];;){if(w=v>>>24,f>>>=w,d-=w,w=v>>>16&255,16&w){if(_=65535&v,w&=15,d<w&&(f+=L[r++]<<d,d+=8,d<w&&(f+=L[r++]<<d,d+=8)),_+=f&(1<<w)-1,_>o){t.msg="invalid distance too far back",S.mode=En;break t}if(f>>>=w,d-=w,w=i-a,_>w){if(w=_-w,w>l&&S.sane){t.msg="invalid distance too far back",S.mode=En;break t}if(x=0,A=c,0===u){if(x+=h-w,w<y){y-=w;do{N[i++]=c[x++]}while(--w);x=i-_,A=N}}else if(u<w){if(x+=h+u-w,w-=u,w<y){y-=w;do{N[i++]=c[x++]}while(--w);if(x=0,u<y){w=u,y-=w;do{N[i++]=c[x++]}while(--w);x=i-_,A=N}}}else if(x+=u-w,w<y){y-=w;do{N[i++]=c[x++]}while(--w);x=i-_,A=N}for(;y>2;)N[i++]=A[x++],N[i++]=A[x++],N[i++]=A[x++],y-=3;y&&(N[i++]=A[x++],y>1&&(N[i++]=A[x++]))}else{x=i-_;do{N[i++]=N[x++],N[i++]=N[x++],N[i++]=N[x++],y-=3}while(y>2);y&&(N[i++]=N[x++],y>1&&(N[i++]=N[x++]))}break}if(64&w){t.msg="invalid distance code",S.mode=En;break t}v=g[(65535&v)+(f&(1<<w)-1)]}}break}}while(r<n&&i<s);y=d>>3,r-=y,d-=y<<3,f&=(1<<d)-1,t.next_in=r,t.next_out=i,t.avail_in=r<n?n-r+5:5-(r-n),t.avail_out=i<s?s-i+257:257-(i-s),S.hold=f,S.bits=d};const Bn=new Uint16Array([3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0]),Mn=new Uint8Array([16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78]),Rn=new Uint16Array([1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0]),Tn=new Uint8Array([16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64]);var qn=(t,e,r,n,i,a,s,o)=>{const h=o.bits;let l,u,c,f,d,p,g=0,m=0,b=0,v=0,w=0,y=0,_=0,x=0,A=0,L=0,N=null;const S=new Uint16Array(16),k=new Uint16Array(16);let P,F,I,C=null;for(g=0;g<=15;g++)S[g]=0;for(m=0;m<n;m++)S[e[r+m]]++;for(w=h,v=15;v>=1&&0===S[v];v--);if(w>v&&(w=v),0===v)return i[a++]=20971520,i[a++]=20971520,o.bits=1,0;for(b=1;b<v&&0===S[b];b++);for(w<b&&(w=b),x=1,g=1;g<=15;g++)if(x<<=1,x-=S[g],x<0)return-1;if(x>0&&(0===t||1!==v))return-1;for(k[1]=0,g=1;g<15;g++)k[g+1]=k[g]+S[g];for(m=0;m<n;m++)0!==e[r+m]&&(s[k[e[r+m]]++]=m);if(0===t?(N=C=s,p=20):1===t?(N=Bn,C=Mn,p=257):(N=Rn,C=Tn,p=0),L=0,m=0,g=b,d=a,y=w,_=0,c=-1,A=1<<w,f=A-1,1===t&&A>852||2===t&&A>592)return 1;for(;;){P=g-_,s[m]+1<p?(F=0,I=s[m]):s[m]>=p?(F=C[s[m]-p],I=N[s[m]-p]):(F=96,I=0),l=1<<g-_,u=1<<y,b=u;do{u-=l,i[d+(L>>_)+u]=P<<24|F<<16|I}while(0!==u);for(l=1<<g-1;L&l;)l>>=1;if(0!==l?(L&=l-1,L+=l):L=0,m++,0===--S[g]){if(g===v)break;g=e[r+s[m]]}if(g>w&&(L&f)!==c){for(0===_&&(_=w),d+=b,y=g-_,x=1<<y;y+_<v&&(x-=S[y+_],!(x<=0));)y++,x<<=1;if(A+=1<<y,1===t&&A>852||2===t&&A>592)return 1;c=L&f,i[c]=w<<24|y<<16|d-a}}return 0!==L&&(i[d+L]=g-_<<24|64<<16),o.bits=w,0};const{Z_FINISH:Dn,Z_BLOCK:zn,Z_TREES:Un,Z_OK:Hn,Z_STREAM_END:Wn,Z_NEED_DICT:Vn,Z_STREAM_ERROR:Gn,Z_DATA_ERROR:Yn,Z_MEM_ERROR:Zn,Z_BUF_ERROR:Jn,Z_DEFLATED:Xn}=ur,Kn=16180,$n=16190,Qn=16191,ti=16192,ei=16194,ri=16199,ni=16200,ii=16206,ai=16209,si=t=>(t>>>24&255)+(t>>>8&65280)+((65280&t)<<8)+((255&t)<<24);function oi(){this.strm=null,this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new Uint16Array(320),this.work=new Uint16Array(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}const hi=t=>{if(!t)return 1;const e=t.state;return!e||e.strm!==t||e.mode<Kn||e.mode>16211?1:0},li=t=>{if(hi(t))return Gn;const e=t.state;return t.total_in=t.total_out=e.total=0,t.msg="",e.wrap&&(t.adler=1&e.wrap),e.mode=Kn,e.last=0,e.havedict=0,e.flags=-1,e.dmax=32768,e.head=null,e.hold=0,e.bits=0,e.lencode=e.lendyn=new Int32Array(852),e.distcode=e.distdyn=new Int32Array(592),e.sane=1,e.back=-1,Hn},ui=t=>{if(hi(t))return Gn;const e=t.state;return e.wsize=0,e.whave=0,e.wnext=0,li(t)},ci=(t,e)=>{let r;if(hi(t))return Gn;const n=t.state;return e<0?(r=0,e=-e):(r=5+(e>>4),e<48&&(e&=15)),e&&(e<8||e>15)?Gn:(null!==n.window&&n.wbits!==e&&(n.window=null),n.wrap=r,n.wbits=e,ui(t))},fi=(t,e)=>{if(!t)return Gn;const r=new oi;t.state=r,r.strm=t,r.window=null,r.mode=Kn;const n=ci(t,e);return n!==Hn&&(t.state=null),n};let di,pi,gi=!0;const mi=t=>{if(gi){di=new Int32Array(512),pi=new Int32Array(32);let e=0;for(;e<144;)t.lens[e++]=8;for(;e<256;)t.lens[e++]=9;for(;e<280;)t.lens[e++]=7;for(;e<288;)t.lens[e++]=8;for(qn(1,t.lens,0,288,di,0,t.work,{bits:9}),e=0;e<32;)t.lens[e++]=5;qn(2,t.lens,0,32,pi,0,t.work,{bits:5}),gi=!1}t.lencode=di,t.lenbits=9,t.distcode=pi,t.distbits=5},bi=(t,e,r,n)=>{let i;const a=t.state;return null===a.window&&(a.wsize=1<<a.wbits,a.wnext=0,a.whave=0,a.window=new Uint8Array(a.wsize)),n>=a.wsize?(a.window.set(e.subarray(r-a.wsize,r),0),a.wnext=0,a.whave=a.wsize):(i=a.wsize-a.wnext,i>n&&(i=n),a.window.set(e.subarray(r-n,r-n+i),a.wnext),(n-=i)?(a.window.set(e.subarray(r-n,r),0),a.wnext=n,a.whave=a.wsize):(a.wnext+=i,a.wnext===a.wsize&&(a.wnext=0),a.whave<a.wsize&&(a.whave+=i))),0};var vi=ui,wi=fi,yi=(t,e)=>{let r,n,i,a,s,o,h,l,u,c,f,d,p,g,m,b,v,w,y,_,x,A,L=0;const N=new Uint8Array(4);let S,k;const P=new Uint8Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]);if(hi(t)||!t.output||!t.input&&0!==t.avail_in)return Gn;r=t.state,r.mode===Qn&&(r.mode=ti),s=t.next_out,i=t.output,h=t.avail_out,a=t.next_in,n=t.input,o=t.avail_in,l=r.hold,u=r.bits,c=o,f=h,A=Hn;t:for(;;)switch(r.mode){case Kn:if(0===r.wrap){r.mode=ti;break}for(;u<16;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(2&r.wrap&&35615===l){0===r.wbits&&(r.wbits=15),r.check=0,N[0]=255&l,N[1]=l>>>8&255,r.check=hr(r.check,N,2,0),l=0,u=0,r.mode=16181;break}if(r.head&&(r.head.done=!1),!(1&r.wrap)||(((255&l)<<8)+(l>>8))%31){t.msg="incorrect header check",r.mode=ai;break}if((15&l)!==Xn){t.msg="unknown compression method",r.mode=ai;break}if(l>>>=4,u-=4,x=8+(15&l),0===r.wbits&&(r.wbits=x),x>15||x>r.wbits){t.msg="invalid window size",r.mode=ai;break}r.dmax=1<<r.wbits,r.flags=0,t.adler=r.check=1,r.mode=512&l?16189:Qn,l=0,u=0;break;case 16181:for(;u<16;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(r.flags=l,(255&r.flags)!==Xn){t.msg="unknown compression method",r.mode=ai;break}if(57344&r.flags){t.msg="unknown header flags set",r.mode=ai;break}r.head&&(r.head.text=l>>8&1),512&r.flags&&4&r.wrap&&(N[0]=255&l,N[1]=l>>>8&255,r.check=hr(r.check,N,2,0)),l=0,u=0,r.mode=16182;case 16182:for(;u<32;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.head&&(r.head.time=l),512&r.flags&&4&r.wrap&&(N[0]=255&l,N[1]=l>>>8&255,N[2]=l>>>16&255,N[3]=l>>>24&255,r.check=hr(r.check,N,4,0)),l=0,u=0,r.mode=16183;case 16183:for(;u<16;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.head&&(r.head.xflags=255&l,r.head.os=l>>8),512&r.flags&&4&r.wrap&&(N[0]=255&l,N[1]=l>>>8&255,r.check=hr(r.check,N,2,0)),l=0,u=0,r.mode=16184;case 16184:if(1024&r.flags){for(;u<16;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.length=l,r.head&&(r.head.extra_len=l),512&r.flags&&4&r.wrap&&(N[0]=255&l,N[1]=l>>>8&255,r.check=hr(r.check,N,2,0)),l=0,u=0}else r.head&&(r.head.extra=null);r.mode=16185;case 16185:if(1024&r.flags&&(d=r.length,d>o&&(d=o),d&&(r.head&&(x=r.head.extra_len-r.length,r.head.extra||(r.head.extra=new Uint8Array(r.head.extra_len)),r.head.extra.set(n.subarray(a,a+d),x)),512&r.flags&&4&r.wrap&&(r.check=hr(r.check,n,d,a)),o-=d,a+=d,r.length-=d),r.length))break t;r.length=0,r.mode=16186;case 16186:if(2048&r.flags){if(0===o)break t;d=0;do{x=n[a+d++],r.head&&x&&r.length<65536&&(r.head.name+=String.fromCharCode(x))}while(x&&d<o);if(512&r.flags&&4&r.wrap&&(r.check=hr(r.check,n,d,a)),o-=d,a+=d,x)break t}else r.head&&(r.head.name=null);r.length=0,r.mode=16187;case 16187:if(4096&r.flags){if(0===o)break t;d=0;do{x=n[a+d++],r.head&&x&&r.length<65536&&(r.head.comment+=String.fromCharCode(x))}while(x&&d<o);if(512&r.flags&&4&r.wrap&&(r.check=hr(r.check,n,d,a)),o-=d,a+=d,x)break t}else r.head&&(r.head.comment=null);r.mode=16188;case 16188:if(512&r.flags){for(;u<16;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(4&r.wrap&&l!==(65535&r.check)){t.msg="header crc mismatch",r.mode=ai;break}l=0,u=0}r.head&&(r.head.hcrc=r.flags>>9&1,r.head.done=!0),t.adler=r.check=0,r.mode=Qn;break;case 16189:for(;u<32;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}t.adler=r.check=si(l),l=0,u=0,r.mode=$n;case $n:if(0===r.havedict)return t.next_out=s,t.avail_out=h,t.next_in=a,t.avail_in=o,r.hold=l,r.bits=u,Vn;t.adler=r.check=1,r.mode=Qn;case Qn:if(e===zn||e===Un)break t;case ti:if(r.last){l>>>=7&u,u-=7&u,r.mode=ii;break}for(;u<3;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}switch(r.last=1&l,l>>>=1,u-=1,3&l){case 0:r.mode=16193;break;case 1:if(mi(r),r.mode=ri,e===Un){l>>>=2,u-=2;break t}break;case 2:r.mode=16196;break;case 3:t.msg="invalid block type",r.mode=ai}l>>>=2,u-=2;break;case 16193:for(l>>>=7&u,u-=7&u;u<32;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if((65535&l)!=(l>>>16^65535)){t.msg="invalid stored block lengths",r.mode=ai;break}if(r.length=65535&l,l=0,u=0,r.mode=ei,e===Un)break t;case ei:r.mode=16195;case 16195:if(d=r.length,d){if(d>o&&(d=o),d>h&&(d=h),0===d)break t;i.set(n.subarray(a,a+d),s),o-=d,a+=d,h-=d,s+=d,r.length-=d;break}r.mode=Qn;break;case 16196:for(;u<14;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(r.nlen=257+(31&l),l>>>=5,u-=5,r.ndist=1+(31&l),l>>>=5,u-=5,r.ncode=4+(15&l),l>>>=4,u-=4,r.nlen>286||r.ndist>30){t.msg="too many length or distance symbols",r.mode=ai;break}r.have=0,r.mode=16197;case 16197:for(;r.have<r.ncode;){for(;u<3;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.lens[P[r.have++]]=7&l,l>>>=3,u-=3}for(;r.have<19;)r.lens[P[r.have++]]=0;if(r.lencode=r.lendyn,r.lenbits=7,S={bits:r.lenbits},A=qn(0,r.lens,0,19,r.lencode,0,r.work,S),r.lenbits=S.bits,A){t.msg="invalid code lengths set",r.mode=ai;break}r.have=0,r.mode=16198;case 16198:for(;r.have<r.nlen+r.ndist;){for(;L=r.lencode[l&(1<<r.lenbits)-1],m=L>>>24,b=L>>>16&255,v=65535&L,!(m<=u);){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(v<16)l>>>=m,u-=m,r.lens[r.have++]=v;else{if(16===v){for(k=m+2;u<k;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(l>>>=m,u-=m,0===r.have){t.msg="invalid bit length repeat",r.mode=ai;break}x=r.lens[r.have-1],d=3+(3&l),l>>>=2,u-=2}else if(17===v){for(k=m+3;u<k;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}l>>>=m,u-=m,x=0,d=3+(7&l),l>>>=3,u-=3}else{for(k=m+7;u<k;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}l>>>=m,u-=m,x=0,d=11+(127&l),l>>>=7,u-=7}if(r.have+d>r.nlen+r.ndist){t.msg="invalid bit length repeat",r.mode=ai;break}for(;d--;)r.lens[r.have++]=x}}if(r.mode===ai)break;if(0===r.lens[256]){t.msg="invalid code -- missing end-of-block",r.mode=ai;break}if(r.lenbits=9,S={bits:r.lenbits},A=qn(1,r.lens,0,r.nlen,r.lencode,0,r.work,S),r.lenbits=S.bits,A){t.msg="invalid literal/lengths set",r.mode=ai;break}if(r.distbits=6,r.distcode=r.distdyn,S={bits:r.distbits},A=qn(2,r.lens,r.nlen,r.ndist,r.distcode,0,r.work,S),r.distbits=S.bits,A){t.msg="invalid distances set",r.mode=ai;break}if(r.mode=ri,e===Un)break t;case ri:r.mode=ni;case ni:if(o>=6&&h>=258){t.next_out=s,t.avail_out=h,t.next_in=a,t.avail_in=o,r.hold=l,r.bits=u,On(t,f),s=t.next_out,i=t.output,h=t.avail_out,a=t.next_in,n=t.input,o=t.avail_in,l=r.hold,u=r.bits,r.mode===Qn&&(r.back=-1);break}for(r.back=0;L=r.lencode[l&(1<<r.lenbits)-1],m=L>>>24,b=L>>>16&255,v=65535&L,!(m<=u);){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(b&&!(240&b)){for(w=m,y=b,_=v;L=r.lencode[_+((l&(1<<w+y)-1)>>w)],m=L>>>24,b=L>>>16&255,v=65535&L,!(w+m<=u);){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}l>>>=w,u-=w,r.back+=w}if(l>>>=m,u-=m,r.back+=m,r.length=v,0===b){r.mode=16205;break}if(32&b){r.back=-1,r.mode=Qn;break}if(64&b){t.msg="invalid literal/length code",r.mode=ai;break}r.extra=15&b,r.mode=16201;case 16201:if(r.extra){for(k=r.extra;u<k;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.length+=l&(1<<r.extra)-1,l>>>=r.extra,u-=r.extra,r.back+=r.extra}r.was=r.length,r.mode=16202;case 16202:for(;L=r.distcode[l&(1<<r.distbits)-1],m=L>>>24,b=L>>>16&255,v=65535&L,!(m<=u);){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(!(240&b)){for(w=m,y=b,_=v;L=r.distcode[_+((l&(1<<w+y)-1)>>w)],m=L>>>24,b=L>>>16&255,v=65535&L,!(w+m<=u);){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}l>>>=w,u-=w,r.back+=w}if(l>>>=m,u-=m,r.back+=m,64&b){t.msg="invalid distance code",r.mode=ai;break}r.offset=v,r.extra=15&b,r.mode=16203;case 16203:if(r.extra){for(k=r.extra;u<k;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}r.offset+=l&(1<<r.extra)-1,l>>>=r.extra,u-=r.extra,r.back+=r.extra}if(r.offset>r.dmax){t.msg="invalid distance too far back",r.mode=ai;break}r.mode=16204;case 16204:if(0===h)break t;if(d=f-h,r.offset>d){if(d=r.offset-d,d>r.whave&&r.sane){t.msg="invalid distance too far back",r.mode=ai;break}d>r.wnext?(d-=r.wnext,p=r.wsize-d):p=r.wnext-d,d>r.length&&(d=r.length),g=r.window}else g=i,p=s-r.offset,d=r.length;d>h&&(d=h),h-=d,r.length-=d;do{i[s++]=g[p++]}while(--d);0===r.length&&(r.mode=ni);break;case 16205:if(0===h)break t;i[s++]=r.length,h--,r.mode=ni;break;case ii:if(r.wrap){for(;u<32;){if(0===o)break t;o--,l|=n[a++]<<u,u+=8}if(f-=h,t.total_out+=f,r.total+=f,4&r.wrap&&f&&(t.adler=r.check=r.flags?hr(r.check,i,f,s-f):sr(r.check,i,f,s-f)),f=h,4&r.wrap&&(r.flags?l:si(l))!==r.check){t.msg="incorrect data check",r.mode=ai;break}l=0,u=0}r.mode=16207;case 16207:if(r.wrap&&r.flags){for(;u<32;){if(0===o)break t;o--,l+=n[a++]<<u,u+=8}if(4&r.wrap&&l!==(4294967295&r.total)){t.msg="incorrect length check",r.mode=ai;break}l=0,u=0}r.mode=16208;case 16208:A=Wn;break t;case ai:A=Yn;break t;case 16210:return Zn;default:return Gn}return t.next_out=s,t.avail_out=h,t.next_in=a,t.avail_in=o,r.hold=l,r.bits=u,(r.wsize||f!==t.avail_out&&r.mode<ai&&(r.mode<ii||e!==Dn))&&bi(t,t.output,t.next_out,f-t.avail_out),c-=t.avail_in,f-=t.avail_out,t.total_in+=c,t.total_out+=f,r.total+=f,4&r.wrap&&f&&(t.adler=r.check=r.flags?hr(r.check,i,f,t.next_out-f):sr(r.check,i,f,t.next_out-f)),t.data_type=r.bits+(r.last?64:0)+(r.mode===Qn?128:0)+(r.mode===ri||r.mode===ei?256:0),(0===c&&0===f||e===Dn)&&A===Hn&&(A=Jn),A},_i=t=>{if(hi(t))return Gn;let e=t.state;return e.window&&(e.window=null),t.state=null,Hn},xi=(t,e)=>{if(hi(t))return Gn;const r=t.state;return 2&r.wrap?(r.head=e,e.done=!1,Hn):Gn},Ai=(t,e)=>{const r=e.length;let n,i,a;return hi(t)?Gn:(n=t.state,0!==n.wrap&&n.mode!==$n?Gn:n.mode===$n&&(i=1,i=sr(i,e,r,0),i!==n.check)?Yn:(a=bi(t,e,r,r),a?(n.mode=16210,Zn):(n.havedict=1,Hn)))},Li=function(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1};const Ni=Object.prototype.toString,{Z_NO_FLUSH:Si,Z_FINISH:ki,Z_OK:Pi,Z_STREAM_END:Fi,Z_NEED_DICT:Ii,Z_STREAM_ERROR:Ci,Z_DATA_ERROR:ji,Z_MEM_ERROR:Ei}=ur;function Oi(t){this.options=pn({chunkSize:65536,windowBits:15,to:""},t||{});const e=this.options;e.raw&&e.windowBits>=0&&e.windowBits<16&&(e.windowBits=-e.windowBits,0===e.windowBits&&(e.windowBits=-15)),!(e.windowBits>=0&&e.windowBits<16)||t&&t.windowBits||(e.windowBits+=32),e.windowBits>15&&e.windowBits<48&&(15&e.windowBits||(e.windowBits|=15)),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new _n,this.strm.avail_out=0;let r=wi(this.strm,e.windowBits);if(r!==Pi)throw new Error(lr[r]);if(this.header=new Li,xi(this.strm,this.header),e.dictionary&&("string"==typeof e.dictionary?e.dictionary=vn(e.dictionary):"[object ArrayBuffer]"===Ni.call(e.dictionary)&&(e.dictionary=new Uint8Array(e.dictionary)),e.raw&&(r=Ai(this.strm,e.dictionary),r!==Pi)))throw new Error(lr[r])}function Bi(t,e){const r=new Oi(e);if(r.push(t),r.err)throw r.msg||lr[r.err];return r.result}Oi.prototype.push=function(t,e){const r=this.strm,n=this.options.chunkSize,i=this.options.dictionary;let a,s,o;if(this.ended)return!1;for(s=e===~~e?e:!0===e?ki:Si,"[object ArrayBuffer]"===Ni.call(t)?r.input=new Uint8Array(t):r.input=t,r.next_in=0,r.avail_in=r.input.length;;){for(0===r.avail_out&&(r.output=new Uint8Array(n),r.next_out=0,r.avail_out=n),a=yi(r,s),a===Ii&&i&&(a=Ai(r,i),a===Pi?a=yi(r,s):a===ji&&(a=Ii));r.avail_in>0&&a===Fi&&r.state.wrap>0&&0!==t[r.next_in];)vi(r),a=yi(r,s);switch(a){case Ci:case ji:case Ii:case Ei:return this.onEnd(a),this.ended=!0,!1}if(o=r.avail_out,r.next_out&&(0===r.avail_out||a===Fi))if("string"===this.options.to){let t=yn(r.output,r.next_out),e=r.next_out-t,i=wn(r.output,t);r.next_out=e,r.avail_out=n-e,e&&r.output.set(r.output.subarray(t,t+e),0),this.onData(i)}else this.onData(r.output.length===r.next_out?r.output:r.output.subarray(0,r.next_out));if(a!==Pi||0!==o){if(a===Fi)return a=_i(this.strm),this.onEnd(a),this.ended=!0,!0;if(0===r.avail_in)break}}return!0},Oi.prototype.onData=function(t){this.chunks.push(t)},Oi.prototype.onEnd=function(t){t===Pi&&("string"===this.options.to?this.result=this.chunks.join(""):this.result=gn(this.chunks)),this.chunks=[],this.err=t,this.msg=this.strm.msg};var Mi={Inflate:Oi,inflate:Bi,inflateRaw:function(t,e){return(e=e||{}).raw=!0,Bi(t,e)},ungzip:Bi,constants:ur};const{Inflate:Ri,inflate:Ti,inflateRaw:qi,ungzip:Di}=Mi;var zi=Ri,Ui=Ti;const Hi=[];for(let ss=0;ss<256;ss++){let t=ss;for(let e=0;e<8;e++)1&t?t=3988292384^t>>>1:t>>>=1;Hi[ss]=t}const Wi=4294967295;function Vi(t,e,r){const n=t.readUint32(),i=(a=new Uint8Array(t.buffer,t.byteOffset+t.offset-e-4,e),(function(t,e,r){let n=t;for(let i=0;i<r;i++)n=Hi[255&(n^e[i])]^n>>>8;return n}(Wi,a,e)^Wi)>>>0);var a;if(i!==n)throw new Error(`CRC mismatch for chunk ${r}. Expected ${n}, found ${i}`)}function Gi(t,e,r){for(let n=0;n<r;n++)e[n]=t[n]}function Yi(t,e,r,n){let i=0;for(;i<n;i++)e[i]=t[i];for(;i<r;i++)e[i]=t[i]+e[i-n]&255}function Zi(t,e,r,n){let i=0;if(0===r.length)for(;i<n;i++)e[i]=t[i];else for(;i<n;i++)e[i]=t[i]+r[i]&255}function Ji(t,e,r,n,i){let a=0;if(0===r.length){for(;a<i;a++)e[a]=t[a];for(;a<n;a++)e[a]=t[a]+(e[a-i]>>1)&255}else{for(;a<i;a++)e[a]=t[a]+(r[a]>>1)&255;for(;a<n;a++)e[a]=t[a]+(e[a-i]+r[a]>>1)&255}}function Xi(t,e,r,n,i){let a=0;if(0===r.length){for(;a<i;a++)e[a]=t[a];for(;a<n;a++)e[a]=t[a]+e[a-i]&255}else{for(;a<i;a++)e[a]=t[a]+r[a]&255;for(;a<n;a++)e[a]=t[a]+Ki(e[a-i],r[a],r[a-i])&255}}function Ki(t,e,r){const n=t+e-r,i=Math.abs(n-t),a=Math.abs(n-e),s=Math.abs(n-r);return i<=a&&i<=s?t:a<=s?e:r}function $i(t,e,r,n,i,a){switch(t){case 0:Gi(e,r,i);break;case 1:Yi(e,r,i,a);break;case 2:Zi(e,r,n,i);break;case 3:Ji(e,r,n,i,a);break;case 4:Xi(e,r,n,i,a);break;default:throw new Error(`Unsupported filter: ${t}`)}}const Qi=new Uint16Array([255]),ta=255===new Uint8Array(Qi.buffer)[0];function ea(t){return(255&t)<<8|t>>8&255}const ra=new Uint16Array([255]),na=255===new Uint8Array(ra.buffer)[0],ia=new Uint8Array(0);function aa(t){const{data:e,width:r,height:n,channels:i,depth:a}=t,s=Math.ceil(a/8)*i,o=Math.ceil(a/8*i*r),h=new Uint8Array(n*o);let l,u,c=ia,f=0;for(let d=0;d<n;d++){switch(l=e.subarray(f+1,f+1+o),u=h.subarray(d*o,(d+1)*o),e[f]){case 0:Gi(l,u,o);break;case 1:Yi(l,u,o,s);break;case 2:Zi(l,u,c,o);break;case 3:Ji(l,u,c,o,s);break;case 4:Xi(l,u,c,o,s);break;default:throw new Error(`Unsupported filter: ${e[f]}`)}c=u,f+=o+1}if(16===a){const t=new Uint16Array(h.buffer);if(na)for(let e=0;e<t.length;e++)t[e]=sa(t[e]);return t}return h}function sa(t){return(255&t)<<8|t>>8&255}const oa=Uint8Array.of(137,80,78,71,13,10,26,10);function ha(t){if(!function(t){if(t.length<oa.length)return!1;for(let e=0;e<oa.length;e++)if(t[e]!==oa[e])return!1;return!0}(t.readBytes(oa.length)))throw new Error("wrong PNG signature")}const la=new TextDecoder("latin1");const ua=/^[\u0000-\u00FF]*$/;function ca(t){for(t.mark();0!==t.readByte(););const e=t.offset;t.reset();const r=la.decode(t.readBytes(e-t.offset-1));return t.skip(1),function(t){if(function(t){if(!ua.test(t))throw new Error("invalid latin1 text")}(t),0===t.length||t.length>79)throw new Error("keyword length must be between 1 and 79")}(r),r}class fa extends Se{_checkCrc;_inflator;_png;_apng;_end;_hasPalette;_palette;_hasTransparency;_transparency;_compressionMethod;_filterMethod;_interlaceMethod;_colorType;_isAnimated;_numberOfFrames;_numberOfPlays;_frames;_writingDataChunks;constructor(t,e={}){super(t);const{checkCrc:r=!1}=e;this._checkCrc=r,this._inflator=new zi,this._png={width:-1,height:-1,channels:-1,data:new Uint8Array(0),depth:1,text:{}},this._apng={width:-1,height:-1,channels:-1,depth:1,numberOfFrames:1,numberOfPlays:0,text:{},frames:[]},this._end=!1,this._hasPalette=!1,this._palette=[],this._hasTransparency=!1,this._transparency=new Uint16Array(0),this._compressionMethod=-1,this._filterMethod=-1,this._interlaceMethod=-1,this._colorType=-1,this._isAnimated=!1,this._numberOfFrames=1,this._numberOfPlays=0,this._frames=[],this._writingDataChunks=!1,this.setBigEndian()}decode(){for(ha(this);!this._end;){const t=this.readUint32(),e=this.readChars(4);this.decodeChunk(t,e)}return this.decodeImage(),this._png}decodeApng(){for(ha(this);!this._end;){const t=this.readUint32(),e=this.readChars(4);this.decodeApngChunk(t,e)}return this.decodeApngImage(),this._apng}decodeChunk(t,e){const r=this.offset;switch(e){case"IHDR":this.decodeIHDR();break;case"PLTE":this.decodePLTE(t);break;case"IDAT":this.decodeIDAT(t);break;case"IEND":this._end=!0;break;case"tRNS":this.decodetRNS(t);break;case"iCCP":this.decodeiCCP(t);break;case"tEXt":!function(t,e,r){const n=ca(e);t[n]=function(t,e){return la.decode(t.readBytes(e))}(e,r-n.length-1)}(this._png.text,this,t);break;case"pHYs":this.decodepHYs();break;default:this.skip(t)}if(this.offset-r!==t)throw new Error(`Length mismatch while decoding chunk ${e}`);this._checkCrc?Vi(this,t+4,e):this.skip(4)}decodeApngChunk(t,e){const r=this.offset;switch("fdAT"!==e&&"IDAT"!==e&&this._writingDataChunks&&this.pushDataToFrame(),e){case"acTL":this.decodeACTL();break;case"fcTL":this.decodeFCTL();break;case"fdAT":this.decodeFDAT(t);break;default:this.decodeChunk(t,e),this.offset=r+t}if(this.offset-r!==t)throw new Error(`Length mismatch while decoding chunk ${e}`);this._checkCrc?Vi(this,t+4,e):this.skip(4)}decodeIHDR(){const t=this._png;t.width=this.readUint32(),t.height=this.readUint32(),t.depth=function(t){if(1!==t&&2!==t&&4!==t&&8!==t&&16!==t)throw new Error(`invalid bit depth: ${t}`);return t}(this.readUint8());const e=this.readUint8();let r;switch(this._colorType=e,e){case 0:case 3:r=1;break;case 2:r=3;break;case 4:r=2;break;case 6:r=4;break;default:throw new Error(`Unknown color type: ${e}`)}if(this._png.channels=r,this._compressionMethod=this.readUint8(),0!==this._compressionMethod)throw new Error(`Unsupported compression method: ${this._compressionMethod}`);this._filterMethod=this.readUint8(),this._interlaceMethod=this.readUint8()}decodeACTL(){this._numberOfFrames=this.readUint32(),this._numberOfPlays=this.readUint32(),this._isAnimated=!0}decodeFCTL(){const t={sequenceNumber:this.readUint32(),width:this.readUint32(),height:this.readUint32(),xOffset:this.readUint32(),yOffset:this.readUint32(),delayNumber:this.readUint16(),delayDenominator:this.readUint16(),disposeOp:this.readUint8(),blendOp:this.readUint8(),data:new Uint8Array(0)};this._frames.push(t)}decodePLTE(t){if(t%3!=0)throw new RangeError(`PLTE field length must be a multiple of 3. Got ${t}`);const e=t/3;this._hasPalette=!0;const r=[];this._palette=r;for(let n=0;n<e;n++)r.push([this.readUint8(),this.readUint8(),this.readUint8()])}decodeIDAT(t){this._writingDataChunks=!0;const e=t,r=this.offset+this.byteOffset;if(this._inflator.push(new Uint8Array(this.buffer,r,e)),this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);this.skip(t)}decodeFDAT(t){this._writingDataChunks=!0;let e=t,r=this.offset+this.byteOffset;if(r+=4,e-=4,this._inflator.push(new Uint8Array(this.buffer,r,e)),this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);this.skip(t)}decodetRNS(t){switch(this._colorType){case 0:case 2:if(t%2!=0)throw new RangeError(`tRNS chunk length must be a multiple of 2. Got ${t}`);if(t/2>this._png.width*this._png.height)throw new Error(`tRNS chunk contains more alpha values than there are pixels (${t/2} vs ${this._png.width*this._png.height})`);this._hasTransparency=!0,this._transparency=new Uint16Array(t/2);for(let e=0;e<t/2;e++)this._transparency[e]=this.readUint16();break;case 3:{if(t>this._palette.length)throw new Error(`tRNS chunk contains more alpha values than there are palette colors (${t} vs ${this._palette.length})`);let e=0;for(;e<t;e++){const t=this.readByte();this._palette[e].push(t)}for(;e<this._palette.length;e++)this._palette[e].push(255);break}default:throw new Error(`tRNS chunk is not supported for color type ${this._colorType}`)}}decodeiCCP(t){const e=ca(this),r=this.readUint8();if(0!==r)throw new Error(`Unsupported iCCP compression method: ${r}`);const n=this.readBytes(t-e.length-2);this._png.iccEmbeddedProfile={name:e,profile:Ui(n)}}decodepHYs(){const t=this.readUint32(),e=this.readUint32(),r=this.readByte();this._png.resolution={x:t,y:e,unit:r}}decodeApngImage(){this._apng.width=this._png.width,this._apng.height=this._png.height,this._apng.channels=this._png.channels,this._apng.depth=this._png.depth,this._apng.numberOfFrames=this._numberOfFrames,this._apng.numberOfPlays=this._numberOfPlays,this._apng.text=this._png.text,this._apng.resolution=this._png.resolution;for(let t=0;t<this._numberOfFrames;t++){const e={sequenceNumber:this._frames[t].sequenceNumber,delayNumber:this._frames[t].delayNumber,delayDenominator:this._frames[t].delayDenominator,data:8===this._apng.depth?new Uint8Array(this._apng.width*this._apng.height*this._apng.channels):new Uint16Array(this._apng.width*this._apng.height*this._apng.channels)},r=this._frames.at(t);if(r){if(r.data=aa({data:r.data,width:r.width,height:r.height,channels:this._apng.channels,depth:this._apng.depth}),this._hasPalette&&(this._apng.palette=this._palette),this._hasTransparency&&(this._apng.transparency=this._transparency),0===t||0===r.xOffset&&0===r.yOffset&&r.width===this._png.width&&r.height===this._png.height)e.data=r.data;else{const n=this._apng.frames.at(t-1);this.disposeFrame(r,n,e),this.addFrameDataToCanvas(e,r)}this._apng.frames.push(e)}}return this._apng}disposeFrame(t,e,r){switch(t.disposeOp){case 0:break;case 1:for(let e=0;e<this._png.height;e++)for(let n=0;n<this._png.width;n++){const i=(e*t.width+n)*this._png.channels;for(let t=0;t<this._png.channels;t++)r.data[i+t]=0}break;case 2:r.data.set(e.data);break;default:throw new Error("Unknown disposeOp")}}addFrameDataToCanvas(t,e){const r=1<<this._png.depth,n=(t,r)=>({index:((t+e.yOffset)*this._png.width+e.xOffset+r)*this._png.channels,frameIndex:(t*e.width+r)*this._png.channels});switch(e.blendOp){case 0:for(let r=0;r<e.height;r++)for(let i=0;i<e.width;i++){const{index:a,frameIndex:s}=n(r,i);for(let r=0;r<this._png.channels;r++)t.data[a+r]=e.data[s+r]}break;case 1:for(let i=0;i<e.height;i++)for(let a=0;a<e.width;a++){const{index:s,frameIndex:o}=n(i,a);for(let n=0;n<this._png.channels;n++){const i=e.data[o+this._png.channels-1]/r,a=n%(this._png.channels-1)==0?1:e.data[o+n],h=Math.floor(i*a+(1-i)*t.data[s+n]);t.data[s+n]+=h}}break;default:throw new Error("Unknown blendOp")}}decodeImage(){if(this._inflator.err)throw new Error(`Error while decompressing the data: ${this._inflator.err}`);const t=this._isAnimated?(this._frames?.at(0)).data:this._inflator.result;if(0!==this._filterMethod)throw new Error(`Filter method ${this._filterMethod} not supported`);if(0===this._interlaceMethod)this._png.data=aa({data:t,width:this._png.width,height:this._png.height,channels:this._png.channels,depth:this._png.depth});else{if(1!==this._interlaceMethod)throw new Error(`Interlace method ${this._interlaceMethod} not supported`);this._png.data=function(t){const{data:e,width:r,height:n,channels:i,depth:a}=t,s=[{x:0,y:0,xStep:8,yStep:8},{x:4,y:0,xStep:8,yStep:8},{x:0,y:4,xStep:4,yStep:8},{x:2,y:0,xStep:4,yStep:4},{x:0,y:2,xStep:2,yStep:4},{x:1,y:0,xStep:2,yStep:2},{x:0,y:1,xStep:1,yStep:2}],o=Math.ceil(a/8)*i,h=new Uint8Array(n*r*o);let l=0;for(let u=0;u<7;u++){const t=s[u],i=Math.ceil((r-t.x)/t.xStep),a=Math.ceil((n-t.y)/t.yStep);if(i<=0||a<=0)continue;const c=i*o,f=new Uint8Array(c);for(let s=0;s<a;s++){const a=e[l++],u=e.subarray(l,l+c);l+=c;const d=new Uint8Array(c);$i(a,u,d,f,c,o),f.set(d);for(let e=0;e<i;e++){const i=t.x+e*t.xStep,a=t.y+s*t.yStep;if(!(i>=r||a>=n))for(let t=0;t<o;t++)h[(a*r+i)*o+t]=d[e*o+t]}}}if(16===a){const t=new Uint16Array(h.buffer);if(ta)for(let e=0;e<t.length;e++)t[e]=ea(t[e]);return t}return h}({data:t,width:this._png.width,height:this._png.height,channels:this._png.channels,depth:this._png.depth})}this._hasPalette&&(this._png.palette=this._palette),this._hasTransparency&&(this._png.transparency=this._transparency)}pushDataToFrame(){const t=this._inflator.result,e=this._frames.at(-1);e?e.data=t:this._frames.push({sequenceNumber:0,width:this._png.width,height:this._png.height,xOffset:0,yOffset:0,delayNumber:0,delayDenominator:0,disposeOp:0,blendOp:0,data:t}),this._inflator=new zi,this._writingDataChunks=!1}}var da,pa,ga,ma,ba,va;function wa(t,e,r,n,i){var a=4,s=xa;switch(i){case R.API.image_compression.FAST:a=1,s=_a;break;case R.API.image_compression.MEDIUM:a=6,s=Aa;break;case R.API.image_compression.SLOW:a=9,s=La}t=function(t,e,r,n){for(var i,a=t.length/e,s=new Uint8Array(t.length+a),o=[ya,_a,xa,Aa,La],h=0;h<a;h+=1){var l=h*e,u=t.subarray(l,l+e);if(n)s.set(n(u,r,i),l+h);else{for(var c=o.length,f=[],d=0;d<c;d+=1)f[d]=o[d](u,r,i);var p=Sa(f.concat());s.set(f[p],l+h)}i=u}return s}(t,e,Math.ceil(r*n/8),s);var o=ye(t,{level:a});return R.API.__addimage__.arrayBufferToBinaryString(o)}function ya(t){var e=Array.apply([],t);return e.unshift(0),e}function _a(t,e){var r=t.length,n=[];n[0]=1;for(var i=0;i<r;i+=1){var a=t[i-e]||0;n[i+1]=t[i]-a+256&255}return n}function xa(t,e,r){var n=t.length,i=[];i[0]=2;for(var a=0;a<n;a+=1){var s=r&&r[a]||0;i[a+1]=t[a]-s+256&255}return i}function Aa(t,e,r){var n=t.length,i=[];i[0]=3;for(var a=0;a<n;a+=1){var s=t[a-e]||0,o=r&&r[a]||0;i[a+1]=t[a]+256-(s+o>>>1)&255}return i}function La(t,e,r){var n=t.length,i=[];i[0]=4;for(var a=0;a<n;a+=1){var s=Na(t[a-e]||0,r&&r[a]||0,r&&r[a-e]||0);i[a+1]=t[a]-s+256&255}return i}function Na(t,e,r){if(t===e&&e===r)return t;var n=Math.abs(e-r),i=Math.abs(t-r),a=Math.abs(t+e-r-r);return n<=i&&n<=a?t:i<=a?e:r}function Sa(t){var e=t.map(function(t){return t.reduce(function(t,e){return t+Math.abs(e)},0)});return e.indexOf(Math.min.apply(null,e))}function ka(t,e,r){var n=e*r,i=Math.floor(n/8),a=16-(n-8*i+r),s=(1<<r)-1;return Fa(t,i)>>a&s}function Pa(t,e,r,n){var i=r*n,a=Math.floor(i/8),s=16-(i-8*a+n),o=(1<<n)-1,h=(e&o)<<s;!function(t,e,r){if(e+1<t.byteLength)t.setUint16(e,r,!1);else{var n=r>>8&255;t.setUint8(e,n)}}
/**
   * @license
   * (c) Dean McNamee <dean@gmail.com>, 2013.
   *
   * https://github.com/deanm/omggif
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy
   * of this software and associated documentation files (the "Software"), to
   * deal in the Software without restriction, including without limitation the
   * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
   * sell copies of the Software, and to permit persons to whom the Software is
   * furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in
   * all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
   * IN THE SOFTWARE.
   *
   * omggif is a JavaScript implementation of a GIF 89a encoder and decoder,
   * including animation and compression.  It does not rely on any specific
   * underlying system, so should run in the browser, Node, or Plask.
   */(t,a,Fa(t,a)&~(o<<s)&65535|h)}function Fa(t,e){return e+1<t.byteLength?t.getUint16(e,!1):t.getUint8(e)<<8}function Ia(t){var e=0;if(71!==t[e++]||73!==t[e++]||70!==t[e++]||56!==t[e++]||56!=(t[e++]+1&253)||97!==t[e++])throw new Error("Invalid GIF 87a/89a header.");var r=t[e++]|t[e++]<<8,n=t[e++]|t[e++]<<8,i=t[e++],a=i>>7,s=1<<1+(7&i);t[e++],t[e++];var o=null,h=null;a&&(o=e,h=s,e+=3*s);var l=!0,u=[],c=0,f=null,d=0,p=null;for(this.width=r,this.height=n;l&&e<t.length;)switch(t[e++]){case 33:switch(t[e++]){case 255:if(11!==t[e]||78==t[e+1]&&69==t[e+2]&&84==t[e+3]&&83==t[e+4]&&67==t[e+5]&&65==t[e+6]&&80==t[e+7]&&69==t[e+8]&&50==t[e+9]&&46==t[e+10]&&48==t[e+11]&&3==t[e+12]&&1==t[e+13]&&0==t[e+16])e+=14,p=t[e++]|t[e++]<<8,e++;else for(e+=12;;){if(!((k=t[e++])>=0))throw Error("Invalid block size");if(0===k)break;e+=k}break;case 249:if(4!==t[e++]||0!==t[e+4])throw new Error("Invalid graphics extension block.");var g=t[e++];c=t[e++]|t[e++]<<8,f=t[e++],1&g||(f=null),d=g>>2&7,e++;break;case 254:for(;;){if(!((k=t[e++])>=0))throw Error("Invalid block size");if(0===k)break;e+=k}break;default:throw new Error("Unknown graphic control label: 0x"+t[e-1].toString(16))}break;case 44:var m=t[e++]|t[e++]<<8,b=t[e++]|t[e++]<<8,v=t[e++]|t[e++]<<8,w=t[e++]|t[e++]<<8,y=t[e++],_=y>>6&1,x=1<<1+(7&y),A=o,L=h,N=!1;y>>7&&(N=!0,A=e,L=x,e+=3*x);var S=e;for(e++;;){var k;if(!((k=t[e++])>=0))throw Error("Invalid block size");if(0===k)break;e+=k}u.push({x:m,y:b,width:v,height:w,has_local_palette:N,palette_offset:A,palette_size:L,data_offset:S,data_length:e-S,transparent_index:f,interlaced:!!_,delay:c,disposal:d});break;case 59:l=!1;break;default:throw new Error("Unknown gif block: 0x"+t[e-1].toString(16))}this.numFrames=function(){return u.length},this.loopCount=function(){return p},this.frameInfo=function(t){if(t<0||t>=u.length)throw new Error("Frame index out of range.");return u[t]},this.decodeAndBlitFrameBGRA=function(e,n){var i=this.frameInfo(e),a=i.width*i.height;if(a>536870912)throw new Error("Image dimensions exceed 512MB, which is too large.");var s=new Uint8Array(a);Ca(t,i.data_offset,s,a);var o=i.palette_offset,h=i.transparent_index;null===h&&(h=256);var l=i.width,u=r-l,c=l,f=4*(i.y*r+i.x),d=4*((i.y+i.height)*r+i.x),p=f,g=4*u;!0===i.interlaced&&(g+=4*r*7);for(var m=8,b=0,v=s.length;b<v;++b){var w=s[b];if(0===c&&(c=l,(p+=g)>=d&&(g=4*u+4*r*(m-1),p=f+(l+u)*(m<<1),m>>=1)),w===h)p+=4;else{var y=t[o+3*w],_=t[o+3*w+1],x=t[o+3*w+2];n[p++]=x,n[p++]=_,n[p++]=y,n[p++]=255}--c}},this.decodeAndBlitFrameRGBA=function(e,n){var i=this.frameInfo(e),a=i.width*i.height;if(a>536870912)throw new Error("Image dimensions exceed 512MB, which is too large.");var s=new Uint8Array(a);Ca(t,i.data_offset,s,a);var o=i.palette_offset,h=i.transparent_index;null===h&&(h=256);var l=i.width,u=r-l,c=l,f=4*(i.y*r+i.x),d=4*((i.y+i.height)*r+i.x),p=f,g=4*u;!0===i.interlaced&&(g+=4*r*7);for(var m=8,b=0,v=s.length;b<v;++b){var w=s[b];if(0===c&&(c=l,(p+=g)>=d&&(g=4*u+4*r*(m-1),p=f+(l+u)*(m<<1),m>>=1)),w===h)p+=4;else{var y=t[o+3*w],_=t[o+3*w+1],x=t[o+3*w+2];n[p++]=y,n[p++]=_,n[p++]=x,n[p++]=255}--c}}}function Ca(t,e,r,n){for(var i=t[e++],a=1<<i,o=a+1,h=o+1,l=i+1,u=(1<<l)-1,c=0,f=0,d=0,p=t[e++],g=new Int32Array(4096),m=null;;){for(;c<16&&0!==p;)f|=t[e++]<<c,c+=8,1===p?p=t[e++]:--p;if(c<l)break;var b=f&u;if(f>>=l,c-=l,b!==a){if(b===o)break;for(var v=b<h?b:m,w=0,y=v;y>a;)y=g[y]>>8,++w;var _=y;if(d+w+(v!==b?1:0)>n)return void s.log("Warning, gif stream longer than expected.");r[d++]=_;var x=d+=w;for(v!==b&&(r[d++]=_),y=v;w--;)y=g[y],r[--x]=255&y,y>>=8;null!==m&&h<4096&&(g[h++]=m<<8|_,h>=u+1&&l<12&&(++l,u=u<<1|1)),m=b}else h=o+1,u=(1<<(l=i+1))-1,m=null}return d!==n&&s.log("Warning, gif stream shorter than expected."),r}
/**
   * @license
    Copyright (c) 2008, Adobe Systems Incorporated
    All rights reserved.

    Redistribution and use in source and binary forms, with or without 
    modification, are permitted provided that the following conditions are
    met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the 
      documentation and/or other materials provided with the distribution.
    
    * Neither the name of Adobe Systems Incorporated nor the names of its 
      contributors may be used to endorse or promote products derived from 
      this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
    IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
    THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
    CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
    EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
    LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
    NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */function ja(t){var e,r,n,i,a,s=Math.floor,o=new Array(64),h=new Array(64),l=new Array(64),u=new Array(64),c=new Array(65535),f=new Array(65535),d=new Array(64),p=new Array(64),g=[],m=0,b=7,v=new Array(64),w=new Array(64),y=new Array(64),_=new Array(256),x=new Array(2048),A=[0,1,5,6,14,15,27,28,2,4,7,13,16,26,29,42,3,8,12,17,25,30,41,43,9,11,18,24,31,40,44,53,10,19,23,32,39,45,52,54,20,22,33,38,46,51,55,60,21,34,37,47,50,56,59,61,35,36,48,49,57,58,62,63],L=[0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0],N=[0,1,2,3,4,5,6,7,8,9,10,11],S=[0,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125],k=[1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250],P=[0,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0],F=[0,1,2,3,4,5,6,7,8,9,10,11],I=[0,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119],C=[0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250];function j(t,e){for(var r=0,n=0,i=new Array,a=1;a<=16;a++){for(var s=1;s<=t[a];s++)i[e[n]]=[],i[e[n]][0]=r,i[e[n]][1]=a,n++,r++;r*=2}return i}function E(t){for(var e=t[0],r=t[1]-1;r>=0;)e&1<<r&&(m|=1<<b),r--,--b<0&&(255==m?(O(255),O(0)):O(m),b=7,m=0)}function O(t){g.push(t)}function B(t){O(t>>8&255),O(255&t)}function M(t,e,r,n,i){for(var a,s=i[0],o=i[240],h=function(t,e){var r,n,i,a,s,o,h,l,u,c,f=0;for(u=0;u<8;++u){r=t[f],n=t[f+1],i=t[f+2],a=t[f+3],s=t[f+4],o=t[f+5],h=t[f+6];var p=r+(l=t[f+7]),g=r-l,m=n+h,b=n-h,v=i+o,w=i-o,y=a+s,_=a-s,x=p+y,A=p-y,L=m+v,N=m-v;t[f]=x+L,t[f+4]=x-L;var S=.707106781*(N+A);t[f+2]=A+S,t[f+6]=A-S;var k=.382683433*((x=_+w)-(N=b+g)),P=.5411961*x+k,F=1.306562965*N+k,I=.707106781*(L=w+b),C=g+I,j=g-I;t[f+5]=j+P,t[f+3]=j-P,t[f+1]=C+F,t[f+7]=C-F,f+=8}for(f=0,u=0;u<8;++u){r=t[f],n=t[f+8],i=t[f+16],a=t[f+24],s=t[f+32],o=t[f+40],h=t[f+48];var E=r+(l=t[f+56]),O=r-l,B=n+h,M=n-h,R=i+o,T=i-o,q=a+s,D=a-s,z=E+q,U=E-q,H=B+R,W=B-R;t[f]=z+H,t[f+32]=z-H;var V=.707106781*(W+U);t[f+16]=U+V,t[f+48]=U-V;var G=.382683433*((z=D+T)-(W=M+O)),Y=.5411961*z+G,Z=1.306562965*W+G,J=.707106781*(H=T+M),X=O+J,K=O-J;t[f+40]=K+Y,t[f+24]=K-Y,t[f+8]=X+Z,t[f+56]=X-Z,f++}for(u=0;u<64;++u)c=t[u]*e[u],d[u]=c>0?c+.5|0:c-.5|0;return d}(t,e),l=0;l<64;++l)p[A[l]]=h[l];var u=p[0]-r;r=p[0],0==u?E(n[0]):(E(n[f[a=32767+u]]),E(c[a]));for(var g=63;g>0&&0==p[g];)g--;if(0==g)return E(s),r;for(var m,b=1;b<=g;){for(var v=b;0==p[b]&&b<=g;)++b;var w=b-v;if(w>=16){m=w>>4;for(var y=1;y<=m;++y)E(o);w&=15}a=32767+p[b],E(i[(w<<4)+f[a]]),E(c[a]),b++}return 63!=g&&E(s),r}function R(t){t=Math.min(Math.max(t,1),100),a!=t&&(function(t){for(var e=[16,11,10,16,24,40,51,61,12,12,14,19,26,58,60,55,14,13,16,24,40,57,69,56,14,17,22,29,51,87,80,62,18,22,37,56,68,109,103,77,24,35,55,64,81,104,113,92,49,64,78,87,103,121,120,101,72,92,95,98,112,100,103,99],r=0;r<64;r++){var n=s((e[r]*t+50)/100);n=Math.min(Math.max(n,1),255),o[A[r]]=n}for(var i=[17,18,24,47,99,99,99,99,18,21,26,66,99,99,99,99,24,26,56,99,99,99,99,99,47,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99],a=0;a<64;a++){var c=s((i[a]*t+50)/100);c=Math.min(Math.max(c,1),255),h[A[a]]=c}for(var f=[1,1.387039845,1.306562965,1.175875602,1,.785694958,.5411961,.275899379],d=0,p=0;p<8;p++)for(var g=0;g<8;g++)l[d]=1/(o[A[d]]*f[p]*f[g]*8),u[d]=1/(h[A[d]]*f[p]*f[g]*8),d++}(t<50?Math.floor(5e3/t):Math.floor(200-2*t)),a=t)}this.encode=function(t,a){a&&R(a),g=new Array,m=0,b=7,B(65496),B(65504),B(16),O(74),O(70),O(73),O(70),O(0),O(1),O(1),O(0),B(1),B(1),O(0),O(0),function(){B(65499),B(132),O(0);for(var t=0;t<64;t++)O(o[t]);O(1);for(var e=0;e<64;e++)O(h[e])}(),function(t,e){B(65472),B(17),O(8),B(e),B(t),O(3),O(1),O(17),O(0),O(2),O(17),O(1),O(3),O(17),O(1)}(t.width,t.height),function(){B(65476),B(418),O(0);for(var t=0;t<16;t++)O(L[t+1]);for(var e=0;e<=11;e++)O(N[e]);O(16);for(var r=0;r<16;r++)O(S[r+1]);for(var n=0;n<=161;n++)O(k[n]);O(1);for(var i=0;i<16;i++)O(P[i+1]);for(var a=0;a<=11;a++)O(F[a]);O(17);for(var s=0;s<16;s++)O(I[s+1]);for(var o=0;o<=161;o++)O(C[o])}(),B(65498),B(12),O(3),O(1),O(0),O(2),O(17),O(3),O(17),O(0),O(63),O(0);var s=0,c=0,f=0;m=0,b=7,this.encode.displayName="_encode_";for(var d,p,_,A,j,T,q,D,z,U=t.data,H=t.width,W=t.height,V=4*H,G=0;G<W;){for(d=0;d<V;){for(j=V*G+d,q=-1,D=0,z=0;z<64;z++)T=j+(D=z>>3)*V+(q=4*(7&z)),G+D>=W&&(T-=V*(G+1+D-W)),d+q>=V&&(T-=d+q-V+4),p=U[T++],_=U[T++],A=U[T++],v[z]=(x[p]+x[_+256|0]+x[A+512|0]>>16)-128,w[z]=(x[p+768|0]+x[_+1024|0]+x[A+1280|0]>>16)-128,y[z]=(x[p+1280|0]+x[_+1536|0]+x[A+1792|0]>>16)-128;s=M(v,l,s,e,n),c=M(w,u,c,r,i),f=M(y,u,f,r,i),d+=32}G+=8}if(b>=0){var Y=[];Y[1]=b+1,Y[0]=(1<<b+1)-1,E(Y)}return B(65497),new Uint8Array(g)},t=t||50,function(){for(var t=String.fromCharCode,e=0;e<256;e++)_[e]=t(e)}(),e=j(L,N),r=j(P,F),n=j(S,k),i=j(I,C),function(){for(var t=1,e=2,r=1;r<=15;r++){for(var n=t;n<e;n++)f[32767+n]=r,c[32767+n]=[],c[32767+n][1]=r,c[32767+n][0]=n;for(var i=-(e-1);i<=-t;i++)f[32767+i]=r,c[32767+i]=[],c[32767+i][1]=r,c[32767+i][0]=e-1+i;t<<=1,e<<=1}}(),function(){for(var t=0;t<256;t++)x[t]=19595*t,x[t+256|0]=38470*t,x[t+512|0]=7471*t+32768,x[t+768|0]=-11059*t,x[t+1024|0]=-21709*t,x[t+1280|0]=32768*t+8421375,x[t+1536|0]=-27439*t,x[t+1792|0]=-5329*t}(),R(t)}
/**
   * @license
   * Copyright (c) 2017 Aras Abbasi
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */function Ea(t,e){if(this.pos=0,this.buffer=t,this.datav=new DataView(t.buffer),this.is_with_alpha=!!e,this.bottom_up=!0,this.flag=String.fromCharCode(this.buffer[0])+String.fromCharCode(this.buffer[1]),this.pos+=2,-1===["BM","BA","CI","CP","IC","PT"].indexOf(this.flag))throw new Error("Invalid BMP File");this.parseHeader(),this.parseBGR()}function Oa(t){function e(t){if(!t)throw Error("assert :P")}function r(t,e,r){for(var n=0;4>n;n++)if(t[e+n]!=r.charCodeAt(n))return!0;return!1}function n(t,e,r,n,i){for(var a=0;a<i;a++)t[e+a]=r[n+a]}function i(t,e,r,n){for(var i=0;i<n;i++)t[e+i]=r}function a(t){return new Int32Array(t)}function s(t,e){for(var r=[],n=0;n<t;n++)r.push(new e);return r}function o(t,e){var r=[];return function t(r,n,i){for(var a=i[n],s=0;s<a&&(r.push(i.length>n+1?[]:new e),!(i.length<n+1));s++)t(r[s],n+1,i)}(r,0,t),r}var h=function(){var t=this;function h(t,e){for(var r=1<<e-1>>>0;t&r;)r>>>=1;return r?(t&r-1)+r:t}function l(t,r,n,i,a){e(!(i%n));do{t[r+(i-=n)]=a}while(0<i)}function u(t,r,n,i,s){if(e(2328>=s),512>=s)var o=a(512);else if(null==(o=a(s)))return 0;return function(t,r,n,i,s,o){var u,f,d=r,p=1<<n,g=a(16),m=a(16);for(e(0!=s),e(null!=i),e(null!=t),e(0<n),f=0;f<s;++f){if(15<i[f])return 0;++g[i[f]]}if(g[0]==s)return 0;for(m[1]=0,u=1;15>u;++u){if(g[u]>1<<u)return 0;m[u+1]=m[u]+g[u]}for(f=0;f<s;++f)u=i[f],0<i[f]&&(o[m[u]++]=f);if(1==m[15])return(i=new c).g=0,i.value=o[0],l(t,d,1,p,i),p;var b,v=-1,w=p-1,y=0,_=1,x=1,A=1<<n;for(f=0,u=1,s=2;u<=n;++u,s<<=1){if(_+=x<<=1,0>(x-=g[u]))return 0;for(;0<g[u];--g[u])(i=new c).g=u,i.value=o[f++],l(t,d+y,s,A,i),y=h(y,u)}for(u=n+1,s=2;15>=u;++u,s<<=1){if(_+=x<<=1,0>(x-=g[u]))return 0;for(;0<g[u];--g[u]){if(i=new c,(y&w)!=v){for(d+=A,b=1<<(v=u)-n;15>v&&!(0>=(b-=g[v]));)++v,b<<=1;p+=A=1<<(b=v-n),t[r+(v=y&w)].g=b+n,t[r+v].value=d-r-v}i.g=u-n,i.value=o[f++],l(t,d+(y>>n),s,A,i),y=h(y,u)}}return _!=2*m[15]-1?0:p}(t,r,n,i,s,o)}function c(){this.value=this.g=0}function f(){this.value=this.g=0}function d(){this.G=s(5,c),this.H=a(5),this.jc=this.Qb=this.qb=this.nd=0,this.pd=s(Rr,f)}function p(t,r,n,i){e(null!=t),e(null!=r),e(2147483648>i),t.Ca=254,t.I=0,t.b=-8,t.Ka=0,t.oa=r,t.pa=n,t.Jd=r,t.Yc=n+i,t.Zc=4<=i?n+i-4+1:n,S(t)}function g(t,e){for(var r=0;0<e--;)r|=P(t,128)<<e;return r}function m(t,e){var r=g(t,e);return k(t)?-r:r}function b(t,r,n,i){var a,s=0;for(e(null!=t),e(null!=r),e(4294967288>i),t.Sb=i,t.Ra=0,t.u=0,t.h=0,4<i&&(i=4),a=0;a<i;++a)s+=r[n+a]<<8*a;t.Ra=s,t.bb=i,t.oa=r,t.pa=n}function v(t){for(;8<=t.u&&t.bb<t.Sb;)t.Ra>>>=8,t.Ra+=t.oa[t.pa+t.bb]<<Dr-8>>>0,++t.bb,t.u-=8;A(t)&&(t.h=1,t.u=0)}function w(t,r){if(e(0<=r),!t.h&&r<=qr){var n=x(t)&Tr[r];return t.u+=r,v(t),n}return t.h=1,t.u=0}function y(){this.b=this.Ca=this.I=0,this.oa=[],this.pa=0,this.Jd=[],this.Yc=0,this.Zc=[],this.Ka=0}function _(){this.Ra=0,this.oa=[],this.h=this.u=this.bb=this.Sb=this.pa=0}function x(t){return t.Ra>>>(t.u&Dr-1)>>>0}function A(t){return e(t.bb<=t.Sb),t.h||t.bb==t.Sb&&t.u>Dr}function L(t,e){t.u=e,t.h=A(t)}function N(t){t.u>=zr&&(e(t.u>=zr),v(t))}function S(t){e(null!=t&&null!=t.oa),t.pa<t.Zc?(t.I=(t.oa[t.pa++]|t.I<<8)>>>0,t.b+=8):(e(null!=t&&null!=t.oa),t.pa<t.Yc?(t.b+=8,t.I=t.oa[t.pa++]|t.I<<8):t.Ka?t.b=0:(t.I<<=8,t.b+=8,t.Ka=1))}function k(t){return g(t,1)}function P(t,e){var r=t.Ca;0>t.b&&S(t);var n=t.b,i=r*e>>>8,a=(t.I>>>n>i)+0;for(a?(r-=i,t.I-=i+1<<n>>>0):r=i+1,n=r,i=0;256<=n;)i+=8,n>>=8;return n=7^i+Ur[n],t.b-=n,t.Ca=(r<<n)-1,a}function F(t,e,r){t[e+0]=r>>24&255,t[e+1]=r>>16&255,t[e+2]=r>>8&255,t[e+3]=255&r}function I(t,e){return t[e+0]|t[e+1]<<8}function C(t,e){return I(t,e)|t[e+2]<<16}function j(t,e){return I(t,e)|I(t,e+2)<<16}function E(t,r){var n=1<<r;return e(null!=t),e(0<r),t.X=a(n),null==t.X?0:(t.Mb=32-r,t.Xa=r,1)}function O(t,r){e(null!=t),e(null!=r),e(t.Xa==r.Xa),n(r.X,0,t.X,0,1<<r.Xa)}function B(){this.X=[],this.Xa=this.Mb=0}function M(t,r,n,i){e(null!=n),e(null!=i);var a=n[0],s=i[0];return 0==a&&(a=(t*s+r/2)/r),0==s&&(s=(r*a+t/2)/t),0>=a||0>=s?0:(n[0]=a,i[0]=s,1)}function R(t,e){return t+(1<<e)-1>>>e}function T(t,e){return((4278255360&t)+(4278255360&e)>>>0&4278255360)+((16711935&t)+(16711935&e)>>>0&16711935)>>>0}function q(e,r){t[r]=function(r,n,i,a,s,o,h){var l;for(l=0;l<s;++l){var u=t[e](o[h+l-1],i,a+l);o[h+l]=T(r[n+l],u)}}}function D(){this.ud=this.hd=this.jd=0}function z(t,e){return((4278124286&(t^e))>>>1)+(t&e)>>>0}function U(t){return 0<=t&&256>t?t:0>t?0:255<t?255:void 0}function H(t,e){return U(t+(t-e+.5>>1))}function W(t,e,r){return Math.abs(e-r)-Math.abs(t-r)}function V(t,e,r,n,i,a,s){for(n=a[s-1],r=0;r<i;++r)a[s+r]=n=T(t[e+r],n)}function G(t,e,r,n,i){var a;for(a=0;a<r;++a){var s=t[e+a],o=s>>8&255,h=16711935&(h=(h=16711935&s)+((o<<16)+o));n[i+a]=(4278255360&s)+h>>>0}}function Y(t,e){e.jd=255&t,e.hd=t>>8&255,e.ud=t>>16&255}function Z(t,e,r,n,i,a){var s;for(s=0;s<n;++s){var o=e[r+s],h=o>>>8,l=o,u=255&(u=(u=o>>>16)+((t.jd<<24>>24)*(h<<24>>24)>>>5));l=255&(l=(l+=(t.hd<<24>>24)*(h<<24>>24)>>>5)+((t.ud<<24>>24)*(u<<24>>24)>>>5)),i[a+s]=(4278255360&o)+(u<<16)+l}}function J(e,r,n,i,a){t[r]=function(t,e,r,n,s,o,h,l,u){for(n=h;n<l;++n)for(h=0;h<u;++h)s[o++]=a(r[i(t[e++])])},t[e]=function(e,r,s,o,h,l,u){var c=8>>e.b,f=e.Ea,d=e.K[0],p=e.w;if(8>c)for(e=(1<<e.b)-1,p=(1<<c)-1;r<s;++r){var g,m=0;for(g=0;g<f;++g)g&e||(m=i(o[h++])),l[u++]=a(d[m&p]),m>>=c}else t["VP8LMapColor"+n](o,h,d,p,l,u,r,s,f)}}function X(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=a>>16&255,n[i++]=a>>8&255,n[i++]=255&a}}function K(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=a>>16&255,n[i++]=a>>8&255,n[i++]=255&a,n[i++]=a>>24&255}}function $(t,e,r,n,i){for(r=e+r;e<r;){var a=(s=t[e++])>>16&240|s>>12&15,s=240&s|s>>28&15;n[i++]=a,n[i++]=s}}function Q(t,e,r,n,i){for(r=e+r;e<r;){var a=(s=t[e++])>>16&248|s>>13&7,s=s>>5&224|s>>3&31;n[i++]=a,n[i++]=s}}function tt(t,e,r,n,i){for(r=e+r;e<r;){var a=t[e++];n[i++]=255&a,n[i++]=a>>8&255,n[i++]=a>>16&255}}function et(t,e,r,i,a,s){if(0==s)for(r=e+r;e<r;)F(i,((s=t[e++])[0]>>24|s[1]>>8&65280|s[2]<<8&16711680|s[3]<<24)>>>0),a+=32;else n(i,a,t,e,r)}function rt(e,r){t[r][0]=t[e+"0"],t[r][1]=t[e+"1"],t[r][2]=t[e+"2"],t[r][3]=t[e+"3"],t[r][4]=t[e+"4"],t[r][5]=t[e+"5"],t[r][6]=t[e+"6"],t[r][7]=t[e+"7"],t[r][8]=t[e+"8"],t[r][9]=t[e+"9"],t[r][10]=t[e+"10"],t[r][11]=t[e+"11"],t[r][12]=t[e+"12"],t[r][13]=t[e+"13"],t[r][14]=t[e+"0"],t[r][15]=t[e+"0"]}function nt(t){return t==Un||t==Hn||t==Wn||t==Vn}function it(){this.eb=[],this.size=this.A=this.fb=0}function at(){this.y=[],this.f=[],this.ea=[],this.F=[],this.Tc=this.Ed=this.Cd=this.Fd=this.lb=this.Db=this.Ab=this.fa=this.J=this.W=this.N=this.O=0}function st(){this.Rd=this.height=this.width=this.S=0,this.f={},this.f.RGBA=new it,this.f.kb=new at,this.sd=null}function ot(){this.width=[0],this.height=[0],this.Pd=[0],this.Qd=[0],this.format=[0]}function ht(){this.Id=this.fd=this.Md=this.hb=this.ib=this.da=this.bd=this.cd=this.j=this.v=this.Da=this.Sd=this.ob=0}function lt(t){return alert("todo:WebPSamplerProcessPlane"),t.T}function ut(t,e){var r=t.T,i=e.ba.f.RGBA,a=i.eb,s=i.fb+t.ka*i.A,o=mi[e.ba.S],h=t.y,l=t.O,u=t.f,c=t.N,f=t.ea,d=t.W,p=e.cc,g=e.dc,m=e.Mc,b=e.Nc,v=t.ka,w=t.ka+t.T,y=t.U,_=y+1>>1;for(0==v?o(h,l,null,null,u,c,f,d,u,c,f,d,a,s,null,null,y):(o(e.ec,e.fc,h,l,p,g,m,b,u,c,f,d,a,s-i.A,a,s,y),++r);v+2<w;v+=2)p=u,g=c,m=f,b=d,c+=t.Rc,d+=t.Rc,s+=2*i.A,o(h,(l+=2*t.fa)-t.fa,h,l,p,g,m,b,u,c,f,d,a,s-i.A,a,s,y);return l+=t.fa,t.j+w<t.o?(n(e.ec,e.fc,h,l,y),n(e.cc,e.dc,u,c,_),n(e.Mc,e.Nc,f,d,_),r--):1&w||o(h,l,null,null,u,c,f,d,u,c,f,d,a,s+i.A,null,null,y),r}function ct(t,r,n){var i=t.F,a=[t.J];if(null!=i){var s=t.U,o=r.ba.S,h=o==qn||o==Wn;r=r.ba.f.RGBA;var l=[0],u=t.ka;l[0]=t.T,t.Kb&&(0==u?--l[0]:(--u,a[0]-=t.width),t.j+t.ka+t.T==t.o&&(l[0]=t.o-t.j-u));var c=r.eb;u=r.fb+u*r.A,t=Ln(i,a[0],t.width,s,l,c,u+(h?0:3),r.A),e(n==l),t&&nt(o)&&xn(c,u,h,s,l,r.A)}return 0}function ft(t){var e=t.ma,r=e.ba.S,n=11>r,i=r==Mn||r==Tn||r==qn||r==Dn||12==r||nt(r);if(e.memory=null,e.Ib=null,e.Jb=null,e.Nd=null,!Or(e.Oa,t,i?11:12))return 0;if(i&&nt(r)&&br(),t.da)alert("todo:use_scaling");else{if(n){if(e.Ib=lt,t.Kb){if(r=t.U+1>>1,e.memory=a(t.U+2*r),null==e.memory)return 0;e.ec=e.memory,e.fc=0,e.cc=e.ec,e.dc=e.fc+t.U,e.Mc=e.cc,e.Nc=e.dc+r,e.Ib=ut,br()}}else alert("todo:EmitYUV");i&&(e.Jb=ct,n&&gr())}if(n&&!Ii){for(t=0;256>t;++t)Ci[t]=89858*(t-128)+Ni>>Li,Oi[t]=-22014*(t-128)+Ni,Ei[t]=-45773*(t-128),ji[t]=113618*(t-128)+Ni>>Li;for(t=Si;t<ki;++t)e=76283*(t-16)+Ni>>Li,Bi[t-Si]=Vt(e,255),Mi[t-Si]=Vt(e+8>>4,15);Ii=1}return 1}function dt(t){var r=t.ma,n=t.U,i=t.T;return e(!(1&t.ka)),0>=n||0>=i?0:(n=r.Ib(t,r),null!=r.Jb&&r.Jb(t,r,n),r.Dc+=n,1)}function pt(t){t.ma.memory=null}function gt(t,e,r,n){return 47!=w(t,8)?0:(e[0]=w(t,14)+1,r[0]=w(t,14)+1,n[0]=w(t,1),0!=w(t,3)?0:!t.h)}function mt(t,e){if(4>t)return t+1;var r=t-2>>1;return(2+(1&t)<<r)+w(e,r)+1}function bt(t,e){return 120<e?e-120:1<=(r=((r=Kn[e-1])>>4)*t+(8-(15&r)))?r:1;var r}function vt(t,e,r){var n=x(r),i=t[e+=255&n].g-8;return 0<i&&(L(r,r.u+8),n=x(r),e+=t[e].value,e+=n&(1<<i)-1),L(r,r.u+t[e].g),t[e].value}function wt(t,r,n){return n.g+=t.g,n.value+=t.value<<r>>>0,e(8>=n.g),t.g}function yt(t,r,n){var i=t.xc;return e((r=0==i?0:t.vc[t.md*(n>>i)+(r>>i)])<t.Wb),t.Ya[r]}function _t(t,r,i,a){var s=t.ab,o=t.c*r,h=t.C;r=h+r;var l=i,u=a;for(a=t.Ta,i=t.Ua;0<s--;){var c=t.gc[s],f=h,d=r,p=l,g=u,m=(u=a,l=i,c.Ea);switch(e(f<d),e(d<=c.nc),c.hc){case 2:Vr(p,g,(d-f)*m,u,l);break;case 0:var b=f,v=d,w=u,y=l,_=(S=c).Ea;0==b&&(Hr(p,g,null,null,1,w,y),V(p,g+1,0,0,_-1,w,y+1),g+=_,y+=_,++b);for(var x=1<<S.b,A=x-1,L=R(_,S.b),N=S.K,S=S.w+(b>>S.b)*L;b<v;){var k=N,P=S,F=1;for(Wr(p,g,w,y-_,1,w,y);F<_;){var I=(F&~A)+x;I>_&&(I=_),(0,Xr[k[P++]>>8&15])(p,g+ +F,w,y+F-_,I-F,w,y+F),F=I}g+=_,y+=_,++b&A||(S+=L)}d!=c.nc&&n(u,l-m,u,l+(d-f-1)*m,m);break;case 1:for(m=p,v=g,_=(p=c.Ea)-(y=p&~(w=(g=1<<c.b)-1)),b=R(p,c.b),x=c.K,c=c.w+(f>>c.b)*b;f<d;){for(A=x,L=c,N=new D,S=v+y,k=v+p;v<S;)Y(A[L++],N),Kr(N,m,v,g,u,l),v+=g,l+=g;v<k&&(Y(A[L++],N),Kr(N,m,v,_,u,l),v+=_,l+=_),++f&w||(c+=b)}break;case 3:if(p==u&&g==l&&0<c.b){for(v=u,p=m=l+(d-f)*m-(y=(d-f)*R(c.Ea,c.b)),g=u,w=l,b=[],y=(_=y)-1;0<=y;--y)b[y]=g[w+y];for(y=_-1;0<=y;--y)v[p+y]=b[y];Gr(c,f,d,u,m,u,l)}else Gr(c,f,d,p,g,u,l)}l=a,u=i}u!=i&&n(a,i,l,u,o)}function xt(t,r){var n=t.V,i=t.Ba+t.c*t.C,a=r-t.C;if(e(r<=t.l.o),e(16>=a),0<a){var s=t.l,o=t.Ta,h=t.Ua,l=s.width;if(_t(t,a,n,i),a=h=[h],e((n=t.C)<(i=r)),e(s.v<s.va),i>s.o&&(i=s.o),n<s.j){var u=s.j-n;n=s.j,a[0]+=u*l}if(n>=i?n=0:(a[0]+=4*s.v,s.ka=n-s.j,s.U=s.va-s.v,s.T=i-n,n=1),n){if(h=h[0],11>(n=t.ca).S){var c=n.f.RGBA,f=(i=n.S,a=s.U,s=s.T,u=c.eb,c.A),d=s;for(c=c.fb+t.Ma*c.A;0<d--;){var p=o,g=h,m=a,b=u,v=c;switch(i){case Bn:$r(p,g,m,b,v);break;case Mn:Qr(p,g,m,b,v);break;case Un:Qr(p,g,m,b,v),xn(b,v,0,m,1,0);break;case Rn:rn(p,g,m,b,v);break;case Tn:et(p,g,m,b,v,1);break;case Hn:et(p,g,m,b,v,1),xn(b,v,0,m,1,0);break;case qn:et(p,g,m,b,v,0);break;case Wn:et(p,g,m,b,v,0),xn(b,v,1,m,1,0);break;case Dn:tn(p,g,m,b,v);break;case Vn:tn(p,g,m,b,v),An(b,v,m,1,0);break;case zn:en(p,g,m,b,v);break;default:e(0)}h+=l,c+=f}t.Ma+=s}else alert("todo:EmitRescaledRowsYUVA");e(t.Ma<=n.height)}}t.C=r,e(t.C<=t.i)}function At(t){var e;if(0<t.ua)return 0;for(e=0;e<t.Wb;++e){var r=t.Ya[e].G,n=t.Ya[e].H;if(0<r[1][n[1]+0].g||0<r[2][n[2]+0].g||0<r[3][n[3]+0].g)return 0}return 1}function Lt(t,r,n,i,a,s){if(0!=t.Z){var o=t.qd,h=t.rd;for(e(null!=gi[t.Z]);r<n;++r)gi[t.Z](o,h,i,a,i,a,s),o=i,h=a,a+=s;t.qd=o,t.rd=h}}function Nt(t,r){var n=t.l.ma,i=0==n.Z||1==n.Z?t.l.j:t.C;if(i=t.C<i?i:t.C,e(r<=t.l.o),r>i){var a=t.l.width,s=n.ca,o=n.tb+a*i,h=t.V,l=t.Ba+t.c*i,u=t.gc;e(1==t.ab),e(3==u[0].hc),Zr(u[0],i,r,h,l,s,o),Lt(n,i,r,s,o,a)}t.C=t.Ma=r}function St(t,r,n,i,a,s,o){var h=t.$/i,l=t.$%i,u=t.m,c=t.s,f=n+t.$,d=f;a=n+i*a;var p=n+i*s,g=280+c.ua,m=t.Pb?h:16777216,b=0<c.ua?c.Wa:null,v=c.wc,w=f<p?yt(c,l,h):null;e(t.C<s),e(p<=a);var y=!1;t:for(;;){for(;y||f<p;){var _=0;if(h>=m){var S=f-n;e((m=t).Pb),m.wd=m.m,m.xd=S,0<m.s.ua&&O(m.s.Wa,m.s.vb),m=h+Qn}if(l&v||(w=yt(c,l,h)),e(null!=w),w.Qb&&(r[f]=w.qb,y=!0),!y)if(N(u),w.jc){_=u,S=r;var k=f,P=w.pd[x(_)&Rr-1];e(w.jc),256>P.g?(L(_,_.u+P.g),S[k]=P.value,_=0):(L(_,_.u+P.g-256),e(256<=P.value),_=P.value),0==_&&(y=!0)}else _=vt(w.G[0],w.H[0],u);if(u.h)break;if(y||256>_){if(!y)if(w.nd)r[f]=(w.qb|_<<8)>>>0;else{if(N(u),y=vt(w.G[1],w.H[1],u),N(u),S=vt(w.G[2],w.H[2],u),k=vt(w.G[3],w.H[3],u),u.h)break;r[f]=(k<<24|y<<16|_<<8|S)>>>0}if(y=!1,++f,++l>=i&&(l=0,++h,null!=o&&h<=s&&!(h%16)&&o(t,h),null!=b))for(;d<f;)_=r[d++],b.X[(506832829*_&4294967295)>>>b.Mb]=_}else if(280>_){if(_=mt(_-256,u),S=vt(w.G[4],w.H[4],u),N(u),S=bt(i,S=mt(S,u)),u.h)break;if(f-n<S||a-f<_)break t;for(k=0;k<_;++k)r[f+k]=r[f+k-S];for(f+=_,l+=_;l>=i;)l-=i,++h,null!=o&&h<=s&&!(h%16)&&o(t,h);if(e(f<=a),l&v&&(w=yt(c,l,h)),null!=b)for(;d<f;)_=r[d++],b.X[(506832829*_&4294967295)>>>b.Mb]=_}else{if(!(_<g))break t;for(y=_-280,e(null!=b);d<f;)_=r[d++],b.X[(506832829*_&4294967295)>>>b.Mb]=_;_=f,e(!(y>>>(S=b).Xa)),r[_]=S.X[y],y=!0}y||e(u.h==A(u))}if(t.Pb&&u.h&&f<a)e(t.m.h),t.a=5,t.m=t.wd,t.$=t.xd,0<t.s.ua&&O(t.s.vb,t.s.Wa);else{if(u.h)break t;null!=o&&o(t,h>s?s:h),t.a=0,t.$=f-n}return 1}return t.a=3,0}function kt(t){e(null!=t),t.vc=null,t.yc=null,t.Ya=null;var r=t.Wa;null!=r&&(r.X=null),t.vb=null,e(null!=t)}function Pt(){var e=new ar;return null==e?null:(e.a=0,e.xb=pi,rt("Predictor","VP8LPredictors"),rt("Predictor","VP8LPredictors_C"),rt("PredictorAdd","VP8LPredictorsAdd"),rt("PredictorAdd","VP8LPredictorsAdd_C"),Vr=G,Kr=Z,$r=X,Qr=K,tn=$,en=Q,rn=tt,t.VP8LMapColor32b=Yr,t.VP8LMapColor8b=Jr,e)}function Ft(t,r,n,o,h){var l=1,f=[t],p=[r],g=o.m,m=o.s,b=null,v=0;t:for(;;){if(n)for(;l&&w(g,1);){var y=f,_=p,A=o,S=1,k=A.m,P=A.gc[A.ab],F=w(k,2);if(A.Oc&1<<F)l=0;else{switch(A.Oc|=1<<F,P.hc=F,P.Ea=y[0],P.nc=_[0],P.K=[null],++A.ab,e(4>=A.ab),F){case 0:case 1:P.b=w(k,3)+2,S=Ft(R(P.Ea,P.b),R(P.nc,P.b),0,A,P.K),P.K=P.K[0];break;case 3:var I,C=w(k,8)+1,j=16<C?0:4<C?1:2<C?2:3;if(y[0]=R(P.Ea,j),P.b=j,I=S=Ft(C,1,0,A,P.K)){var O,B=C,M=P,q=1<<(8>>M.b),D=a(q);if(null==D)I=0;else{var z=M.K[0],U=M.w;for(D[0]=M.K[0][0],O=1;O<1*B;++O)D[O]=T(z[U+O],D[O-1]);for(;O<4*q;++O)D[O]=0;M.K[0]=null,M.K[0]=D,I=1}}S=I;break;case 2:break;default:e(0)}l=S}}if(f=f[0],p=p[0],l&&w(g,1)&&!(l=1<=(v=w(g,4))&&11>=v)){o.a=3;break t}var H;if(H=l)e:{var W,V,G,Y=o,Z=f,J=p,X=v,K=n,$=Y.m,Q=Y.s,tt=[null],et=1,rt=0,nt=$n[X];r:for(;;){if(K&&w($,1)){var it=w($,3)+2,at=R(Z,it),st=R(J,it),ot=at*st;if(!Ft(at,st,0,Y,tt))break r;for(tt=tt[0],Q.xc=it,W=0;W<ot;++W){var ht=tt[W]>>8&65535;tt[W]=ht,ht>=et&&(et=ht+1)}}if($.h)break r;for(V=0;5>V;++V){var lt=Zn[V];!V&&0<X&&(lt+=1<<X),rt<lt&&(rt=lt)}var ut=s(et*nt,c),ct=et,ft=s(ct,d);if(null==ft)var dt=null;else e(65536>=ct),dt=ft;var pt=a(rt);if(null==dt||null==pt||null==ut){Y.a=1;break r}var gt=ut;for(W=G=0;W<et;++W){var mt=dt[W],bt=mt.G,vt=mt.H,yt=0,_t=1,xt=0;for(V=0;5>V;++V){lt=Zn[V],bt[V]=gt,vt[V]=G,!V&&0<X&&(lt+=1<<X);n:{var At,Lt=lt,Nt=Y,Pt=pt,It=gt,Ct=G,jt=0,Et=Nt.m,Ot=w(Et,1);if(i(Pt,0,0,Lt),Ot){var Bt=w(Et,1)+1,Mt=w(Et,1),Rt=w(Et,0==Mt?1:8);Pt[Rt]=1,2==Bt&&(Pt[Rt=w(Et,8)]=1);var Tt=1}else{var qt=a(19),Dt=w(Et,4)+4;if(19<Dt){Nt.a=3;var zt=0;break n}for(At=0;At<Dt;++At)qt[Xn[At]]=w(Et,3);var Ut=void 0,Ht=void 0,Wt=Nt,Vt=qt,Gt=Lt,Yt=Pt,Zt=0,Jt=Wt.m,Xt=8,Kt=s(128,c);i:for(;u(Kt,0,7,Vt,19);){if(w(Jt,1)){var $t=2+2*w(Jt,3);if((Ut=2+w(Jt,$t))>Gt)break i}else Ut=Gt;for(Ht=0;Ht<Gt&&Ut--;){N(Jt);var Qt=Kt[0+(127&x(Jt))];L(Jt,Jt.u+Qt.g);var te=Qt.value;if(16>te)Yt[Ht++]=te,0!=te&&(Xt=te);else{var ee=16==te,re=te-16,ne=Yn[re],ie=w(Jt,Gn[re])+ne;if(Ht+ie>Gt)break i;for(var ae=ee?Xt:0;0<ie--;)Yt[Ht++]=ae}}Zt=1;break i}Zt||(Wt.a=3),Tt=Zt}(Tt=Tt&&!Et.h)&&(jt=u(It,Ct,8,Pt,Lt)),Tt&&0!=jt?zt=jt:(Nt.a=3,zt=0)}if(0==zt)break r;if(_t&&1==Jn[V]&&(_t=0==gt[G].g),yt+=gt[G].g,G+=zt,3>=V){var se,oe=pt[0];for(se=1;se<lt;++se)pt[se]>oe&&(oe=pt[se]);xt+=oe}}if(mt.nd=_t,mt.Qb=0,_t&&(mt.qb=(bt[3][vt[3]+0].value<<24|bt[1][vt[1]+0].value<<16|bt[2][vt[2]+0].value)>>>0,0==yt&&256>bt[0][vt[0]+0].value&&(mt.Qb=1,mt.qb+=bt[0][vt[0]+0].value<<8)),mt.jc=!mt.Qb&&6>xt,mt.jc){var he,le=mt;for(he=0;he<Rr;++he){var ue=he,ce=le.pd[ue],fe=le.G[0][le.H[0]+ue];256<=fe.value?(ce.g=fe.g+256,ce.value=fe.value):(ce.g=0,ce.value=0,ue>>=wt(fe,8,ce),ue>>=wt(le.G[1][le.H[1]+ue],16,ce),ue>>=wt(le.G[2][le.H[2]+ue],0,ce),wt(le.G[3][le.H[3]+ue],24,ce))}}}Q.vc=tt,Q.Wb=et,Q.Ya=dt,Q.yc=ut,H=1;break e}H=0}if(!(l=H)){o.a=3;break t}if(0<v){if(m.ua=1<<v,!E(m.Wa,v)){o.a=1,l=0;break t}}else m.ua=0;var de=o,pe=f,ge=p,me=de.s,be=me.xc;if(de.c=pe,de.i=ge,me.md=R(pe,be),me.wc=0==be?-1:(1<<be)-1,n){o.xb=di;break t}if(null==(b=a(f*p))){o.a=1,l=0;break t}l=(l=St(o,b,0,f,p,p,null))&&!g.h;break t}return l?(null!=h?h[0]=b:(e(null==b),e(n)),o.$=0,n||kt(m)):kt(m),l}function It(t,r){var n=t.c*t.i,i=n+r+16*r;return e(t.c<=r),t.V=a(i),null==t.V?(t.Ta=null,t.Ua=0,t.a=1,0):(t.Ta=t.V,t.Ua=t.Ba+n+r,1)}function Ct(t,r){var n=t.C,i=r-n,a=t.V,s=t.Ba+t.c*n;for(e(r<=t.l.o);0<i;){var o=16<i?16:i,h=t.l.ma,l=t.l.width,u=l*o,c=h.ca,f=h.tb+l*n,d=t.Ta,p=t.Ua;_t(t,o,a,s),Nn(d,p,c,f,u),Lt(h,n,n+o,c,f,l),i-=o,a+=o*t.c,n+=o}e(n==r),t.C=t.Ma=r}function jt(){this.ub=this.yd=this.td=this.Rb=0}function Et(){this.Kd=this.Ld=this.Ud=this.Td=this.i=this.c=0}function Ot(){this.Fb=this.Bb=this.Cb=0,this.Zb=a(4),this.Lb=a(4)}function Bt(){this.Yb=function(){var t=[];return function t(e,r,n){for(var i=n[r],a=0;a<i&&(e.push(n.length>r+1?[]:0),!(n.length<r+1));a++)t(e[a],r+1,n)}(t,0,[3,11]),t}()}function Mt(){this.jb=a(3),this.Wc=o([4,8],Bt),this.Xc=o([4,17],Bt)}function Rt(){this.Pc=this.wb=this.Tb=this.zd=0,this.vd=new a(4),this.od=new a(4)}function Tt(){this.ld=this.La=this.dd=this.tc=0}function qt(){this.Na=this.la=0}function Dt(){this.Sc=[0,0],this.Eb=[0,0],this.Qc=[0,0],this.ia=this.lc=0}function zt(){this.ad=a(384),this.Za=0,this.Ob=a(16),this.$b=this.Ad=this.ia=this.Gc=this.Hc=this.Dd=0}function Ut(){this.uc=this.M=this.Nb=0,this.wa=Array(new Tt),this.Y=0,this.ya=Array(new zt),this.aa=0,this.l=new Gt}function Ht(){this.y=a(16),this.f=a(8),this.ea=a(8)}function Wt(){this.cb=this.a=0,this.sc="",this.m=new y,this.Od=new jt,this.Kc=new Et,this.ed=new Rt,this.Qa=new Ot,this.Ic=this.$c=this.Aa=0,this.D=new Ut,this.Xb=this.Va=this.Hb=this.zb=this.yb=this.Ub=this.za=0,this.Jc=s(8,y),this.ia=0,this.pb=s(4,Dt),this.Pa=new Mt,this.Bd=this.kc=0,this.Ac=[],this.Bc=0,this.zc=[0,0,0,0],this.Gd=Array(new Ht),this.Hd=0,this.rb=Array(new qt),this.sb=0,this.wa=Array(new Tt),this.Y=0,this.oc=[],this.pc=0,this.sa=[],this.ta=0,this.qa=[],this.ra=0,this.Ha=[],this.B=this.R=this.Ia=0,this.Ec=[],this.M=this.ja=this.Vb=this.Fc=0,this.ya=Array(new zt),this.L=this.aa=0,this.gd=o([4,2],Tt),this.ga=null,this.Fa=[],this.Cc=this.qc=this.P=0,this.Gb=[],this.Uc=0,this.mb=[],this.nb=0,this.rc=[],this.Ga=this.Vc=0}function Vt(t,e){return 0>t?0:t>e?e:t}function Gt(){this.T=this.U=this.ka=this.height=this.width=0,this.y=[],this.f=[],this.ea=[],this.Rc=this.fa=this.W=this.N=this.O=0,this.ma="void",this.put="VP8IoPutHook",this.ac="VP8IoSetupHook",this.bc="VP8IoTeardownHook",this.ha=this.Kb=0,this.data=[],this.hb=this.ib=this.da=this.o=this.j=this.va=this.v=this.Da=this.ob=this.w=0,this.F=[],this.J=0}function Yt(){var t=new Wt;return null!=t&&(t.a=0,t.sc="OK",t.cb=0,t.Xb=0,ri||(ri=Kt)),t}function Zt(t,e,r){return 0==t.a&&(t.a=e,t.sc=r,t.cb=0),0}function Jt(t,e,r){return 3<=r&&157==t[e+0]&&1==t[e+1]&&42==t[e+2]}function Xt(t,r){if(null==t)return 0;if(t.a=0,t.sc="OK",null==r)return Zt(t,2,"null VP8Io passed to VP8GetHeaders()");var n=r.data,a=r.w,s=r.ha;if(4>s)return Zt(t,7,"Truncated header.");var o=n[a+0]|n[a+1]<<8|n[a+2]<<16,h=t.Od;if(h.Rb=!(1&o),h.td=o>>1&7,h.yd=o>>4&1,h.ub=o>>5,3<h.td)return Zt(t,3,"Incorrect keyframe parameters.");if(!h.yd)return Zt(t,4,"Frame not displayable.");a+=3,s-=3;var l=t.Kc;if(h.Rb){if(7>s)return Zt(t,7,"cannot parse picture header");if(!Jt(n,a,s))return Zt(t,3,"Bad code word");l.c=16383&(n[a+4]<<8|n[a+3]),l.Td=n[a+4]>>6,l.i=16383&(n[a+6]<<8|n[a+5]),l.Ud=n[a+6]>>6,a+=7,s-=7,t.za=l.c+15>>4,t.Ub=l.i+15>>4,r.width=l.c,r.height=l.i,r.Da=0,r.j=0,r.v=0,r.va=r.width,r.o=r.height,r.da=0,r.ib=r.width,r.hb=r.height,r.U=r.width,r.T=r.height,i((o=t.Pa).jb,0,255,o.jb.length),e(null!=(o=t.Qa)),o.Cb=0,o.Bb=0,o.Fb=1,i(o.Zb,0,0,o.Zb.length),i(o.Lb,0,0,o.Lb)}if(h.ub>s)return Zt(t,7,"bad partition length");p(o=t.m,n,a,h.ub),a+=h.ub,s-=h.ub,h.Rb&&(l.Ld=k(o),l.Kd=k(o)),l=t.Qa;var u,c=t.Pa;if(e(null!=o),e(null!=l),l.Cb=k(o),l.Cb){if(l.Bb=k(o),k(o)){for(l.Fb=k(o),u=0;4>u;++u)l.Zb[u]=k(o)?m(o,7):0;for(u=0;4>u;++u)l.Lb[u]=k(o)?m(o,6):0}if(l.Bb)for(u=0;3>u;++u)c.jb[u]=k(o)?g(o,8):255}else l.Bb=0;if(o.Ka)return Zt(t,3,"cannot parse segment header");if((l=t.ed).zd=k(o),l.Tb=g(o,6),l.wb=g(o,3),l.Pc=k(o),l.Pc&&k(o)){for(c=0;4>c;++c)k(o)&&(l.vd[c]=m(o,6));for(c=0;4>c;++c)k(o)&&(l.od[c]=m(o,6))}if(t.L=0==l.Tb?0:l.zd?1:2,o.Ka)return Zt(t,3,"cannot parse filter header");var f=s;if(s=u=a,a=u+f,l=f,t.Xb=(1<<g(t.m,2))-1,f<3*(c=t.Xb))n=7;else{for(u+=3*c,l-=3*c,f=0;f<c;++f){var d=n[s+0]|n[s+1]<<8|n[s+2]<<16;d>l&&(d=l),p(t.Jc[+f],n,u,d),u+=d,l-=d,s+=3}p(t.Jc[+c],n,u,l),n=u<a?0:5}if(0!=n)return Zt(t,n,"cannot parse partitions");for(n=g(u=t.m,7),s=k(u)?m(u,4):0,a=k(u)?m(u,4):0,l=k(u)?m(u,4):0,c=k(u)?m(u,4):0,u=k(u)?m(u,4):0,f=t.Qa,d=0;4>d;++d){if(f.Cb){var b=f.Zb[d];f.Fb||(b+=n)}else{if(0<d){t.pb[d]=t.pb[0];continue}b=n}var v=t.pb[d];v.Sc[0]=ti[Vt(b+s,127)],v.Sc[1]=ei[Vt(b+0,127)],v.Eb[0]=2*ti[Vt(b+a,127)],v.Eb[1]=101581*ei[Vt(b+l,127)]>>16,8>v.Eb[1]&&(v.Eb[1]=8),v.Qc[0]=ti[Vt(b+c,117)],v.Qc[1]=ei[Vt(b+u,127)],v.lc=b+u}if(!h.Rb)return Zt(t,4,"Not a key frame.");for(k(o),h=t.Pa,n=0;4>n;++n){for(s=0;8>s;++s)for(a=0;3>a;++a)for(l=0;11>l;++l)c=P(o,hi[n][s][a][l])?g(o,8):si[n][s][a][l],h.Wc[n][s].Yb[a][l]=c;for(s=0;17>s;++s)h.Xc[n][s]=h.Wc[n][li[s]]}return t.kc=k(o),t.kc&&(t.Bd=g(o,8)),t.cb=1}function Kt(t,e,r,n,i,a,s){var o=e[i].Yb[r];for(r=0;16>i;++i){if(!P(t,o[r+0]))return i;for(;!P(t,o[r+1]);)if(o=e[++i].Yb[0],r=0,16==i)return 16;var h=e[i+1].Yb;if(P(t,o[r+2])){var l=t,u=0;if(P(l,(f=o)[(c=r)+3]))if(P(l,f[c+6])){for(o=0,c=2*(u=P(l,f[c+8]))+(f=P(l,f[c+9+u])),u=0,f=ni[c];f[o];++o)u+=u+P(l,f[o]);u+=3+(8<<c)}else P(l,f[c+7])?(u=7+2*P(l,165),u+=P(l,145)):u=5+P(l,159);else u=P(l,f[c+4])?3+P(l,f[c+5]):2;o=h[2]}else u=1,o=h[1];h=s+ii[i],0>(l=t).b&&S(l);var c,f=l.b,d=(c=l.Ca>>1)-(l.I>>f)>>31;--l.b,l.Ca+=d,l.Ca|=1,l.I-=(c+1&d)<<f,a[h]=((u^d)-d)*n[(0<i)+0]}return 16}function $t(t){var e=t.rb[t.sb-1];e.la=0,e.Na=0,i(t.zc,0,0,t.zc.length),t.ja=0}function Qt(t,e,r,n,i){i=t[e+r+32*n]+(i>>3),t[e+r+32*n]=-256&i?0>i?0:255:i}function te(t,e,r,n,i,a){Qt(t,e,0,r,n+i),Qt(t,e,1,r,n+a),Qt(t,e,2,r,n-a),Qt(t,e,3,r,n-i)}function ee(t){return(20091*t>>16)+t}function re(t,e,r,n){var i,s=0,o=a(16);for(i=0;4>i;++i){var h=t[e+0]+t[e+8],l=t[e+0]-t[e+8],u=(35468*t[e+4]>>16)-ee(t[e+12]),c=ee(t[e+4])+(35468*t[e+12]>>16);o[s+0]=h+c,o[s+1]=l+u,o[s+2]=l-u,o[s+3]=h-c,s+=4,e++}for(i=s=0;4>i;++i)h=(t=o[s+0]+4)+o[s+8],l=t-o[s+8],u=(35468*o[s+4]>>16)-ee(o[s+12]),Qt(r,n,0,0,h+(c=ee(o[s+4])+(35468*o[s+12]>>16))),Qt(r,n,1,0,l+u),Qt(r,n,2,0,l-u),Qt(r,n,3,0,h-c),s++,n+=32}function ne(t,e,r,n){var i=t[e+0]+4,a=35468*t[e+4]>>16,s=ee(t[e+4]),o=35468*t[e+1]>>16;te(r,n,0,i+s,t=ee(t[e+1]),o),te(r,n,1,i+a,t,o),te(r,n,2,i-a,t,o),te(r,n,3,i-s,t,o)}function ie(t,e,r,n,i){re(t,e,r,n),i&&re(t,e+16,r,n+4)}function ae(t,e,r,n){an(t,e+0,r,n,1),an(t,e+32,r,n+128,1)}function se(t,e,r,n){var i;for(t=t[e+0]+4,i=0;4>i;++i)for(e=0;4>e;++e)Qt(r,n,e,i,t)}function oe(t,e,r,n){t[e+0]&&hn(t,e+0,r,n),t[e+16]&&hn(t,e+16,r,n+4),t[e+32]&&hn(t,e+32,r,n+128),t[e+48]&&hn(t,e+48,r,n+128+4)}function he(t,e,r,n){var i,s=a(16);for(i=0;4>i;++i){var o=t[e+0+i]+t[e+12+i],h=t[e+4+i]+t[e+8+i],l=t[e+4+i]-t[e+8+i],u=t[e+0+i]-t[e+12+i];s[0+i]=o+h,s[8+i]=o-h,s[4+i]=u+l,s[12+i]=u-l}for(i=0;4>i;++i)o=(t=s[0+4*i]+3)+s[3+4*i],h=s[1+4*i]+s[2+4*i],l=s[1+4*i]-s[2+4*i],u=t-s[3+4*i],r[n+0]=o+h>>3,r[n+16]=u+l>>3,r[n+32]=o-h>>3,r[n+48]=u-l>>3,n+=64}function le(t,e,r){var n,i=e-32,a=En,s=255-t[i-1];for(n=0;n<r;++n){var o,h=a,l=s+t[e-1];for(o=0;o<r;++o)t[e+o]=h[l+t[i+o]];e+=32}}function ue(t,e){le(t,e,4)}function ce(t,e){le(t,e,8)}function fe(t,e){le(t,e,16)}function de(t,e){var r;for(r=0;16>r;++r)n(t,e+32*r,t,e-32,16)}function pe(t,e){var r;for(r=16;0<r;--r)i(t,e,t[e-1],16),e+=32}function ge(t,e,r){var n;for(n=0;16>n;++n)i(e,r+32*n,t,16)}function me(t,e){var r,n=16;for(r=0;16>r;++r)n+=t[e-1+32*r]+t[e+r-32];ge(n>>5,t,e)}function be(t,e){var r,n=8;for(r=0;16>r;++r)n+=t[e-1+32*r];ge(n>>4,t,e)}function ve(t,e){var r,n=8;for(r=0;16>r;++r)n+=t[e+r-32];ge(n>>4,t,e)}function we(t,e){ge(128,t,e)}function ye(t,e,r){return t+2*e+r+2>>2}function _e(t,e){var r,i=e-32;for(i=new Uint8Array([ye(t[i-1],t[i+0],t[i+1]),ye(t[i+0],t[i+1],t[i+2]),ye(t[i+1],t[i+2],t[i+3]),ye(t[i+2],t[i+3],t[i+4])]),r=0;4>r;++r)n(t,e+32*r,i,0,i.length)}function xe(t,e){var r=t[e-1],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96];F(t,e+0,16843009*ye(t[e-1-32],r,n)),F(t,e+32,16843009*ye(r,n,i)),F(t,e+64,16843009*ye(n,i,a)),F(t,e+96,16843009*ye(i,a,a))}function Ae(t,e){var r,n=4;for(r=0;4>r;++r)n+=t[e+r-32]+t[e-1+32*r];for(n>>=3,r=0;4>r;++r)i(t,e+32*r,n,4)}function Le(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1-32],s=t[e+0-32],o=t[e+1-32],h=t[e+2-32],l=t[e+3-32];t[e+0+96]=ye(n,i,t[e-1+96]),t[e+1+96]=t[e+0+64]=ye(r,n,i),t[e+2+96]=t[e+1+64]=t[e+0+32]=ye(a,r,n),t[e+3+96]=t[e+2+64]=t[e+1+32]=t[e+0+0]=ye(s,a,r),t[e+3+64]=t[e+2+32]=t[e+1+0]=ye(o,s,a),t[e+3+32]=t[e+2+0]=ye(h,o,s),t[e+3+0]=ye(l,h,o)}function Ne(t,e){var r=t[e+1-32],n=t[e+2-32],i=t[e+3-32],a=t[e+4-32],s=t[e+5-32],o=t[e+6-32],h=t[e+7-32];t[e+0+0]=ye(t[e+0-32],r,n),t[e+1+0]=t[e+0+32]=ye(r,n,i),t[e+2+0]=t[e+1+32]=t[e+0+64]=ye(n,i,a),t[e+3+0]=t[e+2+32]=t[e+1+64]=t[e+0+96]=ye(i,a,s),t[e+3+32]=t[e+2+64]=t[e+1+96]=ye(a,s,o),t[e+3+64]=t[e+2+96]=ye(s,o,h),t[e+3+96]=ye(o,h,h)}function Se(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1-32],s=t[e+0-32],o=t[e+1-32],h=t[e+2-32],l=t[e+3-32];t[e+0+0]=t[e+1+64]=a+s+1>>1,t[e+1+0]=t[e+2+64]=s+o+1>>1,t[e+2+0]=t[e+3+64]=o+h+1>>1,t[e+3+0]=h+l+1>>1,t[e+0+96]=ye(i,n,r),t[e+0+64]=ye(n,r,a),t[e+0+32]=t[e+1+96]=ye(r,a,s),t[e+1+32]=t[e+2+96]=ye(a,s,o),t[e+2+32]=t[e+3+96]=ye(s,o,h),t[e+3+32]=ye(o,h,l)}function ke(t,e){var r=t[e+0-32],n=t[e+1-32],i=t[e+2-32],a=t[e+3-32],s=t[e+4-32],o=t[e+5-32],h=t[e+6-32],l=t[e+7-32];t[e+0+0]=r+n+1>>1,t[e+1+0]=t[e+0+64]=n+i+1>>1,t[e+2+0]=t[e+1+64]=i+a+1>>1,t[e+3+0]=t[e+2+64]=a+s+1>>1,t[e+0+32]=ye(r,n,i),t[e+1+32]=t[e+0+96]=ye(n,i,a),t[e+2+32]=t[e+1+96]=ye(i,a,s),t[e+3+32]=t[e+2+96]=ye(a,s,o),t[e+3+64]=ye(s,o,h),t[e+3+96]=ye(o,h,l)}function Pe(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96];t[e+0+0]=r+n+1>>1,t[e+2+0]=t[e+0+32]=n+i+1>>1,t[e+2+32]=t[e+0+64]=i+a+1>>1,t[e+1+0]=ye(r,n,i),t[e+3+0]=t[e+1+32]=ye(n,i,a),t[e+3+32]=t[e+1+64]=ye(i,a,a),t[e+3+64]=t[e+2+64]=t[e+0+96]=t[e+1+96]=t[e+2+96]=t[e+3+96]=a}function Fe(t,e){var r=t[e-1+0],n=t[e-1+32],i=t[e-1+64],a=t[e-1+96],s=t[e-1-32],o=t[e+0-32],h=t[e+1-32],l=t[e+2-32];t[e+0+0]=t[e+2+32]=r+s+1>>1,t[e+0+32]=t[e+2+64]=n+r+1>>1,t[e+0+64]=t[e+2+96]=i+n+1>>1,t[e+0+96]=a+i+1>>1,t[e+3+0]=ye(o,h,l),t[e+2+0]=ye(s,o,h),t[e+1+0]=t[e+3+32]=ye(r,s,o),t[e+1+32]=t[e+3+64]=ye(n,r,s),t[e+1+64]=t[e+3+96]=ye(i,n,r),t[e+1+96]=ye(a,i,n)}function Ie(t,e){var r;for(r=0;8>r;++r)n(t,e+32*r,t,e-32,8)}function Ce(t,e){var r;for(r=0;8>r;++r)i(t,e,t[e-1],8),e+=32}function je(t,e,r){var n;for(n=0;8>n;++n)i(e,r+32*n,t,8)}function Ee(t,e){var r,n=8;for(r=0;8>r;++r)n+=t[e+r-32]+t[e-1+32*r];je(n>>4,t,e)}function Oe(t,e){var r,n=4;for(r=0;8>r;++r)n+=t[e+r-32];je(n>>3,t,e)}function Be(t,e){var r,n=4;for(r=0;8>r;++r)n+=t[e-1+32*r];je(n>>3,t,e)}function Me(t,e){je(128,t,e)}function Re(t,e,r){var n=t[e-r],i=t[e+0],a=3*(i-n)+Cn[1020+t[e-2*r]-t[e+r]],s=jn[112+(a+4>>3)];t[e-r]=En[255+n+jn[112+(a+3>>3)]],t[e+0]=En[255+i-s]}function Te(t,e,r,n){var i=t[e+0],a=t[e+r];return On[255+t[e-2*r]-t[e-r]]>n||On[255+a-i]>n}function qe(t,e,r,n){return 4*On[255+t[e-r]-t[e+0]]+On[255+t[e-2*r]-t[e+r]]<=n}function De(t,e,r,n,i){var a=t[e-3*r],s=t[e-2*r],o=t[e-r],h=t[e+0],l=t[e+r],u=t[e+2*r],c=t[e+3*r];return 4*On[255+o-h]+On[255+s-l]>n?0:On[255+t[e-4*r]-a]<=i&&On[255+a-s]<=i&&On[255+s-o]<=i&&On[255+c-u]<=i&&On[255+u-l]<=i&&On[255+l-h]<=i}function ze(t,e,r,n){var i=2*n+1;for(n=0;16>n;++n)qe(t,e+n,r,i)&&Re(t,e+n,r)}function Ue(t,e,r,n){var i=2*n+1;for(n=0;16>n;++n)qe(t,e+n*r,1,i)&&Re(t,e+n*r,1)}function He(t,e,r,n){var i;for(i=3;0<i;--i)ze(t,e+=4*r,r,n)}function We(t,e,r,n){var i;for(i=3;0<i;--i)Ue(t,e+=4,r,n)}function Ve(t,e,r,n,i,a,s,o){for(a=2*a+1;0<i--;){if(De(t,e,r,a,s))if(Te(t,e,r,o))Re(t,e,r);else{var h=t,l=e,u=r,c=h[l-2*u],f=h[l-u],d=h[l+0],p=h[l+u],g=h[l+2*u],m=27*(v=Cn[1020+3*(d-f)+Cn[1020+c-p]])+63>>7,b=18*v+63>>7,v=9*v+63>>7;h[l-3*u]=En[255+h[l-3*u]+v],h[l-2*u]=En[255+c+b],h[l-u]=En[255+f+m],h[l+0]=En[255+d-m],h[l+u]=En[255+p-b],h[l+2*u]=En[255+g-v]}e+=n}}function Ge(t,e,r,n,i,a,s,o){for(a=2*a+1;0<i--;){if(De(t,e,r,a,s))if(Te(t,e,r,o))Re(t,e,r);else{var h=t,l=e,u=r,c=h[l-u],f=h[l+0],d=h[l+u],p=jn[112+(4+(g=3*(f-c))>>3)],g=jn[112+(g+3>>3)],m=p+1>>1;h[l-2*u]=En[255+h[l-2*u]+m],h[l-u]=En[255+c+g],h[l+0]=En[255+f-p],h[l+u]=En[255+d-m]}e+=n}}function Ye(t,e,r,n,i,a){Ve(t,e,r,1,16,n,i,a)}function Ze(t,e,r,n,i,a){Ve(t,e,1,r,16,n,i,a)}function Je(t,e,r,n,i,a){var s;for(s=3;0<s;--s)Ge(t,e+=4*r,r,1,16,n,i,a)}function Xe(t,e,r,n,i,a){var s;for(s=3;0<s;--s)Ge(t,e+=4,1,r,16,n,i,a)}function Ke(t,e,r,n,i,a,s,o){Ve(t,e,i,1,8,a,s,o),Ve(r,n,i,1,8,a,s,o)}function $e(t,e,r,n,i,a,s,o){Ve(t,e,1,i,8,a,s,o),Ve(r,n,1,i,8,a,s,o)}function Qe(t,e,r,n,i,a,s,o){Ge(t,e+4*i,i,1,8,a,s,o),Ge(r,n+4*i,i,1,8,a,s,o)}function tr(t,e,r,n,i,a,s,o){Ge(t,e+4,1,i,8,a,s,o),Ge(r,n+4,1,i,8,a,s,o)}function er(){this.ba=new st,this.ec=[],this.cc=[],this.Mc=[],this.Dc=this.Nc=this.dc=this.fc=0,this.Oa=new ht,this.memory=0,this.Ib="OutputFunc",this.Jb="OutputAlphaFunc",this.Nd="OutputRowFunc"}function rr(){this.data=[],this.offset=this.kd=this.ha=this.w=0,this.na=[],this.xa=this.gb=this.Ja=this.Sa=this.P=0}function nr(){this.nc=this.Ea=this.b=this.hc=0,this.K=[],this.w=0}function ir(){this.ua=0,this.Wa=new B,this.vb=new B,this.md=this.xc=this.wc=0,this.vc=[],this.Wb=0,this.Ya=new d,this.yc=new c}function ar(){this.xb=this.a=0,this.l=new Gt,this.ca=new st,this.V=[],this.Ba=0,this.Ta=[],this.Ua=0,this.m=new _,this.Pb=0,this.wd=new _,this.Ma=this.$=this.C=this.i=this.c=this.xd=0,this.s=new ir,this.ab=0,this.gc=s(4,nr),this.Oc=0}function sr(){this.Lc=this.Z=this.$a=this.i=this.c=0,this.l=new Gt,this.ic=0,this.ca=[],this.tb=0,this.qd=null,this.rd=0}function or(t,e,r,n,i,a,s){for(t=null==t?0:t[e+0],e=0;e<s;++e)i[a+e]=t+r[n+e]&255,t=i[a+e]}function hr(t,e,r,n,i,a,s){var o;if(null==t)or(null,null,r,n,i,a,s);else for(o=0;o<s;++o)i[a+o]=t[e+o]+r[n+o]&255}function lr(t,e,r,n,i,a,s){if(null==t)or(null,null,r,n,i,a,s);else{var o,h=t[e+0],l=h,u=h;for(o=0;o<s;++o)l=u+(h=t[e+o])-l,u=r[n+o]+(-256&l?0>l?0:255:l)&255,l=h,i[a+o]=u}}function ur(t,r,i,s){var o=r.width,h=r.o;if(e(null!=t&&null!=r),0>i||0>=s||i+s>h)return null;if(!t.Cc){if(null==t.ga){var l;if(t.ga=new sr,(l=null==t.ga)||(l=r.width*r.o,e(0==t.Gb.length),t.Gb=a(l),t.Uc=0,null==t.Gb?l=0:(t.mb=t.Gb,t.nb=t.Uc,t.rc=null,l=1),l=!l),!l){l=t.ga;var u=t.Fa,c=t.P,f=t.qc,d=t.mb,p=t.nb,g=c+1,m=f-1,v=l.l;if(e(null!=u&&null!=d&&null!=r),gi[0]=null,gi[1]=or,gi[2]=hr,gi[3]=lr,l.ca=d,l.tb=p,l.c=r.width,l.i=r.height,e(0<l.c&&0<l.i),1>=f)r=0;else if(l.$a=3&u[c+0],l.Z=u[c+0]>>2&3,l.Lc=u[c+0]>>4&3,c=u[c+0]>>6&3,0>l.$a||1<l.$a||4<=l.Z||1<l.Lc||c)r=0;else if(v.put=dt,v.ac=ft,v.bc=pt,v.ma=l,v.width=r.width,v.height=r.height,v.Da=r.Da,v.v=r.v,v.va=r.va,v.j=r.j,v.o=r.o,l.$a)t:{e(1==l.$a),r=Pt();e:for(;;){if(null==r){r=0;break t}if(e(null!=l),l.mc=r,r.c=l.c,r.i=l.i,r.l=l.l,r.l.ma=l,r.l.width=l.c,r.l.height=l.i,r.a=0,b(r.m,u,g,m),!Ft(l.c,l.i,1,r,null))break e;if(1==r.ab&&3==r.gc[0].hc&&At(r.s)?(l.ic=1,u=r.c*r.i,r.Ta=null,r.Ua=0,r.V=a(u),r.Ba=0,null==r.V?(r.a=1,r=0):r=1):(l.ic=0,r=It(r,l.c)),!r)break e;r=1;break t}l.mc=null,r=0}else r=m>=l.c*l.i;l=!r}if(l)return null;1!=t.ga.Lc?t.Ga=0:s=h-i}e(null!=t.ga),e(i+s<=h);t:{if(r=(u=t.ga).c,h=u.l.o,0==u.$a){if(g=t.rc,m=t.Vc,v=t.Fa,c=t.P+1+i*r,f=t.mb,d=t.nb+i*r,e(c<=t.P+t.qc),0!=u.Z)for(e(null!=gi[u.Z]),l=0;l<s;++l)gi[u.Z](g,m,v,c,f,d,r),g=f,m=d,d+=r,c+=r;else for(l=0;l<s;++l)n(f,d,v,c,r),g=f,m=d,d+=r,c+=r;t.rc=g,t.Vc=m}else{if(e(null!=u.mc),r=i+s,e(null!=(l=u.mc)),e(r<=l.i),l.C>=r)r=1;else if(u.ic||gr(),u.ic){u=l.V,g=l.Ba,m=l.c;var w=l.i,y=(v=1,c=l.$/m,f=l.$%m,d=l.m,p=l.s,l.$),_=m*w,x=m*r,L=p.wc,S=y<x?yt(p,f,c):null;e(y<=_),e(r<=w),e(At(p));e:for(;;){for(;!d.h&&y<x;){if(f&L||(S=yt(p,f,c)),e(null!=S),N(d),256>(w=vt(S.G[0],S.H[0],d)))u[g+y]=w,++y,++f>=m&&(f=0,++c<=r&&!(c%16)&&Nt(l,c));else{if(!(280>w)){v=0;break e}w=mt(w-256,d);var k,P=vt(S.G[4],S.H[4],d);if(N(d),!(y>=(P=bt(m,P=mt(P,d)))&&_-y>=w)){v=0;break e}for(k=0;k<w;++k)u[g+y+k]=u[g+y+k-P];for(y+=w,f+=w;f>=m;)f-=m,++c<=r&&!(c%16)&&Nt(l,c);y<x&&f&L&&(S=yt(p,f,c))}e(d.h==A(d))}Nt(l,c>r?r:c);break e}!v||d.h&&y<_?(v=0,l.a=d.h?5:3):l.$=y,r=v}else r=St(l,l.V,l.Ba,l.c,l.i,r,Ct);if(!r){s=0;break t}}i+s>=h&&(t.Cc=1),s=1}if(!s)return null;if(t.Cc&&(null!=(s=t.ga)&&(s.mc=null),t.ga=null,0<t.Ga))return alert("todo:WebPDequantizeLevels"),null}return t.nb+i*o}function cr(t,e,r,n,i,a){for(;0<i--;){var s,o=t,h=e+(r?1:0),l=t,u=e+(r?0:3);for(s=0;s<n;++s){var c=l[u+4*s];255!=c&&(c*=32897,o[h+4*s+0]=o[h+4*s+0]*c>>23,o[h+4*s+1]=o[h+4*s+1]*c>>23,o[h+4*s+2]=o[h+4*s+2]*c>>23)}e+=a}}function fr(t,e,r,n,i){for(;0<n--;){var a;for(a=0;a<r;++a){var s=t[e+2*a+0],o=15&(l=t[e+2*a+1]),h=4369*o,l=(240&l|l>>4)*h>>16;t[e+2*a+0]=(240&s|s>>4)*h>>16&240|(15&s|s<<4)*h>>16>>4&15,t[e+2*a+1]=240&l|o}e+=i}}function dr(t,e,r,n,i,a,s,o){var h,l,u=255;for(l=0;l<i;++l){for(h=0;h<n;++h){var c=t[e+h];a[s+4*h]=c,u&=c}e+=r,s+=o}return 255!=u}function pr(t,e,r,n,i){var a;for(a=0;a<i;++a)r[n+a]=t[e+a]>>8}function gr(){xn=cr,An=fr,Ln=dr,Nn=pr}function mr(r,n,i){t[r]=function(t,r,a,s,o,h,l,u,c,f,d,p,g,m,b,v,w){var y,_=w-1>>1,x=o[h+0]|l[u+0]<<16,A=c[f+0]|d[p+0]<<16;e(null!=t);var L=3*x+A+131074>>2;for(n(t[r+0],255&L,L>>16,g,m),null!=a&&(L=3*A+x+131074>>2,n(a[s+0],255&L,L>>16,b,v)),y=1;y<=_;++y){var N=o[h+y]|l[u+y]<<16,S=c[f+y]|d[p+y]<<16,k=x+N+A+S+524296,P=k+2*(N+A)>>3;L=P+x>>1,x=(k=k+2*(x+S)>>3)+N>>1,n(t[r+2*y-1],255&L,L>>16,g,m+(2*y-1)*i),n(t[r+2*y-0],255&x,x>>16,g,m+(2*y-0)*i),null!=a&&(L=k+A>>1,x=P+S>>1,n(a[s+2*y-1],255&L,L>>16,b,v+(2*y-1)*i),n(a[s+2*y+0],255&x,x>>16,b,v+(2*y+0)*i)),x=N,A=S}1&w||(L=3*x+A+131074>>2,n(t[r+w-1],255&L,L>>16,g,m+(w-1)*i),null!=a&&(L=3*A+x+131074>>2,n(a[s+w-1],255&L,L>>16,b,v+(w-1)*i)))}}function br(){mi[Bn]=bi,mi[Mn]=wi,mi[Rn]=vi,mi[Tn]=yi,mi[qn]=_i,mi[Dn]=xi,mi[zn]=Ai,mi[Un]=wi,mi[Hn]=yi,mi[Wn]=_i,mi[Vn]=xi}function vr(t){return t&~Fi?0>t?0:255:t>>Pi}function wr(t,e){return vr((19077*t>>8)+(26149*e>>8)-14234)}function yr(t,e,r){return vr((19077*t>>8)-(6419*e>>8)-(13320*r>>8)+8708)}function _r(t,e){return vr((19077*t>>8)+(33050*e>>8)-17685)}function xr(t,e,r,n,i){n[i+0]=wr(t,r),n[i+1]=yr(t,e,r),n[i+2]=_r(t,e)}function Ar(t,e,r,n,i){n[i+0]=_r(t,e),n[i+1]=yr(t,e,r),n[i+2]=wr(t,r)}function Lr(t,e,r,n,i){var a=yr(t,e,r);e=a<<3&224|_r(t,e)>>3,n[i+0]=248&wr(t,r)|a>>5,n[i+1]=e}function Nr(t,e,r,n,i){var a=240&_r(t,e)|15;n[i+0]=240&wr(t,r)|yr(t,e,r)>>4,n[i+1]=a}function Sr(t,e,r,n,i){n[i+0]=255,xr(t,e,r,n,i+1)}function kr(t,e,r,n,i){Ar(t,e,r,n,i),n[i+3]=255}function Pr(t,e,r,n,i){xr(t,e,r,n,i),n[i+3]=255}function Fr(e,r,n){t[e]=function(t,e,i,a,s,o,h,l,u){for(var c=l+(-2&u)*n;l!=c;)r(t[e+0],i[a+0],s[o+0],h,l),r(t[e+1],i[a+0],s[o+0],h,l+n),e+=2,++a,++o,l+=2*n;1&u&&r(t[e+0],i[a+0],s[o+0],h,l)}}function Ir(t,e,r){return 0==r?0==t?0==e?6:5:0==e?4:0:r}function Cr(t,e,r,n,i){switch(t>>>30){case 3:an(e,r,n,i,0);break;case 2:sn(e,r,n,i);break;case 1:hn(e,r,n,i)}}function jr(t,e){var r,a,s=e.M,o=e.Nb,h=t.oc,l=t.pc+40,u=t.oc,c=t.pc+584,f=t.oc,d=t.pc+600;for(r=0;16>r;++r)h[l+32*r-1]=129;for(r=0;8>r;++r)u[c+32*r-1]=129,f[d+32*r-1]=129;for(0<s?h[l-1-32]=u[c-1-32]=f[d-1-32]=129:(i(h,l-32-1,127,21),i(u,c-32-1,127,9),i(f,d-32-1,127,9)),a=0;a<t.za;++a){var p=e.ya[e.aa+a];if(0<a){for(r=-1;16>r;++r)n(h,l+32*r-4,h,l+32*r+12,4);for(r=-1;8>r;++r)n(u,c+32*r-4,u,c+32*r+4,4),n(f,d+32*r-4,f,d+32*r+4,4)}var g=t.Gd,m=t.Hd+a,b=p.ad,v=p.Hc;if(0<s&&(n(h,l-32,g[m].y,0,16),n(u,c-32,g[m].f,0,8),n(f,d-32,g[m].ea,0,8)),p.Za){var w=h,y=l-32+16;for(0<s&&(a>=t.za-1?i(w,y,g[m].y[15],4):n(w,y,g[m+1].y,0,4)),r=0;4>r;r++)w[y+128+r]=w[y+256+r]=w[y+384+r]=w[y+0+r];for(r=0;16>r;++r,v<<=2)w=h,y=l+Ri[r],ci[p.Ob[r]](w,y),Cr(v,b,16*+r,w,y)}else if(w=Ir(a,s,p.Ob[0]),ui[w](h,l),0!=v)for(r=0;16>r;++r,v<<=2)Cr(v,b,16*+r,h,l+Ri[r]);for(r=p.Gc,w=Ir(a,s,p.Dd),fi[w](u,c),fi[w](f,d),v=b,w=u,y=c,255&(p=0|r)&&(170&p?on(v,256,w,y):ln(v,256,w,y)),p=f,v=d,255&(r>>=8)&&(170&r?on(b,320,p,v):ln(b,320,p,v)),s<t.Ub-1&&(n(g[m].y,0,h,l+480,16),n(g[m].f,0,u,c+224,8),n(g[m].ea,0,f,d+224,8)),r=8*o*t.B,g=t.sa,m=t.ta+16*a+16*o*t.R,b=t.qa,p=t.ra+8*a+r,v=t.Ha,w=t.Ia+8*a+r,r=0;16>r;++r)n(g,m+r*t.R,h,l+32*r,16);for(r=0;8>r;++r)n(b,p+r*t.B,u,c+32*r,8),n(v,w+r*t.B,f,d+32*r,8)}}function Er(t,n,i,a,s,o,h,l,u){var c=[0],f=[0],d=0,p=null!=u?u.kd:0,g=null!=u?u:new rr;if(null==t||12>i)return 7;g.data=t,g.w=n,g.ha=i,n=[n],i=[i],g.gb=[g.gb];t:{var m=n,v=i,w=g.gb;if(e(null!=t),e(null!=v),e(null!=w),w[0]=0,12<=v[0]&&!r(t,m[0],"RIFF")){if(r(t,m[0]+8,"WEBP")){w=3;break t}var y=j(t,m[0]+4);if(12>y||4294967286<y){w=3;break t}if(p&&y>v[0]-8){w=7;break t}w[0]=y,m[0]+=12,v[0]-=12}w=0}if(0!=w)return w;for(y=0<g.gb[0],i=i[0];;){t:{var x=t;v=n,w=i;var A=c,L=f,N=m=[0];if((P=d=[d])[0]=0,8>w[0])w=7;else{if(!r(x,v[0],"VP8X")){if(10!=j(x,v[0]+4)){w=3;break t}if(18>w[0]){w=7;break t}var S=j(x,v[0]+8),k=1+C(x,v[0]+12);if(2147483648<=k*(x=1+C(x,v[0]+15))){w=3;break t}null!=N&&(N[0]=S),null!=A&&(A[0]=k),null!=L&&(L[0]=x),v[0]+=18,w[0]-=18,P[0]=1}w=0}}if(d=d[0],m=m[0],0!=w)return w;if(v=!!(2&m),!y&&d)return 3;if(null!=o&&(o[0]=!!(16&m)),null!=h&&(h[0]=v),null!=l&&(l[0]=0),h=c[0],m=f[0],d&&v&&null==u){w=0;break}if(4>i){w=7;break}if(y&&d||!y&&!d&&!r(t,n[0],"ALPH")){i=[i],g.na=[g.na],g.P=[g.P],g.Sa=[g.Sa];t:{S=t,w=n,y=i;var P=g.gb;A=g.na,L=g.P,N=g.Sa,k=22,e(null!=S),e(null!=y),x=w[0];var F=y[0];for(e(null!=A),e(null!=N),A[0]=null,L[0]=null,N[0]=0;;){if(w[0]=x,y[0]=F,8>F){w=7;break t}var I=j(S,x+4);if(4294967286<I){w=3;break t}var E=8+I+1&-2;if(k+=E,0<P&&k>P){w=3;break t}if(!r(S,x,"VP8 ")||!r(S,x,"VP8L")){w=0;break t}if(F[0]<E){w=7;break t}r(S,x,"ALPH")||(A[0]=S,L[0]=x+8,N[0]=I),x+=E,F-=E}}if(i=i[0],g.na=g.na[0],g.P=g.P[0],g.Sa=g.Sa[0],0!=w)break}i=[i],g.Ja=[g.Ja],g.xa=[g.xa];t:if(P=t,w=n,y=i,A=g.gb[0],L=g.Ja,N=g.xa,S=w[0],x=!r(P,S,"VP8 "),k=!r(P,S,"VP8L"),e(null!=P),e(null!=y),e(null!=L),e(null!=N),8>y[0])w=7;else{if(x||k){if(P=j(P,S+4),12<=A&&P>A-12){w=3;break t}if(p&&P>y[0]-8){w=7;break t}L[0]=P,w[0]+=8,y[0]-=8,N[0]=k}else N[0]=5<=y[0]&&47==P[S+0]&&!(P[S+4]>>5),L[0]=y[0];w=0}if(i=i[0],g.Ja=g.Ja[0],g.xa=g.xa[0],n=n[0],0!=w)break;if(4294967286<g.Ja)return 3;if(null==l||v||(l[0]=g.xa?2:1),h=[h],m=[m],g.xa){if(5>i){w=7;break}l=h,p=m,v=o,null==t||5>i?t=0:5<=i&&47==t[n+0]&&!(t[n+4]>>5)?(y=[0],P=[0],A=[0],b(L=new _,t,n,i),gt(L,y,P,A)?(null!=l&&(l[0]=y[0]),null!=p&&(p[0]=P[0]),null!=v&&(v[0]=A[0]),t=1):t=0):t=0}else{if(10>i){w=7;break}l=m,null==t||10>i||!Jt(t,n+3,i-3)?t=0:(p=t[n+0]|t[n+1]<<8|t[n+2]<<16,v=16383&(t[n+7]<<8|t[n+6]),t=16383&(t[n+9]<<8|t[n+8]),1&p||3<(p>>1&7)||!(p>>4&1)||p>>5>=g.Ja||!v||!t?t=0:(h&&(h[0]=v),l&&(l[0]=t),t=1))}if(!t)return 3;if(h=h[0],m=m[0],d&&(c[0]!=h||f[0]!=m))return 3;null!=u&&(u[0]=g,u.offset=n-u.w,e(4294967286>n-u.w),e(u.offset==u.ha-i));break}return 0==w||7==w&&d&&null==u?(null!=o&&(o[0]|=null!=g.na&&0<g.na.length),null!=a&&(a[0]=h),null!=s&&(s[0]=m),0):w}function Or(t,e,r){var n=e.width,i=e.height,a=0,s=0,o=n,h=i;if(e.Da=null!=t&&0<t.Da,e.Da&&(o=t.cd,h=t.bd,a=t.v,s=t.j,11>r||(a&=-2,s&=-2),0>a||0>s||0>=o||0>=h||a+o>n||s+h>i))return 0;if(e.v=a,e.j=s,e.va=a+o,e.o=s+h,e.U=o,e.T=h,e.da=null!=t&&0<t.da,e.da){if(!M(o,h,r=[t.ib],a=[t.hb]))return 0;e.ib=r[0],e.hb=a[0]}return e.ob=null!=t&&t.ob,e.Kb=null==t||!t.Sd,e.da&&(e.ob=e.ib<3*n/4&&e.hb<3*i/4,e.Kb=0),1}function Br(t){if(null==t)return 2;if(11>t.S){var e=t.f.RGBA;e.fb+=(t.height-1)*e.A,e.A=-e.A}else e=t.f.kb,t=t.height,e.O+=(t-1)*e.fa,e.fa=-e.fa,e.N+=(t-1>>1)*e.Ab,e.Ab=-e.Ab,e.W+=(t-1>>1)*e.Db,e.Db=-e.Db,null!=e.F&&(e.J+=(t-1)*e.lb,e.lb=-e.lb);return 0}function Mr(t,e,r,n){if(null==n||0>=t||0>=e)return 2;if(null!=r){if(r.Da){var i=r.cd,s=r.bd,o=-2&r.v,h=-2&r.j;if(0>o||0>h||0>=i||0>=s||o+i>t||h+s>e)return 2;t=i,e=s}if(r.da){if(!M(t,e,i=[r.ib],s=[r.hb]))return 2;t=i[0],e=s[0]}}n.width=t,n.height=e;t:{var l=n.width,u=n.height;if(t=n.S,0>=l||0>=u||!(t>=Bn&&13>t))t=2;else{if(0>=n.Rd&&null==n.sd){o=s=i=e=0;var c=(h=l*zi[t])*u;if(11>t||(s=(u+1)/2*(e=(l+1)/2),12==t&&(o=(i=l)*u)),null==(u=a(c+2*s+o))){t=1;break t}n.sd=u,11>t?((l=n.f.RGBA).eb=u,l.fb=0,l.A=h,l.size=c):((l=n.f.kb).y=u,l.O=0,l.fa=h,l.Fd=c,l.f=u,l.N=0+c,l.Ab=e,l.Cd=s,l.ea=u,l.W=0+c+s,l.Db=e,l.Ed=s,12==t&&(l.F=u,l.J=0+c+2*s),l.Tc=o,l.lb=i)}if(e=1,i=n.S,s=n.width,o=n.height,i>=Bn&&13>i)if(11>i)t=n.f.RGBA,e&=(h=Math.abs(t.A))*(o-1)+s<=t.size,e&=h>=s*zi[i],e&=null!=t.eb;else{t=n.f.kb,h=(s+1)/2,c=(o+1)/2,l=Math.abs(t.fa),u=Math.abs(t.Ab);var f=Math.abs(t.Db),d=Math.abs(t.lb),p=d*(o-1)+s;e&=l*(o-1)+s<=t.Fd,e&=u*(c-1)+h<=t.Cd,e=(e&=f*(c-1)+h<=t.Ed)&l>=s&u>=h&f>=h,e&=null!=t.y,e&=null!=t.f,e&=null!=t.ea,12==i&&(e&=d>=s,e&=p<=t.Tc,e&=null!=t.F)}else e=0;t=e?0:2}}return 0!=t||null!=r&&r.fd&&(t=Br(n)),t}var Rr=64,Tr=[0,1,3,7,15,31,63,127,255,511,1023,2047,4095,8191,16383,32767,65535,131071,262143,524287,1048575,2097151,4194303,8388607,16777215],qr=24,Dr=32,zr=8,Ur=[0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7];q("Predictor0","PredictorAdd0"),t.Predictor0=function(){return 4278190080},t.Predictor1=function(t){return t},t.Predictor2=function(t,e,r){return e[r+0]},t.Predictor3=function(t,e,r){return e[r+1]},t.Predictor4=function(t,e,r){return e[r-1]},t.Predictor5=function(t,e,r){return z(z(t,e[r+1]),e[r+0])},t.Predictor6=function(t,e,r){return z(t,e[r-1])},t.Predictor7=function(t,e,r){return z(t,e[r+0])},t.Predictor8=function(t,e,r){return z(e[r-1],e[r+0])},t.Predictor9=function(t,e,r){return z(e[r+0],e[r+1])},t.Predictor10=function(t,e,r){return z(z(t,e[r-1]),z(e[r+0],e[r+1]))},t.Predictor11=function(t,e,r){var n=e[r+0];return 0>=W(n>>24&255,t>>24&255,(e=e[r-1])>>24&255)+W(n>>16&255,t>>16&255,e>>16&255)+W(n>>8&255,t>>8&255,e>>8&255)+W(255&n,255&t,255&e)?n:t},t.Predictor12=function(t,e,r){var n=e[r+0];return(U((t>>24&255)+(n>>24&255)-((e=e[r-1])>>24&255))<<24|U((t>>16&255)+(n>>16&255)-(e>>16&255))<<16|U((t>>8&255)+(n>>8&255)-(e>>8&255))<<8|U((255&t)+(255&n)-(255&e)))>>>0},t.Predictor13=function(t,e,r){var n=e[r-1];return(H((t=z(t,e[r+0]))>>24&255,n>>24&255)<<24|H(t>>16&255,n>>16&255)<<16|H(t>>8&255,n>>8&255)<<8|H(255&t,255&n))>>>0};var Hr=t.PredictorAdd0;t.PredictorAdd1=V,q("Predictor2","PredictorAdd2"),q("Predictor3","PredictorAdd3"),q("Predictor4","PredictorAdd4"),q("Predictor5","PredictorAdd5"),q("Predictor6","PredictorAdd6"),q("Predictor7","PredictorAdd7"),q("Predictor8","PredictorAdd8"),q("Predictor9","PredictorAdd9"),q("Predictor10","PredictorAdd10"),q("Predictor11","PredictorAdd11"),q("Predictor12","PredictorAdd12"),q("Predictor13","PredictorAdd13");var Wr=t.PredictorAdd2;J("ColorIndexInverseTransform","MapARGB","32b",function(t){return t>>8&255},function(t){return t}),J("VP8LColorIndexInverseTransformAlpha","MapAlpha","8b",function(t){return t},function(t){return t>>8&255});var Vr,Gr=t.ColorIndexInverseTransform,Yr=t.MapARGB,Zr=t.VP8LColorIndexInverseTransformAlpha,Jr=t.MapAlpha,Xr=t.VP8LPredictorsAdd=[];Xr.length=16,(t.VP8LPredictors=[]).length=16,(t.VP8LPredictorsAdd_C=[]).length=16,(t.VP8LPredictors_C=[]).length=16;var Kr,$r,Qr,tn,en,rn,nn,an,sn,on,hn,ln,un,cn,fn,dn,pn,gn,mn,bn,vn,wn,yn,_n,xn,An,Ln,Nn,Sn=a(511),kn=a(2041),Pn=a(225),Fn=a(767),In=0,Cn=kn,jn=Pn,En=Fn,On=Sn,Bn=0,Mn=1,Rn=2,Tn=3,qn=4,Dn=5,zn=6,Un=7,Hn=8,Wn=9,Vn=10,Gn=[2,3,7],Yn=[3,3,11],Zn=[280,256,256,256,40],Jn=[0,1,1,1,0],Xn=[17,18,0,1,2,3,4,5,16,6,7,8,9,10,11,12,13,14,15],Kn=[24,7,23,25,40,6,39,41,22,26,38,42,56,5,55,57,21,27,54,58,37,43,72,4,71,73,20,28,53,59,70,74,36,44,88,69,75,52,60,3,87,89,19,29,86,90,35,45,68,76,85,91,51,61,104,2,103,105,18,30,102,106,34,46,84,92,67,77,101,107,50,62,120,1,119,121,83,93,17,31,100,108,66,78,118,122,33,47,117,123,49,63,99,109,82,94,0,116,124,65,79,16,32,98,110,48,115,125,81,95,64,114,126,97,111,80,113,127,96,112],$n=[2954,2956,2958,2962,2970,2986,3018,3082,3212,3468,3980,5004],Qn=8,ti=[4,5,6,7,8,9,10,10,11,12,13,14,15,16,17,17,18,19,20,20,21,21,22,22,23,23,24,25,25,26,27,28,29,30,31,32,33,34,35,36,37,37,38,39,40,41,42,43,44,45,46,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,76,77,78,79,80,81,82,83,84,85,86,87,88,89,91,93,95,96,98,100,101,102,104,106,108,110,112,114,116,118,122,124,126,128,130,132,134,136,138,140,143,145,148,151,154,157],ei=[4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,119,122,125,128,131,134,137,140,143,146,149,152,155,158,161,164,167,170,173,177,181,185,189,193,197,201,205,209,213,217,221,225,229,234,239,245,249,254,259,264,269,274,279,284],ri=null,ni=[[173,148,140,0],[176,155,140,135,0],[180,157,141,134,130,0],[254,254,243,230,196,177,153,140,133,130,129,0]],ii=[0,1,4,8,5,2,3,6,9,12,13,10,7,11,14,15],ai=[-0,1,-1,2,-2,3,4,6,-3,5,-4,-5,-6,7,-7,8,-8,-9],si=[[[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]],[[253,136,254,255,228,219,128,128,128,128,128],[189,129,242,255,227,213,255,219,128,128,128],[106,126,227,252,214,209,255,255,128,128,128]],[[1,98,248,255,236,226,255,255,128,128,128],[181,133,238,254,221,234,255,154,128,128,128],[78,134,202,247,198,180,255,219,128,128,128]],[[1,185,249,255,243,255,128,128,128,128,128],[184,150,247,255,236,224,128,128,128,128,128],[77,110,216,255,236,230,128,128,128,128,128]],[[1,101,251,255,241,255,128,128,128,128,128],[170,139,241,252,236,209,255,255,128,128,128],[37,116,196,243,228,255,255,255,128,128,128]],[[1,204,254,255,245,255,128,128,128,128,128],[207,160,250,255,238,128,128,128,128,128,128],[102,103,231,255,211,171,128,128,128,128,128]],[[1,152,252,255,240,255,128,128,128,128,128],[177,135,243,255,234,225,128,128,128,128,128],[80,129,211,255,194,224,128,128,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[246,1,255,128,128,128,128,128,128,128,128],[255,128,128,128,128,128,128,128,128,128,128]]],[[[198,35,237,223,193,187,162,160,145,155,62],[131,45,198,221,172,176,220,157,252,221,1],[68,47,146,208,149,167,221,162,255,223,128]],[[1,149,241,255,221,224,255,255,128,128,128],[184,141,234,253,222,220,255,199,128,128,128],[81,99,181,242,176,190,249,202,255,255,128]],[[1,129,232,253,214,197,242,196,255,255,128],[99,121,210,250,201,198,255,202,128,128,128],[23,91,163,242,170,187,247,210,255,255,128]],[[1,200,246,255,234,255,128,128,128,128,128],[109,178,241,255,231,245,255,255,128,128,128],[44,130,201,253,205,192,255,255,128,128,128]],[[1,132,239,251,219,209,255,165,128,128,128],[94,136,225,251,218,190,255,255,128,128,128],[22,100,174,245,186,161,255,199,128,128,128]],[[1,182,249,255,232,235,128,128,128,128,128],[124,143,241,255,227,234,128,128,128,128,128],[35,77,181,251,193,211,255,205,128,128,128]],[[1,157,247,255,236,231,255,255,128,128,128],[121,141,235,255,225,227,255,255,128,128,128],[45,99,188,251,195,217,255,224,128,128,128]],[[1,1,251,255,213,255,128,128,128,128,128],[203,1,248,255,255,128,128,128,128,128,128],[137,1,177,255,224,255,128,128,128,128,128]]],[[[253,9,248,251,207,208,255,192,128,128,128],[175,13,224,243,193,185,249,198,255,255,128],[73,17,171,221,161,179,236,167,255,234,128]],[[1,95,247,253,212,183,255,255,128,128,128],[239,90,244,250,211,209,255,255,128,128,128],[155,77,195,248,188,195,255,255,128,128,128]],[[1,24,239,251,218,219,255,205,128,128,128],[201,51,219,255,196,186,128,128,128,128,128],[69,46,190,239,201,218,255,228,128,128,128]],[[1,191,251,255,255,128,128,128,128,128,128],[223,165,249,255,213,255,128,128,128,128,128],[141,124,248,255,255,128,128,128,128,128,128]],[[1,16,248,255,255,128,128,128,128,128,128],[190,36,230,255,236,255,128,128,128,128,128],[149,1,255,128,128,128,128,128,128,128,128]],[[1,226,255,128,128,128,128,128,128,128,128],[247,192,255,128,128,128,128,128,128,128,128],[240,128,255,128,128,128,128,128,128,128,128]],[[1,134,252,255,255,128,128,128,128,128,128],[213,62,250,255,255,128,128,128,128,128,128],[55,93,255,128,128,128,128,128,128,128,128]],[[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128],[128,128,128,128,128,128,128,128,128,128,128]]],[[[202,24,213,235,186,191,220,160,240,175,255],[126,38,182,232,169,184,228,174,255,187,128],[61,46,138,219,151,178,240,170,255,216,128]],[[1,112,230,250,199,191,247,159,255,255,128],[166,109,228,252,211,215,255,174,128,128,128],[39,77,162,232,172,180,245,178,255,255,128]],[[1,52,220,246,198,199,249,220,255,255,128],[124,74,191,243,183,193,250,221,255,255,128],[24,71,130,219,154,170,243,182,255,255,128]],[[1,182,225,249,219,240,255,224,128,128,128],[149,150,226,252,216,205,255,171,128,128,128],[28,108,170,242,183,194,254,223,255,255,128]],[[1,81,230,252,204,203,255,192,128,128,128],[123,102,209,247,188,196,255,233,128,128,128],[20,95,153,243,164,173,255,203,128,128,128]],[[1,222,248,255,216,213,128,128,128,128,128],[168,175,246,252,235,205,255,255,128,128,128],[47,116,215,255,211,212,255,255,128,128,128]],[[1,121,236,253,212,214,255,255,128,128,128],[141,84,213,252,201,202,255,219,128,128,128],[42,80,160,240,162,185,255,205,128,128,128]],[[1,1,255,128,128,128,128,128,128,128,128],[244,1,255,128,128,128,128,128,128,128,128],[238,1,255,128,128,128,128,128,128,128,128]]]],oi=[[[231,120,48,89,115,113,120,152,112],[152,179,64,126,170,118,46,70,95],[175,69,143,80,85,82,72,155,103],[56,58,10,171,218,189,17,13,152],[114,26,17,163,44,195,21,10,173],[121,24,80,195,26,62,44,64,85],[144,71,10,38,171,213,144,34,26],[170,46,55,19,136,160,33,206,71],[63,20,8,114,114,208,12,9,226],[81,40,11,96,182,84,29,16,36]],[[134,183,89,137,98,101,106,165,148],[72,187,100,130,157,111,32,75,80],[66,102,167,99,74,62,40,234,128],[41,53,9,178,241,141,26,8,107],[74,43,26,146,73,166,49,23,157],[65,38,105,160,51,52,31,115,128],[104,79,12,27,217,255,87,17,7],[87,68,71,44,114,51,15,186,23],[47,41,14,110,182,183,21,17,194],[66,45,25,102,197,189,23,18,22]],[[88,88,147,150,42,46,45,196,205],[43,97,183,117,85,38,35,179,61],[39,53,200,87,26,21,43,232,171],[56,34,51,104,114,102,29,93,77],[39,28,85,171,58,165,90,98,64],[34,22,116,206,23,34,43,166,73],[107,54,32,26,51,1,81,43,31],[68,25,106,22,64,171,36,225,114],[34,19,21,102,132,188,16,76,124],[62,18,78,95,85,57,50,48,51]],[[193,101,35,159,215,111,89,46,111],[60,148,31,172,219,228,21,18,111],[112,113,77,85,179,255,38,120,114],[40,42,1,196,245,209,10,25,109],[88,43,29,140,166,213,37,43,154],[61,63,30,155,67,45,68,1,209],[100,80,8,43,154,1,51,26,71],[142,78,78,16,255,128,34,197,171],[41,40,5,102,211,183,4,1,221],[51,50,17,168,209,192,23,25,82]],[[138,31,36,171,27,166,38,44,229],[67,87,58,169,82,115,26,59,179],[63,59,90,180,59,166,93,73,154],[40,40,21,116,143,209,34,39,175],[47,15,16,183,34,223,49,45,183],[46,17,33,183,6,98,15,32,183],[57,46,22,24,128,1,54,17,37],[65,32,73,115,28,128,23,128,205],[40,3,9,115,51,192,18,6,223],[87,37,9,115,59,77,64,21,47]],[[104,55,44,218,9,54,53,130,226],[64,90,70,205,40,41,23,26,57],[54,57,112,184,5,41,38,166,213],[30,34,26,133,152,116,10,32,134],[39,19,53,221,26,114,32,73,255],[31,9,65,234,2,15,1,118,73],[75,32,12,51,192,255,160,43,51],[88,31,35,67,102,85,55,186,85],[56,21,23,111,59,205,45,37,192],[55,38,70,124,73,102,1,34,98]],[[125,98,42,88,104,85,117,175,82],[95,84,53,89,128,100,113,101,45],[75,79,123,47,51,128,81,171,1],[57,17,5,71,102,57,53,41,49],[38,33,13,121,57,73,26,1,85],[41,10,67,138,77,110,90,47,114],[115,21,2,10,102,255,166,23,6],[101,29,16,10,85,128,101,196,26],[57,18,10,102,102,213,34,20,43],[117,20,15,36,163,128,68,1,26]],[[102,61,71,37,34,53,31,243,192],[69,60,71,38,73,119,28,222,37],[68,45,128,34,1,47,11,245,171],[62,17,19,70,146,85,55,62,70],[37,43,37,154,100,163,85,160,1],[63,9,92,136,28,64,32,201,85],[75,15,9,9,64,255,184,119,16],[86,6,28,5,64,255,25,248,1],[56,8,17,132,137,255,55,116,128],[58,15,20,82,135,57,26,121,40]],[[164,50,31,137,154,133,25,35,218],[51,103,44,131,131,123,31,6,158],[86,40,64,135,148,224,45,183,128],[22,26,17,131,240,154,14,1,209],[45,16,21,91,64,222,7,1,197],[56,21,39,155,60,138,23,102,213],[83,12,13,54,192,255,68,47,28],[85,26,85,85,128,128,32,146,171],[18,11,7,63,144,171,4,4,246],[35,27,10,146,174,171,12,26,128]],[[190,80,35,99,180,80,126,54,45],[85,126,47,87,176,51,41,20,32],[101,75,128,139,118,146,116,128,85],[56,41,15,176,236,85,37,9,62],[71,30,17,119,118,255,17,18,138],[101,38,60,138,55,70,43,26,142],[146,36,19,30,171,255,97,27,20],[138,45,61,62,219,1,81,188,64],[32,41,20,117,151,142,20,21,163],[112,19,12,61,195,128,48,4,24]]],hi=[[[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[176,246,255,255,255,255,255,255,255,255,255],[223,241,252,255,255,255,255,255,255,255,255],[249,253,253,255,255,255,255,255,255,255,255]],[[255,244,252,255,255,255,255,255,255,255,255],[234,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255]],[[255,246,254,255,255,255,255,255,255,255,255],[239,253,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[251,255,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[251,254,254,255,255,255,255,255,255,255,255],[254,255,254,255,255,255,255,255,255,255,255]],[[255,254,253,255,254,255,255,255,255,255,255],[250,255,254,255,254,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[217,255,255,255,255,255,255,255,255,255,255],[225,252,241,253,255,255,254,255,255,255,255],[234,250,241,250,253,255,253,254,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[223,254,254,255,255,255,255,255,255,255,255],[238,253,254,254,255,255,255,255,255,255,255]],[[255,248,254,255,255,255,255,255,255,255,255],[249,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,255,255,255,255,255,255,255,255,255],[247,254,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[252,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[253,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[186,251,250,255,255,255,255,255,255,255,255],[234,251,244,254,255,255,255,255,255,255,255],[251,251,243,253,254,255,254,255,255,255,255]],[[255,253,254,255,255,255,255,255,255,255,255],[236,253,254,255,255,255,255,255,255,255,255],[251,253,253,254,254,255,255,255,255,255,255]],[[255,254,254,255,255,255,255,255,255,255,255],[254,254,254,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,254,255,255,255,255,255,255,255,255,255],[254,254,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]],[[[248,255,255,255,255,255,255,255,255,255,255],[250,254,252,254,255,255,255,255,255,255,255],[248,254,249,253,255,255,255,255,255,255,255]],[[255,253,253,255,255,255,255,255,255,255,255],[246,253,253,255,255,255,255,255,255,255,255],[252,254,251,254,254,255,255,255,255,255,255]],[[255,254,252,255,255,255,255,255,255,255,255],[248,254,253,255,255,255,255,255,255,255,255],[253,255,254,254,255,255,255,255,255,255,255]],[[255,251,254,255,255,255,255,255,255,255,255],[245,251,254,255,255,255,255,255,255,255,255],[253,253,254,255,255,255,255,255,255,255,255]],[[255,251,253,255,255,255,255,255,255,255,255],[252,253,254,255,255,255,255,255,255,255,255],[255,254,255,255,255,255,255,255,255,255,255]],[[255,252,255,255,255,255,255,255,255,255,255],[249,255,254,255,255,255,255,255,255,255,255],[255,255,254,255,255,255,255,255,255,255,255]],[[255,255,253,255,255,255,255,255,255,255,255],[250,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]],[[255,255,255,255,255,255,255,255,255,255,255],[254,255,255,255,255,255,255,255,255,255,255],[255,255,255,255,255,255,255,255,255,255,255]]]],li=[0,1,2,3,6,4,5,6,6,6,6,6,6,6,6,7,0],ui=[],ci=[],fi=[],di=1,pi=2,gi=[],mi=[];mr("UpsampleRgbLinePair",xr,3),mr("UpsampleBgrLinePair",Ar,3),mr("UpsampleRgbaLinePair",Pr,4),mr("UpsampleBgraLinePair",kr,4),mr("UpsampleArgbLinePair",Sr,4),mr("UpsampleRgba4444LinePair",Nr,2),mr("UpsampleRgb565LinePair",Lr,2);var bi=t.UpsampleRgbLinePair,vi=t.UpsampleBgrLinePair,wi=t.UpsampleRgbaLinePair,yi=t.UpsampleBgraLinePair,_i=t.UpsampleArgbLinePair,xi=t.UpsampleRgba4444LinePair,Ai=t.UpsampleRgb565LinePair,Li=16,Ni=1<<Li-1,Si=-227,ki=482,Pi=6,Fi=(256<<Pi)-1,Ii=0,Ci=a(256),ji=a(256),Ei=a(256),Oi=a(256),Bi=a(ki-Si),Mi=a(ki-Si);Fr("YuvToRgbRow",xr,3),Fr("YuvToBgrRow",Ar,3),Fr("YuvToRgbaRow",Pr,4),Fr("YuvToBgraRow",kr,4),Fr("YuvToArgbRow",Sr,4),Fr("YuvToRgba4444Row",Nr,2),Fr("YuvToRgb565Row",Lr,2);var Ri=[0,4,8,12,128,132,136,140,256,260,264,268,384,388,392,396],Ti=[0,2,8],qi=[8,7,6,4,4,2,2,2,1,1,1,1],Di=1;this.WebPDecodeRGBA=function(t,r,o,h,l){var u=Mn,c=new er,f=new st;c.ba=f,f.S=u,f.width=[f.width],f.height=[f.height];var d=f.width,p=f.height,g=new ot;if(null==g||null==t)var m=2;else e(null!=g),m=Er(t,r,o,g.width,g.height,g.Pd,g.Qd,g.format,null);if(0!=m?d=0:(null!=d&&(d[0]=g.width[0]),null!=p&&(p[0]=g.height[0]),d=1),d){f.width=f.width[0],f.height=f.height[0],null!=h&&(h[0]=f.width),null!=l&&(l[0]=f.height);t:{if(h=new Gt,(l=new rr).data=t,l.w=r,l.ha=o,l.kd=1,r=[0],e(null!=l),(0==(t=Er(l.data,l.w,l.ha,null,null,null,r,null,l))||7==t)&&r[0]&&(t=4),0==(r=t)){if(e(null!=c),h.data=l.data,h.w=l.w+l.offset,h.ha=l.ha-l.offset,h.put=dt,h.ac=ft,h.bc=pt,h.ma=c,l.xa){if(null==(t=Pt())){c=1;break t}if(function(t,r){var n=[0],i=[0],a=[0];e:for(;;){if(null==t)return 0;if(null==r)return t.a=2,0;if(t.l=r,t.a=0,b(t.m,r.data,r.w,r.ha),!gt(t.m,n,i,a)){t.a=3;break e}if(t.xb=pi,r.width=n[0],r.height=i[0],!Ft(n[0],i[0],1,t,null))break e;return 1}return e(0!=t.a),0}(t,h)){if(h=0==(r=Mr(h.width,h.height,c.Oa,c.ba))){e:{h=t;r:for(;;){if(null==h){h=0;break e}if(e(null!=h.s.yc),e(null!=h.s.Ya),e(0<h.s.Wb),e(null!=(o=h.l)),e(null!=(l=o.ma)),0!=h.xb){if(h.ca=l.ba,h.tb=l.tb,e(null!=h.ca),!Or(l.Oa,o,Tn)){h.a=2;break r}if(!It(h,o.width))break r;if(o.da)break r;if((o.da||nt(h.ca.S))&&gr(),11>h.ca.S||(alert("todo:WebPInitConvertARGBToYUV"),null!=h.ca.f.kb.F&&gr()),h.Pb&&0<h.s.ua&&null==h.s.vb.X&&!E(h.s.vb,h.s.Wa.Xa)){h.a=1;break r}h.xb=0}if(!St(h,h.V,h.Ba,h.c,h.i,o.o,xt))break r;l.Dc=h.Ma,h=1;break e}e(0!=h.a),h=0}h=!h}h&&(r=t.a)}else r=t.a}else{if(null==(t=new Yt)){c=1;break t}if(t.Fa=l.na,t.P=l.P,t.qc=l.Sa,Xt(t,h)){if(0==(r=Mr(h.width,h.height,c.Oa,c.ba))){if(t.Aa=0,o=c.Oa,e(null!=(l=t)),null!=o){if(0<(d=0>(d=o.Md)?0:100<d?255:255*d/100)){for(p=g=0;4>p;++p)12>(m=l.pb[p]).lc&&(m.ia=d*qi[0>m.lc?0:m.lc]>>3),g|=m.ia;g&&(alert("todo:VP8InitRandom"),l.ia=1)}l.Ga=o.Id,100<l.Ga?l.Ga=100:0>l.Ga&&(l.Ga=0)}(function(t,r){if(null==t)return 0;if(null==r)return Zt(t,2,"NULL VP8Io parameter in VP8Decode().");if(!t.cb&&!Xt(t,r))return 0;if(e(t.cb),null==r.ac||r.ac(r)){r.ob&&(t.L=0);var o=Ti[t.L];if(2==t.L?(t.yb=0,t.zb=0):(t.yb=r.v-o>>4,t.zb=r.j-o>>4,0>t.yb&&(t.yb=0),0>t.zb&&(t.zb=0)),t.Va=r.o+15+o>>4,t.Hb=r.va+15+o>>4,t.Hb>t.za&&(t.Hb=t.za),t.Va>t.Ub&&(t.Va=t.Ub),0<t.L){var h=t.ed;for(o=0;4>o;++o){var l;if(t.Qa.Cb){var u=t.Qa.Lb[o];t.Qa.Fb||(u+=h.Tb)}else u=h.Tb;for(l=0;1>=l;++l){var c=t.gd[o][l],f=u;if(h.Pc&&(f+=h.vd[0],l&&(f+=h.od[0])),0<(f=0>f?0:63<f?63:f)){var d=f;0<h.wb&&(d=4<h.wb?d>>2:d>>1)>9-h.wb&&(d=9-h.wb),1>d&&(d=1),c.dd=d,c.tc=2*f+d,c.ld=40<=f?2:15<=f?1:0}else c.tc=0;c.La=l}}}o=0}else Zt(t,6,"Frame setup failed"),o=t.a;if(o=0==o){if(o){t.$c=0,0<t.Aa||(t.Ic=Di);e:{o=t.Ic,h=4*(d=t.za);var p=32*d,g=d+1,m=0<t.L?d*(0<t.Aa?2:1):0,b=(2==t.Aa?2:1)*d;if((c=h+832+(l=3*(16*o+Ti[t.L])/2*p)+(u=null!=t.Fa&&0<t.Fa.length?t.Kc.c*t.Kc.i:0))!=c)o=0;else{if(c>t.Vb){if(t.Vb=0,t.Ec=a(c),t.Fc=0,null==t.Ec){o=Zt(t,1,"no memory during frame initialization.");break e}t.Vb=c}c=t.Ec,f=t.Fc,t.Ac=c,t.Bc=f,f+=h,t.Gd=s(p,Ht),t.Hd=0,t.rb=s(g+1,qt),t.sb=1,t.wa=m?s(m,Tt):null,t.Y=0,t.D.Nb=0,t.D.wa=t.wa,t.D.Y=t.Y,0<t.Aa&&(t.D.Y+=d),e(!0),t.oc=c,t.pc=f,f+=832,t.ya=s(b,zt),t.aa=0,t.D.ya=t.ya,t.D.aa=t.aa,2==t.Aa&&(t.D.aa+=d),t.R=16*d,t.B=8*d,d=(p=Ti[t.L])*t.R,p=p/2*t.B,t.sa=c,t.ta=f+d,t.qa=t.sa,t.ra=t.ta+16*o*t.R+p,t.Ha=t.qa,t.Ia=t.ra+8*o*t.B+p,t.$c=0,f+=l,t.mb=u?c:null,t.nb=u?f:null,e(f+u<=t.Fc+t.Vb),$t(t),i(t.Ac,t.Bc,0,h),o=1}}if(o){if(r.ka=0,r.y=t.sa,r.O=t.ta,r.f=t.qa,r.N=t.ra,r.ea=t.Ha,r.Vd=t.Ia,r.fa=t.R,r.Rc=t.B,r.F=null,r.J=0,!In){for(o=-255;255>=o;++o)Sn[255+o]=0>o?-o:o;for(o=-1020;1020>=o;++o)kn[1020+o]=-128>o?-128:127<o?127:o;for(o=-112;112>=o;++o)Pn[112+o]=-16>o?-16:15<o?15:o;for(o=-255;510>=o;++o)Fn[255+o]=0>o?0:255<o?255:o;In=1}nn=he,an=ie,on=ae,hn=se,ln=oe,sn=ne,un=Ye,cn=Ze,fn=Ke,dn=$e,pn=Je,gn=Xe,mn=Qe,bn=tr,vn=ze,wn=Ue,yn=He,_n=We,ci[0]=Ae,ci[1]=ue,ci[2]=_e,ci[3]=xe,ci[4]=Le,ci[5]=Se,ci[6]=Ne,ci[7]=ke,ci[8]=Fe,ci[9]=Pe,ui[0]=me,ui[1]=fe,ui[2]=de,ui[3]=pe,ui[4]=be,ui[5]=ve,ui[6]=we,fi[0]=Ee,fi[1]=ce,fi[2]=Ie,fi[3]=Ce,fi[4]=Be,fi[5]=Oe,fi[6]=Me,o=1}else o=0}o&&(o=function(t,r){for(t.M=0;t.M<t.Va;++t.M){var s,o=t.Jc[t.M&t.Xb],h=t.m,l=t;for(s=0;s<l.za;++s){var u=h,c=l,f=c.Ac,d=c.Bc+4*s,p=c.zc,g=c.ya[c.aa+s];if(c.Qa.Bb?g.$b=P(u,c.Pa.jb[0])?2+P(u,c.Pa.jb[2]):P(u,c.Pa.jb[1]):g.$b=0,c.kc&&(g.Ad=P(u,c.Bd)),g.Za=!P(u,145)+0,g.Za){var m=g.Ob,b=0;for(c=0;4>c;++c){var v,w=p[0+c];for(v=0;4>v;++v){w=oi[f[d+v]][w];for(var y=ai[P(u,w[0])];0<y;)y=ai[2*y+P(u,w[y])];w=-y,f[d+v]=w}n(m,b,f,d,4),b+=4,p[0+c]=w}}else w=P(u,156)?P(u,128)?1:3:P(u,163)?2:0,g.Ob[0]=w,i(f,d,w,4),i(p,0,w,4);g.Dd=P(u,142)?P(u,114)?P(u,183)?1:3:2:0}if(l.m.Ka)return Zt(t,7,"Premature end-of-partition0 encountered.");for(;t.ja<t.za;++t.ja){if(l=o,u=(h=t).rb[h.sb-1],f=h.rb[h.sb+h.ja],s=h.ya[h.aa+h.ja],d=h.kc?s.Ad:0)u.la=f.la=0,s.Za||(u.Na=f.Na=0),s.Hc=0,s.Gc=0,s.ia=0;else{var _,x;if(u=f,f=l,d=h.Pa.Xc,p=h.ya[h.aa+h.ja],g=h.pb[p.$b],c=p.ad,m=0,b=h.rb[h.sb-1],w=v=0,i(c,m,0,384),p.Za)var A=0,L=d[3];else{y=a(16);var N=u.Na+b.Na;if(N=ri(f,d[1],N,g.Eb,0,y,0),u.Na=b.Na=(0<N)+0,1<N)nn(y,0,c,m);else{var S=y[0]+3>>3;for(y=0;256>y;y+=16)c[m+y]=S}A=1,L=d[0]}var k=15&u.la,F=15&b.la;for(y=0;4>y;++y){var I=1&F;for(S=x=0;4>S;++S)k=k>>1|(I=(N=ri(f,L,N=I+(1&k),g.Sc,A,c,m))>A)<<7,x=x<<2|(3<N?3:1<N?2:0!=c[m+0]),m+=16;k>>=4,F=F>>1|I<<7,v=(v<<8|x)>>>0}for(L=k,A=F>>4,_=0;4>_;_+=2){for(x=0,k=u.la>>4+_,F=b.la>>4+_,y=0;2>y;++y){for(I=1&F,S=0;2>S;++S)N=I+(1&k),k=k>>1|(I=0<(N=ri(f,d[2],N,g.Qc,0,c,m)))<<3,x=x<<2|(3<N?3:1<N?2:0!=c[m+0]),m+=16;k>>=2,F=F>>1|I<<5}w|=x<<4*_,L|=k<<4<<_,A|=(240&F)<<_}u.la=L,b.la=A,p.Hc=v,p.Gc=w,p.ia=43690&w?0:g.ia,d=!(v|w)}if(0<h.L&&(h.wa[h.Y+h.ja]=h.gd[s.$b][s.Za],h.wa[h.Y+h.ja].La|=!d),l.Ka)return Zt(t,7,"Premature end-of-file encountered.")}if($t(t),h=r,l=1,s=(o=t).D,u=0<o.L&&o.M>=o.zb&&o.M<=o.Va,0==o.Aa)e:{if(s.M=o.M,s.uc=u,jr(o,s),l=1,s=(x=o.D).Nb,u=(w=Ti[o.L])*o.R,f=w/2*o.B,y=16*s*o.R,S=8*s*o.B,d=o.sa,p=o.ta-u+y,g=o.qa,c=o.ra-f+S,m=o.Ha,b=o.Ia-f+S,F=0==(k=x.M),v=k>=o.Va-1,2==o.Aa&&jr(o,x),x.uc)for(I=(N=o).D.M,e(N.D.uc),x=N.yb;x<N.Hb;++x){A=x,L=I;var C=(j=(z=N).D).Nb;_=z.R;var j=j.wa[j.Y+A],E=z.sa,O=z.ta+16*C*_+16*A,B=j.dd,M=j.tc;if(0!=M)if(e(3<=M),1==z.L)0<A&&wn(E,O,_,M+4),j.La&&_n(E,O,_,M),0<L&&vn(E,O,_,M+4),j.La&&yn(E,O,_,M);else{var R=z.B,T=z.qa,q=z.ra+8*C*R+8*A,D=z.Ha,z=z.Ia+8*C*R+8*A;C=j.ld,0<A&&(cn(E,O,_,M+4,B,C),dn(T,q,D,z,R,M+4,B,C)),j.La&&(gn(E,O,_,M,B,C),bn(T,q,D,z,R,M,B,C)),0<L&&(un(E,O,_,M+4,B,C),fn(T,q,D,z,R,M+4,B,C)),j.La&&(pn(E,O,_,M,B,C),mn(T,q,D,z,R,M,B,C))}}if(o.ia&&alert("todo:DitherRow"),null!=h.put){if(x=16*k,k=16*(k+1),F?(h.y=o.sa,h.O=o.ta+y,h.f=o.qa,h.N=o.ra+S,h.ea=o.Ha,h.W=o.Ia+S):(x-=w,h.y=d,h.O=p,h.f=g,h.N=c,h.ea=m,h.W=b),v||(k-=w),k>h.o&&(k=h.o),h.F=null,h.J=null,null!=o.Fa&&0<o.Fa.length&&x<k&&(h.J=ur(o,h,x,k-x),h.F=o.mb,null==h.F&&0==h.F.length)){l=Zt(o,3,"Could not decode alpha data.");break e}x<h.j&&(w=h.j-x,x=h.j,e(!(1&w)),h.O+=o.R*w,h.N+=o.B*(w>>1),h.W+=o.B*(w>>1),null!=h.F&&(h.J+=h.width*w)),x<k&&(h.O+=h.v,h.N+=h.v>>1,h.W+=h.v>>1,null!=h.F&&(h.J+=h.v),h.ka=x-h.j,h.U=h.va-h.v,h.T=k-x,l=h.put(h))}s+1!=o.Ic||v||(n(o.sa,o.ta-u,d,p+16*o.R,u),n(o.qa,o.ra-f,g,c+8*o.B,f),n(o.Ha,o.Ia-f,m,b+8*o.B,f))}if(!l)return Zt(t,6,"Output aborted.")}return 1}(t,r)),null!=r.bc&&r.bc(r),o&=1}return o?(t.cb=0,o):0})(t,h)||(r=t.a)}}else r=t.a}0==r&&null!=c.Oa&&c.Oa.fd&&(r=Br(c.ba))}c=r}u=0!=c?null:11>u?f.f.RGBA.eb:f.f.kb.y}else u=null;return u};var zi=[3,4,3,4,4,2,2,4,4,4,2,1,1]};function l(t,e){for(var r="",n=0;n<4;n++)r+=String.fromCharCode(t[e++]);return r}function u(t,e){return t[e+0]|t[e+1]<<8}function c(t,e){return(t[e+0]|t[e+1]<<8|t[e+2]<<16)>>>0}function f(t,e){return(t[e+0]|t[e+1]<<8|t[e+2]<<16|t[e+3]<<24)>>>0}new h;var d=[0],p=[0],g=[],m=new h,b=t,v=function(t,e){var r={},n=0,i=!1,a=0,s=0;if(r.frames=[],!
/** @license
     * Copyright (c) 2017 Dominik Homberger
    Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
    The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
    https://webpjs.appspot.com
    WebPRiffParser dominikhlbg@gmail.com
    */
function(t,e){for(var r=0;r<4;r++)if(t[e+r]!="RIFF".charCodeAt(r))return!0;return!1}(t,e)){for(f(t,e+=4),e+=8;e<t.length;){var o=l(t,e),h=f(t,e+=4);e+=4;var d=h+(1&h);switch(o){case"VP8 ":case"VP8L":void 0===r.frames[n]&&(r.frames[n]={}),(m=r.frames[n]).src_off=i?s:e-8,m.src_size=a+h+8,n++,i&&(i=!1,a=0,s=0);break;case"VP8X":(m=r.header={}).feature_flags=t[e];var p=e+4;m.canvas_width=1+c(t,p),p+=3,m.canvas_height=1+c(t,p),p+=3;break;case"ALPH":i=!0,a=d+8,s=e-8;break;case"ANIM":(m=r.header).bgcolor=f(t,e),p=e+4,m.loop_count=u(t,p),p+=2;break;case"ANMF":var g,m;(m=r.frames[n]={}).offset_x=2*c(t,e),e+=3,m.offset_y=2*c(t,e),e+=3,m.width=1+c(t,e),e+=3,m.height=1+c(t,e),e+=3,m.duration=c(t,e),e+=3,g=t[e++],m.dispose=1&g,m.blend=g>>1&1}"ANMF"!=o&&(e+=d)}return r}}(b,0);v.response=b,v.rgbaoutput=!0,v.dataurl=!1;var w=v.header?v.header:null,y=v.frames?v.frames:null;if(w){w.loop_counter=w.loop_count,d=[w.canvas_height],p=[w.canvas_width];for(var _=0;_<y.length&&0!=y[_].blend;_++);}var x=y[0],A=m.WebPDecodeRGBA(b,x.src_off,x.src_size,p,d);x.rgba=A,x.imgwidth=p[0],x.imgheight=d[0];for(var L=0;L<p[0]*d[0]*4;L++)g[L]=A[L];return this.width=p,this.height=d,this.data=g,this}
/** ====================================================================
   * @license
   * jsPDF XMP metadata plugin
   * Copyright (c) 2016 Jussi Utunen, u-jussi@suomi24.fi
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   * ====================================================================
   */
function Ba(){var t,e=this.internal.__metadata__.metadata,r=unescape(encodeURIComponent(e));t=this.internal.__metadata__.rawXml?r:'<x:xmpmeta xmlns:x="adobe:ns:meta/"><rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"><rdf:Description rdf:about="" xmlns:jspdf="'+this.internal.__metadata__.namespaceUri+'"><jspdf:metadata>'+r.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")+"</jspdf:metadata></rdf:Description></rdf:RDF></x:xmpmeta>",this.internal.__metadata__.metadataObjectNumber=this.internal.newObject(),this.internal.write("<< /Type /Metadata /Subtype /XML /Length "+t.length+" >>"),this.internal.write("stream"),this.internal.write(t),this.internal.write("endstream"),this.internal.write("endobj")}function Ma(){this.internal.__metadata__.metadataObjectNumber&&this.internal.write("/Metadata "+this.internal.__metadata__.metadataObjectNumber+" 0 R")}!function(t){t[t.UNKNOWN=0]="UNKNOWN",t[t.METRE=1]="METRE"}(da||(da={})),R.API.processPNG=function(t,e,n,i){if(this.__addimage__.isArrayBuffer(t)&&(t=new Uint8Array(t)),this.__addimage__.isArrayBufferView(t)){var a,s=new fa(t,{checkCrc:!0}).decode(),o=s.width,h=s.height,l=s.channels,u=s.palette,c=s.depth;a=u&&1===l?function(t){for(var e=t.width,n=t.height,i=t.data,a=t.palette,s=t.depth,o=!1,h=[],l=[],u=void 0,c=!1,f=0,d=0;d<a.length;d++){var p=r(a[d],4),g=p[0],m=p[1],b=p[2],v=p[3];h.push(g,m,b),null!=v&&(0===v?(f++,l.length<1&&l.push(d)):v<255&&(c=!0))}if(c||f>1){o=!0,l=void 0;var w=e*n;u=new Uint8Array(w);for(var y=new DataView(i.buffer),_=0;_<w;_++){var x=r(a[ka(y,_,s)],4)[3];u[_]=x}}else 0===f&&(l=void 0);return{colorSpace:"Indexed",colorsPerPixel:1,sMaskBitsPerComponent:o?8:void 0,colorBytes:i,alphaBytes:u,needSMask:o,palette:h,mask:l}}(s):2===l||4===l?function(t){for(var e=t.data,r=t.width,n=t.height,i=t.channels,a=t.depth,s=2===i?"DeviceGray":"DeviceRGB",o=i-1,h=r*n,l=o,u=h*l,c=1*h,f=Math.ceil(u*a/8),d=Math.ceil(c*a/8),p=new Uint8Array(f),g=new Uint8Array(d),m=new DataView(e.buffer),b=new DataView(p.buffer),v=new DataView(g.buffer),w=!1,y=0;y<h;y++){for(var _=y*i,x=0;x<l;x++)Pa(b,ka(m,_+x,a),y*l+x,a);var A=ka(m,_+l,a);A<(1<<a)-1&&(w=!0),Pa(v,A,1*y,a)}return{colorSpace:s,colorsPerPixel:o,sMaskBitsPerComponent:w?a:void 0,colorBytes:p,alphaBytes:g,needSMask:w}}(s):function(t){var e,r=t.data,n=1===t.channels?"DeviceGray":"DeviceRGB",i="DeviceGray"===n?1:3;return e=r instanceof Uint16Array?function(t){for(var e=t.length,r=new Uint8Array(2*e),n=new DataView(r.buffer,r.byteOffset,r.byteLength),i=0;i<e;i++)n.setUint16(2*i,t[i],!1);return r}(r):r,{colorSpace:n,colorsPerPixel:i,colorBytes:e,needSMask:!1}}(s);var f,d,p,g=a,m=g.colorSpace,b=g.colorsPerPixel,v=g.sMaskBitsPerComponent,w=g.colorBytes,y=g.alphaBytes,_=g.needSMask,x=g.palette,A=g.mask,L=null;return i!==R.API.image_compression.NONE?(L=function(t){var e;switch(t){case R.API.image_compression.FAST:e=11;break;case R.API.image_compression.MEDIUM:e=13;break;case R.API.image_compression.SLOW:e=14;break;default:e=12}return e}(i),f=this.decode.FLATE_DECODE,d="/Predictor ".concat(L," /Colors ").concat(b," /BitsPerComponent ").concat(c," /Columns ").concat(o),t=wa(w,Math.ceil(o*b*c/8),b,c,i),_&&(p=wa(y,Math.ceil(o*v/8),1,v,i))):(f=void 0,d=void 0,t=w,_&&(p=y)),(this.__addimage__.isArrayBuffer(t)||this.__addimage__.isArrayBufferView(t))&&(t=this.__addimage__.arrayBufferToBinaryString(t)),(p&&this.__addimage__.isArrayBuffer(p)||this.__addimage__.isArrayBufferView(p))&&(p=this.__addimage__.arrayBufferToBinaryString(p)),{alias:n,data:t,index:e,filter:f,decodeParameters:d,transparency:A,palette:x,sMask:p,predictor:L,width:o,height:h,bitsPerComponent:c,sMaskBitsPerComponent:v,colorSpace:m}}},function(t){t.processGIF89A=function(e,r,n,i){var a=new Ia(e),s=a.width,o=a.height,h=[];a.decodeAndBlitFrameRGBA(0,h);var l={data:h,width:s,height:o},u=new ja(100).encode(l,100);return t.processJPEG.call(this,u,r,n,i)},t.processGIF87A=t.processGIF89A}(R.API),Ea.prototype.parseHeader=function(){if(this.fileSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.reserved=this.datav.getUint32(this.pos,!0),this.pos+=4,this.offset=this.datav.getUint32(this.pos,!0),this.pos+=4,this.headerSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.width=this.datav.getUint32(this.pos,!0),this.pos+=4,this.height=this.datav.getInt32(this.pos,!0),this.pos+=4,this.planes=this.datav.getUint16(this.pos,!0),this.pos+=2,this.bitPP=this.datav.getUint16(this.pos,!0),this.pos+=2,this.compress=this.datav.getUint32(this.pos,!0),this.pos+=4,this.rawSize=this.datav.getUint32(this.pos,!0),this.pos+=4,this.hr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.vr=this.datav.getUint32(this.pos,!0),this.pos+=4,this.colors=this.datav.getUint32(this.pos,!0),this.pos+=4,this.importantColors=this.datav.getUint32(this.pos,!0),this.pos+=4,16===this.bitPP&&this.is_with_alpha&&(this.bitPP=15),this.bitPP<15){var t=0===this.colors?1<<this.bitPP:this.colors;this.palette=new Array(t);for(var e=0;e<t;e++){var r=this.datav.getUint8(this.pos++,!0),n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0);this.palette[e]={red:i,green:n,blue:r,quad:a}}}this.height<0&&(this.height*=-1,this.bottom_up=!1)},Ea.prototype.parseBGR=function(){this.pos=this.offset;var t="bit"+this.bitPP,e=this.width*this.height*4;if(e>536870912)throw new Error("Image dimensions exceed 512MB, which is too large.");this.data=new Uint8Array(e);try{this[t]()}catch(is){s.log("bit decode error:"+is)}},Ea.prototype.bit1=function(){var t,e=Math.ceil(this.width/8),r=e%4;for(t=this.height-1;t>=0;t--){for(var n=this.bottom_up?t:this.height-1-t,i=0;i<e;i++)for(var a=this.datav.getUint8(this.pos++,!0),s=n*this.width*4+8*i*4,o=0;o<8&&8*i+o<this.width;o++){var h=this.palette[a>>7-o&1];this.data[s+4*o]=h.blue,this.data[s+4*o+1]=h.green,this.data[s+4*o+2]=h.red,this.data[s+4*o+3]=255}0!==r&&(this.pos+=4-r)}},Ea.prototype.bit4=function(){for(var t=Math.ceil(this.width/2),e=t%4,r=this.height-1;r>=0;r--){for(var n=this.bottom_up?r:this.height-1-r,i=0;i<t;i++){var a=this.datav.getUint8(this.pos++,!0),s=n*this.width*4+2*i*4,o=a>>4,h=15&a,l=this.palette[o];if(this.data[s]=l.blue,this.data[s+1]=l.green,this.data[s+2]=l.red,this.data[s+3]=255,2*i+1>=this.width)break;l=this.palette[h],this.data[s+4]=l.blue,this.data[s+4+1]=l.green,this.data[s+4+2]=l.red,this.data[s+4+3]=255}0!==e&&(this.pos+=4-e)}},Ea.prototype.bit8=function(){for(var t=this.width%4,e=this.height-1;e>=0;e--){for(var r=this.bottom_up?e:this.height-1-e,n=0;n<this.width;n++){var i=this.datav.getUint8(this.pos++,!0),a=r*this.width*4+4*n;if(i<this.palette.length){var s=this.palette[i];this.data[a]=s.red,this.data[a+1]=s.green,this.data[a+2]=s.blue,this.data[a+3]=255}else this.data[a]=255,this.data[a+1]=255,this.data[a+2]=255,this.data[a+3]=255}0!==t&&(this.pos+=4-t)}},Ea.prototype.bit15=function(){for(var t=this.width%3,e=parseInt("11111",2),r=this.height-1;r>=0;r--){for(var n=this.bottom_up?r:this.height-1-r,i=0;i<this.width;i++){var a=this.datav.getUint16(this.pos,!0);this.pos+=2;var s=(a&e)/e*255|0,o=(a>>5&e)/e*255|0,h=(a>>10&e)/e*255|0,l=a>>15?255:0,u=n*this.width*4+4*i;this.data[u]=h,this.data[u+1]=o,this.data[u+2]=s,this.data[u+3]=l}this.pos+=t}},Ea.prototype.bit16=function(){for(var t=this.width%3,e=parseInt("11111",2),r=parseInt("111111",2),n=this.height-1;n>=0;n--){for(var i=this.bottom_up?n:this.height-1-n,a=0;a<this.width;a++){var s=this.datav.getUint16(this.pos,!0);this.pos+=2;var o=(s&e)/e*255|0,h=(s>>5&r)/r*255|0,l=(s>>11)/e*255|0,u=i*this.width*4+4*a;this.data[u]=l,this.data[u+1]=h,this.data[u+2]=o,this.data[u+3]=255}this.pos+=t}},Ea.prototype.bit24=function(){for(var t=this.height-1;t>=0;t--){for(var e=this.bottom_up?t:this.height-1-t,r=0;r<this.width;r++){var n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),s=e*this.width*4+4*r;this.data[s]=a,this.data[s+1]=i,this.data[s+2]=n,this.data[s+3]=255}this.pos+=this.width%4}},Ea.prototype.bit32=function(){for(var t=this.height-1;t>=0;t--)for(var e=this.bottom_up?t:this.height-1-t,r=0;r<this.width;r++){var n=this.datav.getUint8(this.pos++,!0),i=this.datav.getUint8(this.pos++,!0),a=this.datav.getUint8(this.pos++,!0),s=this.datav.getUint8(this.pos++,!0),o=e*this.width*4+4*r;this.data[o]=a,this.data[o+1]=i,this.data[o+2]=n,this.data[o+3]=s}},Ea.prototype.getData=function(){return this.data},
/**
   * @license
   * Copyright (c) 2018 Aras Abbasi
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){t.processBMP=function(e,r,n,i){var a=new Ea(e,!1),s=a.width,o=a.height,h={data:a.getData(),width:s,height:o},l=new ja(100).encode(h,100);return t.processJPEG.call(this,l,r,n,i)}}(R.API),Oa.prototype.getData=function(){return this.data},
/**
   * @license
   * Copyright (c) 2019 Aras Abbasi
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){t.processWEBP=function(e,r,n,i){var a=new Oa(e),s=a.width,o=a.height,h={data:a.getData(),width:s,height:o},l=new ja(100).encode(h,100);return t.processJPEG.call(this,l,r,n,i)}}(R.API),
/**
   * @license
   *
   * Copyright (c) 2021 Antti Palola, https://github.com/Pantura
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   * ====================================================================
   */
function(t){t.processRGBA=function(t,e,r){for(var n=t.data,i=n.length,a=new Uint8Array(i/4*3),s=new Uint8Array(i/4),o=0,h=0,l=0;l<i;l+=4){var u=n[l],c=n[l+1],f=n[l+2],d=n[l+3];a[o++]=u,a[o++]=c,a[o++]=f,s[h++]=d}var p=this.__addimage__.arrayBufferToBinaryString(a);return{alpha:this.__addimage__.arrayBufferToBinaryString(s),data:p,index:e,alias:r,colorSpace:"DeviceRGB",bitsPerComponent:8,width:t.width,height:t.height}}}(R.API),
/**
   * @license
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){t.setLanguage=function(t){return void 0===this.internal.languageSettings&&(this.internal.languageSettings={},this.internal.languageSettings.isSubscribed=!1),void 0!=={af:"Afrikaans",sq:"Albanian",ar:"Arabic (Standard)","ar-DZ":"Arabic (Algeria)","ar-BH":"Arabic (Bahrain)","ar-EG":"Arabic (Egypt)","ar-IQ":"Arabic (Iraq)","ar-JO":"Arabic (Jordan)","ar-KW":"Arabic (Kuwait)","ar-LB":"Arabic (Lebanon)","ar-LY":"Arabic (Libya)","ar-MA":"Arabic (Morocco)","ar-OM":"Arabic (Oman)","ar-QA":"Arabic (Qatar)","ar-SA":"Arabic (Saudi Arabia)","ar-SY":"Arabic (Syria)","ar-TN":"Arabic (Tunisia)","ar-AE":"Arabic (U.A.E.)","ar-YE":"Arabic (Yemen)",an:"Aragonese",hy:"Armenian",as:"Assamese",ast:"Asturian",az:"Azerbaijani",eu:"Basque",be:"Belarusian",bn:"Bengali",bs:"Bosnian",br:"Breton",bg:"Bulgarian",my:"Burmese",ca:"Catalan",ch:"Chamorro",ce:"Chechen",zh:"Chinese","zh-HK":"Chinese (Hong Kong)","zh-CN":"Chinese (PRC)","zh-SG":"Chinese (Singapore)","zh-TW":"Chinese (Taiwan)",cv:"Chuvash",co:"Corsican",cr:"Cree",hr:"Croatian",cs:"Czech",da:"Danish",nl:"Dutch (Standard)","nl-BE":"Dutch (Belgian)",en:"English","en-AU":"English (Australia)","en-BZ":"English (Belize)","en-CA":"English (Canada)","en-IE":"English (Ireland)","en-JM":"English (Jamaica)","en-NZ":"English (New Zealand)","en-PH":"English (Philippines)","en-ZA":"English (South Africa)","en-TT":"English (Trinidad & Tobago)","en-GB":"English (United Kingdom)","en-US":"English (United States)","en-ZW":"English (Zimbabwe)",eo:"Esperanto",et:"Estonian",fo:"Faeroese",fj:"Fijian",fi:"Finnish",fr:"French (Standard)","fr-BE":"French (Belgium)","fr-CA":"French (Canada)","fr-FR":"French (France)","fr-LU":"French (Luxembourg)","fr-MC":"French (Monaco)","fr-CH":"French (Switzerland)",fy:"Frisian",fur:"Friulian",gd:"Gaelic (Scots)","gd-IE":"Gaelic (Irish)",gl:"Galacian",ka:"Georgian",de:"German (Standard)","de-AT":"German (Austria)","de-DE":"German (Germany)","de-LI":"German (Liechtenstein)","de-LU":"German (Luxembourg)","de-CH":"German (Switzerland)",el:"Greek",gu:"Gujurati",ht:"Haitian",he:"Hebrew",hi:"Hindi",hu:"Hungarian",is:"Icelandic",id:"Indonesian",iu:"Inuktitut",ga:"Irish",it:"Italian (Standard)","it-CH":"Italian (Switzerland)",ja:"Japanese",kn:"Kannada",ks:"Kashmiri",kk:"Kazakh",km:"Khmer",ky:"Kirghiz",tlh:"Klingon",ko:"Korean","ko-KP":"Korean (North Korea)","ko-KR":"Korean (South Korea)",la:"Latin",lv:"Latvian",lt:"Lithuanian",lb:"Luxembourgish",mk:"North Macedonia",ms:"Malay",ml:"Malayalam",mt:"Maltese",mi:"Maori",mr:"Marathi",mo:"Moldavian",nv:"Navajo",ng:"Ndonga",ne:"Nepali",no:"Norwegian",nb:"Norwegian (Bokmal)",nn:"Norwegian (Nynorsk)",oc:"Occitan",or:"Oriya",om:"Oromo",fa:"Persian","fa-IR":"Persian/Iran",pl:"Polish",pt:"Portuguese","pt-BR":"Portuguese (Brazil)",pa:"Punjabi","pa-IN":"Punjabi (India)","pa-PK":"Punjabi (Pakistan)",qu:"Quechua",rm:"Rhaeto-Romanic",ro:"Romanian","ro-MO":"Romanian (Moldavia)",ru:"Russian","ru-MO":"Russian (Moldavia)",sz:"Sami (Lappish)",sg:"Sango",sa:"Sanskrit",sc:"Sardinian",sd:"Sindhi",si:"Singhalese",sr:"Serbian",sk:"Slovak",sl:"Slovenian",so:"Somani",sb:"Sorbian",es:"Spanish","es-AR":"Spanish (Argentina)","es-BO":"Spanish (Bolivia)","es-CL":"Spanish (Chile)","es-CO":"Spanish (Colombia)","es-CR":"Spanish (Costa Rica)","es-DO":"Spanish (Dominican Republic)","es-EC":"Spanish (Ecuador)","es-SV":"Spanish (El Salvador)","es-GT":"Spanish (Guatemala)","es-HN":"Spanish (Honduras)","es-MX":"Spanish (Mexico)","es-NI":"Spanish (Nicaragua)","es-PA":"Spanish (Panama)","es-PY":"Spanish (Paraguay)","es-PE":"Spanish (Peru)","es-PR":"Spanish (Puerto Rico)","es-ES":"Spanish (Spain)","es-UY":"Spanish (Uruguay)","es-VE":"Spanish (Venezuela)",sx:"Sutu",sw:"Swahili",sv:"Swedish","sv-FI":"Swedish (Finland)","sv-SV":"Swedish (Sweden)",ta:"Tamil",tt:"Tatar",te:"Teluga",th:"Thai",tig:"Tigre",ts:"Tsonga",tn:"Tswana",tr:"Turkish",tk:"Turkmen",uk:"Ukrainian",hsb:"Upper Sorbian",ur:"Urdu",ve:"Venda",vi:"Vietnamese",vo:"Volapuk",wa:"Walloon",cy:"Welsh",xh:"Xhosa",ji:"Yiddish",zu:"Zulu"}[t]&&(this.internal.languageSettings.languageCode=t,!1===this.internal.languageSettings.isSubscribed&&(this.internal.events.subscribe("putCatalog",function(){this.internal.write("/Lang ("+this.internal.languageSettings.languageCode+")")}),this.internal.languageSettings.isSubscribed=!0)),this}}(R.API),pa=R.API,ga=pa.getCharWidthsArray=function(t,e){var r,i,a=(e=e||{}).font||this.internal.getFont(),s=e.fontSize||this.internal.getFontSize(),o=e.charSpace||this.internal.getCharSpace(),h=e.widths?e.widths:a.metadata.Unicode.widths,l=h.fof?h.fof:1,u=e.kerning?e.kerning:a.metadata.Unicode.kerning,c=u.fof?u.fof:1,f=!1!==e.doKerning,d=0,p=t.length,g=0,m=h[0]||l,b=[];for(r=0;r<p;r++)i=t.charCodeAt(r),"function"==typeof a.metadata.widthOfString?b.push((a.metadata.widthOfGlyph(a.metadata.characterToGlyph(i))+o*(1e3/s)||0)/1e3):(d=f&&"object"===n(u[i])&&!isNaN(parseInt(u[i][g],10))?u[i][g]/c:0,b.push((h[i]||m)/l+d)),g=i;return b},ma=pa.getStringUnitWidth=function(t,e){var r=(e=e||{}).fontSize||this.internal.getFontSize(),n=e.font||this.internal.getFont(),i=e.charSpace||this.internal.getCharSpace();return pa.processArabic&&(t=pa.processArabic(t)),"function"==typeof n.metadata.widthOfString?n.metadata.widthOfString(t,r,i)/r:ga.apply(this,arguments).reduce(function(t,e){return t+e},0)},ba=function(t,e,r,n){for(var i=[],a=0,s=t.length,o=0;a!==s&&o+e[a]<r;)o+=e[a],a++;i.push(t.slice(0,a));var h=a;for(o=0;a!==s;)o+e[a]>n&&(i.push(t.slice(h,a)),o=0,h=a),o+=e[a],a++;return h!==a&&i.push(t.slice(h,a)),i},va=function(t,e,r){r||(r={});var n,i,a,s,o,h,l,u=[],c=[u],f=r.textIndent||0,d=0,p=0,g=t.split(" "),m=ga.apply(this,[" ",r])[0];if(h=-1===r.lineIndent?g[0].length+2:r.lineIndent||0){var b=Array(h).join(" "),v=[];g.map(function(t){(t=t.split(/\s*\n/)).length>1?v=v.concat(t.map(function(t,e){return(e&&t.length?"\n":"")+t})):v.push(t[0])}),g=v,h=ma.apply(this,[b,r])}for(a=0,s=g.length;a<s;a++){var w=0;if(n=g[a],h&&"\n"==n[0]&&(n=n.substr(1),w=1),f+d+(p=(i=ga.apply(this,[n,r])).reduce(function(t,e){return t+e},0))>e||w){if(p>e){for(o=ba.apply(this,[n,i,e-(f+d),e]),u.push(o.shift()),u=[o.pop()];o.length;)c.push([o.shift()]);p=i.slice(n.length-(u[0]?u[0].length:0)).reduce(function(t,e){return t+e},0)}else u=[n];c.push(u),f=p+h,d=m}else u.push(n),f+=d+p,d=m}return l=h?function(t,e){return(e?b:"")+t.join(" ")}:function(t){return t.join(" ")},c.map(l)},pa.splitTextToSize=function(t,e,r){var n,i=(r=r||{}).fontSize||this.internal.getFontSize(),a=function(t){if(t.widths&&t.kerning)return{widths:t.widths,kerning:t.kerning};var e=this.internal.getFont(t.fontName,t.fontStyle),r="Unicode";return e.metadata[r]?{widths:e.metadata[r].widths||{0:1},kerning:e.metadata[r].kerning||{}}:{font:e.metadata,fontSize:this.internal.getFontSize(),charSpace:this.internal.getCharSpace()}}.call(this,r);n=Array.isArray(t)?t:String(t).split(/\r?\n/);var s=1*this.internal.scaleFactor*e/i;a.textIndent=r.textIndent?1*r.textIndent*this.internal.scaleFactor/i:0,a.lineIndent=r.lineIndent;var o,h,l=[];for(o=0,h=n.length;o<h;o++)l=l.concat(va.apply(this,[n[o],s,a]));return l},function(t){t.__fontmetrics__=t.__fontmetrics__||{};for(var e="0123456789abcdef",r="klmnopqrstuvwxyz",i={},a={},s=0;s<16;s++)i[r[s]]=e[s],a[e[s]]=r[s];var o=function(t){return"0x"+parseInt(t,10).toString(16)},h=t.__fontmetrics__.compress=function(t){var e,r,i,s,l=["{"];for(var u in t){if(e=t[u],isNaN(parseInt(u,10))?r="'"+u+"'":(u=parseInt(u,10),r=(r=o(u).slice(2)).slice(0,-1)+a[r.slice(-1)]),"number"==typeof e)e<0?(i=o(e).slice(3),s="-"):(i=o(e).slice(2),s=""),i=s+i.slice(0,-1)+a[i.slice(-1)];else{if("object"!==n(e))throw new Error("Don't know what to do with value type "+n(e)+".");i=h(e)}l.push(r+i)}return l.push("}"),l.join("")},l=t.__fontmetrics__.uncompress=function(t){if("string"!=typeof t)throw new Error("Invalid argument passed to uncompress.");for(var e,r,n,a,s={},o=1,h=s,l=[],u="",c="",f=t.length-1,d=1;d<f;d+=1)"'"==(a=t[d])?e?(n=e.join(""),e=void 0):e=[]:e?e.push(a):"{"==a?(l.push([h,n]),h={},n=void 0):"}"==a?((r=l.pop())[0][r[1]]=h,n=void 0,h=r[0]):"-"==a?o=-1:void 0===n?i.hasOwnProperty(a)?(u+=i[a],n=parseInt(u,16)*o,o=1,u=""):u+=a:i.hasOwnProperty(a)?(c+=i[a],h[n]=parseInt(c,16)*o,o=1,n=void 0,c=""):c+=a;return s},u={codePages:["WinAnsiEncoding"],WinAnsiEncoding:l("{19m8n201n9q201o9r201s9l201t9m201u8m201w9n201x9o201y8o202k8q202l8r202m9p202q8p20aw8k203k8t203t8v203u9v2cq8s212m9t15m8w15n9w2dw9s16k8u16l9u17s9z17x8y17y9y}")},c={Unicode:{Courier:u,"Courier-Bold":u,"Courier-BoldOblique":u,"Courier-Oblique":u,Helvetica:u,"Helvetica-Bold":u,"Helvetica-BoldOblique":u,"Helvetica-Oblique":u,"Times-Roman":u,"Times-Bold":u,"Times-BoldItalic":u,"Times-Italic":u}},f={Unicode:{"Courier-Oblique":l("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-BoldItalic":l("{'widths'{k3o2q4ycx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2r202m2n2n3m2o3m2p5n202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5n4l4m4m4m4n4m4o4s4p4m4q4m4r4s4s4y4t2r4u3m4v4m4w3x4x5t4y4s4z4s5k3x5l4s5m4m5n3r5o3x5p4s5q4m5r5t5s4m5t3x5u3x5v2l5w1w5x2l5y3t5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q2l6r3m6s3r6t1w6u1w6v3m6w1w6x4y6y3r6z3m7k3m7l3m7m2r7n2r7o1w7p3r7q2w7r4m7s3m7t2w7u2r7v2n7w1q7x2n7y3t202l3mcl4mal2ram3man3mao3map3mar3mas2lat4uau1uav3maw3way4uaz2lbk2sbl3t'fof'6obo2lbp3tbq3mbr1tbs2lbu1ybv3mbz3mck4m202k3mcm4mcn4mco4mcp4mcq5ycr4mcs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz2w203k6o212m6o2dw2l2cq2l3t3m3u2l17s3x19m3m}'kerning'{cl{4qu5kt5qt5rs17ss5ts}201s{201ss}201t{cks4lscmscnscoscpscls2wu2yu201ts}201x{2wu2yu}2k{201ts}2w{4qx5kx5ou5qx5rs17su5tu}2x{17su5tu5ou}2y{4qx5kx5ou5qx5rs17ss5ts}'fof'-6ofn{17sw5tw5ou5qw5rs}7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qs}3v{17su5tu5os5qs}7p{17su5tu}ck{4qu5kt5qt5rs17ss5ts}4l{4qu5kt5qt5rs17ss5ts}cm{4qu5kt5qt5rs17ss5ts}cn{4qu5kt5qt5rs17ss5ts}co{4qu5kt5qt5rs17ss5ts}cp{4qu5kt5qt5rs17ss5ts}6l{4qu5ou5qw5rt17su5tu}5q{ckuclucmucnucoucpu4lu}5r{ckuclucmucnucoucpu4lu}7q{cksclscmscnscoscps4ls}6p{4qu5ou5qw5rt17sw5tw}ek{4qu5ou5qw5rt17su5tu}el{4qu5ou5qw5rt17su5tu}em{4qu5ou5qw5rt17su5tu}en{4qu5ou5qw5rt17su5tu}eo{4qu5ou5qw5rt17su5tu}ep{4qu5ou5qw5rt17su5tu}es{17ss5ts5qs4qu}et{4qu5ou5qw5rt17sw5tw}eu{4qu5ou5qw5rt17ss5ts}ev{17ss5ts5qs4qu}6z{17sw5tw5ou5qw5rs}fm{17sw5tw5ou5qw5rs}7n{201ts}fo{17sw5tw5ou5qw5rs}fp{17sw5tw5ou5qw5rs}fq{17sw5tw5ou5qw5rs}7r{cksclscmscnscoscps4ls}fs{17sw5tw5ou5qw5rs}ft{17su5tu}fu{17su5tu}fv{17su5tu}fw{17su5tu}fz{cksclscmscnscoscps4ls}}}"),"Helvetica-Bold":l("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}"),Courier:l("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Courier-BoldOblique":l("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-Bold":l("{'widths'{k3q2q5ncx2r201n3m201o6o201s2l201t2l201u2l201w3m201x3m201y3m2k1t2l2l202m2n2n3m2o3m2p6o202q6o2r1w2s2l2t2l2u3m2v3t2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w3t3x3t3y3t3z3m4k5x4l4s4m4m4n4s4o4s4p4m4q3x4r4y4s4y4t2r4u3m4v4y4w4m4x5y4y4s4z4y5k3x5l4y5m4s5n3r5o4m5p4s5q4s5r6o5s4s5t4s5u4m5v2l5w1w5x2l5y3u5z3m6k2l6l3m6m3r6n2w6o3r6p2w6q2l6r3m6s3r6t1w6u2l6v3r6w1w6x5n6y3r6z3m7k3r7l3r7m2w7n2r7o2l7p3r7q3m7r4s7s3m7t3m7u2w7v2r7w1q7x2r7y3o202l3mcl4sal2lam3man3mao3map3mar3mas2lat4uau1yav3maw3tay4uaz2lbk2sbl3t'fof'6obo2lbp3rbr1tbs2lbu2lbv3mbz3mck4s202k3mcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw2r2m3rcy2rcz2rdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3rek3mel3mem3men3meo3mep3meq4ser2wes2wet2weu2wev2wew1wex1wey1wez1wfl3rfm3mfn3mfo3mfp3mfq3mfr3tfs3mft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3m3u2l17s4s19m3m}'kerning'{cl{4qt5ks5ot5qy5rw17sv5tv}201t{cks4lscmscnscoscpscls4wv}2k{201ts}2w{4qu5ku7mu5os5qx5ru17su5tu}2x{17su5tu5ou5qs}2y{4qv5kv7mu5ot5qz5ru17su5tu}'fof'-6o7t{cksclscmscnscoscps4ls}3u{17su5tu5os5qu}3v{17su5tu5os5qu}fu{17su5tu5ou5qu}7p{17su5tu5ou5qu}ck{4qt5ks5ot5qy5rw17sv5tv}4l{4qt5ks5ot5qy5rw17sv5tv}cm{4qt5ks5ot5qy5rw17sv5tv}cn{4qt5ks5ot5qy5rw17sv5tv}co{4qt5ks5ot5qy5rw17sv5tv}cp{4qt5ks5ot5qy5rw17sv5tv}6l{17st5tt5ou5qu}17s{ckuclucmucnucoucpu4lu4wu}5o{ckuclucmucnucoucpu4lu4wu}5q{ckzclzcmzcnzcozcpz4lz4wu}5r{ckxclxcmxcnxcoxcpx4lx4wu}5t{ckuclucmucnucoucpu4lu4wu}7q{ckuclucmucnucoucpu4lu}6p{17sw5tw5ou5qu}ek{17st5tt5qu}el{17st5tt5ou5qu}em{17st5tt5qu}en{17st5tt5qu}eo{17st5tt5qu}ep{17st5tt5ou5qu}es{17ss5ts5qu}et{17sw5tw5ou5qu}eu{17sw5tw5ou5qu}ev{17ss5ts5qu}6z{17sw5tw5ou5qu5rs}fm{17sw5tw5ou5qu5rs}fn{17sw5tw5ou5qu5rs}fo{17sw5tw5ou5qu5rs}fp{17sw5tw5ou5qu5rs}fq{17sw5tw5ou5qu5rs}7r{cktcltcmtcntcotcpt4lt5os}fs{17sw5tw5ou5qu5rs}ft{17su5tu5ou5qu}7m{5os}fv{17su5tu5ou5qu}fw{17su5tu5ou5qu}fz{cksclscmscnscoscps4ls}}}"),Symbol:l("{'widths'{k3uaw4r19m3m2k1t2l2l202m2y2n3m2p5n202q6o3k3m2s2l2t2l2v3r2w1t3m3m2y1t2z1wbk2sbl3r'fof'6o3n3m3o3m3p3m3q3m3r3m3s3m3t3m3u1w3v1w3w3r3x3r3y3r3z2wbp3t3l3m5v2l5x2l5z3m2q4yfr3r7v3k7w1o7x3k}'kerning'{'fof'-6o}}"),Helvetica:l("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}"),"Helvetica-BoldOblique":l("{'widths'{k3s2q4scx1w201n3r201o6o201s1w201t1w201u1w201w3m201x3m201y3m2k1w2l2l202m2n2n3r2o3r2p5t202q6o2r1s2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v2l3w3u3x3u3y3u3z3x4k6l4l4s4m4s4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3r4v4s4w3x4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v2l5w1w5x2l5y3u5z3r6k2l6l3r6m3x6n3r6o3x6p3r6q2l6r3x6s3x6t1w6u1w6v3r6w1w6x5t6y3x6z3x7k3x7l3x7m2r7n3r7o2l7p3x7q3r7r4y7s3r7t3r7u3m7v2r7w1w7x2r7y3u202l3rcl4sal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3xbq3rbr1wbs2lbu2obv3rbz3xck4s202k3rcm4scn4sco4scp4scq6ocr4scs4mct4mcu4mcv4mcw1w2m2zcy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3res3ret3reu3rev3rew1wex1wey1wez1wfl3xfm3xfn3xfo3xfp3xfq3xfr3ufs3xft3xfu3xfv3xfw3xfz3r203k6o212m6o2dw2l2cq2l3t3r3u2l17s4m19m3r}'kerning'{cl{4qs5ku5ot5qs17sv5tv}201t{2ww4wy2yw}201w{2ks}201x{2ww4wy2yw}2k{201ts201xs}2w{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}2x{5ow5qs}2y{7qs4qu5kw5os5qw5rs17su5tu7tsfzs}'fof'-6o7p{17su5tu5ot}ck{4qs5ku5ot5qs17sv5tv}4l{4qs5ku5ot5qs17sv5tv}cm{4qs5ku5ot5qs17sv5tv}cn{4qs5ku5ot5qs17sv5tv}co{4qs5ku5ot5qs17sv5tv}cp{4qs5ku5ot5qs17sv5tv}6l{17st5tt5os}17s{2kwclvcmvcnvcovcpv4lv4wwckv}5o{2kucltcmtcntcotcpt4lt4wtckt}5q{2ksclscmscnscoscps4ls4wvcks}5r{2ks4ws}5t{2kwclvcmvcnvcovcpv4lv4wwckv}eo{17st5tt5os}fu{17su5tu5ot}6p{17ss5ts}ek{17st5tt5os}el{17st5tt5os}em{17st5tt5os}en{17st5tt5os}6o{201ts}ep{17st5tt5os}es{17ss5ts}et{17ss5ts}eu{17ss5ts}ev{17ss5ts}6z{17su5tu5os5qt}fm{17su5tu5os5qt}fn{17su5tu5os5qt}fo{17su5tu5os5qt}fp{17su5tu5os5qt}fq{17su5tu5os5qt}fs{17su5tu5os5qt}ft{17su5tu5ot}7m{5os}fv{17su5tu5ot}fw{17su5tu5ot}}}"),ZapfDingbats:l("{'widths'{k4u2k1w'fof'6o}'kerning'{'fof'-6o}}"),"Courier-Bold":l("{'widths'{k3w'fof'6o}'kerning'{'fof'-6o}}"),"Times-Italic":l("{'widths'{k3n2q4ycx2l201n3m201o5t201s2l201t2l201u2l201w3r201x3r201y3r2k1t2l2l202m2n2n3m2o3m2p5n202q5t2r1p2s2l2t2l2u3m2v4n2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v2l3w4n3x4n3y4n3z3m4k5w4l3x4m3x4n4m4o4s4p3x4q3x4r4s4s4s4t2l4u2w4v4m4w3r4x5n4y4m4z4s5k3x5l4s5m3x5n3m5o3r5p4s5q3x5r5n5s3x5t3r5u3r5v2r5w1w5x2r5y2u5z3m6k2l6l3m6m3m6n2w6o3m6p2w6q1w6r3m6s3m6t1w6u1w6v2w6w1w6x4s6y3m6z3m7k3m7l3m7m2r7n2r7o1w7p3m7q2w7r4m7s2w7t2w7u2r7v2s7w1v7x2s7y3q202l3mcl3xal2ram3man3mao3map3mar3mas2lat4wau1vav3maw4nay4waz2lbk2sbl4n'fof'6obo2lbp3mbq3obr1tbs2lbu1zbv3mbz3mck3x202k3mcm3xcn3xco3xcp3xcq5tcr4mcs3xct3xcu3xcv3xcw2l2m2ucy2lcz2ldl4mdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek3mel3mem3men3meo3mep3meq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr4nfs3mft3mfu3mfv3mfw3mfz2w203k6o212m6m2dw2l2cq2l3t3m3u2l17s3r19m3m}'kerning'{cl{5kt4qw}201s{201sw}201t{201tw2wy2yy6q-t}201x{2wy2yy}2k{201tw}2w{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}2x{17ss5ts5os}2y{7qs4qy7rs5ky7mw5os5qx5ru17su5tu}'fof'-6o6t{17ss5ts5qs}7t{5os}3v{5qs}7p{17su5tu5qs}ck{5kt4qw}4l{5kt4qw}cm{5kt4qw}cn{5kt4qw}co{5kt4qw}cp{5kt4qw}6l{4qs5ks5ou5qw5ru17su5tu}17s{2ks}5q{ckvclvcmvcnvcovcpv4lv}5r{ckuclucmucnucoucpu4lu}5t{2ks}6p{4qs5ks5ou5qw5ru17su5tu}ek{4qs5ks5ou5qw5ru17su5tu}el{4qs5ks5ou5qw5ru17su5tu}em{4qs5ks5ou5qw5ru17su5tu}en{4qs5ks5ou5qw5ru17su5tu}eo{4qs5ks5ou5qw5ru17su5tu}ep{4qs5ks5ou5qw5ru17su5tu}es{5ks5qs4qs}et{4qs5ks5ou5qw5ru17su5tu}eu{4qs5ks5qw5ru17su5tu}ev{5ks5qs4qs}ex{17ss5ts5qs}6z{4qv5ks5ou5qw5ru17su5tu}fm{4qv5ks5ou5qw5ru17su5tu}fn{4qv5ks5ou5qw5ru17su5tu}fo{4qv5ks5ou5qw5ru17su5tu}fp{4qv5ks5ou5qw5ru17su5tu}fq{4qv5ks5ou5qw5ru17su5tu}7r{5os}fs{4qv5ks5ou5qw5ru17su5tu}ft{17su5tu5qs}fu{17su5tu5qs}fv{17su5tu5qs}fw{17su5tu5qs}}}"),"Times-Roman":l("{'widths'{k3n2q4ycx2l201n3m201o6o201s2l201t2l201u2l201w2w201x2w201y2w2k1t2l2l202m2n2n3m2o3m2p5n202q6o2r1m2s2l2t2l2u3m2v3s2w1t2x2l2y1t2z1w3k3m3l3m3m3m3n3m3o3m3p3m3q3m3r3m3s3m203t2l203u2l3v1w3w3s3x3s3y3s3z2w4k5w4l4s4m4m4n4m4o4s4p3x4q3r4r4s4s4s4t2l4u2r4v4s4w3x4x5t4y4s4z4s5k3r5l4s5m4m5n3r5o3x5p4s5q4s5r5y5s4s5t4s5u3x5v2l5w1w5x2l5y2z5z3m6k2l6l2w6m3m6n2w6o3m6p2w6q2l6r3m6s3m6t1w6u1w6v3m6w1w6x4y6y3m6z3m7k3m7l3m7m2l7n2r7o1w7p3m7q3m7r4s7s3m7t3m7u2w7v3k7w1o7x3k7y3q202l3mcl4sal2lam3man3mao3map3mar3mas2lat4wau1vav3maw3say4waz2lbk2sbl3s'fof'6obo2lbp3mbq2xbr1tbs2lbu1zbv3mbz2wck4s202k3mcm4scn4sco4scp4scq5tcr4mcs3xct3xcu3xcv3xcw2l2m2tcy2lcz2ldl4sdm4sdn4sdo4sdp4sdq4sds4sdt4sdu4sdv4sdw4sdz3mek2wel2wem2wen2weo2wep2weq4mer2wes2wet2weu2wev2wew1wex1wey1wez1wfl3mfm3mfn3mfo3mfp3mfq3mfr3sfs3mft3mfu3mfv3mfw3mfz3m203k6o212m6m2dw2l2cq2l3t3m3u1w17s4s19m3m}'kerning'{cl{4qs5ku17sw5ou5qy5rw201ss5tw201ws}201s{201ss}201t{ckw4lwcmwcnwcowcpwclw4wu201ts}2k{201ts}2w{4qs5kw5os5qx5ru17sx5tx}2x{17sw5tw5ou5qu}2y{4qs5kw5os5qx5ru17sx5tx}'fof'-6o7t{ckuclucmucnucoucpu4lu5os5rs}3u{17su5tu5qs}3v{17su5tu5qs}7p{17sw5tw5qs}ck{4qs5ku17sw5ou5qy5rw201ss5tw201ws}4l{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cm{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cn{4qs5ku17sw5ou5qy5rw201ss5tw201ws}co{4qs5ku17sw5ou5qy5rw201ss5tw201ws}cp{4qs5ku17sw5ou5qy5rw201ss5tw201ws}6l{17su5tu5os5qw5rs}17s{2ktclvcmvcnvcovcpv4lv4wuckv}5o{ckwclwcmwcnwcowcpw4lw4wu}5q{ckyclycmycnycoycpy4ly4wu5ms}5r{cktcltcmtcntcotcpt4lt4ws}5t{2ktclvcmvcnvcovcpv4lv4wuckv}7q{cksclscmscnscoscps4ls}6p{17su5tu5qw5rs}ek{5qs5rs}el{17su5tu5os5qw5rs}em{17su5tu5os5qs5rs}en{17su5qs5rs}eo{5qs5rs}ep{17su5tu5os5qw5rs}es{5qs}et{17su5tu5qw5rs}eu{17su5tu5qs5rs}ev{5qs}6z{17sv5tv5os5qx5rs}fm{5os5qt5rs}fn{17sv5tv5os5qx5rs}fo{17sv5tv5os5qx5rs}fp{5os5qt5rs}fq{5os5qt5rs}7r{ckuclucmucnucoucpu4lu5os}fs{17sv5tv5os5qx5rs}ft{17ss5ts5qs}fu{17sw5tw5qs}fv{17sw5tw5qs}fw{17ss5ts5qs}fz{ckuclucmucnucoucpu4lu5os5rs}}}"),"Helvetica-Oblique":l("{'widths'{k3p2q4mcx1w201n3r201o6o201s1q201t1q201u1q201w2l201x2l201y2l2k1w2l1w202m2n2n3r2o3r2p5t202q6o2r1n2s2l2t2l2u2r2v3u2w1w2x2l2y1w2z1w3k3r3l3r3m3r3n3r3o3r3p3r3q3r3r3r3s3r203t2l203u2l3v1w3w3u3x3u3y3u3z3r4k6p4l4m4m4m4n4s4o4s4p4m4q3x4r4y4s4s4t1w4u3m4v4m4w3r4x5n4y4s4z4y5k4m5l4y5m4s5n4m5o3x5p4s5q4m5r5y5s4m5t4m5u3x5v1w5w1w5x1w5y2z5z3r6k2l6l3r6m3r6n3m6o3r6p3r6q1w6r3r6s3r6t1q6u1q6v3m6w1q6x5n6y3r6z3r7k3r7l3r7m2l7n3m7o1w7p3r7q3m7r4s7s3m7t3m7u3m7v2l7w1u7x2l7y3u202l3rcl4mal2lam3ran3rao3rap3rar3ras2lat4tau2pav3raw3uay4taz2lbk2sbl3u'fof'6obo2lbp3rbr1wbs2lbu2obv3rbz3xck4m202k3rcm4mcn4mco4mcp4mcq6ocr4scs4mct4mcu4mcv4mcw1w2m2ncy1wcz1wdl4sdm4ydn4ydo4ydp4ydq4yds4ydt4sdu4sdv4sdw4sdz3xek3rel3rem3ren3reo3rep3req5ter3mes3ret3reu3rev3rew1wex1wey1wez1wfl3rfm3rfn3rfo3rfp3rfq3rfr3ufs3xft3rfu3rfv3rfw3rfz3m203k6o212m6o2dw2l2cq2l3t3r3u1w17s4m19m3r}'kerning'{5q{4wv}cl{4qs5kw5ow5qs17sv5tv}201t{2wu4w1k2yu}201x{2wu4wy2yu}17s{2ktclucmucnu4otcpu4lu4wycoucku}2w{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}2x{17sy5ty5oy5qs}2y{7qs4qz5k1m17sy5ow5qx5rsfsu5ty7tufzu}'fof'-6o7p{17sv5tv5ow}ck{4qs5kw5ow5qs17sv5tv}4l{4qs5kw5ow5qs17sv5tv}cm{4qs5kw5ow5qs17sv5tv}cn{4qs5kw5ow5qs17sv5tv}co{4qs5kw5ow5qs17sv5tv}cp{4qs5kw5ow5qs17sv5tv}6l{17sy5ty5ow}do{17st5tt}4z{17st5tt}7s{fst}dm{17st5tt}dn{17st5tt}5o{ckwclwcmwcnwcowcpw4lw4wv}dp{17st5tt}dq{17st5tt}7t{5ow}ds{17st5tt}5t{2ktclucmucnu4otcpu4lu4wycoucku}fu{17sv5tv5ow}6p{17sy5ty5ow5qs}ek{17sy5ty5ow}el{17sy5ty5ow}em{17sy5ty5ow}en{5ty}eo{17sy5ty5ow}ep{17sy5ty5ow}es{17sy5ty5qs}et{17sy5ty5ow5qs}eu{17sy5ty5ow5qs}ev{17sy5ty5ow5qs}6z{17sy5ty5ow5qs}fm{17sy5ty5ow5qs}fn{17sy5ty5ow5qs}fo{17sy5ty5ow5qs}fp{17sy5ty5qs}fq{17sy5ty5ow5qs}7r{5ow}fs{17sy5ty5ow5qs}ft{17sv5tv5ow}7m{5ow}fv{17sv5tv5ow}fw{17sv5tv5ow}}}")}};t.events.push(["addFont",function(t){var e=t.font,r=f.Unicode[e.postScriptName];r&&(e.metadata.Unicode={},e.metadata.Unicode.widths=r.widths,e.metadata.Unicode.kerning=r.kerning);var n=c.Unicode[e.postScriptName];n&&(e.metadata.Unicode.encoding=n,e.encoding=n.codePages[0])}])}(R.API),
/**
   * @license
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e=function(t){for(var e=t.length,r=new Uint8Array(e),n=0;n<e;n++)r[n]=t.charCodeAt(n);return r};t.API.events.push(["addFont",function(r){var n=void 0,i=r.font,a=r.instance;if(!i.isStandardFont){if(void 0===a)throw new Error("Font does not exist in vFS, import fonts or remove declaration doc.addFont('"+i.postScriptName+"').");if("string"!=typeof(n=!1===a.existsFileInVFS(i.postScriptName)?a.loadFile(i.postScriptName):a.getFileFromVFS(i.postScriptName)))throw new Error("Font is not stored as string-data in vFS, import fonts or remove declaration doc.addFont('"+i.postScriptName+"').");!function(r,n){n=/^\x00\x01\x00\x00/.test(n)?e(n):e(f(n)),r.metadata=t.API.TTFFont.open(n),r.metadata.Unicode=r.metadata.Unicode||{encoding:{},kerning:{},widths:[]},r.metadata.glyIdsUsed=[0]}(i,n)}}])}(R),function(e){e.addSvgAsImage=function(e,r,a,o,h,l,u,c){if(isNaN(r)||isNaN(a))throw s.error("jsPDF.addSvgAsImage: Invalid coordinates",arguments),new Error("Invalid coordinates passed to jsPDF.addSvgAsImage");if(isNaN(o)||isNaN(h))throw s.error("jsPDF.addSvgAsImage: Invalid measurements",arguments),new Error("Invalid measurements (width and/or height) passed to jsPDF.addSvgAsImage");var f=document.createElement("canvas");f.width=o,f.height=h;var d=f.getContext("2d");d.fillStyle="#fff",d.fillRect(0,0,f.width,f.height);var p={ignoreMouse:!0,ignoreAnimation:!0,ignoreDimensions:!0},g=this;return(i.canvg?Promise.resolve(i.canvg):"object"===(void 0===t?"undefined":n(t))&&"undefined"!=typeof module?new Promise(function(t,e){try{t(require("canvg"))}catch(is){e(is)}}):"function"==typeof define&&define.amd?new Promise(function(t,e){try{require(["canvg"],t)}catch(is){e(is)}}):Promise.reject(new Error("Could not load canvg"))).catch(function(t){return Promise.reject(new Error("Could not load canvg: "+t))}).then(function(t){return t.default?t.default:t}).then(function(t){return t.fromString(d,e,p)},function(){return Promise.reject(new Error("Could not load canvg."))}).then(function(t){return t.render(p)}).then(function(){g.addImage(f.toDataURL("image/jpeg",1),r,a,o,h,u,c)})}}(R.API),
/**
   * @license
   * ====================================================================
   * Copyright (c) 2013 Eduardo Menezes de Morais, eduardo.morais@usp.br
   *
   * Permission is hereby granted, free of charge, to any person obtaining
   * a copy of this software and associated documentation files (the
   * "Software"), to deal in the Software without restriction, including
   * without limitation the rights to use, copy, modify, merge, publish,
   * distribute, sublicense, and/or sell copies of the Software, and to
   * permit persons to whom the Software is furnished to do so, subject to
   * the following conditions:
   *
   * The above copyright notice and this permission notice shall be
   * included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
   * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
   * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
   * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   * ====================================================================
   */
function(t){t.putTotalPages=function(t){var e,r=0;parseInt(this.internal.getFont().id.substr(1),10)<15?(e=new RegExp(t,"g"),r=this.internal.getNumberOfPages()):(e=new RegExp(this.pdfEscape16(t,this.internal.getFont()),"g"),r=this.pdfEscape16(this.internal.getNumberOfPages()+"",this.internal.getFont()));for(var n=1;n<=this.internal.getNumberOfPages();n++)for(var i=0;i<this.internal.pages[n].length;i++)this.internal.pages[n][i]=this.internal.pages[n][i].replace(e,r);return this}}(R.API),function(t){t.viewerPreferences=function(t,e){var r;t=t||{},e=e||!1;var i,a,s,o={HideToolbar:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideMenubar:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},HideWindowUI:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},FitWindow:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},CenterWindow:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.3},DisplayDocTitle:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.4},NonFullScreenPageMode:{defaultValue:"UseNone",value:"UseNone",type:"name",explicitSet:!1,valueSet:["UseNone","UseOutlines","UseThumbs","UseOC"],pdfVersion:1.3},Direction:{defaultValue:"L2R",value:"L2R",type:"name",explicitSet:!1,valueSet:["L2R","R2L"],pdfVersion:1.3},ViewArea:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},ViewClip:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintArea:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintClip:{defaultValue:"CropBox",value:"CropBox",type:"name",explicitSet:!1,valueSet:["MediaBox","CropBox","TrimBox","BleedBox","ArtBox"],pdfVersion:1.4},PrintScaling:{defaultValue:"AppDefault",value:"AppDefault",type:"name",explicitSet:!1,valueSet:["AppDefault","None"],pdfVersion:1.6},Duplex:{defaultValue:"",value:"none",type:"name",explicitSet:!1,valueSet:["Simplex","DuplexFlipShortEdge","DuplexFlipLongEdge","none"],pdfVersion:1.7},PickTrayByPDFSize:{defaultValue:!1,value:!1,type:"boolean",explicitSet:!1,valueSet:[!0,!1],pdfVersion:1.7},PrintPageRange:{defaultValue:"",value:"",type:"array",explicitSet:!1,valueSet:null,pdfVersion:1.7},NumCopies:{defaultValue:1,value:1,type:"integer",explicitSet:!1,valueSet:null,pdfVersion:1.7}},h=Object.keys(o),l=[],u=0,c=0,f=0;function d(t,e){var r,n=!1;for(r=0;r<t.length;r+=1)t[r]===e&&(n=!0);return n}if(void 0===this.internal.viewerpreferences&&(this.internal.viewerpreferences={},this.internal.viewerpreferences.configuration=JSON.parse(JSON.stringify(o)),this.internal.viewerpreferences.isSubscribed=!1),r=this.internal.viewerpreferences.configuration,"reset"===t||!0===e){var p=h.length;for(f=0;f<p;f+=1)r[h[f]].value=r[h[f]].defaultValue,r[h[f]].explicitSet=!1}if("object"===n(t))for(a in t)if(s=t[a],d(h,a)&&void 0!==s){if("boolean"===r[a].type&&"boolean"==typeof s)r[a].value=s;else if("name"===r[a].type&&d(r[a].valueSet,s))r[a].value=s;else if("integer"===r[a].type&&Number.isInteger(s))r[a].value=s;else if("array"===r[a].type){for(u=0;u<s.length;u+=1)if(i=!0,1===s[u].length&&"number"==typeof s[u][0])l.push(String(s[u]-1));else if(s[u].length>1){for(c=0;c<s[u].length;c+=1)"number"!=typeof s[u][c]&&(i=!1);!0===i&&l.push([s[u][0]-1,s[u][1]-1].join(" "))}r[a].value="["+l.join(" ")+"]"}else r[a].value=r[a].defaultValue;r[a].explicitSet=!0}return!1===this.internal.viewerpreferences.isSubscribed&&(this.internal.events.subscribe("putCatalog",function(){var t,e=[];for(t in r)!0===r[t].explicitSet&&("name"===r[t].type?e.push("/"+t+" /"+r[t].value):e.push("/"+t+" "+r[t].value));0!==e.length&&this.internal.write("/ViewerPreferences\n<<\n"+e.join("\n")+"\n>>")}),this.internal.viewerpreferences.isSubscribed=!0),this.internal.viewerpreferences.configuration=r,this}}(R.API),R.API.addMetadata=function(t,e){return void 0===this.internal.__metadata__&&(this.internal.__metadata__={metadata:t,namespaceUri:null!=e?e:"http://jspdf.default.namespaceuri/",rawXml:"boolean"==typeof e&&e},this.internal.events.subscribe("putCatalog",Ma),this.internal.events.subscribe("postPutResources",Ba)),this},function(t){var e=t.API,r=e.pdfEscape16=function(t,e){for(var r,n=e.metadata.Unicode.widths,i=["","0","00","000","0000"],a=[""],s=0,o=t.length;s<o;++s){if(r=e.metadata.characterToGlyph(t.charCodeAt(s)),e.metadata.glyIdsUsed.push(r),e.metadata.toUnicode[r]=t.charCodeAt(s),-1==n.indexOf(r)&&(n.push(r),n.push([parseInt(e.metadata.widthOfGlyph(r),10)])),"0"==r)return a.join("");r=r.toString(16),a.push(i[4-r.length],r)}return a.join("")},n=function(t){var e,r,n,i,a,s,o;for(a="/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo <<\n  /Registry (Adobe)\n  /Ordering (UCS)\n  /Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000><ffff>\nendcodespacerange",n=[],s=0,o=(r=Object.keys(t).sort(function(t,e){return t-e})).length;s<o;s++)e=r[s],n.length>=100&&(a+="\n"+n.length+" beginbfchar\n"+n.join("\n")+"\nendbfchar",n=[]),void 0!==t[e]&&null!==t[e]&&"function"==typeof t[e].toString&&(i=("0000"+t[e].toString(16)).slice(-4),e=("0000"+(+e).toString(16)).slice(-4),n.push("<"+e+"><"+i+">"));return n.length&&(a+="\n"+n.length+" beginbfchar\n"+n.join("\n")+"\nendbfchar\n"),a+"endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend"};e.events.push(["putFont",function(e){!function(e){var r=e.font,i=e.out,a=e.newObject,s=e.putStream;if(r.metadata instanceof t.API.TTFFont&&"Identity-H"===r.encoding){for(var o=r.metadata.Unicode.widths,h=r.metadata.subset.encode(r.metadata.glyIdsUsed,1),l="",u=0;u<h.length;u++)l+=String.fromCharCode(h[u]);var c=a();s({data:l,addLength1:!0,objectId:c}),i("endobj");var f=a();s({data:n(r.metadata.toUnicode),addLength1:!0,objectId:f}),i("endobj");var d=a();i("<<"),i("/Type /FontDescriptor"),i("/FontName /"+C(r.fontName)),i("/FontFile2 "+c+" 0 R"),i("/FontBBox "+t.API.PDFObject.convert(r.metadata.bbox)),i("/Flags "+r.metadata.flags),i("/StemV "+r.metadata.stemV),i("/ItalicAngle "+r.metadata.italicAngle),i("/Ascent "+r.metadata.ascender),i("/Descent "+r.metadata.decender),i("/CapHeight "+r.metadata.capHeight),i(">>"),i("endobj");var p=a();i("<<"),i("/Type /Font"),i("/BaseFont /"+C(r.fontName)),i("/FontDescriptor "+d+" 0 R"),i("/W "+t.API.PDFObject.convert(o)),i("/CIDToGIDMap /Identity"),i("/DW 1000"),i("/Subtype /CIDFontType2"),i("/CIDSystemInfo"),i("<<"),i("/Supplement 0"),i("/Registry (Adobe)"),i("/Ordering ("+r.encoding+")"),i(">>"),i(">>"),i("endobj"),r.objectNumber=a(),i("<<"),i("/Type /Font"),i("/Subtype /Type0"),i("/ToUnicode "+f+" 0 R"),i("/BaseFont /"+C(r.fontName)),i("/Encoding /"+r.encoding),i("/DescendantFonts ["+p+" 0 R]"),i(">>"),i("endobj"),r.isAlreadyPutted=!0}}(e)}]),e.events.push(["putFont",function(e){!function(e){var r=e.font,i=e.out,a=e.newObject,s=e.putStream;if(r.metadata instanceof t.API.TTFFont&&"WinAnsiEncoding"===r.encoding){for(var o=r.metadata.rawData,h="",l=0;l<o.length;l++)h+=String.fromCharCode(o[l]);var u=a();s({data:h,addLength1:!0,objectId:u}),i("endobj");var c=a();s({data:n(r.metadata.toUnicode),addLength1:!0,objectId:c}),i("endobj");var f=a();i("<<"),i("/Descent "+r.metadata.decender),i("/CapHeight "+r.metadata.capHeight),i("/StemV "+r.metadata.stemV),i("/Type /FontDescriptor"),i("/FontFile2 "+u+" 0 R"),i("/Flags 96"),i("/FontBBox "+t.API.PDFObject.convert(r.metadata.bbox)),i("/FontName /"+C(r.fontName)),i("/ItalicAngle "+r.metadata.italicAngle),i("/Ascent "+r.metadata.ascender),i(">>"),i("endobj"),r.objectNumber=a();for(var d=0;d<r.metadata.hmtx.widths.length;d++)r.metadata.hmtx.widths[d]=parseInt(r.metadata.hmtx.widths[d]*(1e3/r.metadata.head.unitsPerEm));i("<</Subtype/TrueType/Type/Font/ToUnicode "+c+" 0 R/BaseFont/"+C(r.fontName)+"/FontDescriptor "+f+" 0 R/Encoding/"+r.encoding+" /FirstChar 29 /LastChar 255 /Widths "+t.API.PDFObject.convert(r.metadata.hmtx.widths)+">>"),i("endobj"),r.isAlreadyPutted=!0}}(e)}]);var i=function(t){var e,n=t.text||"",i=t.x,a=t.y,s=t.options||{},o=t.mutex||{},h=o.pdfEscape,l=o.activeFontKey,u=o.fonts,c=l,f="",d=0,p="",g=u[c].encoding;if("Identity-H"!==u[c].encoding)return{text:n,x:i,y:a,options:s,mutex:o};for(p=n,c=l,Array.isArray(n)&&(p=n[0]),d=0;d<p.length;d+=1)u[c].metadata.hasOwnProperty("cmap")&&(e=u[c].metadata.cmap.unicode.codeMap[p[d].charCodeAt(0)]),e||p[d].charCodeAt(0)<256&&u[c].metadata.hasOwnProperty("Unicode")?f+=p[d]:f+="";var m="";return parseInt(c.slice(1))<14||"WinAnsiEncoding"===g?m=h(f,c).split("").map(function(t){return t.charCodeAt(0).toString(16)}).join(""):"Identity-H"===g&&(m=r(f,u[c])),o.isHex=!0,{text:m,x:i,y:a,options:s,mutex:o}};e.events.push(["postProcessText",function(t){var e=t.text||"",r=[],n={text:e,x:t.x,y:t.y,options:t.options,mutex:t.mutex};if(Array.isArray(e)){var a=0;for(a=0;a<e.length;a+=1)Array.isArray(e[a])&&3===e[a].length?r.push([i(Object.assign({},n,{text:e[a][0]})).text,e[a][1],e[a][2]]):r.push(i(Object.assign({},n,{text:e[a]})).text);t.text=r}else t.text=i(Object.assign({},n,{text:e})).text}])}(R),
/**
   * @license
   * jsPDF virtual FileSystem functionality
   *
   * Licensed under the MIT License.
   * http://opensource.org/licenses/mit-license
   */
function(t){var e=function(){return void 0===this.internal.vFS&&(this.internal.vFS={}),!0};t.existsFileInVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]},t.addFileToVFS=function(t,r){return e.call(this),this.internal.vFS[t]=r,this},t.getFileFromVFS=function(t){return e.call(this),void 0!==this.internal.vFS[t]?this.internal.vFS[t]:null}}(R.API),
/**
   * @license
   * Unicode Bidi Engine based on the work of Alex Shensis (@asthensis)
   * MIT License
   */
function(t){t.__bidiEngine__=t.prototype.__bidiEngine__=function(t){var r,n,i,a,s,o,h,l=e,u=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],c=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],f={L:0,R:1,EN:2,AN:3,N:4,B:5,S:6},d={0:0,5:1,6:2,7:3,32:4,251:5,254:6,255:7},p=["(",")","(","<",">","<","[","]","[","{","}","{","«","»","«","‹","›","‹","⁅","⁆","⁅","⁽","⁾","⁽","₍","₎","₍","≤","≥","≤","〈","〉","〈","﹙","﹚","﹙","﹛","﹜","﹛","﹝","﹞","﹝","﹤","﹥","﹤"],g=new RegExp(/^([1-4|9]|1[0-9]|2[0-9]|3[0168]|4[04589]|5[012]|7[78]|159|16[0-9]|17[0-2]|21[569]|22[03489]|250)$/),m=!1,b=0;this.__bidiEngine__={};var v=function(t){var e=t.charCodeAt(),r=e>>8,n=d[r];return void 0!==n?l[256*n+(255&e)]:252===r||253===r?"AL":g.test(r)?"L":8===r?"R":"N"},w=function(t){for(var e,r=0;r<t.length;r++){if("L"===(e=v(t.charAt(r))))return!1;if("R"===e)return!0}return!1},y=function(t,e,s,o){var h,l,u,c,f=e[o];switch(f){case"L":case"R":case"LRE":case"RLE":case"LRO":case"RLO":case"PDF":m=!1;break;case"N":case"AN":break;case"EN":m&&(f="AN");break;case"AL":m=!0,f="R";break;case"WS":case"BN":f="N";break;case"CS":o<1||o+1>=e.length||"EN"!==(h=s[o-1])&&"AN"!==h||"EN"!==(l=e[o+1])&&"AN"!==l?f="N":m&&(l="AN"),f=l===h?l:"N";break;case"ES":f="EN"===(h=o>0?s[o-1]:"B")&&o+1<e.length&&"EN"===e[o+1]?"EN":"N";break;case"ET":if(o>0&&"EN"===s[o-1]){f="EN";break}if(m){f="N";break}for(u=o+1,c=e.length;u<c&&"ET"===e[u];)u++;f=u<c&&"EN"===e[u]?"EN":"N";break;case"NSM":if(i&&!a){for(c=e.length,u=o+1;u<c&&"NSM"===e[u];)u++;if(u<c){var d=t[o],p=d>=1425&&d<=2303||64286===d;if(h=e[u],p&&("R"===h||"AL"===h)){f="R";break}}}f=o<1||"B"===(h=e[o-1])?"N":s[o-1];break;case"B":m=!1,r=!0,f=b;break;case"S":n=!0,f="N"}return f},_=function(t,e,r){var n=t.split("");return r&&x(n,r,{hiLevel:b}),n.reverse(),e&&e.reverse(),n.join("")},x=function(t,e,i){var a,s,o,h,l,d=-1,p=t.length,g=0,w=[],_=b?c:u,x=[];for(m=!1,r=!1,n=!1,s=0;s<p;s++)x[s]=v(t[s]);for(o=0;o<p;o++){if(l=g,w[o]=y(t,x,w,o),a=240&(g=_[l][f[w[o]]]),g&=15,e[o]=h=_[g][5],a>0)if(16===a){for(s=d;s<o;s++)e[s]=1;d=-1}else d=-1;if(_[g][6])-1===d&&(d=o);else if(d>-1){for(s=d;s<o;s++)e[s]=h;d=-1}"B"===x[o]&&(e[o]=0),i.hiLevel|=h}n&&function(t,e,r){for(var n=0;n<r;n++)if("S"===t[n]){e[n]=b;for(var i=n-1;i>=0&&"WS"===t[i];i--)e[i]=b}}(x,e,p)},A=function(t,e,n,i,a){if(!(a.hiLevel<t)){if(1===t&&1===b&&!r)return e.reverse(),void(n&&n.reverse());for(var s,o,h,l,u=e.length,c=0;c<u;){if(i[c]>=t){for(h=c+1;h<u&&i[h]>=t;)h++;for(l=c,o=h-1;l<o;l++,o--)s=e[l],e[l]=e[o],e[o]=s,n&&(s=n[l],n[l]=n[o],n[o]=s);c=h}c++}}},L=function(t,e,r){var n=t.split(""),i={hiLevel:b};return r||(r=[]),x(n,r,i),function(t,e,r){if(0!==r.hiLevel&&h)for(var n,i=0;i<t.length;i++)1===e[i]&&(n=p.indexOf(t[i]))>=0&&(t[i]=p[n+1])}(n,r,i),A(2,n,e,r,i),A(1,n,e,r,i),n.join("")};return this.__bidiEngine__.doBidiReorder=function(t,e,r){if(function(t,e){if(e)for(var r=0;r<t.length;r++)e[r]=r;void 0===a&&(a=w(t)),void 0===o&&(o=w(t))}(t,e),i||!s||o)if(i&&s&&a^o)b=a?1:0,t=_(t,e,r);else if(!i&&s&&o)b=a?1:0,t=L(t,e,r),t=_(t,e);else if(!i||a||s||o){if(i&&!s&&a^o)t=_(t,e),a?(b=0,t=L(t,e,r)):(b=1,t=L(t,e,r),t=_(t,e));else if(i&&a&&!s&&o)b=1,t=L(t,e,r),t=_(t,e);else if(!i&&!s&&a^o){var n=h;a?(b=1,t=L(t,e,r),b=0,h=!1,t=L(t,e,r),h=n):(b=0,t=L(t,e,r),t=_(t,e),b=1,h=!1,t=L(t,e,r),h=n,t=_(t,e))}}else b=0,t=L(t,e,r);else b=a?1:0,t=L(t,e,r);return t},this.__bidiEngine__.setOptions=function(t){t&&(i=t.isInputVisual,s=t.isOutputVisual,a=t.isInputRtl,o=t.isOutputRtl,h=t.isSymmetricSwapping)},this.__bidiEngine__.setOptions(t),this.__bidiEngine__};var e=["BN","BN","BN","BN","BN","BN","BN","BN","BN","S","B","S","WS","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","B","B","B","S","WS","N","N","ET","ET","ET","N","N","N","N","N","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","BN","BN","BN","BN","BN","BN","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","CS","N","ET","ET","ET","ET","N","N","N","N","L","N","N","BN","N","N","ET","ET","EN","EN","N","L","N","N","N","EN","L","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","L","L","L","L","L","L","L","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","L","N","N","N","N","N","ET","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","R","NSM","R","NSM","NSM","R","NSM","NSM","R","NSM","N","N","N","N","N","N","N","N","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","N","N","N","N","N","R","R","R","R","R","N","N","N","N","N","N","N","N","N","N","N","AN","AN","AN","AN","AN","AN","N","N","AL","ET","ET","AL","CS","AL","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","AN","AN","AN","AN","AN","AN","AN","AN","AN","ET","AN","AN","AL","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","N","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","NSM","NSM","N","NSM","NSM","NSM","NSM","AL","AL","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","N","N","N","N","N","N","N","N","N","N","N","N","N","N","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","R","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","R","R","N","N","N","N","R","N","N","N","N","N","WS","WS","WS","WS","WS","WS","WS","WS","WS","WS","WS","BN","BN","BN","L","R","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","WS","B","LRE","RLE","PDF","LRO","RLO","CS","ET","ET","ET","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","CS","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","WS","BN","BN","BN","BN","BN","N","LRI","RLI","FSI","PDI","BN","BN","BN","BN","BN","BN","EN","L","N","N","EN","EN","EN","EN","EN","EN","ES","ES","N","N","N","L","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","ES","ES","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","L","L","N","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","N","N","N","N","N","R","NSM","R","R","R","R","R","R","R","R","R","R","ES","R","R","R","R","R","R","R","R","R","R","R","R","R","N","R","R","R","R","R","N","R","N","R","R","N","R","R","N","R","R","R","R","R","R","R","R","R","R","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","CS","N","CS","N","N","CS","N","N","N","N","N","N","N","N","N","ET","N","N","ES","ES","N","N","N","N","N","ET","ET","N","N","N","N","N","AL","AL","AL","AL","AL","N","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","N","N","BN","N","N","N","ET","ET","ET","N","N","N","N","N","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","N","N","N","N","N","N","N","N","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","N","N","N","L","L","L","L","L","L","N","N","L","L","L","L","L","L","N","N","L","L","L","L","L","L","N","N","L","L","L","N","N","N","ET","ET","N","N","N","ET","ET","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N","N"],r=new t.__bidiEngine__({isInputVisual:!0});t.API.events.push(["postProcessText",function(t){var e=t.text;t.x,t.y;var n=t.options||{};t.mutex,n.lang;var i=[];if(n.isInputVisual="boolean"!=typeof n.isInputVisual||n.isInputVisual,r.setOptions(n),"[object Array]"===Object.prototype.toString.call(e)){var a=0;for(i=[],a=0;a<e.length;a+=1)"[object Array]"===Object.prototype.toString.call(e[a])?i.push([r.doBidiReorder(e[a][0]),e[a][1],e[a][2]]):i.push([r.doBidiReorder(e[a])]);t.text=i}else t.text=r.doBidiReorder(e);r.setOptions({isInputVisual:!0})}])}(R),R.API.TTFFont=function(){function t(t){var e;if(this.rawData=t,e=this.contents=new Ta(t),this.contents.pos=4,"ttcf"===e.readString(4))throw new Error("TTCF not supported.");e.pos=0,this.parse(),this.subset=new ns(this),this.registerTTF()}return t.open=function(e){return new t(e)},t.prototype.parse=function(){return this.directory=new qa(this.contents),this.head=new Ua(this),this.name=new Ja(this),this.cmap=new Wa(this),this.toUnicode={},this.hhea=new Va(this),this.maxp=new Xa(this),this.hmtx=new Ka(this),this.post=new Ya(this),this.os2=new Ga(this),this.loca=new rs(this),this.glyf=new Qa(this),this.ascender=this.os2.exists&&this.os2.ascender||this.hhea.ascender,this.decender=this.os2.exists&&this.os2.decender||this.hhea.decender,this.lineGap=this.os2.exists&&this.os2.lineGap||this.hhea.lineGap,this.bbox=[this.head.xMin,this.head.yMin,this.head.xMax,this.head.yMax]},t.prototype.registerTTF=function(){var t,e,r,n,i;if(this.scaleFactor=1e3/this.head.unitsPerEm,this.bbox=function(){var e,r,n,i;for(i=[],e=0,r=(n=this.bbox).length;e<r;e++)t=n[e],i.push(Math.round(t*this.scaleFactor));return i}.call(this),this.stemV=0,this.post.exists?(r=255&(n=this.post.italic_angle),32768&(e=n>>16)&&(e=-(1+(65535^e))),this.italicAngle=+(e+"."+r)):this.italicAngle=0,this.ascender=Math.round(this.ascender*this.scaleFactor),this.decender=Math.round(this.decender*this.scaleFactor),this.lineGap=Math.round(this.lineGap*this.scaleFactor),this.capHeight=this.os2.exists&&this.os2.capHeight||this.ascender,this.xHeight=this.os2.exists&&this.os2.xHeight||0,this.familyClass=(this.os2.exists&&this.os2.familyClass||0)>>8,this.isSerif=1===(i=this.familyClass)||2===i||3===i||4===i||5===i||7===i,this.isScript=10===this.familyClass,this.flags=0,this.post.isFixedPitch&&(this.flags|=1),this.isSerif&&(this.flags|=2),this.isScript&&(this.flags|=8),0!==this.italicAngle&&(this.flags|=64),this.flags|=32,!this.cmap.unicode)throw new Error("No unicode cmap for font")},t.prototype.characterToGlyph=function(t){var e;return(null!=(e=this.cmap.unicode)?e.codeMap[t]:void 0)||0},t.prototype.widthOfGlyph=function(t){var e;return e=1e3/this.head.unitsPerEm,this.hmtx.forGlyph(t).advance*e},t.prototype.widthOfString=function(t,e,r){var n,i,a,s;for(a=0,i=0,s=(t=""+t).length;0<=s?i<s:i>s;i=0<=s?++i:--i)n=t.charCodeAt(i),a+=this.widthOfGlyph(this.characterToGlyph(n))+r*(1e3/e)||0;return a*(e/1e3)},t.prototype.lineHeight=function(t,e){var r;return null==e&&(e=!1),r=e?this.lineGap:0,(this.ascender+r-this.decender)/1e3*t},t}();var Ra,Ta=function(){function t(t){this.data=null!=t?t:[],this.pos=0,this.length=this.data.length}return t.prototype.readByte=function(){return this.data[this.pos++]},t.prototype.writeByte=function(t){return this.data[this.pos++]=t},t.prototype.readUInt32=function(){return 16777216*this.readByte()+(this.readByte()<<16)+(this.readByte()<<8)+this.readByte()},t.prototype.writeUInt32=function(t){return this.writeByte(t>>>24&255),this.writeByte(t>>16&255),this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt32=function(){var t;return(t=this.readUInt32())>=2147483648?t-4294967296:t},t.prototype.writeInt32=function(t){return t<0&&(t+=4294967296),this.writeUInt32(t)},t.prototype.readUInt16=function(){return this.readByte()<<8|this.readByte()},t.prototype.writeUInt16=function(t){return this.writeByte(t>>8&255),this.writeByte(255&t)},t.prototype.readInt16=function(){var t;return(t=this.readUInt16())>=32768?t-65536:t},t.prototype.writeInt16=function(t){return t<0&&(t+=65536),this.writeUInt16(t)},t.prototype.readString=function(t){var e,r;for(r=[],e=0;0<=t?e<t:e>t;e=0<=t?++e:--e)r[e]=String.fromCharCode(this.readByte());return r.join("")},t.prototype.writeString=function(t){var e,r,n;for(n=[],e=0,r=t.length;0<=r?e<r:e>r;e=0<=r?++e:--e)n.push(this.writeByte(t.charCodeAt(e)));return n},t.prototype.readShort=function(){return this.readInt16()},t.prototype.writeShort=function(t){return this.writeInt16(t)},t.prototype.readLongLong=function(){var t,e,r,n,i,a,s,o;return t=this.readByte(),e=this.readByte(),r=this.readByte(),n=this.readByte(),i=this.readByte(),a=this.readByte(),s=this.readByte(),o=this.readByte(),128&t?-1*(72057594037927940*(255^t)+281474976710656*(255^e)+1099511627776*(255^r)+4294967296*(255^n)+16777216*(255^i)+65536*(255^a)+256*(255^s)+(255^o)+1):72057594037927940*t+281474976710656*e+1099511627776*r+4294967296*n+16777216*i+65536*a+256*s+o},t.prototype.writeLongLong=function(t){var e,r;return e=Math.floor(t/4294967296),r=4294967295&t,this.writeByte(e>>24&255),this.writeByte(e>>16&255),this.writeByte(e>>8&255),this.writeByte(255&e),this.writeByte(r>>24&255),this.writeByte(r>>16&255),this.writeByte(r>>8&255),this.writeByte(255&r)},t.prototype.readInt=function(){return this.readInt32()},t.prototype.writeInt=function(t){return this.writeInt32(t)},t.prototype.read=function(t){var e,r;for(e=[],r=0;0<=t?r<t:r>t;r=0<=t?++r:--r)e.push(this.readByte());return e},t.prototype.write=function(t){var e,r,n,i;for(i=[],r=0,n=t.length;r<n;r++)e=t[r],i.push(this.writeByte(e));return i},t}(),qa=function(){var t;function e(t){var e,r,n;for(this.scalarType=t.readInt(),this.tableCount=t.readShort(),this.searchRange=t.readShort(),this.entrySelector=t.readShort(),this.rangeShift=t.readShort(),this.tables={},r=0,n=this.tableCount;0<=n?r<n:r>n;r=0<=n?++r:--r)e={tag:t.readString(4),checksum:t.readInt(),offset:t.readInt(),length:t.readInt()},this.tables[e.tag]=e}return e.prototype.encode=function(e){var r,n,i,a,s,o,h,l,u,c,f,d,p;for(p in f=Object.keys(e).length,o=Math.log(2),u=16*Math.floor(Math.log(f)/o),a=Math.floor(u/o),l=16*f-u,(n=new Ta).writeInt(this.scalarType),n.writeShort(f),n.writeShort(u),n.writeShort(a),n.writeShort(l),i=16*f,h=n.pos+i,s=null,d=[],e)for(c=e[p],n.writeString(p),n.writeInt(t(c)),n.writeInt(h),n.writeInt(c.length),d=d.concat(c),"head"===p&&(s=h),h+=c.length;h%4;)d.push(0),h++;return n.write(d),r=2981146554-t(n.data),n.pos=s+8,n.writeUInt32(r),n.data},t=function(t){var e,r,n,i;for(t=$a.call(t);t.length%4;)t.push(0);for(n=new Ta(t),r=0,e=0,i=t.length;e<i;e=e+=4)r+=n.readUInt32();return 4294967295&r},e}(),Da={}.hasOwnProperty,za=function(t,e){for(var r in e)Da.call(e,r)&&(t[r]=e[r]);function n(){this.constructor=t}return n.prototype=e.prototype,t.prototype=new n,t.__super__=e.prototype,t},Ua=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="head",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.revision=t.readInt(),this.checkSumAdjustment=t.readInt(),this.magicNumber=t.readInt(),this.flags=t.readShort(),this.unitsPerEm=t.readShort(),this.created=t.readLongLong(),this.modified=t.readLongLong(),this.xMin=t.readShort(),this.yMin=t.readShort(),this.xMax=t.readShort(),this.yMax=t.readShort(),this.macStyle=t.readShort(),this.lowestRecPPEM=t.readShort(),this.fontDirectionHint=t.readShort(),this.indexToLocFormat=t.readShort(),this.glyphDataFormat=t.readShort()},e.prototype.encode=function(t){var e;return(e=new Ta).writeInt(this.version),e.writeInt(this.revision),e.writeInt(this.checkSumAdjustment),e.writeInt(this.magicNumber),e.writeShort(this.flags),e.writeShort(this.unitsPerEm),e.writeLongLong(this.created),e.writeLongLong(this.modified),e.writeShort(this.xMin),e.writeShort(this.yMin),e.writeShort(this.xMax),e.writeShort(this.yMax),e.writeShort(this.macStyle),e.writeShort(this.lowestRecPPEM),e.writeShort(this.fontDirectionHint),e.writeShort(t),e.writeShort(this.glyphDataFormat),e.data},e}(Ra=function(){function t(t){var e;this.file=t,e=this.file.directory.tables[this.tag],this.exists=!!e,e&&(this.offset=e.offset,this.length=e.length,this.parse(this.file.contents))}return t.prototype.parse=function(){},t.prototype.encode=function(){},t.prototype.raw=function(){return this.exists?(this.file.contents.pos=this.offset,this.file.contents.read(this.length)):null},t}()),Ha=function(){function t(t,e){var r,n,i,a,s,o,h,l,u,c,f,d,p,g,m,b,v;switch(this.platformID=t.readUInt16(),this.encodingID=t.readShort(),this.offset=e+t.readInt(),u=t.pos,t.pos=this.offset,this.format=t.readUInt16(),this.length=t.readUInt16(),this.language=t.readUInt16(),this.isUnicode=3===this.platformID&&1===this.encodingID&&4===this.format||0===this.platformID&&4===this.format,this.codeMap={},this.format){case 0:for(o=0;o<256;++o)this.codeMap[o]=t.readByte();break;case 4:for(f=t.readUInt16(),c=f/2,t.pos+=6,i=function(){var e,r;for(r=[],o=e=0;0<=c?e<c:e>c;o=0<=c?++e:--e)r.push(t.readUInt16());return r}(),t.pos+=2,p=function(){var e,r;for(r=[],o=e=0;0<=c?e<c:e>c;o=0<=c?++e:--e)r.push(t.readUInt16());return r}(),h=function(){var e,r;for(r=[],o=e=0;0<=c?e<c:e>c;o=0<=c?++e:--e)r.push(t.readUInt16());return r}(),l=function(){var e,r;for(r=[],o=e=0;0<=c?e<c:e>c;o=0<=c?++e:--e)r.push(t.readUInt16());return r}(),n=(this.length-t.pos+this.offset)/2,s=function(){var e,r;for(r=[],o=e=0;0<=n?e<n:e>n;o=0<=n?++e:--e)r.push(t.readUInt16());return r}(),o=m=0,v=i.length;m<v;o=++m)for(g=i[o],r=b=d=p[o];d<=g?b<=g:b>=g;r=d<=g?++b:--b)0===l[o]?a=r+h[o]:0!==(a=s[l[o]/2+(r-d)-(c-o)]||0)&&(a+=h[o]),this.codeMap[r]=65535&a}t.pos=u}return t.encode=function(t,e){var r,n,i,a,s,o,h,l,u,c,f,d,p,g,m,b,v,w,y,_,x,A,L,N,S,k,P,F,I,C,j,E,O,B,M,R,T,q,D,z,U,H,W,V,G,Y;switch(F=new Ta,a=Object.keys(t).sort(function(t,e){return t-e}),e){case"macroman":for(p=0,g=function(){var t=[];for(d=0;d<256;++d)t.push(0);return t}(),b={0:0},i={},I=0,O=a.length;I<O;I++)null==b[W=t[n=a[I]]]&&(b[W]=++p),i[n]={old:t[n],new:b[t[n]]},g[n]=b[t[n]];return F.writeUInt16(1),F.writeUInt16(0),F.writeUInt32(12),F.writeUInt16(0),F.writeUInt16(262),F.writeUInt16(0),F.write(g),{charMap:i,subtable:F.data,maxGlyphID:p+1};case"unicode":for(k=[],u=[],v=0,b={},r={},m=h=null,C=0,B=a.length;C<B;C++)null==b[y=t[n=a[C]]]&&(b[y]=++v),r[n]={old:y,new:b[y]},s=b[y]-n,null!=m&&s===h||(m&&u.push(m),k.push(n),h=s),m=n;for(m&&u.push(m),u.push(65535),k.push(65535),N=2*(L=k.length),A=2*Math.pow(Math.log(L)/Math.LN2,2),c=Math.log(A/2)/Math.LN2,x=2*L-A,o=[],_=[],f=[],d=j=0,M=k.length;j<M;d=++j){if(S=k[d],l=u[d],65535===S){o.push(0),_.push(0);break}if(S-(P=r[S].new)>=32768)for(o.push(0),_.push(2*(f.length+L-d)),n=E=S;S<=l?E<=l:E>=l;n=S<=l?++E:--E)f.push(r[n].new);else o.push(P-S),_.push(0)}for(F.writeUInt16(3),F.writeUInt16(1),F.writeUInt32(12),F.writeUInt16(4),F.writeUInt16(16+8*L+2*f.length),F.writeUInt16(0),F.writeUInt16(N),F.writeUInt16(A),F.writeUInt16(c),F.writeUInt16(x),U=0,R=u.length;U<R;U++)n=u[U],F.writeUInt16(n);for(F.writeUInt16(0),H=0,T=k.length;H<T;H++)n=k[H],F.writeUInt16(n);for(V=0,q=o.length;V<q;V++)s=o[V],F.writeUInt16(s);for(G=0,D=_.length;G<D;G++)w=_[G],F.writeUInt16(w);for(Y=0,z=f.length;Y<z;Y++)p=f[Y],F.writeUInt16(p);return{charMap:r,subtable:F.data,maxGlyphID:v+1}}},t}(),Wa=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="cmap",e.prototype.parse=function(t){var e,r,n;for(t.pos=this.offset,this.version=t.readUInt16(),n=t.readUInt16(),this.tables=[],this.unicode=null,r=0;0<=n?r<n:r>n;r=0<=n?++r:--r)e=new Ha(t,this.offset),this.tables.push(e),e.isUnicode&&null==this.unicode&&(this.unicode=e);return!0},e.encode=function(t,e){var r,n;return null==e&&(e="macroman"),r=Ha.encode(t,e),(n=new Ta).writeUInt16(0),n.writeUInt16(1),r.table=n.data.concat(r.subtable),r},e}(Ra),Va=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="hhea",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.ascender=t.readShort(),this.decender=t.readShort(),this.lineGap=t.readShort(),this.advanceWidthMax=t.readShort(),this.minLeftSideBearing=t.readShort(),this.minRightSideBearing=t.readShort(),this.xMaxExtent=t.readShort(),this.caretSlopeRise=t.readShort(),this.caretSlopeRun=t.readShort(),this.caretOffset=t.readShort(),t.pos+=8,this.metricDataFormat=t.readShort(),this.numberOfMetrics=t.readUInt16()},e}(Ra),Ga=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="OS/2",e.prototype.parse=function(t){if(t.pos=this.offset,this.version=t.readUInt16(),this.averageCharWidth=t.readShort(),this.weightClass=t.readUInt16(),this.widthClass=t.readUInt16(),this.type=t.readShort(),this.ySubscriptXSize=t.readShort(),this.ySubscriptYSize=t.readShort(),this.ySubscriptXOffset=t.readShort(),this.ySubscriptYOffset=t.readShort(),this.ySuperscriptXSize=t.readShort(),this.ySuperscriptYSize=t.readShort(),this.ySuperscriptXOffset=t.readShort(),this.ySuperscriptYOffset=t.readShort(),this.yStrikeoutSize=t.readShort(),this.yStrikeoutPosition=t.readShort(),this.familyClass=t.readShort(),this.panose=function(){var e,r;for(r=[],e=0;e<10;++e)r.push(t.readByte());return r}(),this.charRange=function(){var e,r;for(r=[],e=0;e<4;++e)r.push(t.readInt());return r}(),this.vendorID=t.readString(4),this.selection=t.readShort(),this.firstCharIndex=t.readShort(),this.lastCharIndex=t.readShort(),this.version>0&&(this.ascent=t.readShort(),this.descent=t.readShort(),this.lineGap=t.readShort(),this.winAscent=t.readShort(),this.winDescent=t.readShort(),this.codePageRange=function(){var e,r;for(r=[],e=0;e<2;e=++e)r.push(t.readInt());return r}(),this.version>1))return this.xHeight=t.readShort(),this.capHeight=t.readShort(),this.defaultChar=t.readShort(),this.breakChar=t.readShort(),this.maxContext=t.readShort()},e}(Ra),Ya=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="post",e.prototype.parse=function(t){var e,r,n;switch(t.pos=this.offset,this.format=t.readInt(),this.italicAngle=t.readInt(),this.underlinePosition=t.readShort(),this.underlineThickness=t.readShort(),this.isFixedPitch=t.readInt(),this.minMemType42=t.readInt(),this.maxMemType42=t.readInt(),this.minMemType1=t.readInt(),this.maxMemType1=t.readInt(),this.format){case 65536:case 196608:break;case 131072:var i;for(r=t.readUInt16(),this.glyphNameIndex=[],i=0;0<=r?i<r:i>r;i=0<=r?++i:--i)this.glyphNameIndex.push(t.readUInt16());for(this.names=[],n=[];t.pos<this.offset+this.length;)e=t.readByte(),n.push(this.names.push(t.readString(e)));return n;case 151552:return r=t.readUInt16(),this.offsets=t.read(r);case 262144:return this.map=function(){var e,r,n;for(n=[],i=e=0,r=this.file.maxp.numGlyphs;0<=r?e<r:e>r;i=0<=r?++e:--e)n.push(t.readUInt32());return n}.call(this)}},e}(Ra),Za=function(t,e){this.raw=t,this.length=t.length,this.platformID=e.platformID,this.encodingID=e.encodingID,this.languageID=e.languageID},Ja=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="name",e.prototype.parse=function(t){var e,r,n,i,a,s,o,h,l,u,c;for(t.pos=this.offset,t.readShort(),e=t.readShort(),s=t.readShort(),r=[],i=0;0<=e?i<e:i>e;i=0<=e?++i:--i)r.push({platformID:t.readShort(),encodingID:t.readShort(),languageID:t.readShort(),nameID:t.readShort(),length:t.readShort(),offset:this.offset+s+t.readShort()});for(o={},i=l=0,u=r.length;l<u;i=++l)n=r[i],t.pos=n.offset,h=t.readString(n.length),a=new Za(h,n),null==o[c=n.nameID]&&(o[c]=[]),o[n.nameID].push(a);this.strings=o,this.copyright=o[0],this.fontFamily=o[1],this.fontSubfamily=o[2],this.uniqueSubfamily=o[3],this.fontName=o[4],this.version=o[5];try{this.postscriptName=o[6][0].raw.replace(/[\x00-\x19\x80-\xff]/g,"")}catch(is){this.postscriptName=o[4][0].raw.replace(/[\x00-\x19\x80-\xff]/g,"")}return this.trademark=o[7],this.manufacturer=o[8],this.designer=o[9],this.description=o[10],this.vendorUrl=o[11],this.designerUrl=o[12],this.license=o[13],this.licenseUrl=o[14],this.preferredFamily=o[15],this.preferredSubfamily=o[17],this.compatibleFull=o[18],this.sampleText=o[19]},e}(Ra),Xa=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="maxp",e.prototype.parse=function(t){return t.pos=this.offset,this.version=t.readInt(),this.numGlyphs=t.readUInt16(),this.maxPoints=t.readUInt16(),this.maxContours=t.readUInt16(),this.maxCompositePoints=t.readUInt16(),this.maxComponentContours=t.readUInt16(),this.maxZones=t.readUInt16(),this.maxTwilightPoints=t.readUInt16(),this.maxStorage=t.readUInt16(),this.maxFunctionDefs=t.readUInt16(),this.maxInstructionDefs=t.readUInt16(),this.maxStackElements=t.readUInt16(),this.maxSizeOfInstructions=t.readUInt16(),this.maxComponentElements=t.readUInt16(),this.maxComponentDepth=t.readUInt16()},e}(Ra),Ka=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="hmtx",e.prototype.parse=function(t){var e,r,n,i,a,s,o;for(t.pos=this.offset,this.metrics=[],e=0,s=this.file.hhea.numberOfMetrics;0<=s?e<s:e>s;e=0<=s?++e:--e)this.metrics.push({advance:t.readUInt16(),lsb:t.readInt16()});for(n=this.file.maxp.numGlyphs-this.file.hhea.numberOfMetrics,this.leftSideBearings=function(){var r,i;for(i=[],e=r=0;0<=n?r<n:r>n;e=0<=n?++r:--r)i.push(t.readInt16());return i}(),this.widths=function(){var t,e,r,n;for(n=[],t=0,e=(r=this.metrics).length;t<e;t++)i=r[t],n.push(i.advance);return n}.call(this),r=this.widths[this.widths.length-1],o=[],e=a=0;0<=n?a<n:a>n;e=0<=n?++a:--a)o.push(this.widths.push(r));return o},e.prototype.forGlyph=function(t){return t in this.metrics?this.metrics[t]:{advance:this.metrics[this.metrics.length-1].advance,lsb:this.leftSideBearings[t-this.metrics.length]}},e}(Ra),$a=[].slice,Qa=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="glyf",e.prototype.parse=function(){return this.cache={}},e.prototype.glyphFor=function(t){var e,r,n,i,a,s,o,h,l,u;return t in this.cache?this.cache[t]:(i=this.file.loca,e=this.file.contents,r=i.indexOf(t),0===(n=i.lengthOf(t))?this.cache[t]=null:(e.pos=this.offset+r,a=(s=new Ta(e.read(n))).readShort(),h=s.readShort(),u=s.readShort(),o=s.readShort(),l=s.readShort(),this.cache[t]=-1===a?new es(s,h,u,o,l):new ts(s,a,h,u,o,l),this.cache[t]))},e.prototype.encode=function(t,e,r){var n,i,a,s,o;for(a=[],i=[],s=0,o=e.length;s<o;s++)n=t[e[s]],i.push(a.length),n&&(a=a.concat(n.encode(r)));return i.push(a.length),{table:a,offsets:i}},e}(Ra),ts=function(){function t(t,e,r,n,i,a){this.raw=t,this.numberOfContours=e,this.xMin=r,this.yMin=n,this.xMax=i,this.yMax=a,this.compound=!1}return t.prototype.encode=function(){return this.raw.data},t}(),es=function(){function t(t,e,r,n,i){var a,s;for(this.raw=t,this.xMin=e,this.yMin=r,this.xMax=n,this.yMax=i,this.compound=!0,this.glyphIDs=[],this.glyphOffsets=[],a=this.raw;s=a.readShort(),this.glyphOffsets.push(a.pos),this.glyphIDs.push(a.readUInt16()),32&s;)a.pos+=1&s?4:2,128&s?a.pos+=8:64&s?a.pos+=4:8&s&&(a.pos+=2)}return t.prototype.encode=function(){var t,e,r;for(e=new Ta($a.call(this.raw.data)),t=0,r=this.glyphIDs.length;t<r;++t)e.pos=this.glyphOffsets[t];return e.data},t}(),rs=function(t){function e(){return e.__super__.constructor.apply(this,arguments)}return za(e,t),e.prototype.tag="loca",e.prototype.parse=function(t){var e,r;return t.pos=this.offset,e=this.file.head.indexToLocFormat,this.offsets=0===e?function(){var e,n;for(n=[],r=0,e=this.length;r<e;r+=2)n.push(2*t.readUInt16());return n}.call(this):function(){var e,n;for(n=[],r=0,e=this.length;r<e;r+=4)n.push(t.readUInt32());return n}.call(this)},e.prototype.indexOf=function(t){return this.offsets[t]},e.prototype.lengthOf=function(t){return this.offsets[t+1]-this.offsets[t]},e.prototype.encode=function(t,e){for(var r=new Uint32Array(this.offsets.length),n=0,i=0,a=0;a<r.length;++a)if(r[a]=n,i<e.length&&e[i]==a){++i,r[a]=n;var s=this.offsets[a],o=this.offsets[a+1]-s;o>0&&(n+=o)}for(var h=new Array(4*r.length),l=0;l<r.length;++l)h[4*l+3]=255&r[l],h[4*l+2]=(65280&r[l])>>8,h[4*l+1]=(16711680&r[l])>>16,h[4*l]=(4278190080&r[l])>>24;return h},e}(Ra),ns=function(){function t(t){this.font=t,this.subset={},this.unicodes={},this.next=33}return t.prototype.generateCmap=function(){var t,e,r,n,i;for(e in n=this.font.cmap.tables[0].codeMap,t={},i=this.subset)r=i[e],t[e]=n[r];return t},t.prototype.glyphsFor=function(t){var e,r,n,i,a,s,o;for(n={},a=0,s=t.length;a<s;a++)n[i=t[a]]=this.font.glyf.glyphFor(i);for(i in e=[],n)(null!=(r=n[i])?r.compound:void 0)&&e.push.apply(e,r.glyphIDs);if(e.length>0)for(i in o=this.glyphsFor(e))r=o[i],n[i]=r;return n},t.prototype.encode=function(t,e){var r,n,i,a,s,o,h,l,u,c,f,d,p,g,m;for(n in r=Wa.encode(this.generateCmap(),"unicode"),a=this.glyphsFor(t),f={0:0},m=r.charMap)f[(o=m[n]).old]=o.new;for(d in c=r.maxGlyphID,a)d in f||(f[d]=c++);return l=function(t){var e,r;for(e in r={},t)r[t[e]]=e;return r}(f),u=Object.keys(l).sort(function(t,e){return t-e}),p=function(){var t,e,r;for(r=[],t=0,e=u.length;t<e;t++)s=u[t],r.push(l[s]);return r}(),i=this.font.glyf.encode(a,p,f),h=this.font.loca.encode(i.offsets,p),g={cmap:this.font.cmap.raw(),glyf:i.table,loca:h,hmtx:this.font.hmtx.raw(),hhea:this.font.hhea.raw(),maxp:this.font.maxp.raw(),post:this.font.post.raw(),name:this.font.name.raw(),head:this.font.head.encode(e)},this.font.os2.exists&&(g["OS/2"]=this.font.os2.raw()),this.font.directory.encode(g)},t}();R.API.PDFObject=function(){var t;function e(){}return t=function(t,e){return(Array(e+1).join("0")+t).slice(-e)},e.convert=function(r){var n,i,a,s;if(Array.isArray(r))return"["+function(){var t,i,a;for(a=[],t=0,i=r.length;t<i;t++)n=r[t],a.push(e.convert(n));return a}().join(" ")+"]";if("string"==typeof r)return"/"+r;if(null!=r?r.isString:void 0)return"("+r+")";if(r instanceof Date)return"(D:"+t(r.getUTCFullYear(),4)+t(r.getUTCMonth(),2)+t(r.getUTCDate(),2)+t(r.getUTCHours(),2)+t(r.getUTCMinutes(),2)+t(r.getUTCSeconds(),2)+"Z)";if("[object Object]"==={}.toString.call(r)){for(i in a=["<<"],r)s=r[i],a.push("/"+i+" "+e.convert(s));return a.push(">>"),a.join("\n")}return""+r},e}(),t.AcroForm=St,t.AcroFormAppearance=Lt,t.AcroFormButton=bt,t.AcroFormCheckBox=_t,t.AcroFormChoiceField=dt,t.AcroFormComboBox=gt,t.AcroFormEditBox=mt,t.AcroFormListBox=pt,t.AcroFormPasswordField=At,t.AcroFormPushButton=vt,t.AcroFormRadioButton=wt,t.AcroFormTextField=xt,t.GState=E,t.ShadingPattern=B,t.TilingPattern=M,t.default=R,t.jsPDF=R,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=jspdf.umd.min.js.map
