@echo off
REM CashBook ERP - cPanel Quick Deployment Script (Windows)
REM 
REM This script prepares the application for cPanel upload.
REM Requires: Node.js, npm, Composer, Git Bash or PowerShell

setlocal enabledelayedexpansion

echo ===  CashBook ERP - cPanel Deployment Preparation ===
echo.

REM Step 1: Build frontend static export
echo [Step 1] Building frontend static export...
cd frontend
call npm install --prefer-offline --no-audit
call npm run export
if errorlevel 1 (
  echo ERROR: Frontend build failed
  exit /b 1
)
echo OK - Frontend build complete. Files in ./out/
cd ..
echo.

REM Step 2: Prepare backend
echo [Step 2] Preparing backend dependencies...
cd backend
call composer install --optimize-autoloader --no-dev
if errorlevel 1 (
  echo ERROR: Composer install failed
  exit /b 1
)
echo OK - Backend dependencies installed
cd ..
echo.

REM Step 3: Create deployment packages (requires 7-Zip or can use GitHub Desktop's built-in ZIP)
echo [Step 3] Creating deployment packages...

REM Frontend package
echo Creating frontend package...
cd frontend\out
if exist ..\..\cashbook-frontend.zip del ..\..\cashbook-frontend.zip
tar -czf ..\..\cashbook-frontend.tar.gz . 2>nul || (
  REM Fallback: just specify the directory to upload
  echo OK - Use WinSCP or cPanel File Manager to upload contents of this directory
)
cd ..\..
echo OK - Frontend contents ready in frontend/out/

REM Backend package (simplified - just specify directory)
echo OK - Backend contents ready in backend/

echo.
echo [Step 4] Database schema ready...
echo OK - Database schema: backend/database/schema.cpanel.sql

echo.
echo [Step 5] Checking documentation...
if exist CPANEL_DEPLOYMENT.md (
  echo OK - Deployment guide: CPANEL_DEPLOYMENT.md
) else (
  echo WARNING - CPANEL_DEPLOYMENT.md not found
)

echo.
echo === Deployment Preparation Complete ===
echo.
echo Next steps:
echo 1. Log into cPanel at https://your-domain.com:2083
echo 2. In File Manager, go to public_html
echo 3. Upload all contents of frontend/out/ to public_html/
echo 4. Create folder "api" in public_html
echo 5. Upload all backend files (except Dockerfile, docker/) to public_html/api/
echo 6. Create PostgreSQL database "cashbook_prod" in cPanel
echo 7. Import backend/database/schema.cpanel.sql using phpPgAdmin
echo 8. Copy backend/.env.cpanel.example to public_html/api/.env
echo 9. Update .env with database credentials
echo 10. Test: https://your-domain.com/
echo.
echo See CPANEL_DEPLOYMENT.md for detailed instructions.
echo.

pause
