<?php

namespace CashBook\Middleware;

use CashBook\Core\Request;
use CashBook\Core\Response;

class RoleMiddleware
{
    private array $allowedRoles;

    public function __construct(array $allowedRoles = [])
    {
        $this->allowedRoles = $allowedRoles;
    }

    public function handle(Request $request): bool
    {
        $user = $request->getUser();

        if (!$user) {
            Response::unauthorized();
            exit;
        }

        if (!empty($this->allowedRoles) && !in_array($user['role'], $this->allowedRoles)) {
            Response::forbidden('Insufficient permissions');
            exit;
        }

        return true;
    }
}
