<?php

namespace CashBook\Middleware;

use CashBook\Core\Request;
use CashBook\Core\Response;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class AuthMiddleware
{
    public function handle(Request $request): bool
    {
        $token = $request->getBearerToken();

        if (!$token) {
            Response::unauthorized('No token provided');
            exit;
        }

        try {
            $decoded = JWT::decode($token, new Key($_ENV['JWT_SECRET'], 'HS256'));
            $user = (array) $decoded;
            $request->setUser($user);
            return true;
        } catch (\Exception $e) {
            Response::unauthorized('Invalid or expired token');
            exit;
        }
    }
}
