<?php
/**
 * CashBook ERP - Application Bootstrap
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Autoloader
require_once __DIR__ . '/../vendor/autoload.php';

// Load environment variables
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
$dotenv->safeLoad();

// Application constants
define('APP_ROOT', dirname(__DIR__));
define('APP_NAME', $_ENV['APP_NAME'] ?? 'CashBook ERP');
define('APP_ENV', $_ENV['APP_ENV'] ?? 'development');
define('APP_DEBUG', ($_ENV['APP_DEBUG'] ?? 'false') === 'true');
define('APP_URL', $_ENV['APP_URL'] ?? 'http://localhost:8000');
define('FRONTEND_URL', $_ENV['FRONTEND_URL'] ?? 'http://localhost:3000');

// Timezone - Ghana is GMT/UTC+0
date_default_timezone_set('Africa/Accra');

// Session configuration
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', APP_ENV === 'production' ? 1 : 0);
ini_set('session.use_strict_mode', 1);
