# CashBook ERP - cPanel Deployment Checklist

## Pre-Deployment (Local Machine)

- [ ] Update `frontend/next.config.js` with `output: 'export'`
- [ ] Run `cd frontend && npm run export` to generate static files
- [ ] Verify `frontend/out/` directory contains `index.html` and `_next/` folders
- [ ] Run `cd backend && composer install --optimize-autoloader --no-dev`
- [ ] Test backend API locally: `curl http://localhost:8000/api/health`

## cPanel Setup

### Database
- [ ] Log into cPanel
- [ ] Go to **PostgreSQL Databases** (or MySQL if not available)
- [ ] Create database: `cashbook_prod`
- [ ] Create user: `cashbook_user` with strong password
- [ ] Assign user to database with ALL privileges
- [ ] Note connection credentials (DB_HOST, DB_NAME, DB_USER, DB_PASS)
- [ ] Go to **phpPgAdmin** (or phpMyAdmin)
- [ ] Select database `cashbook_prod`
- [ ] Import `schema.cpanel.sql`
- [ ] Verify tables created: `SELECT tablename FROM pg_tables WHERE schemaname='public';`

### Frontend (Static HTML/JS/CSS)

**In cPanel File Manager:**
- [ ] Navigate to `public_html`
- [ ] Delete existing files (if starting fresh)
- [ ] Upload all contents of `frontend/out/` to `public_html/`
- [ ] Verify these files exist in `public_html/`:
  - [ ] `index.html`
  - [ ] `_next/` (folder)
  - [ ] `login/index.html`
  - [ ] `dashboard/index.html`
- [ ] Upload `.htaccess.frontend` (rename to `.htaccess`) to `public_html/`
- [ ] Verify `.htaccess` content includes `RewriteRule ^ index.html [QSA,L]`

### Backend (PHP API)

**In cPanel File Manager:**
- [ ] Navigate to `public_html`
- [ ] Create new folder: `api`
- [ ] Upload all backend files to `public_html/api/` **except:**
  - [ ] ~Dockerfile~
  - [ ] ~docker/~
  - [ ] ~.dockerignore~
  - [ ] ~docker-compose*~
- [ ] Verify these exist in `public_html/api/`:
  - [ ] `public/index.php`
  - [ ] `src/` (folder)
  - [ ] `vendor/` (folder)
  - [ ] `config/` (folder)
  - [ ] `routes/` (folder)
  - [ ] `.htaccess`
- [ ] Upload `.htaccess` to `public_html/api/`
- [ ] Create `.env` file in `public_html/api/` from `.env.cpanel.example`
- [ ] Update `.env` with:
  - [ ] `APP_URL=https://your-domain.com`
  - [ ] `FRONTEND_URL=https://your-domain.com`
  - [ ] `DB_HOST=localhost`
  - [ ] `DB_NAME=cashbook_prod`
  - [ ] `DB_USER=cashbook_user`
  - [ ] `DB_PASS=your-password-from-step-above`
  - [ ] `JWT_SECRET=openssl rand -base64 48` (generate a new one)

### Permissions & Configuration

**Via SSH or cPanel Terminal:**
```bash
cd ~/public_html/api
chmod 755 public
chmod 644 public/index.php
chmod 755 src vendor config routes
chmod 644 .env
chmod 644 .htaccess
```

Alternatively in **cPanel > File Manager:**
- [ ] Right-click each file → Change Permissions
- [ ] `.env` → `644`
- [ ] `.htaccess` → `644`
- [ ] `public/index.php` → `644`
- [ ] Folders (`public/`, `src/`, `vendor/`, etc.) → `755`

## Post-Deployment Testing

### Frontend Access
- [ ] Open `https://your-domain.com/` in browser
- [ ] Page loads with login form
- [ ] Click "Get Started" → goes to `/register`
- [ ] Click back → returns to `/`
- [ ] Try different URLs like `/dashboard`, `/login` → page loads (SPA routing works)
- [ ] Check browser console (F12) for errors

### Backend API Access
- [ ] Open `https://your-domain.com/api/health` in browser
- [ ] JSON response: `{"status":"ok","app":"CashBook ERP",...}`
- [ ] Test API login via curl:
  ```bash
  curl -X POST https://your-domain.com/api/auth/register \
    -H "Content-Type: application/json" \
    -d '{
      "company_name":"Test Co",
      "tin":"C0000000000",
      "name":"Admin",
      "email":"admin@test.com",
      "password":"Password123!"
    }'
  ```
- [ ] Response includes `success: true, data: {user: {...}, company: {...}}` 

### Login Test
- [ ] Go to `https://your-domain.com/login`
- [ ] Enter admin@test.com / Password123!
- [ ] Login succeeds, redirects to dashboard
- [ ] Dashboard loads with tables/charts
- [ ] Check browser console (F12) for errors

### API Data Flow
- [ ] In dashboard, click on a section (e.g., Accounting, Invoices)
- [ ] Page loads with data from API
- [ ] Check Network tab (F12) → requests to `/api/*` succeed (status 200)
- [ ] No CORS errors in console

## Debugging

### If Frontend Shows Blank Page or 404

1. **Check .htaccess exists** in `public_html`:
   ```bash
   cat ~/public_html/.htaccess
   ```
   Should contain `RewriteRule ^ index.html [QSA,L]`

2. **Enable mod_rewrite** in cPanel:
   - Go to **Apache Modules**
   - Search for `rewrite_module`
   - Enable if disabled

3. **Check error log**:
   ```bash
   tail -f ~/public_html/error_log
   ```

### If API Returns 500 Error

1. **Check PHP error log**:
   ```bash
   tail -f ~/public_html/error_log
   tail -f ~/public_html/api/error_log
   ```

2. **Verify database connection**:
   ```bash
   psql -h localhost -U cashbook_user -d cashbook_prod
   ```

3. **Check .env file** exists and has correct DB credentials:
   ```bash
   cat ~/public_html/api/.env
   ```

### If Can't Connect to Database

1. **Verify credentials**:
   ```bash
   psql -h localhost -U cashbook_user -d cashbook_prod -c "\dt"
   ```

2. **Check PostgreSQL service** is running:
   ```bash
   psql -U postgres -c "SELECT version();"
   ```

3. **In cPanel**, go to **PostgreSQL Databases** and verify:
   - Database exists: `cashbook_prod`
   - User exists: `cashbook_user`
   - User has privileges on database

## Security Hardening (Post-Deployment)

- [ ] Change `JWT_SECRET` to a strong random value
- [ ] Change database password to strong value (20+ chars)
- [ ] Set `APP_DEBUG=false` in `.env`
- [ ] Enable HTTPS (Let's Encrypt via cPanel)
- [ ] Disable directory listing: Add to `.htaccess`:
  ```apache
  Options -Indexes
  ```
- [ ] Remove sensitive files from public folders:
  - [ ] Delete `README.md` from `public_html/`
  - [ ] Delete `.env.example` from `public_html/api/`
  - [ ] Delete `.env.cpanel.example` from `public_html/api/`
- [ ] Set permissions to restrict access:
  ```bash
  chmod 600 ~/.ssh/authorized_keys  # If using SSH
  ```

## Ongoing Maintenance

- [ ] **Weekly**: Check error logs for issues
- [ ] **Monthly**: Update Composer dependencies:
  ```bash
  cd ~/public_html/api
  composer update
  ```
- [ ] **Monthly**: Review audit logs:
  ```bash
  psql -U cashbook_user -d cashbook_prod -c "SELECT COUNT(*) FROM audit_log;"
  ```
- [ ] **Quarterly**: Back up database:
  ```bash
  pg_dump -h localhost -U cashbook_user -d cashbook_prod | gzip > backup_$(date +%Y%m%d).sql.gz
  ```

## Emergency Contacts

- **cPanel Support**: https://cpanel.com/support/
- **PostgreSQL Issues**: https://www.postgresql.org/support/
- **PHP Issues**: Check error_log (see Debugging section)

---

**Deployment completed!** Your CashBook ERP is now live on cPanel.
